/*
 * Decompiled with CFR 0.152.
 */
package users.swarthmore.abug.FreightCar_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.tools.ResourceLoader;
import users.swarthmore.abug.FreightCar_pkg.FreightCarSimulation;
import users.swarthmore.abug.FreightCar_pkg.FreightCarView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreightCar
extends AbstractModel {
    public FreightCarSimulation _simulation = null;
    public FreightCarView _view = null;
    public FreightCar _model = this;
    public double t = 0.0;
    public double dt = 0.01;
    public double m = 0.0;
    public double TM;
    public double omega;
    public double v = 0.0;
    public double M = 1.0;
    public double b = 0.3;
    public double F = 3.0;
    public double x = 0.0;
    public boolean bt;
    private _ODE_evolution1 _ODEi_evolution1;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/swarthmore/abug/FreightCar.xml";
    }

    public static String _getModelDirectory() {
        return "users/swarthmore/abug/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/swarthmore/abug/happyLand.jpeg");
        hashSet.add("users/swarthmore/abug/push2.gif");
        hashSet.add("users/swarthmore/abug/sandPile.gif");
        hashSet.add("users/swarthmore/abug/fallingSand.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/swarthmore/abug/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Documents and Settings/coxaj/Desktop/downloads/EJS_4.1_090306/EJS_4.1/bin/config/");
        }
        FreightCar freightCar = new FreightCar(stringArray);
    }

    public FreightCar() {
        this(null, null, null, null, null, false);
    }

    public FreightCar(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public FreightCar(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new FreightCarSimulation(this, string, frame, uRL, bl);
        this._view = (FreightCarView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _constraints1() {
        this.omega = -this.v / 0.05;
    }

    public String _method_for_drawingPanel_BRmessage() {
        return "v=" + this._format(this.v, "0.0");
    }

    public double _method_for_sandOnCar_sizey() {
        return 0.5 * this.m;
    }

    public double _method_for_pusher_x() {
        return this.x - 0.4;
    }

    public double _method_for_wheelR_x() {
        return this.x + 0.1;
    }

    public double _method_for_wheelR_angle() {
        return this.omega * this.t;
    }

    public double _method_for_wheelL_x() {
        return this.x - 0.1;
    }

    public double _method_for_wheelL_angle() {
        return this.omega * this.t;
    }

    public double _method_for_velocity_x() {
        return this.x + 0.2;
    }

    public double _method_for_velocity_sizex() {
        return 0.3 * this.v;
    }

    public void _method_for_twoStateButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_twoStateButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_step_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_BrainTeaser_actionon() {
        this._simulation.disableLoop();
        this.bt = true;
        this._simulation.enableLoop();
    }

    public void _method_for_BrainTeaser_actionoff() {
        this._simulation.disableLoop();
        this.bt = false;
        this._simulation.enableLoop();
    }

    public double _method_for_WrongAnalyticalSolution_y() {
        return this.F / this.b * Math.log(this.M + this.m) - this.F / this.b * Math.log(this.M);
    }

    public double _method_for_AnalyticalSolution_y() {
        return this.F * this.t / (this.M + this.b * this.t);
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.dt = 0.01;
        this.m = 0.0;
        this.v = 0.0;
        this.M = 1.0;
        this.b = 0.3;
        this.F = 3.0;
        this.x = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private RK4 __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = FreightCar.this.TM;
            this.__state[n++] = FreightCar.this.x;
            this.__state[n++] = FreightCar.this.m;
            this.__state[n++] = FreightCar.this.v;
            this.__state[n++] = FreightCar.this.t;
            this.__solver = new RK4(this);
            this.__solver.initialize(FreightCar.this.dt);
        }

        void step() {
            if (FreightCar.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(FreightCar.this.dt);
            }
            int n = 0;
            this.__state[n++] = FreightCar.this.TM;
            this.__state[n++] = FreightCar.this.x;
            this.__state[n++] = FreightCar.this.m;
            this.__state[n++] = FreightCar.this.v;
            this.__state[n++] = FreightCar.this.t;
            this.__solver.step();
            n = 0;
            FreightCar.this.TM = this.__state[n++];
            FreightCar.this.x = this.__state[n++];
            FreightCar.this.m = this.__state[n++];
            FreightCar.this.v = this.__state[n++];
            FreightCar.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = dArray[n++];
            n = 0;
            dArray2[n++] = FreightCar.this.b;
            dArray2[n++] = d4;
            dArray2[n++] = FreightCar.this.b;
            dArray2[n++] = (FreightCar.this.F - FreightCar.this.b * d4) / (FreightCar.this.M + d3);
            dArray2[n++] = 1.0;
        }
    }
}

