/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.Password;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.controls.XMLTableInspector;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.AppFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.EncryptionTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LauncherUndo;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    protected static final Icon defaultIcon = new DefaultIcon();
    protected static String defaultFileName = "launcher_default";
    protected static String resourcesPath = "/org/opensourcephysics/resources/tools/";
    protected static String classPath;
    protected static String tabSetBasePath;
    protected static String version;
    protected static String releaseDate;
    protected static JFileChooser chooser;
    protected static FileFilter xmlFileFilter;
    protected static FileFilter xsetFileFilter;
    protected static FileFilter launcherFileFilter;
    protected static int wInit;
    protected static int hInit;
    protected static JDialog splashDialog;
    protected static JLabel creditsLabel;
    protected static JLabel splashTitleLabel;
    protected static JLabel splashPathLabel;
    protected static Timer splashTimer;
    protected static float baseMenuFontSize;
    protected static Icon launchIcon;
    protected static Icon launchedIcon;
    protected static Icon singletonIcon;
    protected static Icon whiteFolderIcon;
    protected static Icon redFileIcon;
    protected static Icon greenFileIcon;
    protected static Icon magentaFileIcon;
    protected static Icon yellowFileIcon;
    protected static Icon whiteFileIcon;
    protected static Icon noFileIcon;
    protected static Icon ghostFileIcon;
    protected static Icon redFolderIcon;
    protected static Icon greenFolderIcon;
    protected static Icon yellowFolderIcon;
    protected static Icon linkIcon;
    protected static Icon htmlIcon;
    protected static Icon launchEmptyIcon;
    protected static Icon ejsIcon;
    public static boolean singleAppMode;
    public static boolean singletonMode;
    private static boolean newVMAllowed;
    protected static Timer frameFinder;
    protected static ArrayList<Frame> existingFrames;
    public static LaunchNode activeNode;
    protected JDialog xmlInspector;
    protected JDialog tableInspector;
    protected int divider = 160;
    public JFrame frame;
    protected JPanel contentPane;
    protected JTabbedPane tabbedPane;
    protected boolean postEdits = true;
    protected boolean navigationVisible = true;
    protected JToolBar navbar;
    protected Icon navOpenIcon;
    protected Icon navClosedIcon;
    protected JButton navButton;
    protected JButton backButton;
    protected JButton forwardButton;
    protected Component navSpacer = Box.createHorizontalGlue();
    protected Component[] navbarAddOns;
    protected JMenuItem singleAppItem;
    protected LaunchNode selectedNode;
    protected LaunchNode previousNode;
    protected String tabSetName;
    protected JTextPane textPane;
    protected JScrollPane textScroller;
    protected boolean showText = true;
    protected ArrayList<HTMLPane> htmlTabList = new ArrayList();
    protected JMenu fileMenu;
    protected JMenu displayMenu;
    protected JMenu helpMenu;
    protected JMenuItem openItem;
    protected JMenu openFromJarMenu;
    protected JMenuItem closeTabItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem editItem;
    protected JMenuItem exitItem;
    protected JMenuItem inspectItem;
    protected JMenuItem hideItem;
    protected JMenuItem backItem;
    protected JMenu languageMenu;
    protected JMenuItem sizeUpItem;
    protected JMenuItem sizeDownItem;
    protected JMenu lookFeelMenu;
    protected ButtonGroup specificLFGroup;
    protected ButtonGroup genericLFGroup;
    protected JMenuItem javaLFItem;
    protected JMenuItem systemLFItem;
    protected JMenuItem defaultLFItem;
    protected JMenuItem lookFeelItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected JMenuItem authorInfoItem;
    protected JMenu diagnosticMenu;
    protected JMenuItem[] languageItems;
    protected LaunchClassChooser classChooser;
    protected JPopupMenu popup = new JPopupMenu();
    protected Set<String> openPaths = new HashSet<String>();
    protected Launcher spawner;
    protected boolean previewing = false;
    protected boolean editorEnabled = true;
    protected Set<String> changedFiles = new HashSet<String>();
    protected MouseListener tabListener;
    protected boolean newNodeSelected = false;
    protected boolean selfContained = false;
    protected String jarBasePath = null;
    protected String title;
    protected ArrayList<Component> tabs = new ArrayList();
    protected LauncherUndo undoManager;
    protected UndoableEditSupport undoSupport;
    protected String password;
    protected boolean pwRequiredToLoad;
    protected HyperlinkListener linkListener;
    protected boolean saveState = true;
    protected String lookAndFeel;

    static {
        tabSetBasePath = "";
        version = "1.4";
        releaseDate = "July 2007";
        wInit = 480;
        hInit = 400;
        singleAppMode = false;
        singletonMode = false;
        newVMAllowed = false;
        existingFrames = new ArrayList();
        OSPRuntime.setAuthorMode(false);
        OSPRuntime.setLauncherMode(true);
        ResourceLoader.addExtractExtension("pdf");
    }

    public Launcher() {
        this(true);
    }

    public Launcher(boolean bl) {
        Object object;
        this.createGUI(bl);
        XML.setLoader(LaunchSet.class, new LaunchSet());
        if (OSPRuntime.applet == null) {
            object = new Runnable(){

                public void run() {
                    if (OSPRuntime.isVista() || OSPRuntime.isLinux()) {
                        return;
                    }
                    try {
                        Process process = Runtime.getRuntime().exec("java");
                        newVMAllowed = true;
                        process.destroy();
                    }
                    catch (Exception exception) {}
                }
            };
            try {
                Thread thread = new Thread((Runnable)object);
                thread.start();
                thread.join(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (FontSizer.getLevel() != 0) {
            this.setFontLevel(FontSizer.getLevel());
        } else {
            this.refreshStringResources();
            this.refreshGUI();
        }
        object = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (((Dimension)object).width - this.frame.getBounds().width) / 2;
        int n2 = (((Dimension)object).height - this.frame.getBounds().height) / 2;
        this.frame.setLocation(n, n2);
    }

    public Launcher(String string) {
        this(string, string == null || !string.startsWith("<?xml"));
    }

    public Launcher(String string, boolean bl) {
        this.createGUI(bl);
        XML.setLoader(LaunchSet.class, new LaunchSet());
        String string2 = null;
        if (string == null) {
            if (OSPRuntime.getLaunchJarName() != null) {
                string = String.valueOf(XML.stripExtension(OSPRuntime.getLaunchJarName())) + ".xset";
                string2 = this.open(string);
            }
            if (string2 == null) {
                string = String.valueOf(defaultFileName) + ".xset";
                string2 = this.open(string);
            }
            if (string2 == null) {
                string = String.valueOf(defaultFileName) + ".xml";
                string2 = this.open(string);
            }
        } else {
            string2 = this.open(string);
        }
        if (FontSizer.getLevel() != 0) {
            this.setFontLevel(FontSizer.getLevel());
        } else {
            this.refreshStringResources();
            this.refreshGUI();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.frame.getBounds().width) / 2;
        int n2 = (dimension.height - this.frame.getBounds().height) / 2;
        this.frame.setLocation(n, n2);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Dimension getSize() {
        return this.contentPane.getSize();
    }

    public void setSize(Dimension dimension) {
        this.contentPane.setPreferredSize(dimension);
        this.frame.pack();
    }

    public int getDivider() {
        return this.divider;
    }

    public void setDivider(int n) {
        this.divider = n;
        this.refreshGUI();
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void setNavigationVisible(boolean bl) {
        this.navigationVisible = bl;
        if (this.getSelectedNode().isButtonView()) {
            this.showButtonView(this.getSelectedNode());
        } else {
            this.showTabbedPaneView();
        }
    }

    public void clearHistory() {
        this.undoManager.discardAllEdits();
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
    }

    public void setEditorEnabled(boolean bl) {
        this.editorEnabled = bl;
    }

    public void setHyperlinksEnabled(boolean bl) {
        int n = 0;
        while (n < this.getTabCount()) {
            LaunchPanel launchPanel = this.getTab(n);
            Enumeration<TreeNode> enumeration = launchPanel.getRootNode().breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
                this.setHyperlinksEnabled(launchNode, bl);
            }
            ++n;
        }
    }

    public void setHyperlinksEnabled(LaunchNode launchNode, boolean bl) {
        int n = 0;
        while (n < launchNode.getHTMLCount()) {
            LaunchNode.HTML hTML = launchNode.getHTML(n);
            hTML.hyperlinksEnabled = bl;
            ++n;
        }
    }

    public LaunchPanel getSelectedTab() {
        return (LaunchPanel)this.tabbedPane.getSelectedComponent();
    }

    public LaunchPanel setSelectedTab(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            LaunchPanel launchPanel = this.getTab(n);
            if (string.startsWith(launchPanel.getRootNode().name)) {
                this.tabbedPane.setSelectedComponent(launchPanel);
                return launchPanel;
            }
            ++n;
        }
        return null;
    }

    public LaunchPanel setSelectedTab(LaunchPanel launchPanel) {
        this.tabbedPane.setSelectedComponent(launchPanel);
        return launchPanel == this.tabbedPane.getSelectedComponent() ? launchPanel : null;
    }

    public LaunchNode getSelectedNode() {
        this.selectedNode = this.getSelectedTab() == null ? null : this.getSelectedTab().getSelectedNode();
        return this.selectedNode;
    }

    public LaunchNode setSelectedNode(String string) {
        return this.setSelectedNode(string, 0, null);
    }

    public LaunchNode setSelectedNode(String string, int n) {
        return this.setSelectedNode(string, n, null);
    }

    public LaunchNode setSelectedNode(String string, int n, URL uRL) {
        if (string == null) {
            return null;
        }
        string = XML.forwardSlash(string);
        this.setSelectedTab(string);
        LaunchPanel launchPanel = this.getSelectedTab();
        if (launchPanel == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = launchPanel.getRootNode().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (!string.equals(launchNode.getPathString())) continue;
            launchPanel.setSelectedNode(launchNode, n, uRL);
            return launchNode;
        }
        return null;
    }

    public LaunchNode setSelectedNodeByKey(String string, int n) {
        if (string == null || string.equals("")) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.getTabCount()) {
            LaunchPanel launchPanel = this.getTab(n2);
            Enumeration<TreeNode> enumeration = launchPanel.getRootNode().breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
                if (!string.equals(launchNode.keywords)) continue;
                this.setSelectedTab(launchPanel);
                launchPanel.setSelectedNode(launchNode, n);
                return launchNode;
            }
            ++n2;
        }
        return null;
    }

    public LaunchNode getRootNode() {
        if (this.getSelectedTab() == null) {
            return null;
        }
        return this.getSelectedTab().getRootNode();
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public LaunchPanel getTab(int n) {
        if (n >= this.tabbedPane.getTabCount()) {
            return null;
        }
        return (LaunchPanel)this.tabbedPane.getComponentAt(n);
    }

    public HTMLPane getHTMLTab(int n) {
        while (n >= this.htmlTabList.size()) {
            this.htmlTabList.add(new HTMLPane());
        }
        return this.htmlTabList.get(n);
    }

    public String open(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string = this.open(stringArray[0]);
        if (stringArray.length > 1 && stringArray[1] != null) {
            this.setSelectedNode(stringArray[1]);
        }
        return string;
    }

    public String open(String string) {
        Class<?> clazz;
        String string2;
        String string3;
        if (string == null || string.equals("")) {
            return null;
        }
        ResourceLoader.addSearchPath(resourcesPath);
        ResourceLoader.addSearchPath(tabSetBasePath);
        String string4 = string;
        String string5 = "";
        XMLControlElement xMLControlElement = new XMLControlElement();
        if (string.startsWith("<?xml")) {
            xMLControlElement.readXML(string);
            if (xMLControlElement.failedToRead()) {
                return null;
            }
        }
        if (xMLControlElement.getObjectClassName().equals(Object.class.getName())) {
            string3 = OSPRuntime.getLaunchJarDirectory();
            string5 = xMLControlElement.read(XML.getResolvedPath(string4, string3));
            if (xMLControlElement.failedToRead()) {
                string5 = xMLControlElement.read(string4);
            }
        }
        if (xMLControlElement.failedToRead()) {
            string3 = XML.stripExtension(OSPRuntime.getLaunchJarName());
            if (!string.startsWith(defaultFileName) && string3 != null && !string.startsWith(string3)) {
                OSPLog.info(String.valueOf(LaunchRes.getString("Log.Message.InvalidXML")) + " " + string);
                JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.InvalidXML.Message")) + " \"" + string + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
            }
            return null;
        }
        OSPLog.fine(string);
        string3 = XML.forwardSlash(string5);
        String string6 = LaunchRes.getString("Splash.Label.Internal");
        int n = Math.max(string3.indexOf("jar!"), string3.indexOf("zip!"));
        if (n > -1) {
            string6 = XML.getName(string3.substring(0, n + 3));
            string2 = XML.getDirectoryPath(string3.substring(0, n + 3));
            this.jarBasePath = string2.equals("") ? XML.forwardSlash(System.getProperty("user.dir", "")) : string2;
            string3 = string3.substring(n + 5);
        } else {
            this.jarBasePath = null;
        }
        string2 = this.password;
        if (xMLControlElement.getPassword() != null) {
            boolean bl = xMLControlElement.getBoolean("pw_required_by_launcher");
            if ((this instanceof LaunchBuilder || bl) && Password.verify(xMLControlElement.getPassword(), string3)) {
                this.password = xMLControlElement.getPassword();
            }
        }
        if (LaunchSet.class.equals(clazz = xMLControlElement.getObjectClass())) {
            LaunchNode launchNode;
            Object object;
            if (!string3.equals("") && splashDialog != null && splashDialog.isVisible()) {
                Resource resource = ResourceLoader.getResource(string4);
                object = String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": ";
                if (resource.getFile() != null) {
                    OSPLog.info(String.valueOf(object) + resource.getAbsolutePath());
                    splashDialog.getContentPane().setBackground(new Color(242, 242, 255));
                    splashPathLabel.setIcon(magentaFileIcon);
                    splashPathLabel.setText(String.valueOf(object) + string);
                } else {
                    boolean bl;
                    object = String.valueOf(LaunchRes.getString("Log.Message.LoadingFrom")) + " " + string6 + ": " + string;
                    boolean bl2 = bl = string6.equals(LaunchRes.getString("Splash.Label.Internal")) || string6.equals(OSPRuntime.getLaunchJarName());
                    if (bl) {
                        splashDialog.getContentPane().setBackground(new Color(255, 255, 228));
                        splashPathLabel.setIcon(greenFileIcon);
                    } else {
                        splashDialog.getContentPane().setBackground(new Color(242, 242, 255));
                        splashPathLabel.setIcon(magentaFileIcon);
                    }
                    splashPathLabel.setText((String)object);
                    object = String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": ";
                    OSPLog.info(String.valueOf(object) + resource.getAbsolutePath());
                }
            }
            if (!this.removeAllTabs()) {
                this.password = string2;
                return null;
            }
            this.tabSetName = XML.getName(string3);
            if (!string3.equals("")) {
                tabSetBasePath = this.jarBasePath != null ? "" : XML.getDirectoryPath(string3);
            }
            OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": " + string3);
            boolean bl = this.postEdits;
            this.postEdits = false;
            object = new LaunchSet(this, this.tabSetName);
            xMLControlElement.loadObject(object);
            if (((LaunchSet)object).failedToLoad) {
                if (this.tabSetName.equals(XML.getName(string3))) {
                    this.tabSetName = null;
                }
                string3 = null;
            } else if (splashDialog != null && splashDialog.isVisible() && (launchNode = this.getRootNode()) != null && !launchNode.getAuthor().trim().equals("")) {
                String string7 = String.valueOf(LaunchRes.getString("Label.Author")) + ": ";
                creditsLabel.setText(String.valueOf(string7) + launchNode.getAuthor());
            }
            this.changedFiles.clear();
            OSPLog.fine("returning " + string3);
            this.postEdits = bl;
            return string3;
        }
        if (LaunchNode.class.equals(clazz)) {
            LaunchNode launchNode;
            OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": " + string4);
            LaunchNode launchNode2 = new LaunchNode(LaunchRes.getString("NewNode.Name"));
            launchNode2.setFileName(XML.getPathRelativeTo(string3, tabSetBasePath));
            xMLControlElement.loadObject(launchNode2);
            String string8 = Launcher.getDisplayName(string3);
            int n2 = 0;
            while (n2 < this.tabbedPane.getComponentCount()) {
                if (this.tabbedPane.getTitleAt(n2).equals(string8) && (launchNode = ((LaunchPanel)this.tabbedPane.getComponent(n2)).getRootNode()).matches(launchNode2)) {
                    this.tabbedPane.setSelectedIndex(n2);
                    return null;
                }
                ++n2;
            }
            this.postEdits = false;
            if (this.tabSetName == null) {
                this.tabSetName = LaunchRes.getString("Tabset.Name.New");
                this.title = null;
                tabSetBasePath = XML.getDirectoryPath(string3);
                this.editorEnabled = true;
            }
            this.addTab(launchNode2);
            Enumeration<TreeNode> enumeration = launchNode2.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                launchNode = (LaunchNode)enumeration.nextElement();
                launchNode.setLaunchClass(launchNode.launchClassName);
            }
            this.postEdits = true;
            return string3;
        }
        OSPLog.info(LaunchRes.getString("Log.Message.NotLauncherFile"));
        if (string.length() > 20) {
            string = String.valueOf(string.substring(0, 20)) + "...";
        }
        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.NotLauncherFile.Message")) + " \"" + string + "\"", LaunchRes.getString("Dialog.NotLauncherFile.Title"), 2);
        return null;
    }

    public void setNavbarRightEndComponents(Component[] componentArray) {
        Component component;
        int n;
        int n2;
        Component[] componentArray2;
        if (this.navbar.getComponentCount() > 1 && this.navbarAddOns != null) {
            this.navbar.remove(this.navSpacer);
            componentArray2 = this.navbarAddOns;
            n2 = this.navbarAddOns.length;
            n = 0;
            while (n < n2) {
                component = componentArray2[n];
                if (component != null) {
                    this.navbar.remove(component);
                }
                ++n;
            }
        }
        this.navbarAddOns = componentArray;
        if (this.navbar.getComponentCount() > 1 && this.navbarAddOns != null) {
            this.navbar.add(this.navSpacer);
            componentArray2 = this.navbarAddOns;
            n2 = this.navbarAddOns.length;
            n = 0;
            while (n < n2) {
                component = componentArray2[n];
                if (component != null) {
                    this.navbar.add(component);
                }
                ++n;
            }
        }
        this.navbar.revalidate();
    }

    protected boolean addTab(LaunchNode launchNode) {
        final LaunchPanel launchPanel = new LaunchPanel(launchNode, this);
        this.tabs.add(launchPanel);
        if (launchNode.isHiddenInLauncher() && !(this instanceof LaunchBuilder)) {
            return false;
        }
        launchPanel.tree.setCellRenderer(new LaunchRenderer());
        launchPanel.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Launcher.this.newNodeSelected = true;
                Launcher.this.refreshGUI();
            }
        });
        launchPanel.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                launchPanel.tree.removeMouseListener(this);
            }
        });
        launchPanel.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Launcher.this.popup.removeAll();
                Launcher.this.handleMousePressed(mouseEvent, launchPanel);
            }
        });
        this.tabbedPane.addTab(launchNode.toString(), launchPanel);
        this.tabbedPane.setSelectedComponent(launchPanel);
        launchPanel.setSelectedNode(launchNode);
        if (!launchNode.tooltip.equals("")) {
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getSelectedIndex(), launchNode.tooltip);
        }
        launchPanel.dataPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Launcher.this.divider = launchPanel.splitPane.getDividerLocation();
            }
        });
        return true;
    }

    protected void showButtonView(final LaunchNode launchNode) {
        Object object;
        Serializable serializable;
        block7: {
            LaunchNode.HTML hTML = launchNode.getHTML(0);
            if (hTML != null && hTML.url != null) {
                this.setLinksEnabled(this.textPane, hTML.hyperlinksEnabled);
                try {
                    if (hTML.url.getContent() != null) {
                        serializable = hTML.url;
                        object = new Runnable((URL)serializable){
                            private final /* synthetic */ URL val$url;
                            {
                                this.val$url = uRL;
                            }

                            public void run() {
                                try {
                                    Launcher.this.textPane.setPage(this.val$url);
                                }
                                catch (IOException iOException) {
                                    OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + this.val$url);
                                }
                            }
                        };
                        SwingUtilities.invokeLater((Runnable)object);
                    }
                    break block7;
                }
                catch (IOException iOException) {
                    OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + hTML.url);
                    if (this.showText) {
                        this.textPane.setContentType("text");
                        this.textPane.setText(launchNode.description);
                    }
                    break block7;
                }
            }
            if (this.showText) {
                this.textPane.setContentType("text");
                this.textPane.setText(launchNode.description);
            }
        }
        this.contentPane.removeAll();
        this.contentPane.add((Component)this.textScroller, "Center");
        serializable = new JPanel();
        this.contentPane.add((Component)serializable, "South");
        object = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                LaunchNode launchNode2 = (LaunchNode)launchNode.getChildAt(n);
                if (launchNode2.getLaunchClass() == null) {
                    String[] stringArray = Launcher.this.undoManager.getLauncherState();
                    if (Launcher.this.open(launchNode2.args) != null) {
                        if (stringArray != null) {
                            LauncherUndo launcherUndo = Launcher.this.undoManager;
                            launcherUndo.getClass();
                            LauncherUndo.LoadEdit loadEdit = new LauncherUndo.LoadEdit(launcherUndo, launchNode2.args, stringArray);
                            Launcher.this.undoSupport.postEdit(loadEdit);
                        }
                        Launcher.this.refreshGUI();
                    }
                } else {
                    launchNode2.launch();
                }
            }
        };
        int n = 0;
        while (n < launchNode.getChildCount()) {
            LaunchNode launchNode2 = (LaunchNode)launchNode.getChildAt(n);
            JButton jButton = new JButton(launchNode2.name);
            jButton.addActionListener((ActionListener)object);
            jButton.setActionCommand(String.valueOf(n));
            jButton.setToolTipText(launchNode2.tooltip);
            ((Container)serializable).add(jButton);
            ++n;
        }
        this.frame.validate();
        this.refreshGUI();
        this.frame.repaint();
    }

    protected void showTabbedPaneView() {
        this.contentPane.removeAll();
        if (this.navigationVisible && !(this instanceof LaunchBuilder)) {
            this.contentPane.add((Component)this.navbar, "North");
        }
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.frame.validate();
        this.refreshGUI();
        this.frame.repaint();
    }

    protected String open() {
        Launcher.getXMLChooser().setFileFilter(launcherFileFilter);
        int n = Launcher.getXMLChooser().showOpenDialog(null);
        if (n == 0) {
            File file = Launcher.getXMLChooser().getSelectedFile();
            String string = XML.forwardSlash(file.getAbsolutePath());
            OSPRuntime.chooserDir = XML.getDirectoryPath(string);
            return this.open(string);
        }
        return null;
    }

    protected boolean removeSelectedTab() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 0) {
            return false;
        }
        String[] stringArray = this.undoManager.getLauncherState();
        this.tabs.remove(this.getTab(n));
        this.tabbedPane.removeTabAt(n);
        this.previousNode = this.selectedNode;
        this.newNodeSelected = true;
        if (this.tabbedPane.getTabCount() == 0) {
            this.tabSetName = null;
            this.title = null;
            if (stringArray != null) {
                LauncherUndo launcherUndo = this.undoManager;
                launcherUndo.getClass();
                LauncherUndo.LoadEdit loadEdit = new LauncherUndo.LoadEdit(launcherUndo, null, stringArray);
                this.undoSupport.postEdit(loadEdit);
            }
        }
        this.refreshGUI();
        return true;
    }

    protected boolean removeAllTabs() {
        int n = this.tabbedPane.getTabCount();
        if (n == 0) {
            return true;
        }
        boolean bl = this.postEdits;
        this.postEdits = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            this.tabbedPane.removeTabAt(n2);
            --n2;
        }
        if (this.tabbedPane.getTabCount() == 0) {
            this.tabSetName = null;
            this.title = null;
            this.password = null;
        } else {
            this.previousNode = this.selectedNode;
            this.newNodeSelected = true;
        }
        this.refreshGUI();
        this.tabs.clear();
        n2 = 0;
        while (n2 < this.tabbedPane.getTabCount()) {
            this.tabs.add(this.tabbedPane.getComponentAt(n2));
            ++n2;
        }
        this.postEdits = bl;
        return this.tabbedPane.getTabCount() == 0;
    }

    protected void refreshStringResources() {
        this.fileMenu.setText(LaunchRes.getString("Menu.File"));
        this.displayMenu.setText(LaunchRes.getString("Menu.Display"));
        this.openItem.setText(LaunchRes.getString("Menu.File.Open"));
        this.closeTabItem.setText(LaunchRes.getString("Menu.File.CloseTab"));
        this.closeAllItem.setText(LaunchRes.getString("Menu.File.CloseAll"));
        this.editItem.setText(LaunchRes.getString("Menu.File.Edit"));
        this.backItem.setText(LaunchRes.getString("Menu.File.Back"));
        this.helpMenu.setText(LaunchRes.getString("Menu.Help"));
        this.logItem.setText(LaunchRes.getString("Menu.Help.MessageLog"));
        this.inspectItem.setText(LaunchRes.getString("Menu.Help.Inspect"));
        String string = XML.getSimpleClassName(this.getClass());
        String string2 = String.valueOf(LaunchRes.getString("Menu.Help.About")) + " " + string + "...";
        this.aboutItem.setText(string2);
        String string3 = String.valueOf(LaunchRes.getString("Menu.Help.AuthorInfo")) + "...";
        LaunchNode launchNode = this.getSelectedNode();
        if (launchNode != null) {
            string3 = String.valueOf(LaunchRes.getString("Help.About.Title")) + " \"" + launchNode.getName() + "\"...";
        }
        this.authorInfoItem.setText(string3);
        this.diagnosticMenu.setText(LaunchRes.getString("Menu.Help.Diagnostics"));
        if (this.exitItem != null) {
            this.exitItem.setText(LaunchRes.getString("Menu.File.Exit"));
        }
        this.languageMenu.setText(LaunchRes.getString("Menu.Display.Language"));
        this.sizeUpItem.setText(LaunchRes.getString("Menu.Display.IncreaseFontSize"));
        this.sizeDownItem.setText(LaunchRes.getString("Menu.Display.DecreaseFontSize"));
        this.lookFeelMenu.setText(LaunchRes.getString("Menu.Display.LookFeel"));
        this.javaLFItem.setText(LaunchRes.getString("MenuItem.JavaLookFeel"));
        this.systemLFItem.setText(LaunchRes.getString("MenuItem.SystemLookFeel"));
        this.defaultLFItem.setText(LaunchRes.getString("MenuItem.DefaultLookFeel"));
        if (this.openFromJarMenu != null) {
            this.openFromJarMenu.setText(LaunchRes.getString("Menu.File.OpenFromJar"));
        }
        Locale[] localeArray = OSPRuntime.getInstalledLocales();
        int n = 0;
        while (n < localeArray.length) {
            if (localeArray[n].getLanguage().equals(LaunchRes.locale.getLanguage())) {
                this.languageItems[n].setSelected(true);
            }
            ++n;
        }
    }

    protected void refreshGUI() {
        String string = this.title == null ? this.tabSetName : this.title;
        string = string == null ? LaunchRes.getString("Frame.Title") : String.valueOf(LaunchRes.getString("Frame.Title")) + ": " + string;
        this.frame.setTitle(string);
        LaunchPanel launchPanel = this.getSelectedTab();
        if (launchPanel != null) {
            this.getSelectedTab().splitPane.setDividerLocation(this.divider);
        }
        this.backButton.setEnabled(this.undoManager.canUndo());
        this.forwardButton.setEnabled(this.undoManager.canRedo());
        this.fileMenu.removeAll();
        if (this.undoManager.canReload()) {
            this.fileMenu.add(this.backItem);
        }
        if (OSPRuntime.applet == null) {
            if (this.fileMenu.getItemCount() > 0) {
                this.fileMenu.addSeparator();
            }
            this.fileMenu.add(this.openItem);
        }
        if (this.openFromJarMenu != null) {
            this.fileMenu.add(this.openFromJarMenu);
        }
        if (OSPRuntime.applet != null) {
            this.fileMenu.add(this.hideItem);
            return;
        }
        if (launchPanel != null) {
            if (this.fileMenu.getItemCount() > 0) {
                this.fileMenu.addSeparator();
            }
            boolean bl = true;
            if (this.getClass() == Launcher.class) {
                if (launchPanel.getRootNode().isButtonView()) {
                    bl = false;
                    string = String.valueOf(LaunchRes.getString("Frame.Title")) + ": " + launchPanel.getRootNode().name;
                } else if (this.tabbedPane.getTabCount() == 1) {
                    bl = false;
                }
            }
            if (bl) {
                this.fileMenu.add(this.closeTabItem);
                this.closeAllItem.setText(LaunchRes.getString("Menu.File.CloseAll"));
            } else {
                this.closeAllItem.setText(LaunchRes.getString("MenuItem.Close"));
            }
            this.fileMenu.add(this.closeAllItem);
        }
        if (this.editorEnabled && !OSPRuntime.isWebStart()) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.editItem);
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        this.fileMenu.add(jMenu);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintUtils.printComponent(Launcher.this.frame);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PrintUtils.saveComponentAsEPS(Launcher.this.frame);
                }
                catch (IOException iOException) {}
            }
        });
        this.fileMenu.addSeparator();
        if (this.exitItem != null) {
            this.fileMenu.add(this.exitItem);
        }
        this.inspectItem.setEnabled(this.password == null || this instanceof LaunchBuilder);
        this.sizeDownItem.setEnabled((float)this.fileMenu.getFont().getSize() > baseMenuFontSize);
    }

    private void appletGUI() {
        this.hideItem = new JMenuItem(LaunchRes.getString("Menu.File.Hide"));
        this.hideItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.exit();
            }
        });
    }

    protected void createGUI(boolean bl) {
        JarFile jarFile;
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        Object object3;
        String string = "/org/opensourcephysics/resources/tools/images/launch.gif";
        launchIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/launched.gif";
        launchedIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/singleton.gif";
        singletonIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/nofile.gif";
        noFileIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/greenfile.gif";
        greenFileIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/magentafile.gif";
        magentaFileIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/link.gif";
        linkIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/html.gif";
        htmlIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/launchempty.gif";
        launchEmptyIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/launchEJS.gif";
        ejsIcon = Launcher.loadIcon(string);
        this.appletGUI();
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            existingFrames.add(frameArray[n]);
            ++n;
        }
        OSPLog.getOSPLog();
        OSPRuntime.getTranslator();
        this.undoManager = new LauncherUndo(this);
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.frame = new LauncherFrame();
        existingFrames.add(this.frame);
        if (bl && OSPRuntime.applet == null) {
            this.splash();
        }
        this.xmlInspector = new JDialog((Frame)this.frame, false);
        this.xmlInspector.setSize(new Dimension(600, 300));
        this.tableInspector = new XMLTableInspector(true, false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        n2 = (dimension.width - this.xmlInspector.getBounds().width) / 2;
        int n3 = (dimension.height - this.xmlInspector.getBounds().height) / 2;
        this.xmlInspector.setLocation(n2, n3);
        n2 = (dimension.width - this.tableInspector.getBounds().width) / 2;
        n3 = (dimension.height - this.tableInspector.getBounds().height) / 2;
        this.tableInspector.setLocation(n2, n3);
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setPreferredSize(new Dimension(wInit, hInit));
        this.frame.setContentPane(this.contentPane);
        this.frame.setDefaultCloseOperation(1);
        this.navbar = new JToolBar();
        this.navbar.setFloatable(false);
        this.navbar.setBorder(BorderFactory.createEtchedBorder());
        string = "/org/opensourcephysics/resources/tools/images/nav_open.gif";
        this.navOpenIcon = Launcher.loadIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/nav_closed.gif";
        this.navClosedIcon = Launcher.loadIcon(string);
        this.navButton = new JButton(this.navOpenIcon);
        this.navButton.setBorder(BorderFactory.createEmptyBorder());
        this.navButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Launcher.this.navbar.getComponentCount() > 1) {
                    Launcher.this.navbar.remove(Launcher.this.backButton);
                    Launcher.this.navbar.remove(Launcher.this.forwardButton);
                    Launcher.this.navbar.remove(Launcher.this.navSpacer);
                    if (Launcher.this.navbarAddOns != null) {
                        Component[] componentArray = Launcher.this.navbarAddOns;
                        int n = Launcher.this.navbarAddOns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component component = componentArray[n2];
                            if (component != null) {
                                Launcher.this.navbar.remove(component);
                            }
                            ++n2;
                        }
                    }
                    Launcher.this.navButton.setIcon(Launcher.this.navClosedIcon);
                } else {
                    Launcher.this.navbar.add(Launcher.this.backButton);
                    Launcher.this.navbar.add(Launcher.this.forwardButton);
                    if (Launcher.this.navbarAddOns != null) {
                        Launcher.this.navbar.add(Launcher.this.navSpacer);
                        Component[] componentArray = Launcher.this.navbarAddOns;
                        int n = Launcher.this.navbarAddOns.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Component component = componentArray[n3];
                            if (component != null) {
                                Launcher.this.navbar.add(component);
                            }
                            ++n3;
                        }
                    }
                    Launcher.this.navButton.setIcon(Launcher.this.navOpenIcon);
                }
                Launcher.this.navbar.revalidate();
            }
        });
        this.navbar.add(this.navButton);
        string = "/org/opensourcephysics/resources/tools/images/undo.gif";
        this.backButton = new JButton(Launcher.loadIcon(string));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.undoManager.undo();
                Launcher.this.refreshGUI();
            }
        });
        this.navbar.add(this.backButton);
        string = "/org/opensourcephysics/resources/tools/images/redo.gif";
        this.forwardButton = new JButton(Launcher.loadIcon(string));
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.undoManager.redo();
                Launcher.this.refreshGUI();
            }
        });
        this.navbar.add(this.forwardButton);
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textScroller = new JScrollPane(this.textPane);
        this.tabbedPane = new JTabbedPane(3);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Serializable serializable;
                Launcher.this.previousNode = Launcher.this.selectedNode;
                Launcher.this.selectedNode = Launcher.this.getSelectedNode();
                Launcher.this.newNodeSelected = true;
                LaunchNode launchNode = Launcher.this.getRootNode();
                if (launchNode != null && launchNode.isButtonView() && Launcher.this.getClass() == Launcher.class) {
                    Launcher.this.showButtonView(launchNode);
                } else {
                    Launcher.this.showTabbedPaneView();
                    serializable = Launcher.this.getSelectedTab();
                    if (serializable != null) {
                        if (Launcher.this.getSelectedNode() != null) {
                            serializable.displayHTML(Launcher.this.selectedNode);
                        } else {
                            serializable.displayHTML(launchNode);
                        }
                    }
                }
                if (Launcher.this.previousNode != null && Launcher.this.selectedNode != null) {
                    if (Launcher.this.selectedNode.htmlURL == null && !Launcher.this.selectedNode.htmlData.isEmpty()) {
                        int n = Math.max(0, Launcher.this.selectedNode.htmlTabNumber);
                        LaunchNode.HTML hTML = Launcher.this.selectedNode.htmlData.get(n);
                        Launcher.this.selectedNode.htmlURL = hTML.url;
                        Launcher.this.selectedNode.htmlTabNumber = n;
                    }
                    if (Launcher.this.postEdits) {
                        LauncherUndo launcherUndo = Launcher.this.undoManager;
                        launcherUndo.getClass();
                        serializable = new LauncherUndo.NavEdit(launcherUndo, Launcher.this.previousNode, Launcher.this.selectedNode);
                        Launcher.this.undoSupport.postEdit((UndoableEdit)((Object)serializable));
                    }
                }
                Launcher.this.refreshGUI();
            }
        });
        this.tabListener = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (Launcher.this.contentPane.getTopLevelAncestor() != Launcher.this.frame) {
                    return;
                }
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(LaunchRes.getString("MenuItem.Close"));
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Launcher.this.removeSelectedTab();
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(Launcher.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        };
        this.tabbedPane.addMouseListener(this.tabListener);
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileMenu.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                Launcher.this.fileMenu.removeMouseListener(this);
            }
        });
        jMenuBar.add(this.fileMenu);
        this.openItem = new JMenuItem();
        int n4 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n4));
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = Launcher.this.undoManager.getLauncherState();
                if (stringArray != null) {
                    String string = Launcher.this.open();
                    if (string != null) {
                        String[] stringArray2 = new String[]{string};
                        LauncherUndo launcherUndo = Launcher.this.undoManager;
                        launcherUndo.getClass();
                        LauncherUndo.LoadEdit loadEdit = new LauncherUndo.LoadEdit(launcherUndo, stringArray2, stringArray);
                        Launcher.this.undoSupport.postEdit(loadEdit);
                        Launcher.this.refreshGUI();
                    }
                } else {
                    Launcher.this.open();
                    Launcher.this.refreshGUI();
                }
            }
        });
        this.closeTabItem = new JMenuItem();
        this.closeTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.removeSelectedTab();
            }
        });
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = Launcher.this.undoManager.getLauncherState();
                if (Launcher.this.removeAllTabs() && stringArray != null) {
                    LauncherUndo launcherUndo = Launcher.this.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.LoadEdit loadEdit = new LauncherUndo.LoadEdit(launcherUndo, null, stringArray);
                    Launcher.this.undoSupport.postEdit(loadEdit);
                }
                Launcher.this.refreshGUI();
            }
        });
        this.editItem = new JMenuItem();
        this.editItem.setAccelerator(KeyStroke.getKeyStroke(69, n4));
        if (OSPRuntime.isWebStart()) {
            this.editItem.setEnabled(false);
        }
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Launcher.this.password != null && !Launcher.this.pwRequiredToLoad && !Password.verify(Launcher.this.password, Launcher.this.tabSetName)) {
                    return;
                }
                if (Launcher.this.previewing) {
                    LaunchNode launchNode;
                    Launcher.this.previewing = false;
                    if (Launcher.this.spawner != null && (launchNode = Launcher.this.getSelectedNode()) != null) {
                        Launcher.this.spawner.setSelectedNode(launchNode.getPathString());
                    }
                    Launcher.this.exit();
                } else {
                    Object object;
                    LaunchBuilder launchBuilder;
                    if (Launcher.this.tabSetName == null) {
                        launchBuilder = new LaunchBuilder(false);
                        launchBuilder.newItem.doClick();
                    } else {
                        object = new LaunchSet(Launcher.this, Launcher.this.tabSetName);
                        XMLControlElement xMLControlElement = new XMLControlElement(object);
                        xMLControlElement.setPassword(null);
                        launchBuilder = new LaunchBuilder(xMLControlElement.toXML());
                        LaunchNode launchNode = Launcher.this.getSelectedNode();
                        if (launchNode != null) {
                            launchBuilder.setSelectedNode(launchNode.getPathString());
                        }
                        launchBuilder.tabSetName = Launcher.this.tabSetName;
                        launchBuilder.password = Launcher.this.password;
                    }
                    launchBuilder.spawner = Launcher.this;
                    launchBuilder.jarBasePath = Launcher.this.jarBasePath;
                    object = Launcher.this.frame.getLocation();
                    launchBuilder.frame.setLocation(((Point)object).x + 24, ((Point)object).y + 24);
                    launchBuilder.frame.setVisible(true);
                    launchBuilder.frame.pack();
                    launchBuilder.frame.setDefaultCloseOperation(0);
                }
            }
        });
        this.backItem = new JMenuItem();
        this.backItem.setAccelerator(KeyStroke.getKeyStroke(37, n4));
        this.backItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.undoManager.undo();
                Launcher.this.refreshGUI();
            }
        });
        this.displayMenu = new JMenu();
        jMenuBar.add(this.displayMenu);
        LaunchRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Launcher.this.refreshStringResources();
                Launcher.this.refreshGUI();
            }
        });
        this.languageMenu = new JMenu();
        final Locale[] localeArray = OSPRuntime.getInstalledLocales();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                OSPLog.finest("setting language to " + string);
                int n = 0;
                while (n < localeArray.length) {
                    if (string.equals(localeArray[n].getDisplayName())) {
                        LaunchRes.setLocale(localeArray[n]);
                        return;
                    }
                    ++n;
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[localeArray.length];
        int n5 = 0;
        while (n5 < localeArray.length) {
            this.languageItems[n5] = new JRadioButtonMenuItem(localeArray[n5].getDisplayName(localeArray[n5]));
            this.languageItems[n5].setActionCommand(localeArray[n5].getDisplayName());
            this.languageItems[n5].addActionListener(abstractAction);
            this.languageMenu.add(this.languageItems[n5]);
            buttonGroup.add(this.languageItems[n5]);
            ++n5;
        }
        this.displayMenu.add(this.languageMenu);
        this.displayMenu.addSeparator();
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                Launcher.this.setFontLevel(n);
            }
        });
        this.sizeUpItem = new JMenuItem();
        this.sizeUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelUp();
            }
        });
        this.displayMenu.add(this.sizeUpItem);
        this.sizeDownItem = new JMenuItem();
        this.sizeDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelDown();
            }
        });
        this.displayMenu.add(this.sizeDownItem);
        this.displayMenu.addSeparator();
        this.lookFeelMenu = new JMenu();
        this.displayMenu.add(this.lookFeelMenu);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.setLookAndFeel(actionEvent.getActionCommand(), false);
            }
        };
        String string2 = UIManager.getLookAndFeel().getClass().getName();
        this.specificLFGroup = new ButtonGroup();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n6 = 0;
        while (n6 < lookAndFeelInfoArray.length) {
            object3 = lookAndFeelInfoArray[n6].getClassName();
            Object object4 = ((String)object3).indexOf("Nimbus") > -1 ? "NIMBUS" : (((String)object3).indexOf("GTK") > -1 ? "GTK" : (((String)object3).indexOf("Motif") > -1 ? "MOTIF" : (((String)object3).indexOf("WindowsClassic") > -1 ? null : (((String)object3).indexOf("Windows") > -1 ? "WINDOWS" : (object2 = ((String)object3).indexOf("Metal") > -1 ? "METAL" : null)))));
            if (object2 != null) {
                object = XML.getName(lookAndFeelInfoArray[n6].getName());
                jMenuItem = new JRadioButtonMenuItem((String)object);
                this.specificLFGroup.add(jMenuItem);
                jMenuItem.setActionCommand((String)object2);
                jMenuItem.addActionListener(abstractAction2);
                this.lookFeelMenu.add(jMenuItem);
                if (string2.equals(object3)) {
                    jMenuItem.setSelected(true);
                }
            }
            ++n6;
        }
        this.genericLFGroup = new ButtonGroup();
        this.defaultLFItem = new JRadioButtonMenuItem();
        this.defaultLFItem.setSelected(true);
        this.defaultLFItem.setActionCommand("DEFAULT");
        this.defaultLFItem.addActionListener(abstractAction2);
        this.genericLFGroup.add(this.defaultLFItem);
        this.javaLFItem = new JRadioButtonMenuItem();
        this.javaLFItem.setActionCommand("CROSS_PLATFORM");
        this.javaLFItem.addActionListener(abstractAction2);
        this.genericLFGroup.add(this.javaLFItem);
        this.systemLFItem = new JRadioButtonMenuItem();
        this.systemLFItem.setActionCommand("SYSTEM");
        this.systemLFItem.addActionListener(abstractAction2);
        this.genericLFGroup.add(this.systemLFItem);
        this.lookFeelMenu.addSeparator();
        this.lookFeelMenu.add(this.javaLFItem);
        this.lookFeelMenu.add(this.systemLFItem);
        this.lookFeelMenu.add(this.defaultLFItem);
        this.helpMenu = new JMenu();
        this.helpMenu.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                Launcher.this.helpMenu.removeMouseListener(this);
            }
        });
        this.helpMenu.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                LaunchNode launchNode = Launcher.this.getSelectedNode();
                if (launchNode != null) {
                    Launcher.this.helpMenu.add(Launcher.this.authorInfoItem);
                } else {
                    Launcher.this.helpMenu.remove(Launcher.this.authorInfoItem);
                }
            }
        });
        jMenuBar.add(this.helpMenu);
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n4));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OSPRuntime.applet == null) {
                    OSPLog oSPLog = OSPLog.getOSPLog();
                    if (oSPLog.getLocation().x == 0 && oSPLog.getLocation().y == 0) {
                        Point point = Launcher.this.frame.getLocation();
                        oSPLog.setLocation(point.x + 28, point.y + 28);
                    }
                }
                OSPLog.showLog();
            }
        });
        this.helpMenu.add(this.logItem);
        this.inspectItem = new JMenuItem();
        this.helpMenu.add(this.inspectItem);
        this.inspectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaunchSet launchSet = new LaunchSet(Launcher.this, Launcher.this.tabSetName);
                launchSet.showHiddenNodes = Launcher.this instanceof LaunchBuilder;
                XMLControlElement xMLControlElement = new XMLControlElement(launchSet);
                XMLTreePanel xMLTreePanel = new XMLTreePanel(xMLControlElement, false);
                Launcher.this.xmlInspector.setContentPane(xMLTreePanel);
                Launcher.this.xmlInspector.setTitle(String.valueOf(LaunchRes.getString("Inspector.Title.TabSet")) + " \"" + Launcher.getDisplayName(Launcher.this.tabSetName) + "\"");
                Launcher.this.xmlInspector.setVisible(true);
            }
        });
        this.diagnosticMenu = new JMenu();
        this.helpMenu.add(this.diagnosticMenu);
        JMenuItem jMenuItem2 = new JMenuItem("Jar");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutLaunchJar();
            }
        });
        this.diagnosticMenu.add(jMenuItem2);
        object3 = new JMenuItem("Java VM");
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutJava();
            }
        });
        this.diagnosticMenu.add((JMenuItem)object3);
        object2 = new JMenuItem("OS");
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutOS();
            }
        });
        this.diagnosticMenu.add((JMenuItem)object2);
        object = new JMenuItem("QuickTime");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutQTJava();
            }
        });
        this.diagnosticMenu.add((JMenuItem)object);
        jMenuItem = new JMenuItem("Java 3D");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutJava3D();
            }
        });
        this.diagnosticMenu.add(jMenuItem);
        JMenuItem jMenuItem3 = new JMenuItem("JOGL");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Diagnostics.aboutJOGL();
            }
        });
        this.diagnosticMenu.add(jMenuItem3);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.authorInfoItem = new JMenuItem();
        this.authorInfoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.this.showAuthorInformation();
            }
        });
        this.helpMenu.add(this.authorInfoItem);
        if (OSPRuntime.applet == null) {
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Launcher.this.exit();
                }

                public void windowGainedFocus(WindowEvent windowEvent) {
                    OSPRuntime.setAuthorMode(false);
                }

                public void windowActivated(WindowEvent windowEvent) {
                    OSPRuntime.setAuthorMode(false);
                }
            });
            this.fileMenu.addSeparator();
            this.exitItem = new JMenuItem();
            this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n4));
            this.exitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Launcher.this.exit();
                }
            });
        }
        if (OSPRuntime.getLaunchJarPath() == null) {
            ResourceLoader.getResource("/org/opensourcephysics/tools/Launcher.class");
        }
        if (OSPRuntime.getLaunchJarPath() != null && (jarFile = OSPRuntime.getLaunchJar()) != null) {
            AbstractAction abstractAction3 = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ((JMenuItem)actionEvent.getSource()).getText();
                    string = String.valueOf(OSPRuntime.getLaunchJarName()) + "!/" + string;
                    String[] stringArray = Launcher.this.undoManager.getLauncherState();
                    if (stringArray != null && Launcher.this.open(string) != null) {
                        String[] stringArray2 = new String[]{string};
                        LauncherUndo launcherUndo = Launcher.this.undoManager;
                        launcherUndo.getClass();
                        LauncherUndo.LoadEdit loadEdit = new LauncherUndo.LoadEdit(launcherUndo, stringArray2, stringArray);
                        Launcher.this.undoSupport.postEdit(loadEdit);
                        Launcher.this.refreshGUI();
                    } else {
                        Launcher.this.open(string);
                        Launcher.this.refreshGUI();
                    }
                }
            };
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string3 = jarEntry.getName();
                if (!string3.endsWith(".xset") || string3.startsWith(resourcesPath.substring(1)) || string3.startsWith(defaultFileName)) continue;
                if (this.openFromJarMenu == null) {
                    this.openFromJarMenu = new JMenu();
                }
                JMenuItem jMenuItem4 = new JMenuItem(string3);
                jMenuItem4.addActionListener(abstractAction3);
                this.openFromJarMenu.add(jMenuItem4);
            }
        }
        baseMenuFontSize = this.fileMenu.getFont().getSize();
        this.frame.setJMenuBar(jMenuBar);
        this.frame.pack();
    }

    protected void setFontLevel(int n) {
        FontSizer.setFonts(this.frame.getJMenuBar(), n);
        FontSizer.setFonts(this.frame.getContentPane(), n);
        this.refreshStringResources();
        LaunchPanel launchPanel = this.getSelectedTab();
        if (launchPanel != null) {
            Enumeration<TreeNode> enumeration = launchPanel.getRootNode().breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
                launchPanel.treeModel.nodeChanged(launchNode);
            }
        }
        this.refreshGUI();
    }

    protected Set<String> getOpenPaths() {
        this.openPaths.clear();
        this.openPaths.add(this.tabSetName);
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            LaunchPanel launchPanel = (LaunchPanel)this.tabbedPane.getComponentAt(n);
            LaunchNode[] launchNodeArray = launchPanel.getRootNode().getAllOwnedNodes();
            int n2 = 0;
            while (n2 < launchNodeArray.length) {
                this.openPaths.add(launchNodeArray[n2].getFileName());
                ++n2;
            }
            this.openPaths.add(launchPanel.getRootNode().getFileName());
            ++n;
        }
        return this.openPaths;
    }

    protected Launcher setLookAndFeel(final String string, final boolean bl) {
        if (string == null) {
            return null;
        }
        this.lookAndFeel = string;
        boolean bl2 = true;
        boolean bl3 = JFrame.isDefaultLookAndFeelDecorated();
        if (string.equals("SYSTEM")) {
            this.systemLFItem.setSelected(true);
        } else if (string.equals("CROSS_PLATFORM")) {
            this.javaLFItem.setSelected(true);
        } else if (string.equals("DEFAULT")) {
            bl2 = OSPRuntime.DEFAULT_LOOK_AND_FEEL_DECORATIONS;
            this.defaultLFItem.setSelected(true);
        } else if (this.genericLFGroup.getSelection() != null) {
            this.genericLFGroup.remove(this.systemLFItem);
            this.genericLFGroup.remove(this.javaLFItem);
            this.genericLFGroup.remove(this.defaultLFItem);
            this.systemLFItem.setSelected(false);
            this.javaLFItem.setSelected(false);
            this.defaultLFItem.setSelected(false);
            this.genericLFGroup.add(this.systemLFItem);
            this.genericLFGroup.add(this.javaLFItem);
            this.genericLFGroup.add(this.defaultLFItem);
        }
        String string2 = OSPRuntime.LOOK_AND_FEEL_TYPES.get(string);
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (!bl && bl2 == bl3 && lookAndFeel.getClass().getName().equals(string2)) {
            return null;
        }
        if (!this.isVisible()) {
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    Launcher.this.setLookAndFeel(string, bl);
                    Launcher.this.frame.removeWindowListener(this);
                }
            });
            return null;
        }
        OSPRuntime.setLookAndFeel(bl2, string);
        if (this.spawner != null) {
            this.spawner = this.spawner.setLookAndFeel(string, true);
        }
        this.exitCurrentApps();
        LauncherUndo launcherUndo = this.undoManager;
        UndoableEditSupport undoableEditSupport = this.undoSupport;
        LaunchNode launchNode = this.getSelectedNode();
        Point point = this.frame.getLocation();
        this.frame.dispose();
        LaunchSet launchSet = new LaunchSet(this, this.tabSetName);
        XMLControlElement xMLControlElement = new XMLControlElement(launchSet);
        xMLControlElement.setPassword(null);
        Launcher launcher = this instanceof LaunchBuilder ? new LaunchBuilder(xMLControlElement.toXML()) : new Launcher(xMLControlElement.toXML());
        launcher.setSelectedNode(launchNode.getPathString());
        launcherUndo.setLauncher(launcher);
        launcher.undoManager = launcherUndo;
        launcher.undoSupport = undoableEditSupport;
        launcher.tabSetName = this.tabSetName;
        launcher.password = this.password;
        launcher.spawner = this.spawner;
        launcher.jarBasePath = this.jarBasePath;
        launcher.frame.setDefaultCloseOperation(this.frame.getDefaultCloseOperation());
        launcher.refreshGUI();
        launcher.frame.setLocation(point);
        launcher.setVisible(true);
        launcher.frame.pack();
        SwingUtilities.updateComponentTreeUI(OSPLog.getOSPLog());
        return launcher;
    }

    protected void showAboutDialog() {
        String string = XML.NEW_LINE;
        String string2 = "Launcher " + version + " " + releaseDate + string + "Open Source Physics Project" + string + "www.opensourcephysics.org" + string + LaunchRes.getString("Label.CodeAuthor") + ": Douglas Brown";
        JOptionPane.showMessageDialog(this.frame, string2, String.valueOf(LaunchRes.getString("Help.About.Title")) + " Launcher", 1);
    }

    protected void showAuthorInformation() {
        LaunchNode launchNode = this.getSelectedNode();
        if (launchNode != null) {
            String string = XML.NEW_LINE;
            String string2 = "";
            if (!launchNode.getAuthor().trim().equals("")) {
                string2 = String.valueOf(string2) + LaunchRes.getString("Label.Author") + ": ";
                string2 = String.valueOf(string2) + launchNode.getAuthor() + string;
            }
            if (!launchNode.getKeywords().trim().equals("")) {
                string2 = String.valueOf(string2) + LaunchRes.getString("Label.Keywords") + ": ";
                string2 = String.valueOf(string2) + launchNode.getKeywords() + string;
            }
            if (!launchNode.getCourseLevel().trim().equals("")) {
                string2 = String.valueOf(string2) + LaunchRes.getString("Label.Level") + ": ";
                string2 = String.valueOf(string2) + launchNode.getCourseLevel() + string;
            }
            if (!launchNode.getLanguages().trim().equals("")) {
                string2 = String.valueOf(string2) + LaunchRes.getString("Label.Languages") + ": ";
                string2 = String.valueOf(string2) + launchNode.getLanguages() + string;
            }
            if (!launchNode.getComment().trim().equals("")) {
                string2 = String.valueOf(string2) + LaunchRes.getString("Label.Comments") + ": ";
                string2 = String.valueOf(string2) + launchNode.getComment() + string;
            }
            if (string2.equals("")) {
                string2 = LaunchRes.getString("Dialog.AuthorInfo.NoInfo");
            }
            JOptionPane.showMessageDialog(this.frame, string2, String.valueOf(LaunchRes.getString("Help.About.Title")) + " \"" + launchNode.getName() + "\"", 1);
        }
    }

    protected boolean isLink(LaunchNode launchNode) {
        if (launchNode == null || !launchNode.isLeaf() || launchNode.launchClassName != null && !launchNode.launchClassName.equals("")) {
            return false;
        }
        return !launchNode.args[0].equals("") || launchNode.args.length > 1 && !launchNode.args[1].equals("") || launchNode.args.length > 2 && !launchNode.args[2].equals("");
    }

    protected boolean hasEJSModel(LaunchNode launchNode) {
        if (launchNode == null || !launchNode.isLeaf()) {
            return false;
        }
        return EjsTool.hasEjsModel(launchNode.getLaunchClass());
    }

    protected boolean isLaunchable(LaunchNode launchNode) {
        if (launchNode == null || !launchNode.isLeaf()) {
            return false;
        }
        return Launcher.isLaunchable(launchNode.getLaunchClass());
    }

    protected void setLinksEnabled(JEditorPane jEditorPane, boolean bl) {
        if (this.linkListener == null && bl) {
            this.linkListener = new HyperlinkListener(){
                HyperlinkEvent event;

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        boolean bl;
                        if (this.event == hyperlinkEvent) {
                            return;
                        }
                        this.event = hyperlinkEvent;
                        URL uRL = hyperlinkEvent.getURL();
                        String string = uRL.toString();
                        boolean bl2 = bl = !uRL.getHost().equals("") || string.endsWith(".pdf");
                        if (bl) {
                            if (string.endsWith(".pdf") && string.indexOf("jar!") > -1) {
                                int n = string.indexOf("jar!/");
                                String string2 = string.substring(n + 5);
                                File file = new File(string2);
                                if (file.exists()) {
                                    string = file.toURI().toString();
                                } else {
                                    Resource resource = ResourceLoader.getResource(string);
                                    if (resource != null) {
                                        string = resource.getURL().toString();
                                        final File file2 = resource.getFile();
                                        Thread thread = new Thread(){

                                            public void run() {
                                                file2.deleteOnExit();
                                            }
                                        };
                                        Runtime.getRuntime().addShutdownHook(thread);
                                    }
                                }
                            }
                            if (!OSPDesktop.displayURL(string)) {
                                OSPLog.warning("unable to open in browser: " + string);
                            }
                        } else {
                            URL uRL2 = Launcher.this.selectedNode.htmlURL;
                            if (uRL2 != uRL) {
                                Object object;
                                String string3 = Launcher.this.selectedNode.getPathString();
                                Integer n = new Integer(Launcher.this.selectedNode.htmlTabNumber);
                                Object[] objectArray = new Object[4];
                                objectArray[1] = string3;
                                objectArray[2] = n;
                                objectArray[3] = uRL2;
                                Object[] objectArray2 = objectArray;
                                Object[] objectArray3 = null;
                                if (uRL2.getPath().equals(uRL.getPath())) {
                                    Object[] objectArray4 = new Object[4];
                                    objectArray4[1] = string3;
                                    objectArray4[2] = n;
                                    objectArray4[3] = uRL;
                                    objectArray3 = objectArray4;
                                } else {
                                    object = Launcher.this.getNodeAndPage(uRL);
                                    if (object != null) {
                                        Object[] objectArray5 = new Object[4];
                                        objectArray5[1] = object[0];
                                        objectArray5[2] = object[1];
                                        objectArray5[3] = uRL;
                                        objectArray3 = objectArray5;
                                    } else {
                                        Object[] objectArray6 = new Object[4];
                                        objectArray6[1] = string3;
                                        objectArray6[2] = n;
                                        objectArray6[3] = uRL;
                                        objectArray3 = objectArray6;
                                    }
                                }
                                if (Launcher.this.postEdits) {
                                    LauncherUndo launcherUndo = Launcher.this.undoManager;
                                    launcherUndo.getClass();
                                    object = new LauncherUndo.NavEdit(launcherUndo, objectArray2, objectArray3);
                                    Launcher.this.undoSupport.postEdit((UndoableEdit)object);
                                }
                                Launcher.this.postEdits = false;
                                object = (String)objectArray3[1];
                                int n2 = (Integer)objectArray3[2];
                                Launcher.this.setSelectedNode((String)object, n2, uRL);
                                Launcher.this.postEdits = true;
                            }
                        }
                    }
                }
            };
        }
        if (bl) {
            jEditorPane.addHyperlinkListener(this.linkListener);
        } else {
            jEditorPane.removeHyperlinkListener(this.linkListener);
        }
    }

    protected Object[] getNodeAndPage(URL uRL) {
        String string = uRL.getFile();
        int n = 0;
        while (n < this.getTabCount()) {
            LaunchPanel launchPanel = this.getTab(n);
            Enumeration<TreeNode> enumeration = launchPanel.getRootNode().breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
                int n2 = 0;
                while (n2 < launchNode.getHTMLCount()) {
                    String string2;
                    URL uRL2 = launchNode.getHTML(n2).getURL();
                    if (uRL2 != null && (string2 = uRL2.getFile()).equals(string)) {
                        String string3 = launchNode.getPathString();
                        return new Object[]{string3, new Integer(n2)};
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    protected static boolean isLaunchable(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod("main", String[].class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    protected void handleMousePressed(MouseEvent mouseEvent, final LaunchPanel launchPanel) {
        block22: {
            LaunchNode launchNode;
            block24: {
                block23: {
                    block21: {
                        launchNode = this.getSelectedNode();
                        if (!OSPRuntime.isPopupTrigger(mouseEvent)) break block21;
                        TreePath treePath = launchPanel.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                        if (treePath == null) {
                            return;
                        }
                        launchPanel.tree.setSelectionPath(treePath);
                        final LaunchNode launchNode2 = this.getSelectedNode();
                        if (launchNode2 == null) {
                            return;
                        }
                        JMenuItem jMenuItem = new JMenuItem(LaunchRes.getString("MenuItem.Inspect"));
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Launcher.this.inspect(launchNode2);
                            }
                        });
                        jMenuItem.setEnabled(this.password == null || this instanceof LaunchBuilder);
                        this.popup.add(jMenuItem);
                        if (launchNode2.getLaunchClass() != null) {
                            JMenuItem jMenuItem2;
                            if (launchNode2.launchCount == 0) {
                                this.popup.addSeparator();
                                jMenuItem2 = new JMenuItem(LaunchRes.getString("MenuItem.Launch"));
                                this.popup.add(jMenuItem2);
                                jMenuItem2.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        launchNode2.launch(launchPanel);
                                    }
                                });
                            } else {
                                this.popup.addSeparator();
                                jMenuItem2 = new JMenuItem(LaunchRes.getString("MenuItem.Terminate"));
                                this.popup.add(jMenuItem2);
                                jMenuItem2.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        launchNode2.terminateAll();
                                    }
                                });
                                if (launchNode2.launchCount > 1) {
                                    jMenuItem2.setText(LaunchRes.getString("MenuItem.TerminateAll"));
                                }
                                if (!launchNode2.isSingleton()) {
                                    JMenuItem jMenuItem3 = new JMenuItem(LaunchRes.getString("MenuItem.Relaunch"));
                                    this.popup.add(jMenuItem3);
                                    jMenuItem3.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent actionEvent) {
                                            launchNode2.launch(launchPanel);
                                        }
                                    });
                                }
                            }
                            if (this.hasEJSModel(launchNode2)) {
                                this.popup.addSeparator();
                                jMenuItem2 = new JMenuItem(LaunchRes.getString("Popup.MenuItem.EjsModel"));
                                this.popup.add(jMenuItem2);
                                jMenuItem2.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        boolean bl = EjsTool.runEjs(launchNode2.getLaunchClass());
                                        if (bl) {
                                            launchNode2.terminateAll();
                                        }
                                    }
                                });
                            }
                        }
                        if (this.getClass().equals(Launcher.class)) {
                            this.popup.show(launchPanel, mouseEvent.getX() + 4, mouseEvent.getY() + 12);
                        }
                        break block22;
                    }
                    if (mouseEvent.getClickCount() != 2 || !this.isLaunchable(launchNode)) break block23;
                    if (launchNode.launchCount == 0) {
                        launchNode.launch(launchPanel);
                    } else if (launchNode.isSingleton() || launchNode.isSingleVM() && launchNode.isSingleApp()) {
                        JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.Singleton.Message")) + " \"" + launchNode.toString() + "\"", LaunchRes.getString("Dialog.Singleton.Title"), 1);
                    } else {
                        int n = JOptionPane.showConfirmDialog(this.frame, LaunchRes.getString("Dialog.Relaunch.Message"), LaunchRes.getString("Dialog.Relaunch.Title"), 0);
                        if (n == 0) {
                            launchNode.launch(launchPanel);
                        }
                    }
                    if (launchNode.launchPanel != null) {
                        launchNode.launchPanel.repaint();
                    }
                    break block22;
                }
                if (mouseEvent.getClickCount() != 2 || !this.isLink(launchNode)) break block24;
                String[] stringArray = this.undoManager.getLauncherState();
                if (this.open(launchNode.args) != null && stringArray != null) {
                    LauncherUndo launcherUndo = this.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.LoadEdit loadEdit = new LauncherUndo.LoadEdit(launcherUndo, launchNode.args, stringArray);
                    this.undoSupport.postEdit(loadEdit);
                }
                this.refreshGUI();
                break block22;
            }
            if (mouseEvent.getClickCount() != 2 || launchNode.getLaunchClass() != null || launchNode.launchClassName == null || launchNode.launchClassName.equals("")) break block22;
            String[] stringArray = LaunchClassChooser.parsePath(launchNode.getClassPath());
            String string = "";
            int n = 0;
            while (n < stringArray.length) {
                block26: {
                    block25: {
                        if (string.equals("")) break block25;
                        if (stringArray[n].equals(OSPRuntime.getLaunchJarName())) break block26;
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + stringArray[n];
                }
                ++n;
            }
            JOptionPane.showMessageDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.ClassNotFound.Message1")) + launchNode.launchClassName + XML.NEW_LINE + LaunchRes.getString("Dialog.ClassNotFound.Message2") + XML.NEW_LINE + string, LaunchRes.getString("Dialog.ClassNotFound.Title"), 2);
        }
    }

    private void exitCurrentApps() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            if (!existingFrames.contains(frameArray[n]) && !(frameArray[n] instanceof LauncherFrame)) {
                WindowListener[] windowListenerArray = frameArray[n].getWindowListeners();
                int n3 = 0;
                while (n3 < windowListenerArray.length) {
                    windowListenerArray[n3].windowClosing(null);
                    ++n3;
                }
                if (frameArray[n].isVisible()) {
                    frameArray[n].dispose();
                }
            }
            ++n;
        }
    }

    private void splash() {
        Serializable serializable;
        int n = 360;
        int n2 = 120;
        if (splashDialog == null) {
            splashDialog = new JDialog((Frame)this.frame, false);
            splashDialog.setUndecorated(true);
            serializable = new Color(128, 0, 0);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(Color.white);
            jPanel.setPreferredSize(new Dimension(n, n2));
            jPanel.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    splashDialog.dispose();
                }
            });
            this.frame.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    splashDialog.dispose();
                    Launcher.this.frame.removeMouseListener(this);
                }
            });
            Border border = BorderFactory.createEtchedBorder();
            jPanel.setBorder(border);
            splashDialog.setContentPane(jPanel);
            Box box = Box.createVerticalBox();
            JLabel jLabel = new JLabel("OSP Launcher");
            if (this instanceof LaunchBuilder) {
                jLabel.setText("OSP Launch Builder");
            }
            Font font = jLabel.getFont().deriveFont(1);
            jLabel.setFont(font.deriveFont(24.0f));
            jLabel.setForeground((Color)serializable);
            jLabel.setAlignmentX(0.5f);
            jLabel.setHorizontalAlignment(0);
            creditsLabel = new JLabel(" ");
            font = font.deriveFont(0);
            font = font.deriveFont(12.0f);
            creditsLabel.setFont(font);
            creditsLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 10, 2));
            creditsLabel.setHorizontalAlignment(0);
            creditsLabel.setAlignmentX(0.5f);
            splashPathLabel = new JLabel(" "){

                public void setText(String string) {
                    int n = 80;
                    if (string != null && string.length() > n) {
                        string = String.valueOf(string.substring(0, n - 4)) + "...";
                    }
                    super.setText(string);
                }
            };
            splashPathLabel.setFont(font);
            splashPathLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            splashPathLabel.setHorizontalAlignment(0);
            splashPathLabel.setAlignmentX(0.5f);
            box.add(Box.createGlue());
            box.add(jLabel);
            box.add(Box.createGlue());
            box.add(splashPathLabel);
            box.add(creditsLabel);
            jPanel.add((Component)box, "Center");
            splashDialog.pack();
            splashTimer = new Timer(4000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Launcher.this.frame.isShowing()) {
                        splashDialog.dispose();
                        splashTimer.stop();
                    }
                }
            });
        }
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = serializable.width / 2;
        int n4 = serializable.height / 2;
        splashDialog.setLocation(n3 - n / 2, n4 - n2 / 2);
        splashDialog.setVisible(true);
        splashTimer.start();
    }

    protected void exit() {
        if (!this.terminateApps()) {
            final int n = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            Runnable runnable = new Runnable(){

                public void run() {
                    Launcher.this.frame.setDefaultCloseOperation(n);
                }
            };
            SwingUtilities.invokeLater(runnable);
            return;
        }
        if (OSPRuntime.applet == null && this.frame.getDefaultCloseOperation() == 1) {
            System.exit(0);
        } else {
            this.exitCurrentApps();
            this.frame.setVisible(false);
        }
    }

    protected boolean terminateApps() {
        if (this.frame.getDefaultCloseOperation() == 1) {
            int n;
            boolean bl = false;
            Frame[] frameArray = Frame.getFrames();
            int n2 = 0;
            int n3 = frameArray.length;
            while (n2 < n3) {
                if (!(bl || !frameArray[n2].isVisible() || frameArray[n2] instanceof LauncherFrame || frameArray[n2] instanceof OSPLog || frameArray[n2] instanceof EncryptionTool || existingFrames.contains(frameArray[n2]))) {
                    n = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.Terminate.Message")) + XML.NEW_LINE + LaunchRes.getString("Dialog.Terminate.Question"), LaunchRes.getString("Dialog.Terminate.Title"), 0);
                    if (n == 0) {
                        bl = true;
                    } else {
                        return false;
                    }
                }
                ++n2;
            }
            bl = false;
            n2 = 0;
            Component[] componentArray = this.tabbedPane.getComponents();
            n = 0;
            while (n < componentArray.length) {
                LaunchPanel launchPanel = (LaunchPanel)componentArray[n];
                Enumeration<TreeNode> enumeration = launchPanel.getRootNode().breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
                    if (launchNode.processes.isEmpty()) continue;
                    if (!bl && n2 == 0) {
                        int n4 = JOptionPane.showConfirmDialog(this.frame, String.valueOf(LaunchRes.getString("Dialog.TerminateSeparateVM.Message")) + XML.NEW_LINE + LaunchRes.getString("Dialog.TerminateSeparateVM.Question"), LaunchRes.getString("Dialog.TerminateSeparateVM.Title"), 0);
                        bl = n4 == 0;
                        int n5 = n2 = bl ? 0 : 1;
                    }
                    if (bl) {
                        Iterator<Process> iterator = launchNode.processes.iterator();
                        while (iterator.hasNext()) {
                            Process process = iterator.next();
                            iterator.remove();
                            process.destroy();
                        }
                        continue;
                    }
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    protected Icon getFileIcon(LaunchNode launchNode) {
        if (launchNode.getFileName().length() == 0) {
            return null;
        }
        File file = launchNode.getFile();
        Resource resource = launchNode.getResource();
        boolean bl = this.changedFiles.contains(launchNode.getFileName());
        if (bl) {
            return yellowFileIcon;
        }
        if (resource == null || launchNode.isParentSelfContained()) {
            return ghostFileIcon;
        }
        if (file != null && file.canWrite()) {
            return whiteFileIcon;
        }
        if (file == null) {
            return magentaFileIcon;
        }
        return redFileIcon;
    }

    public static void launch(Class<?> clazz) {
        Launcher.launch(clazz, null, null);
    }

    public static void launch(Class<?> clazz, String[] stringArray) {
        Launcher.launch(clazz, stringArray, null);
    }

    public static void launch(final Class<?> clazz, String[] stringArray, final LaunchNode launchNode) {
        if (clazz == null) {
            OSPLog.info(LaunchRes.getString("Log.Message.NoClass"));
            JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.NoLaunchClass.Message"), LaunchRes.getString("Dialog.NoLaunchClass.Title"), 2);
            return;
        }
        String string = String.valueOf(LaunchRes.getString("Log.Message.Launching")) + " " + clazz + ", args ";
        if (stringArray == null) {
            string = String.valueOf(string) + stringArray;
        } else {
            string = String.valueOf(string) + "{";
            int n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + stringArray[n];
                if (n < stringArray.length - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
            string = String.valueOf(string) + "}";
        }
        OSPLog.fine(string);
        if (OSPRuntime.launchingInSingleVM || !newVMAllowed) {
            OSPRuntime.launchingInSingleVM = true;
            OSPLog.finer(LaunchRes.getString("Log.Message.LaunchCurrentVM"));
            final Frame[] frameArray = Frame.getFrames();
            if (singleAppMode) {
                OSPLog.finer(LaunchRes.getString("Log.Message.LaunchSingleApp"));
                boolean bl = OSPLog.isLogVisible();
                int n = 0;
                int n2 = frameArray.length;
                while (n < n2) {
                    if (!existingFrames.contains(frameArray[n]) && !(frameArray[n] instanceof LauncherFrame)) {
                        WindowListener[] windowListenerArray = frameArray[n].getWindowListeners();
                        int n3 = 0;
                        while (n3 < windowListenerArray.length) {
                            windowListenerArray[n3].windowClosing(null);
                            ++n3;
                        }
                        frameArray[n].dispose();
                    }
                    ++n;
                }
                if (bl) {
                    OSPLog.showLog();
                }
            }
            if (launchNode != null) {
                String string2 = launchNode.getClassPath();
                XML.setClassLoader(LaunchClassChooser.getClassLoader(string2));
            }
            final String[] stringArray2 = stringArray;
            final Runnable runnable = new Runnable(){

                public void run() {
                    activeNode = launchNode;
                    try {
                        Method method = clazz.getMethod("main", String[].class);
                        method.invoke((Object)clazz, new Object[]{stringArray2});
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    launchNode.threads.remove(this);
                    activeNode = null;
                    if (frameFinder != null) {
                        Launcher.findFramesFor(launchNode, frameArray, this);
                        if (frameFinder != null) {
                            frameFinder.stop();
                            frameFinder = null;
                        }
                    }
                }
            };
            if (frameFinder != null) {
                frameFinder.stop();
            }
            frameFinder = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Launcher.findFramesFor(launchNode, frameArray, runnable);
                }
            });
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            launchNode.threads.put(runnable, thread);
            thread.start();
            frameFinder.start();
            return;
        }
        OSPLog.finer(LaunchRes.getString("Log.Message.LaunchSeparateVM"));
        final Vector<String> vector = new Vector<String>();
        vector.add("java");
        if (classPath != null && !classPath.equals("")) {
            String string3 = Launcher.getDefaultJar();
            if (string3 != null && classPath.indexOf(string3) == -1) {
                classPath = String.valueOf(classPath) + ";" + string3;
            }
            int n = classPath.indexOf(":");
            while (n != -1) {
                classPath = String.valueOf(classPath.substring(0, n)) + ";" + classPath.substring(n + 1);
                n = classPath.indexOf(":");
            }
            char c = System.getProperty("path.separator").charAt(0);
            classPath = classPath.replace(';', c);
            vector.add("-classpath");
            vector.add(classPath);
        }
        vector.add(clazz.getName());
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length && stringArray[n] != null) {
                vector.add(stringArray[n]);
                ++n;
            }
        }
        Runnable runnable = new Runnable(){

            public void run() {
                block6: {
                    OSPLog.finer(String.valueOf(LaunchRes.getString("Log.Message.Command")) + " " + vector.toString());
                    String[] stringArray = vector.toArray(new String[0]);
                    String[] stringArray2 = new String[]{"osp_launcher=true"};
                    try {
                        int n;
                        Process process = Runtime.getRuntime().exec(stringArray, stringArray2);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((n = bufferedInputStream.read()) != -1) {
                            stringBuffer.append((char)n);
                        }
                        bufferedInputStream.close();
                        String string = stringBuffer.toString().trim();
                        if (string.length() > 0) {
                            OSPLog.info("error buffer: " + stringBuffer.toString());
                        }
                        if (launchNode != null) {
                            launchNode.processes.add(process);
                        }
                        process.waitFor();
                        if (launchNode != null) {
                            launchNode.threadRunning(false);
                            launchNode.processes.remove(process);
                        }
                    }
                    catch (Exception exception) {
                        OSPLog.info(exception.toString());
                        if (launchNode == null) break block6;
                        launchNode.threadRunning(false);
                    }
                }
            }
        };
        if (launchNode != null) {
            launchNode.threadRunning(true);
        }
        new Thread(runnable).start();
    }

    public static void setJarsOnly(boolean bl) {
        LaunchClassChooser.jarsOnly = bl;
    }

    public static void main(String[] stringArray) {
        Object object;
        Launcher launcher = new Launcher();
        if (stringArray != null && stringArray.length > 0) {
            launcher.open(stringArray);
        } else {
            object = null;
            if (OSPRuntime.getLaunchJarName() != null) {
                object = launcher.open(String.valueOf(XML.stripExtension(OSPRuntime.getLaunchJarName())) + ".xset");
            }
            if (object == null) {
                object = launcher.open(String.valueOf(defaultFileName) + ".xset");
            }
            if (object == null) {
                object = launcher.open(String.valueOf(defaultFileName) + ".xml");
            }
        }
        launcher.refreshGUI();
        object = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (((Dimension)object).width - launcher.frame.getBounds().width) / 2;
        int n2 = (((Dimension)object).height - launcher.frame.getBounds().height) / 2;
        launcher.frame.setLocation(n, n2);
        launcher.frame.setVisible(true);
    }

    protected LaunchClassChooser getClassChooser() {
        if (this.classChooser == null) {
            this.classChooser = new LaunchClassChooser(this.contentPane);
        }
        return this.classChooser;
    }

    protected static JFileChooser getXMLChooser() {
        if (chooser != null) {
            return chooser;
        }
        chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        launcherFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && (string.equals("xset") || string.equals("xml") || string.equals("zip"));
            }

            public String getDescription() {
                return LaunchRes.getString("FileChooser.LauncherFilter.Description");
            }
        };
        xmlFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && string.equals("xml");
            }

            public String getDescription() {
                return LaunchRes.getString("FileChooser.XMLFilter.Description");
            }
        };
        xsetFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && string.equals("xset");
            }

            public String getDescription() {
                return LaunchRes.getString("FileChooser.XSETFilter.Description");
            }
        };
        chooser.addChoosableFileFilter(xmlFileFilter);
        chooser.addChoosableFileFilter(xsetFileFilter);
        chooser.addChoosableFileFilter(launcherFileFilter);
        return chooser;
    }

    protected static String getDisplayName(String string) {
        int n = (string = XML.getName(string)).lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    protected static String getDefaultJar() {
        URL uRL = ClassLoader.getSystemResource(String.valueOf(defaultFileName) + ".xset");
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(String.valueOf(defaultFileName) + ".xml");
        }
        if (uRL == null) {
            return null;
        }
        String string = uRL.getPath();
        int n = string.indexOf("/" + defaultFileName);
        if (n == -1) {
            return null;
        }
        if ((n = (string = string.substring(0, n)).lastIndexOf("!")) == -1) {
            return null;
        }
        return string.substring(string.lastIndexOf("/") + 1, n);
    }

    private void inspect(LaunchNode launchNode) {
        Object object;
        XMLControlElement xMLControlElement = new XMLControlElement(launchNode);
        if (this.hasEJSModel(launchNode)) {
            object = XML.getSimpleClassName(launchNode.getLaunchClass());
            xMLControlElement.setValue("EJS_model", String.valueOf(object) + ".xml");
        }
        object = new XMLTable(xMLControlElement);
        this.tableInspector.setContentPane(new JScrollPane((Component)object));
        this.tableInspector.setTitle(String.valueOf(LaunchRes.getString("Inspector.Title.Node")) + " \"" + launchNode.name + "\"");
        this.tableInspector.setVisible(true);
    }

    private static void findFramesFor(LaunchNode launchNode, Frame[] frameArray, Runnable runnable) {
        Frame[] frameArray2 = Frame.getFrames();
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        int n = 0;
        while (n < frameArray2.length) {
            JFrame jFrame;
            if (!(frameArray2[n] instanceof JFrame && ((jFrame = (JFrame)frameArray2[n]).getDefaultCloseOperation() == 0 || jFrame instanceof MessageFrame || jFrame instanceof LauncherFrame) || frameArray2[n].getClass().getName().indexOf("SharedOwnerFrame") > -1 || frameArray2[n].getClass().getName().indexOf("QTFrame") > -1)) {
                arrayList.add(frameArray2[n]);
            }
            ++n;
        }
        n = 0;
        while (n < frameArray.length) {
            arrayList.remove(frameArray[n]);
            ++n;
        }
        if (arrayList.isEmpty()) {
            return;
        }
        frameArray2 = arrayList.toArray(new Frame[0]);
        arrayList.clear();
        FrameCloser frameCloser = new FrameCloser(launchNode, arrayList, runnable);
        int n2 = 0;
        while (n2 < frameArray2.length) {
            if (frameArray2[n2] instanceof JFrame) {
                JFrame jFrame = (JFrame)frameArray2[n2];
                if (jFrame instanceof AppFrame && ((AppFrame)((Object)jFrame)).wishesToExit() || jFrame.getDefaultCloseOperation() == 3) {
                    if (jFrame.getDefaultCloseOperation() == 3) {
                        jFrame.setDefaultCloseOperation(2);
                    }
                    jFrame.addWindowListener(frameCloser);
                }
                arrayList.add(jFrame);
            }
            ++n2;
        }
        if (launchNode != null) {
            launchNode.frames.addAll(arrayList);
            ++launchNode.launchCount;
            if (frameFinder != null) {
                frameFinder.stop();
                frameFinder = null;
            }
        }
        if (launchNode.launchPanel != null) {
            launchNode.launchPanel.repaint();
        }
    }

    protected static Icon loadIcon(String string) {
        Icon icon = ResourceLoader.getIcon(string);
        if (icon == null) {
            icon = defaultIcon;
        }
        return icon;
    }

    static class DefaultIcon
    implements Icon {
        int w = 16;
        int h = 16;

        DefaultIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(Color.BLUE);
            graphics.drawOval(n + 3, n2 + 3, this.w - 6, this.h - 6);
            graphics.setColor(color);
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FrameCloser
    extends WindowAdapter {
        LaunchNode node;
        Collection<Frame> frames;
        Runnable runner;

        FrameCloser(LaunchNode launchNode, Collection<Frame> collection, Runnable runnable) {
            this.frames = collection;
            this.node = launchNode;
            this.runner = runnable;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            OSPLog.fine("Closing frames for node " + this.node);
            for (Frame object : this.frames) {
                object.removeWindowListener(this);
                object.dispose();
            }
            if (this.node != null) {
                Thread thread = this.node.threads.get(this.runner);
                if (thread != null) {
                    thread.interrupt();
                    this.node.threads.put(this.runner, null);
                }
                this.node.frames.removeAll(this.frames);
                this.node.launchCount = Math.max(0, --this.node.launchCount);
                if (this.node.launchPanel != null) {
                    this.node.launchPanel.repaint();
                }
            }
        }
    }

    public class HTMLPane {
        public JTextPane editorPane = new JTextPane(){

            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        JScrollPane scroller;

        HTMLPane() {
            this.editorPane.setEditable(false);
            this.editorPane.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!((HTMLPane)HTMLPane.this).Launcher.this.undoManager.canUndo()) {
                        return;
                    }
                    if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        JMenuItem jMenuItem = new JMenuItem(LaunchRes.getString("Popup.MenuItem.Back"));
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ((HTMLPane)(this).HTMLPane.this).Launcher.this.undoManager.undo();
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                        jPopupMenu.show(HTMLPane.this.editorPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                    }
                }
            });
            this.scroller = new JScrollPane(this.editorPane);
        }
    }

    private class LaunchRenderer
    extends DefaultTreeCellRenderer {
        private LaunchRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            LaunchNode launchNode = (LaunchNode)object;
            this.setToolTipText(launchNode.tooltip.equals("") ? null : launchNode.tooltip);
            if (launchNode.getFileName() != null && Launcher.this instanceof LaunchBuilder) {
                this.setToolTipText(String.valueOf(LaunchRes.getString("ToolTip.FileName")) + " \"" + launchNode.getFileName() + "\"");
                this.setIcon(Launcher.this.getFileIcon(launchNode));
            } else if (launchNode.launchCount > 0) {
                if (launchNode.isSingleton()) {
                    this.setIcon(singletonIcon);
                } else if (launchNode.isSingleVM() && launchNode.isSingleApp()) {
                    this.setIcon(singletonIcon);
                } else {
                    this.setIcon(launchedIcon);
                }
            } else if (Launcher.this.hasEJSModel(launchNode)) {
                this.setIcon(ejsIcon);
            } else if (Launcher.this.isLaunchable(launchNode)) {
                this.setIcon(launchIcon);
            } else if (Launcher.this.isLink(launchNode)) {
                this.setIcon(linkIcon);
            } else if (launchNode.isLeaf()) {
                if (launchNode.getLaunchClass() == null && launchNode.launchClassName != null && !launchNode.launchClassName.equals("")) {
                    this.setIcon(launchEmptyIcon);
                } else if (launchNode.getHTMLCount() > 0) {
                    int n2 = 0;
                    for (LaunchNode.HTML hTML : launchNode.htmlData) {
                        if (hTML.url == null) continue;
                        ++n2;
                    }
                    if (n2 > 0) {
                        this.setIcon(htmlIcon);
                    } else {
                        this.setIcon(noFileIcon);
                    }
                } else {
                    this.setIcon(noFileIcon);
                }
            }
            return this;
        }
    }

    public class LaunchSet
    implements XML.ObjectLoader {
        private Launcher launcher;
        private String name;
        boolean failedToLoad = false;
        public boolean showHiddenNodes = true;

        public LaunchSet() {
            this.launcher = Launcher.this;
        }

        protected LaunchSet(Launcher launcher2, String string) {
            this.launcher = launcher2;
            this.name = XML.getName(XML.forwardSlash(string));
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Object object2;
            int n;
            Cloneable cloneable;
            LaunchSet launchSet = (LaunchSet)object;
            Launcher launcher = launchSet.launcher;
            xMLControl.setValue("classpath", classPath);
            xMLControl.setValue("title", launcher.title);
            Dimension dimension = launcher.getSize();
            xMLControl.setValue("width", dimension.width);
            xMLControl.setValue("height", dimension.height);
            xMLControl.setValue("divider", launcher.divider);
            xMLControl.setValue("look_and_feel", launcher.lookAndFeel);
            xMLControl.setValue("editor_enabled", launcher.editorEnabled);
            if (Launcher.this.saveState) {
                cloneable = launcher.getSelectedNode();
                xMLControl.setValue("selected_node", ((LaunchNode)cloneable).getPathString());
                n = launcher.tabbedPane.getTabCount();
                object2 = new Collection[n];
                int n2 = 0;
                while (n2 < n) {
                    LaunchPanel launchPanel = launcher.getTab(n2);
                    object2[n2] = launchPanel.getExpandedNodes();
                    ++n2;
                }
                xMLControl.setValue("expanded", object2);
            }
            cloneable = new ArrayList();
            n = 0;
            while (n < launcher.tabs.size()) {
                object2 = ((LaunchPanel)launcher.tabs.get(n)).getRootNode();
                if (!((LaunchNode)object2).isHiddenInLauncher() || launchSet.showHiddenNodes) {
                    ((LaunchNode)object2).parentSelfContained = false;
                    ((LaunchNode)object2).previewing = false;
                    ((LaunchNode)object2).saveHiddenNodes = launchSet.showHiddenNodes;
                    if (launcher.selfContained) {
                        ((LaunchNode)object2).setSelfContained(false);
                        ((LaunchNode)object2).parentSelfContained = true;
                        cloneable.add(object2);
                    } else if (launcher.previewing) {
                        ((LaunchNode)object2).previewing = true;
                        cloneable.add(object2);
                    } else if (((LaunchNode)object2).getFileName() == null || ((LaunchNode)object2).getFileName().equals("")) {
                        cloneable.add(object2);
                    } else {
                        cloneable.add(((LaunchNode)object2).getFileName());
                    }
                }
                ++n;
            }
            xMLControl.setValue("launch_nodes", cloneable);
            int n3 = n = launcher.password != null && !launcher.password.equals("") ? 1 : 0;
            if (n != 0 && Launcher.this.pwRequiredToLoad) {
                xMLControl.setValue("pw_required_by_launcher", true);
            }
            xMLControl.setValue("xml_password", launcher.password);
        }

        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            String string;
            LaunchSet launchSet = (LaunchSet)object;
            final Launcher launcher = launchSet.launcher;
            if (xMLControl.getPropertyNames().contains("launchset")) {
                String string2 = launcher.open(xMLControl.getString("launchset"));
                launchSet.failedToLoad = string2 == null;
                return object;
            }
            if (xMLControl.getPropertyNames().contains("classpath")) {
                classPath = xMLControl.getString("classpath");
            }
            if ((string = xMLControl.getString("look_and_feel")) != null) {
                object2 = new Runnable(){

                    public void run() {
                        launcher.setLookAndFeel(string, false);
                    }
                };
                SwingUtilities.invokeLater((Runnable)object2);
            }
            launcher.saveState = (object2 = xMLControl.getString("selected_node")) != null;
            Collection collection = (Collection)Collection.class.cast(xMLControl.getObject("launch_nodes"));
            if (collection != null && !collection.isEmpty()) {
                int n = launcher.tabbedPane.getSelectedIndex();
                Iterator iterator = collection.iterator();
                boolean bl = false;
                Object object3 = null;
                while (iterator.hasNext()) {
                    Object object4;
                    Object e = iterator.next();
                    if (launchSet.name != null && launchSet.name.equals(e)) continue;
                    if (e instanceof String) {
                        object4 = XML.getResolvedPath((String)e, tabSetBasePath);
                        if (launcher.open((String)object4) == null) continue;
                        bl = true;
                        continue;
                    }
                    if (!(e instanceof LaunchNode)) continue;
                    object4 = (LaunchNode)e;
                    boolean bl2 = bl = launcher.addTab((LaunchNode)object4) || bl;
                    if (launcher.getClass() != Launcher.class || !((LaunchNode)object4).isButtonView() || object3 != null) continue;
                    object3 = object4;
                }
                if (!launcher.saveState) {
                    if (object3 != null) {
                        int n2 = 0;
                        while (n2 < launcher.tabbedPane.getTabCount()) {
                            if (launcher.getTab(n2).getRootNode() == object3) {
                                launcher.tabbedPane.setSelectedIndex(n2);
                            }
                            ++n2;
                        }
                    } else if (bl) {
                        launcher.tabbedPane.setSelectedIndex(n + 1);
                    }
                }
            }
            if (launcher.saveState) {
                Collection[] collectionArray = (Collection[])Collection[].class.cast(xMLControl.getObject("expanded"));
                if (collectionArray != null) {
                    int n = 0;
                    while (n < collectionArray.length) {
                        LaunchPanel launchPanel = launcher.getTab(n);
                        launchPanel.setExpandedNodes(collectionArray[n]);
                        ++n;
                    }
                }
                launcher.setSelectedNode((String)object2);
            }
            launcher.title = xMLControl.getString("title");
            if (xMLControl.getPropertyNames().contains("editor_enabled")) {
                launcher.editorEnabled = xMLControl.getBoolean("editor_enabled");
            }
            launcher.password = xMLControl.getString("xml_password");
            launcher.pwRequiredToLoad = xMLControl.getBoolean("pw_required_by_launcher");
            if (xMLControl.getPropertyNames().contains("width") && xMLControl.getPropertyNames().contains("height")) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                dimension.width = Math.min(8 * dimension.width / 10, xMLControl.getInt("width"));
                dimension.height = Math.min(8 * dimension.height / 10, xMLControl.getInt("height"));
                launcher.setSize(dimension);
            }
            if (xMLControl.getPropertyNames().contains("divider")) {
                launcher.divider = xMLControl.getInt("divider");
                launcher.refreshGUI();
            }
            return object;
        }
    }

    private class LauncherFrame
    extends JFrame {
        public LauncherFrame() {
            this.setName("LauncherTool");
            try {
                URL uRL = Launcher.class.getResource("/org/opensourcephysics/resources/controls/images/osp_icon.gif");
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.setIconImage(imageIcon.getImage());
            }
            catch (Exception exception) {}
        }
    }
}

