/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.LaunchableClassMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchClassChooser
extends JDialog {
    private static Pattern pattern;
    private static Matcher matcher;
    private static Map<String, LaunchableClassMap> classMaps;
    protected static boolean jarsOnly;
    private JTextField searchField;
    private String defaultSearch;
    private String currentSearch;
    private JScrollPane scroller;
    private JList choices;
    private LaunchableClassMap classMap;
    private boolean applyChanges;
    private JButton okButton;

    static {
        classMaps = new TreeMap<String, LaunchableClassMap>();
        jarsOnly = true;
    }

    public LaunchClassChooser(Component component) {
        super(JOptionPane.getFrameForComponent(component), true);
        this.currentSearch = this.defaultSearch = "";
        this.applyChanges = false;
        this.setTitle(LaunchRes.getString("ClassChooser.Frame.Title"));
        JLabel jLabel = new JLabel(String.valueOf(LaunchRes.getString("ClassChooser.Search.Label")) + " ");
        this.okButton = new JButton(LaunchRes.getString("ClassChooser.Button.Accept"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaunchClassChooser.this.applyChanges = true;
                LaunchClassChooser.this.setVisible(false);
            }
        });
        JButton jButton = new JButton(LaunchRes.getString("ClassChooser.Button.Cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaunchClassChooser.this.setVisible(false);
            }
        });
        this.searchField = new JTextField(this.defaultSearch);
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Object e = LaunchClassChooser.this.choices.getSelectedValue();
                LaunchClassChooser.this.search();
                LaunchClassChooser.this.choices.setSelectedValue(e, true);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.searchField);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.okButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(jButton);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel3, "South");
        this.scroller = new JScrollPane();
        this.scroller.setPreferredSize(new Dimension(400, 300));
        jPanel2.add((Component)this.scroller, "Center");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    public boolean setPath(String string) {
        String[] stringArray = LaunchClassChooser.parsePath(string);
        this.classMap = null;
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            if (!string2.equals("")) {
                string2 = String.valueOf(string2) + ";";
            }
            string2 = String.valueOf(string2) + stringArray[n];
            ++n;
        }
        this.classMap = classMaps.get(string2);
        if (this.classMap == null) {
            this.classMap = new LaunchableClassMap(stringArray);
            classMaps.put(string2, this.classMap);
        }
        return true;
    }

    public boolean isLoaded(String string) {
        if (this.classMap == null) {
            return false;
        }
        String[] stringArray = LaunchClassChooser.parsePath(string);
        int n = 0;
        while (n < stringArray.length) {
            if (!this.classMap.includesJar(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean chooseClassFor(LaunchNode launchNode) {
        this.search();
        this.choices.setSelectedValue(launchNode.launchClassName, true);
        this.applyChanges = false;
        this.setVisible(true);
        if (!this.applyChanges) {
            return false;
        }
        Object e = this.choices.getSelectedValue();
        if (e == null) {
            return false;
        }
        String string = e.toString();
        launchNode.launchClass = (Class)this.classMap.get(string);
        launchNode.launchClassName = string;
        return true;
    }

    public Class<?> getClass(String string) {
        if (this.classMap == null) {
            return null;
        }
        return this.classMap.getClass(string);
    }

    public static Class<?> getClass(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String[] stringArray = LaunchClassChooser.parsePath(string);
        LaunchableClassMap launchableClassMap = LaunchClassChooser.getClassMap(stringArray);
        return launchableClassMap.getClass(string2);
    }

    public static ClassLoader getClassLoader(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        String[] stringArray = LaunchClassChooser.parsePath(string);
        LaunchableClassMap launchableClassMap = LaunchClassChooser.getClassMap(stringArray);
        return launchableClassMap.classLoader;
    }

    private static LaunchableClassMap getClassMap(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            if (!string.equals("")) {
                string = String.valueOf(string) + ";";
            }
            string = String.valueOf(string) + stringArray[n];
            ++n;
        }
        LaunchableClassMap launchableClassMap = classMaps.get(string);
        if (launchableClassMap == null) {
            launchableClassMap = new LaunchableClassMap(stringArray);
            classMaps.put(string, launchableClassMap);
        }
        return launchableClassMap;
    }

    private void search() {
        if (this.classMap == null) {
            return;
        }
        this.classMap.loadAllLaunchables();
        if (this.search(this.searchField.getText())) {
            this.currentSearch = this.searchField.getText();
            this.searchField.setBackground(Color.white);
        } else {
            JOptionPane.showMessageDialog(this, String.valueOf(LaunchRes.getString("Dialog.InvalidRegex.Message")) + " \"" + this.searchField.getText() + "\"", LaunchRes.getString("Dialog.InvalidRegex.Title"), 2);
            this.searchField.setText(this.currentSearch);
        }
    }

    private boolean search(String string) {
        string = string.toLowerCase();
        this.okButton.setEnabled(false);
        try {
            pattern = Pattern.compile(string);
        }
        catch (Exception exception) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.classMap.keySet()) {
            matcher = pattern.matcher(string2.toLowerCase());
            if (!matcher.find()) continue;
            arrayList.add(string2);
        }
        Object[] objectArray = arrayList.toArray();
        this.choices = new JList<Object>(objectArray);
        this.choices.setSelectionMode(0);
        this.choices.setFont(this.searchField.getFont());
        this.choices.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                LaunchClassChooser.this.okButton.setEnabled(!jList.isSelectionEmpty());
            }
        });
        this.choices.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 2 && !jList.isSelectionEmpty()) {
                    LaunchClassChooser.this.okButton.doClick();
                }
            }
        });
        this.scroller.getViewport().setView(this.choices);
        return true;
    }

    static String[] parsePath(String string) {
        return LaunchClassChooser.parsePath(string, jarsOnly);
    }

    static String[] parsePath(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        int n = string.indexOf(";");
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        } else {
            string = "";
        }
        while (string2.length() > 0) {
            if (!bl || string2.endsWith(".jar")) {
                arrayList.add(string2);
            }
            if ((n = string.indexOf(";")) == -1) {
                string2 = string.trim();
                string = "";
                continue;
            }
            string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
        }
        return arrayList.toArray(new String[0]);
    }
}

