/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.IRK.Radau5Adaptive;
import org.opensourcephysics.ode.ODEInterpolator;

public class Radau5
extends Radau5Adaptive
implements ODEInterpolator {
    static final double c1 = (4.0 - Math.sqrt(6.0)) / 10.0;
    static final double c2 = (4.0 + Math.sqrt(6.0)) / 10.0;
    static final double c1m1 = c1 - 1.0;
    static final double c2m1 = c2 - 1.0;
    static final double c1mc2 = c1 - c2;
    double[][] interpolationCoeffs;
    double takenStepSize = 0.0;

    public Radau5(ODE oDE) {
        super(oDE);
        this.interpolationCoeffs = new double[4][oDE.getState().length];
    }

    public double step() {
        this.takenStepSize = super.step();
        this.constructInterpolationCoeffs();
        return this.takenStepSize;
    }

    public void constructInterpolationCoeffs() {
        int n = 0;
        while (n < this.numEqn) {
            this.interpolationCoeffs[0][n] = this.state[n];
            this.interpolationCoeffs[1][n] = (this.intermediateStagesIncrement[1][n] - this.intermediateStagesIncrement[2][n]) / c2m1;
            double d = (this.intermediateStagesIncrement[0][n] - this.intermediateStagesIncrement[1][n]) / c1mc2;
            double d2 = this.intermediateStagesIncrement[0][n] / c1;
            d2 = (d - d2) / c2;
            this.interpolationCoeffs[2][n] = (d - this.interpolationCoeffs[1][n]) / c1m1;
            this.interpolationCoeffs[3][n] = this.interpolationCoeffs[2][n] - d2;
            ++n;
        }
    }

    public void doInterpolation(double d, double[] dArray) {
        if (this.takenStepSize == 0.0) {
            int n = 0;
            while (n < this.numEqn) {
                dArray[n] = this.state[n];
                ++n;
            }
        }
        double d2 = (d - this.takenStepSize) / this.takenStepSize;
        int n = 0;
        while (n < this.numEqn) {
            dArray[n] = this.interpolationCoeffs[0][n] + d2 * (this.interpolationCoeffs[1][n] + (d2 - c2m1) * (this.interpolationCoeffs[2][n] + (d2 - c1m1) * this.interpolationCoeffs[3][n]));
            ++n;
        }
    }

    protected void estimateNewtonInitialValue(double[][] dArray) {
        double d = this.stepSize / this.takenStepSize;
        double d2 = c1 * d;
        double d3 = c2 * d;
        int n = 0;
        while (n < this.numEqn) {
            dArray[0][n] = d2 * (this.interpolationCoeffs[1][n] + (d2 - c2m1) * (this.interpolationCoeffs[2][n] + (d2 - c1m1) * this.interpolationCoeffs[3][n]));
            dArray[1][n] = d3 * (this.interpolationCoeffs[1][n] + (d3 - c2m1) * (this.interpolationCoeffs[2][n] + (d3 - c1m1) * this.interpolationCoeffs[3][n]));
            dArray[2][n] = d * (this.interpolationCoeffs[1][n] + (d - c2m1) * (this.interpolationCoeffs[2][n] + (d - c1m1) * this.interpolationCoeffs[3][n]));
            ++n;
        }
    }
}

