/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Polynomial;
import org.opensourcephysics.numerics.specialfunctions.Factorials;
import org.opensourcephysics.numerics.specialfunctions.Messages;
import org.opensourcephysics.numerics.specialfunctions.QNKey;

public class Legendre {
    static final ArrayList<Polynomial> legendreList;
    static final Map<QNKey, AssociatedLegendreFunction> associatedMap;

    static {
        associatedMap = new HashMap<QNKey, AssociatedLegendreFunction>();
        legendreList = new ArrayList();
        Polynomial polynomial = new Polynomial(new double[]{1.0});
        legendreList.add(polynomial);
        Polynomial polynomial2 = new Polynomial(new double[]{0.0, 1.0});
        legendreList.add(polynomial2);
    }

    private Legendre() {
    }

    public static synchronized Polynomial getPolynomial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Legendre.neg_degree"));
        }
        if (n < legendreList.size()) {
            return legendreList.get(n);
        }
        Polynomial polynomial = new Polynomial(new double[]{0.0, (2.0 * (double)n - 1.0) / (double)n});
        Polynomial polynomial2 = Legendre.getPolynomial(n - 1).multiply(polynomial);
        Polynomial polynomial3 = Legendre.getPolynomial(n - 2).multiply((1.0 - (double)n) / (double)n);
        Polynomial polynomial4 = polynomial2.add(polynomial3);
        legendreList.add(polynomial4);
        return polynomial4;
    }

    public static synchronized Function getAssociatedFunction(int n, int n2) {
        if (n2 * n2 > n * n) {
            throw new IllegalArgumentException(Messages.getString("Legendre.out_of_range_m"));
        }
        QNKey qNKey = new QNKey(n, n2);
        AssociatedLegendreFunction associatedLegendreFunction = associatedMap.get(qNKey);
        if (associatedLegendreFunction != null) {
            return associatedLegendreFunction;
        }
        associatedLegendreFunction = new AssociatedLegendreFunction(n, n2);
        associatedMap.put(qNKey, associatedLegendreFunction);
        return associatedLegendreFunction;
    }

    public static double evaluate(int n, double d) {
        return Legendre.getPolynomial(n).evaluate(d);
    }

    static class AssociatedLegendreFunction
    implements Function {
        Polynomial p;
        int n;
        int m;
        boolean oddPower;
        boolean positiveM;

        AssociatedLegendreFunction(int n, int n2) {
            this.n = n;
            this.positiveM = n2 > 0;
            this.m = n2 = Math.abs(n2);
            this.oddPower = n2 % 2 == 1;
            this.p = Legendre.getPolynomial(this.n);
            int n3 = 0;
            while (n3 < n2) {
                this.p = this.p.derivative();
                ++n3;
            }
            if (this.positiveM && this.oddPower) {
                this.p = this.p.multiply(-1.0);
            }
            if (!this.positiveM) {
                this.p = this.p.multiply(Factorials.factorial(this.n - n2) / Factorials.factorial(this.n + n2));
            }
        }

        public double evaluate(double d) {
            double d2 = Math.pow(1.0 - d * d, this.m / 2) * this.p.evaluate(d);
            return this.oddPower ? d2 * Math.sqrt(1.0 - d * d) : d2;
        }
    }
}

