/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODEEventSolver;
import org.opensourcephysics.numerics.ODEInterpolationSolver;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.numerics.TriggerODE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODEBisectionEventSolver
implements ODEEventSolver,
ODEAdaptiveSolver {
    public static final int MAX = 50;
    protected int size;
    protected double[] statea;
    protected ODESolver solver;
    protected TriggerODE triggerOde;
    protected Vector<StateEvent> eventList = new Vector();
    protected Vector<StateEvent> happened = new Vector();
    protected int errorCode = 0;
    protected boolean eventHappened = false;

    public ODEBisectionEventSolver(ODE oDE, Class<?> clazz) {
        this.triggerOde = new TriggerODE(oDE);
        try {
            Class[] classArray = new Class[]{ODE.class};
            Object[] objectArray = new Object[]{this.triggerOde};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            this.solver = (ODESolver)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("BisectionEventSolver: Solver class " + clazz + " not found!");
            System.err.println("  I will use RK4 as default solver.");
            this.solver = new RK4(this.triggerOde);
        }
    }

    @Override
    public void addEvent(StateEvent stateEvent) {
        this.eventList.add(stateEvent);
    }

    @Override
    public void removeEvent(StateEvent stateEvent) {
        this.eventList.remove(stateEvent);
    }

    @Override
    public void initialize(double d) {
        this.triggerOde.readRealState();
        this.size = this.triggerOde.getState().length;
        this.statea = new double[this.size];
        this.solver.initialize(d);
    }

    @Override
    public void setStepSize(double d) {
        this.solver.setStepSize(d);
    }

    @Override
    public double getStepSize() {
        return this.solver.getStepSize();
    }

    @Override
    public void setTolerance(double d) {
        if (this.solver instanceof ODEAdaptiveSolver) {
            ((ODEAdaptiveSolver)this.solver).setTolerance(d);
        }
    }

    @Override
    public double getTolerance() {
        if (this.solver instanceof ODEAdaptiveSolver) {
            return ((ODEAdaptiveSolver)this.solver).getTolerance();
        }
        return 0.0;
    }

    public boolean getEventHappened() {
        return this.eventHappened;
    }

    @Override
    public double step() {
        this.errorCode = 0;
        this.eventHappened = false;
        double d = 0.0;
        double d2 = this.solver.getStepSize();
        do {
            Object object;
            this.triggerOde.readRealState();
            System.arraycopy(this.triggerOde.getState(), 0, this.statea, 0, this.size);
            double d3 = this.solver.step();
            double[] dArray = this.triggerOde.getState();
            this.happened.clear();
            Object object2 = this.eventList.elements();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (!(object.evaluate(dArray) <= -object.getTolerance())) continue;
                this.happened.add((StateEvent)object);
            }
            if (this.happened.size() == 0) {
                this.triggerOde.updateRealState();
                this.solver.setStepSize(d2);
                return d3;
            }
            this.eventHappened = true;
            this.triggerOde.setState(this.statea);
            object2 = null;
            object = this.happened.elements();
            while (object.hasMoreElements()) {
                StateEvent stateEvent = (StateEvent)object.nextElement();
                if (!(Math.abs(stateEvent.evaluate(this.statea)) < stateEvent.getTolerance())) continue;
                object2 = stateEvent;
                break;
            }
            if (object2 == null) {
                if (this.solver instanceof ODEInterpolationSolver) {
                    this.solver.initialize(this.solver.getStepSize());
                }
                int n = 0;
                while (n < 50) {
                    StateEvent stateEvent;
                    this.solver.setStepSize(d3 *= 0.5);
                    double d4 = this.solver.step();
                    dArray = this.triggerOde.getState();
                    StateEvent stateEvent2 = null;
                    Enumeration<StateEvent> enumeration = this.happened.elements();
                    while (enumeration.hasMoreElements()) {
                        stateEvent = enumeration.nextElement();
                        double d5 = stateEvent.evaluate(dArray);
                        if (d5 <= -stateEvent.getTolerance()) {
                            stateEvent2 = stateEvent;
                            break;
                        }
                        if (!(d5 < stateEvent.getTolerance())) continue;
                        object2 = stateEvent;
                    }
                    if (stateEvent2 != null) {
                        enumeration = this.happened.elements();
                        while (enumeration.hasMoreElements()) {
                            stateEvent = enumeration.nextElement();
                            if (stateEvent == stateEvent2 || !(stateEvent.evaluate(dArray) > -stateEvent.getTolerance())) continue;
                            this.happened.remove(stateEvent);
                        }
                        this.triggerOde.setState(this.statea);
                        if (this.solver instanceof ODEInterpolationSolver) {
                            this.solver.initialize(this.solver.getStepSize());
                        }
                    } else {
                        d += d4;
                        System.arraycopy(dArray, 0, this.statea, 0, this.size);
                        if (object2 != null) break;
                    }
                    ++n;
                }
                if (object2 == null) {
                    object2 = this.happened.elementAt(0);
                    System.err.println("BisectionEventSolver Warning : Event not found after 50 subdivisions.");
                    System.err.println("  Event = " + object2);
                    System.err.println("  Please check your event algorithm or decrease the initial stepTime.");
                    this.errorCode = 2;
                }
            }
            this.triggerOde.updateRealState();
            if (object2.action()) {
                if (this.solver instanceof ODEInterpolationSolver) {
                    this.triggerOde.readRealState();
                    this.solver.initialize(d2);
                } else {
                    this.solver.setStepSize(d2);
                }
                return d;
            }
            if (this.solver instanceof ODEInterpolationSolver) {
                this.triggerOde.readRealState();
                this.solver.initialize(d2 - d);
                continue;
            }
            this.solver.setStepSize(d2 - d);
        } while (d < d2);
        this.solver.setStepSize(d2);
        return d;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }
}

