/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;

public class LagrangeInterpolator
implements Function {
    protected double[] hornerCoef;
    double[] xd;
    double[] yd;

    public LagrangeInterpolator(double[] dArray, double[] dArray2) {
        this.hornerCoef = new double[dArray.length];
        this.xd = dArray;
        this.yd = dArray2;
        this.computeCoefficients(dArray, dArray2);
    }

    private void computeCoefficients(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.hornerCoef[n2] = dArray2[n2];
            ++n2;
        }
        --n;
        n2 = 0;
        while (n2 < n) {
            int n3 = n;
            while (n3 > n2) {
                int n4 = n3 - 1;
                int n5 = n3 - (n2 + 1);
                this.hornerCoef[n3] = (this.hornerCoef[n3] - this.hornerCoef[n4]) / (dArray[n3] - dArray[n5]);
                --n3;
            }
            ++n2;
        }
    }

    public double evaluate(double d) {
        int n = this.hornerCoef.length;
        double d2 = this.hornerCoef[--n];
        while (--n >= 0) {
            d2 = d2 * (d - this.xd[n]) + this.hornerCoef[n];
        }
        return d2;
    }

    public double[] getCoefficients() {
        int n = this.xd.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        dArray[n - 1] = -this.xd[0];
        int n2 = 1;
        while (n2 < n) {
            int n3 = n - n2 - 1;
            while (n3 < n - 1) {
                int n4 = n3;
                dArray[n4] = dArray[n4] - this.xd[n2] * dArray[n3 + 1];
                ++n3;
            }
            int n5 = n - 1;
            dArray[n5] = dArray[n5] - this.xd[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            double d = n;
            int n6 = n - 1;
            while (n6 >= 1) {
                d = (double)n6 * dArray[n6] + this.xd[n2] * d;
                --n6;
            }
            double d2 = this.yd[n2] / d;
            double d3 = 1.0;
            int n7 = n - 1;
            while (n7 >= 0) {
                int n8 = n7;
                dArray2[n8] = dArray2[n8] + d3 * d2;
                d3 = dArray[n7] + this.xd[n2] * d3;
                --n7;
            }
            ++n2;
        }
        return dArray2;
    }
}

