/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.drawing2d.Element;

public class ElementText
extends Element {
    private String text = "";
    private Font font;
    private boolean trueSize = false;
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];
    private TextLine textLine = new TextLine();
    private AffineTransform translation = new AffineTransform();

    public ElementText() {
        this.setSizeXY(0.4, 0.4);
        this.setFont(new Font("dialog", 0, 12));
        this.getStyle().setRelativePosition(0);
        this.getStyle().setFillColor(this.getStyle().getLineColor());
    }

    public void setText(String string) {
        this.text = TeXParser.parseTeX(string);
        this.textLine.setText(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
        this.textLine.setFont(font);
    }

    public Font getFont() {
        return this.font;
    }

    public void setTrueSize(boolean bl) {
        this.trueSize = bl;
        this.setNeedToProject(true);
    }

    public boolean isTrueSize() {
        return this.trueSize;
    }

    protected void styleChanged(int n) {
        if (n == 5) {
            double d;
            double d2;
            switch (this.getStyle().getRelativePosition()) {
                default: {
                    this.textLine.setJustification(0);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    this.textLine.setJustification(2);
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    this.textLine.setJustification(1);
                }
            }
            switch (this.getStyle().getRelativePosition()) {
                default: {
                    d2 = -0.5;
                    d = -0.5;
                    break;
                }
                case 1: {
                    d2 = -0.5;
                    d = -1.0;
                    break;
                }
                case 2: {
                    d2 = -0.5;
                    d = 0.0;
                    break;
                }
                case 3: {
                    d2 = -1.0;
                    d = -0.5;
                    break;
                }
                case 4: {
                    d2 = 0.0;
                    d = -0.5;
                    break;
                }
                case 5: {
                    d2 = -1.0;
                    d = -1.0;
                    break;
                }
                case 6: {
                    d2 = 0.0;
                    d = -1.0;
                    break;
                }
                case 7: {
                    d2 = -1.0;
                    d = 0.0;
                    break;
                }
                case 8: {
                    d2 = 0.0;
                    d = 0.0;
                }
            }
            this.translation = AffineTransform.getTranslateInstance(d2, d);
        }
    }

    protected int getCorners(double[] dArray) {
        if (this.trueSize) {
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return 1;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                dArray[0] = -0.5;
                dArray[1] = -0.5;
                break;
            }
            case 1: {
                dArray[0] = -0.5;
                dArray[1] = -1.0;
                break;
            }
            case 2: {
                dArray[0] = -0.5;
                dArray[1] = 0.0;
                break;
            }
            case 3: {
                dArray[0] = -1.0;
                dArray[1] = -0.5;
                break;
            }
            case 4: {
                dArray[0] = 0.0;
                dArray[1] = -0.5;
                break;
            }
            case 5: {
                dArray[0] = -1.0;
                dArray[1] = -1.0;
                break;
            }
            case 6: {
                dArray[0] = 0.0;
                dArray[1] = -1.0;
                break;
            }
            case 7: {
                dArray[0] = -1.0;
                dArray[1] = 0.0;
                break;
            }
            case 8: {
                dArray[0] = 0.0;
                dArray[1] = 0.0;
            }
        }
        dArray[4] = dArray[2] = dArray[0] + 1.0;
        dArray[6] = dArray[0];
        dArray[3] = dArray[1];
        dArray[5] = dArray[7] = dArray[1] + 1.0;
        return 4;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.isReallyVisible() || this.text == null || this.text.length() <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.getStyle().getLineColor();
        Color color2 = this.getStyle().getFillColor();
        graphics2D.setStroke(this.getStyle().getLineStroke());
        if (this.trueSize) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            this.textLine.setColor(color);
            AffineTransform affineTransform = graphics2D.getTransform();
            try {
                AffineTransform affineTransform2 = new AffineTransform(affineTransform);
                affineTransform2.concatenate(AffineTransform.getTranslateInstance(this.pixel[0], this.pixel[1]));
                affineTransform2.concatenate(((AffineTransform)this.getTransformation()).createInverse());
                affineTransform2.concatenate(AffineTransform.getTranslateInstance(-this.pixel[0], -this.pixel[1]));
                graphics2D.setTransform(affineTransform2);
            }
            catch (Exception exception) {}
            int n = (int)this.pixel[0];
            int n2 = (int)this.pixel[1];
            int n3 = this.textLine.getHeight(graphics) / 2;
            switch (this.getStyle().getRelativePosition()) {
                case 0: 
                case 3: 
                case 4: {
                    n2 = (int)((double)n2 + (double)n3 / 2.0);
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    n2 += n3;
                    break;
                }
            }
            this.textLine.drawText(graphics2D, n, n2);
            graphics2D.setTransform(affineTransform);
        } else {
            TextLayout textLayout = new TextLayout(this.text, this.font, graphics2D.getFontRenderContext());
            Rectangle2D rectangle2D = textLayout.getBounds();
            AffineTransform affineTransform = new AffineTransform(this.translation);
            affineTransform.scale(1.0 / rectangle2D.getWidth(), -1.0 / rectangle2D.getHeight());
            affineTransform.translate(-rectangle2D.getX(), -rectangle2D.getMaxY());
            Shape shape = this.getPixelTransform(drawingPanel).createTransformedShape(textLayout.getOutline(affineTransform));
            if (color2 != null && this.getStyle().isDrawingFill()) {
                graphics2D.setPaint(color2);
                graphics2D.fill(shape);
            }
            if (color != null && this.getStyle().isDrawingLines()) {
                graphics2D.setColor(color);
                graphics2D.draw(shape);
            }
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        int n3 = this.getStyle().getSensitivity();
        if (Math.abs(this.pixel[0] - (double)n) < (double)n3 && Math.abs(this.pixel[1] - (double)n2) < (double)n3) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        this.coordinates[0] = 0.0;
        this.coordinates[1] = 0.0;
        this.getTotalTransform().transform(this.coordinates, 0, this.coordinates, 0, 1);
        this.getPanel().projectPosition(this.coordinates, this.pixel);
        this.setNeedToProject(false);
    }
}

