/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.rod_pkg;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.JSliderDouble;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing2d.PlottingPanel2D;
import users.ehu.jma.analytical_mechanics.rod_pkg.rod;
import users.ehu.jma.analytical_mechanics.rod_pkg.rodSimulation;

class rodView
extends EjsControl
implements View {
    private rodSimulation _simulation = null;
    private rod _model = null;
    public Component Main;
    public JPanel Left;
    public JPanel Void;
    public JSliderDouble Height;
    public JPanel Center;
    public JPanel Graph;
    public PlottingPanel2D Evolution;
    public InteractiveTrace HeightEvolution;
    public DrawingPanel2D Space;
    public InteractiveArrow Table;
    public InteractiveArrow Wall;
    public InteractiveArrow Rod;
    public InteractiveParticle Upper;
    public InteractiveParticle CenterPoint;
    public InteractiveTrace UpperTraj;
    public InteractiveTrace CenterTraj;
    public JPanel Times;
    public JLabel t1;
    public JLabel t2;
    public JPanel Bottom;
    public JPanel Controls;
    public JPanel Display;
    public JTextField h;
    public JTextField dt;
    public JCheckBox Pause;
    public JCheckBox ShowTrajectories;
    public JPanel Buttons;
    public JButton Start;
    public JButton Continue;
    public JButton Stop;
    public JButton Reset;
    private boolean __t_canBeChanged__ = true;
    private boolean __phi1_canBeChanged__ = true;
    private boolean __t1_canBeChanged__ = true;
    private boolean __t2_canBeChanged__ = true;
    private boolean __state_canBeChanged__ = true;
    private boolean __y0_canBeChanged__ = true;
    private boolean __dt_canBeChanged__ = true;
    private boolean __tol_canBeChanged__ = true;
    private boolean __eps_canBeChanged__ = true;
    private boolean __stopEvents_canBeChanged__ = true;
    private boolean __x1_canBeChanged__ = true;
    private boolean __y1_canBeChanged__ = true;
    private boolean __x2_canBeChanged__ = true;
    private boolean __y2_canBeChanged__ = true;
    private boolean __x3_canBeChanged__ = true;
    private boolean __y3_canBeChanged__ = true;
    private boolean __t1Label_canBeChanged__ = true;
    private boolean __t2Label_canBeChanged__ = true;
    private boolean __formatString_canBeChanged__ = true;
    private boolean __showTraj_canBeChanged__ = true;

    public rodView(rodSimulation rodSimulation2, String string, Frame frame) {
        super(rodSimulation2, string, frame);
        this._simulation = rodSimulation2;
        this._model = (rod)rodSimulation2.getModel();
        this._model._view = this;
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model._resetModel();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        if (SwingUtilities.isEventDispatchThread()) {
            this.createControl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        rodView.this.createControl();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t");
        this.addListener("phi1");
        this.addListener("t1");
        this.addListener("t2");
        this.addListener("state");
        this.addListener("y0");
        this.addListener("dt");
        this.addListener("tol");
        this.addListener("eps");
        this.addListener("stopEvents");
        this.addListener("x1");
        this.addListener("y1");
        this.addListener("x2");
        this.addListener("y2");
        this.addListener("x3");
        this.addListener("y3");
        this.addListener("t1Label");
        this.addListener("t2Label");
        this.addListener("formatString");
        this.addListener("showTraj");
    }

    @Override
    public void read() {
    }

    @Override
    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
            this.__t_canBeChanged__ = true;
        }
        if ("phi1".equals(string)) {
            this._model.phi1 = this.getDouble("phi1");
            this.__phi1_canBeChanged__ = true;
        }
        if ("t1".equals(string)) {
            this._model.t1 = this.getDouble("t1");
            this.__t1_canBeChanged__ = true;
        }
        if ("t2".equals(string)) {
            this._model.t2 = this.getDouble("t2");
            this.__t2_canBeChanged__ = true;
        }
        if ("state".equals(string)) {
            double[] dArray = (double[])this.getValue("state").getObject();
            int n = dArray.length;
            if (n > this._model.state.length) {
                n = this._model.state.length;
            }
            for (int i = 0; i < n; ++i) {
                this._model.state[i] = dArray[i];
            }
            this.__state_canBeChanged__ = true;
        }
        if ("y0".equals(string)) {
            this._model.y0 = this.getDouble("y0");
            this.__y0_canBeChanged__ = true;
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
            this.__dt_canBeChanged__ = true;
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
            this.__tol_canBeChanged__ = true;
        }
        if ("eps".equals(string)) {
            this._model.eps = this.getDouble("eps");
            this.__eps_canBeChanged__ = true;
        }
        if ("stopEvents".equals(string)) {
            this._model.stopEvents = this.getBoolean("stopEvents");
            this.__stopEvents_canBeChanged__ = true;
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
            this.__x1_canBeChanged__ = true;
        }
        if ("y1".equals(string)) {
            this._model.y1 = this.getDouble("y1");
            this.__y1_canBeChanged__ = true;
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
            this.__x2_canBeChanged__ = true;
        }
        if ("y2".equals(string)) {
            this._model.y2 = this.getDouble("y2");
            this.__y2_canBeChanged__ = true;
        }
        if ("x3".equals(string)) {
            this._model.x3 = this.getDouble("x3");
            this.__x3_canBeChanged__ = true;
        }
        if ("y3".equals(string)) {
            this._model.y3 = this.getDouble("y3");
            this.__y3_canBeChanged__ = true;
        }
        if ("t1Label".equals(string)) {
            this._model.t1Label = this.getString("t1Label");
            this.__t1Label_canBeChanged__ = true;
        }
        if ("t2Label".equals(string)) {
            this._model.t2Label = this.getString("t2Label");
            this.__t2Label_canBeChanged__ = true;
        }
        if ("formatString".equals(string)) {
            this._model.formatString = this.getString("formatString");
            this.__formatString_canBeChanged__ = true;
        }
        if ("showTraj".equals(string)) {
            this._model.showTraj = this.getBoolean("showTraj");
            this.__showTraj_canBeChanged__ = true;
        }
    }

    @Override
    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        if (this.__t_canBeChanged__) {
            this.setValue("t", this._model.t);
        }
        if (this.__phi1_canBeChanged__) {
            this.setValue("phi1", this._model.phi1);
        }
        if (this.__t1_canBeChanged__) {
            this.setValue("t1", this._model.t1);
        }
        if (this.__t2_canBeChanged__) {
            this.setValue("t2", this._model.t2);
        }
        if (this.__state_canBeChanged__) {
            this.setValue("state", this._model.state);
        }
        if (this.__y0_canBeChanged__) {
            this.setValue("y0", this._model.y0);
        }
        if (this.__dt_canBeChanged__) {
            this.setValue("dt", this._model.dt);
        }
        if (this.__tol_canBeChanged__) {
            this.setValue("tol", this._model.tol);
        }
        if (this.__eps_canBeChanged__) {
            this.setValue("eps", this._model.eps);
        }
        if (this.__stopEvents_canBeChanged__) {
            this.setValue("stopEvents", this._model.stopEvents);
        }
        if (this.__x1_canBeChanged__) {
            this.setValue("x1", this._model.x1);
        }
        if (this.__y1_canBeChanged__) {
            this.setValue("y1", this._model.y1);
        }
        if (this.__x2_canBeChanged__) {
            this.setValue("x2", this._model.x2);
        }
        if (this.__y2_canBeChanged__) {
            this.setValue("y2", this._model.y2);
        }
        if (this.__x3_canBeChanged__) {
            this.setValue("x3", this._model.x3);
        }
        if (this.__y3_canBeChanged__) {
            this.setValue("y3", this._model.y3);
        }
        if (this.__t1Label_canBeChanged__) {
            this.setValue("t1Label", this._model.t1Label);
        }
        if (this.__t2Label_canBeChanged__) {
            this.setValue("t2Label", this._model.t2Label);
        }
        if (this.__formatString_canBeChanged__) {
            this.setValue("formatString", this._model.formatString);
        }
        if (this.__showTraj_canBeChanged__) {
            this.setValue("showTraj", this._model.showTraj);
        }
    }

    @Override
    public void blockVariable(String string) {
        if ("t".equals(string)) {
            this.__t_canBeChanged__ = false;
        }
        if ("phi1".equals(string)) {
            this.__phi1_canBeChanged__ = false;
        }
        if ("t1".equals(string)) {
            this.__t1_canBeChanged__ = false;
        }
        if ("t2".equals(string)) {
            this.__t2_canBeChanged__ = false;
        }
        if ("state".equals(string)) {
            this.__state_canBeChanged__ = false;
        }
        if ("y0".equals(string)) {
            this.__y0_canBeChanged__ = false;
        }
        if ("dt".equals(string)) {
            this.__dt_canBeChanged__ = false;
        }
        if ("tol".equals(string)) {
            this.__tol_canBeChanged__ = false;
        }
        if ("eps".equals(string)) {
            this.__eps_canBeChanged__ = false;
        }
        if ("stopEvents".equals(string)) {
            this.__stopEvents_canBeChanged__ = false;
        }
        if ("x1".equals(string)) {
            this.__x1_canBeChanged__ = false;
        }
        if ("y1".equals(string)) {
            this.__y1_canBeChanged__ = false;
        }
        if ("x2".equals(string)) {
            this.__x2_canBeChanged__ = false;
        }
        if ("y2".equals(string)) {
            this.__y2_canBeChanged__ = false;
        }
        if ("x3".equals(string)) {
            this.__x3_canBeChanged__ = false;
        }
        if ("y3".equals(string)) {
            this.__y3_canBeChanged__ = false;
        }
        if ("t1Label".equals(string)) {
            this.__t1Label_canBeChanged__ = false;
        }
        if ("t2Label".equals(string)) {
            this.__t2Label_canBeChanged__ = false;
        }
        if ("formatString".equals(string)) {
            this.__formatString_canBeChanged__ = false;
        }
        if ("showTraj".equals(string)) {
            this.__showTraj_canBeChanged__ = false;
        }
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("waitForReset", "true").setProperty("title", "Falling rod").setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,-4").setProperty("size", "640,460").getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Void = (JPanel)this.addElement(new ControlPanel(), "Void").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("layout", "border").setProperty("background", "239,239,255,255").getObject();
        this.Height = (JSliderDouble)this.addElement(new ControlSlider(), "Height").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Left").setProperty("variable", "y0").setProperty("minimum", "0.01").setProperty("maximum", ".999").setProperty("orientation", "VERTICAL").setProperty("enabled", "_isPaused").setProperty("dragaction", "_model._method_for_Height_dragaction()").setProperty("action", "_model._method_for_Height_action()").setProperty("background", "239,239,255,255").setProperty("tooltip", "Initial height of upper end").getObject();
        this.Center = (JPanel)this.addElement(new ControlPanel(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Graph = (JPanel)this.addElement(new ControlPanel(), "Graph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Center").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Evolution = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("title", "Evolution of the upper end height").setProperty("titleX", "t").setProperty("titleY", "y").setProperty("xFormat", "t = 0.###").setProperty("yFormat", "y = 0.###").getObject();
        this.HeightEvolution = (InteractiveTrace)this.addElement(new ControlTrace(), "HeightEvolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "t").setProperty("y", "y1").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").setProperty("stroke", "2").getObject();
        this.Space = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-.5").setProperty("maximumX", "1.5").setProperty("minimumY", "-.05").setProperty("maximumY", "1.05").setProperty("square", "true").setProperty("xFormat", "null").setProperty("yFormat", "y = 0.###").getObject();
        this.Table = (InteractiveArrow)this.addElement(new ControlArrow(), "Table").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9").getObject();
        this.Wall = (InteractiveArrow)this.addElement(new ControlArrow(), "Wall").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "-.03").setProperty("y", "0").setProperty("sizex", "0").setProperty("sizey", "1.1").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9").getObject();
        this.Rod = (InteractiveArrow)this.addElement(new ControlArrow(), "Rod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("y", "y1").setProperty("sizex", "%_model._method_for_Rod_sizex()%").setProperty("sizey", "%_model._method_for_Rod_sizey()%").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "black").setProperty("stroke", "5").getObject();
        this.Upper = (InteractiveParticle)this.addElement(new ControlParticle(), "Upper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("y", "y1").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("visible", "showTraj").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "red").getObject();
        this.CenterPoint = (InteractiveParticle)this.addElement(new ControlParticle(), "CenterPoint").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x2").setProperty("y", "y2").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("visible", "showTraj").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "blue").getObject();
        this.UpperTraj = (InteractiveTrace)this.addElement(new ControlTrace(), "UpperTraj").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("y", "y1").setProperty("visible", "showTraj").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").getObject();
        this.CenterTraj = (InteractiveTrace)this.addElement(new ControlTrace(), "CenterTraj").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x2").setProperty("y", "y2").setProperty("visible", "showTraj").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").getObject();
        this.Times = (JPanel)this.addElement(new ControlPanel(), "Times").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Center").setProperty("layout", "grid:1,2,0,0").getObject();
        this.t1 = (JLabel)this.addElement(new ControlLabel(), "t1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("text", "%t1Label%").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", "At this time the rod leaves the wall").getObject();
        this.t2 = (JLabel)this.addElement(new ControlLabel(), "t2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("text", "%t2Label%").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", "At this time the rod reaches the horizontal").getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "border").getObject();
        this.Display = (JPanel)this.addElement(new ControlPanel(), "Display").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("layout", "hbox").getObject();
        this.h = (JTextField)this.addElement(new ControlParsedNumberField(), "h").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "y0").setProperty("format", "h = 0.###").setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_h_action()").setProperty("tooltip", "Initial height of upper end").getObject();
        this.dt = (JTextField)this.addElement(new ControlParsedNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "dt").setProperty("format", "$\\Delta$t = 0.####").setProperty("tooltip", "Integration step").getObject();
        this.Pause = (JCheckBox)this.addElement(new ControlCheckBox(), "Pause").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "stopEvents").setProperty("text", "Events").setProperty("mnemonic", "e").setProperty("tooltip", "Pause when the rod leaves the wall or reaches the horizontal").getObject();
        this.ShowTrajectories = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowTrajectories").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "showTraj").setProperty("text", "Trajectories").setProperty("mnemonic", "t").setProperty("tooltip", "Show the trajectories of the upper end and the center point").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Controls").setProperty("layout", "grid:1,4,0,0").getObject();
        this.Start = (JButton)this.addElement(new ControlButton(), "Start").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", "/org/opensourcephysics/resources/controls/images/play.gif").setProperty("mnemonic", "g").setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_Start_action()").setProperty("tooltip", "Start simulation from initial conditions").getObject();
        this.Continue = (JButton)this.addElement(new ControlButton(), "Continue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", "/org/opensourcephysics/resources/controls/images/continue.gif").setProperty("mnemonic", "c").setProperty("enabled", "%_model._method_for_Continue_enabled()%").setProperty("action", "_model._method_for_Continue_action()").setProperty("tooltip", "Continue simulation").getObject();
        this.Stop = (JButton)this.addElement(new ControlButton(), "Stop").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", "/org/opensourcephysics/resources/controls/images/pause.gif").setProperty("mnemonic", "s").setProperty("enabled", "_isPlaying").setProperty("action", "_model._method_for_Stop_action()").setProperty("tooltip", "Stop simulation").getObject();
        this.Reset = (JButton)this.addElement(new ControlButton(), "Reset").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("text", "Reset").setProperty("image", "/org/opensourcephysics/resources/controls/images/reset.gif").setProperty("mnemonic", "r").setProperty("action", "_model._method_for_Reset_action()").setProperty("tooltip", "Reciver initial settings").getObject();
    }

    @Override
    public void reset() {
        this.getElement("Main").setProperty("title", "Falling rod").setProperty("visible", "true");
        this.getElement("Left");
        this.getElement("Void").setProperty("background", "239,239,255,255");
        this.getElement("Height").setProperty("minimum", "0.01").setProperty("maximum", ".999").setProperty("orientation", "VERTICAL").setProperty("background", "239,239,255,255").setProperty("tooltip", "Initial height of upper end");
        this.getElement("Center");
        this.getElement("Graph");
        this.getElement("Evolution").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("title", "Evolution of the upper end height").setProperty("titleY", "y").setProperty("xFormat", "t = 0.###").setProperty("yFormat", "y = 0.###");
        this.getElement("HeightEvolution").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").setProperty("stroke", "2");
        this.getElement("Space").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-.5").setProperty("maximumX", "1.5").setProperty("minimumY", "-.05").setProperty("maximumY", "1.05").setProperty("square", "true").setProperty("xFormat", "null").setProperty("yFormat", "y = 0.###");
        this.getElement("Table").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9");
        this.getElement("Wall").setProperty("x", "-.03").setProperty("y", "0").setProperty("sizex", "0").setProperty("sizey", "1.1").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9");
        this.getElement("Rod").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "black").setProperty("stroke", "5");
        this.getElement("Upper").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "red");
        this.getElement("CenterPoint").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "blue");
        this.getElement("UpperTraj").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("CenterTraj").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Times");
        this.getElement("t1").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", "At this time the rod leaves the wall");
        this.getElement("t2").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", "At this time the rod reaches the horizontal");
        this.getElement("Bottom");
        this.getElement("Controls");
        this.getElement("Display");
        this.getElement("h").setProperty("format", "h = 0.###").setProperty("tooltip", "Initial height of upper end");
        this.getElement("dt").setProperty("format", "$\\Delta$t = 0.####").setProperty("tooltip", "Integration step");
        this.getElement("Pause").setProperty("text", "Events").setProperty("mnemonic", "e").setProperty("tooltip", "Pause when the rod leaves the wall or reaches the horizontal");
        this.getElement("ShowTrajectories").setProperty("text", "Trajectories").setProperty("tooltip", "Show the trajectories of the upper end and the center point");
        this.getElement("Buttons");
        this.getElement("Start").setProperty("image", "/org/opensourcephysics/resources/controls/images/play.gif").setProperty("mnemonic", "g").setProperty("tooltip", "Start simulation from initial conditions");
        this.getElement("Continue").setProperty("image", "/org/opensourcephysics/resources/controls/images/continue.gif").setProperty("mnemonic", "c").setProperty("tooltip", "Continue simulation");
        this.getElement("Stop").setProperty("image", "/org/opensourcephysics/resources/controls/images/pause.gif").setProperty("mnemonic", "s").setProperty("tooltip", "Stop simulation");
        this.getElement("Reset").setProperty("text", "Reset").setProperty("image", "/org/opensourcephysics/resources/controls/images/reset.gif").setProperty("mnemonic", "r").setProperty("tooltip", "Reciver initial settings");
        this.__t_canBeChanged__ = true;
        this.__phi1_canBeChanged__ = true;
        this.__t1_canBeChanged__ = true;
        this.__t2_canBeChanged__ = true;
        this.__state_canBeChanged__ = true;
        this.__y0_canBeChanged__ = true;
        this.__dt_canBeChanged__ = true;
        this.__tol_canBeChanged__ = true;
        this.__eps_canBeChanged__ = true;
        this.__stopEvents_canBeChanged__ = true;
        this.__x1_canBeChanged__ = true;
        this.__y1_canBeChanged__ = true;
        this.__x2_canBeChanged__ = true;
        this.__y2_canBeChanged__ = true;
        this.__x3_canBeChanged__ = true;
        this.__y3_canBeChanged__ = true;
        this.__t1Label_canBeChanged__ = true;
        this.__t2Label_canBeChanged__ = true;
        this.__formatString_canBeChanged__ = true;
        this.__showTraj_canBeChanged__ = true;
        super.reset();
    }
}

