/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public abstract class SimpleAbstractTile
extends SimpleElement {
    protected static final int RECOMPUTE_VERTEX = 24;
    protected int[][] a = null;
    protected int[][] b = null;
    private int numberOfTiles = -1;
    private double[][][] standardTile = null;
    private double[][][] vertex = null;
    private double[] pixel = new double[3];
    private double[] center = new double[3];
    private boolean drawQuickInterior = false;
    private int interiorTransparency = 128;

    public SimpleAbstractTile(Element element) {
        super(element);
    }

    protected abstract double[][][] computeTile();

    public void processChanges(int n, int n2) {
        if ((n2 & 0x18) != 0) {
            this.computeVertex();
            this.computeCoordinates();
            this.projectPoints();
        } else if ((n2 & 0x136) != 0) {
            this.computeCoordinates();
            this.projectPoints();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoints();
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        if (this.element.getColorLevels() != null && this.element.getColorPalette() != null) {
            this.drawColorCoded(graphics2D, n);
            return;
        }
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        int n2 = this.vertex[n].length;
        if (this.style.isDrawingFill()) {
            graphics2D.setPaint(drawingPanel3D.projectPaint(this.style.getFillColor(), this.objects[n].getDistance()));
            graphics2D.fillPolygon(this.a[n], this.b[n], n2);
        }
        if (this.style.isDrawingLines()) {
            graphics2D.setStroke(this.style.getLineStroke());
            graphics2D.setColor(drawingPanel3D.projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
            graphics2D.drawPolygon(this.a[n], this.b[n], n2);
        }
    }

    public void drawQuickly(Graphics2D graphics2D) {
        if (this.style.isDrawingFill() || this.drawQuickInterior) {
            Color color;
            Paint paint = this.style.getFillColor();
            if (this.drawQuickInterior && paint instanceof Color && (color = (Color)paint).getAlpha() > this.interiorTransparency) {
                paint = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.interiorTransparency);
            }
            graphics2D.setPaint(paint);
            int n = 0;
            while (n < this.numberOfTiles) {
                graphics2D.fillPolygon(this.a[n], this.b[n], this.vertex[n].length);
                ++n;
            }
        }
        if (this.style.isDrawingLines()) {
            graphics2D.setStroke(this.style.getLineStroke());
            graphics2D.setColor(this.style.getLineColor());
            int n = 0;
            while (n < this.numberOfTiles) {
                graphics2D.drawPolygon(this.a[n], this.b[n], this.vertex[n].length);
                ++n;
            }
        }
    }

    protected final void computeVertex() {
        this.standardTile = this.computeTile();
        if (this.standardTile == null) {
            this.numberOfTiles = 0;
            return;
        }
        if (this.standardTile.length != this.numberOfTiles) {
            this.numberOfTiles = this.standardTile.length;
            this.vertex = new double[this.numberOfTiles][][];
            this.a = new int[this.numberOfTiles][];
            this.b = new int[this.numberOfTiles][];
            this.objects = new Object3D[this.numberOfTiles];
        }
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.standardTile[n].length;
            if (this.a[n] == null || n2 != this.a[n].length) {
                this.vertex[n] = new double[n2][3];
                this.a[n] = new int[n2];
                this.b[n] = new int[n2];
            }
            this.objects[n] = new Object3D(this, n);
            ++n;
        }
    }

    protected final void computeCoordinates() {
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = 0;
            int n3 = this.vertex[n].length;
            while (n2 < n3) {
                System.arraycopy(this.standardTile[n][n2], 0, this.vertex[n][n2], 0, 3);
                this.element.sizeAndToSpaceFrame(this.vertex[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    protected final void projectPoints() {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        double d = this.style.getDepthFactor();
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.vertex[n].length;
            int n3 = 0;
            while (n3 < 3) {
                this.center[n3] = 0.0;
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                System.arraycopy(this.vertex[n][n3], 0, this.pixel, 0, 3);
                drawingPanel3D.projectPosition(this.pixel);
                this.a[n][n3] = (int)this.pixel[0];
                this.b[n][n3] = (int)this.pixel[1];
                int n4 = 0;
                while (n4 < 3) {
                    int n5 = n4;
                    this.center[n5] = this.center[n5] + this.vertex[n][n3][n4];
                    ++n4;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < 3) {
                int n6 = n3++;
                this.center[n6] = this.center[n6] / (double)n2;
            }
            drawingPanel3D.projectPosition(this.center);
            this.objects[n].setDistance(this.center[2] * d);
            ++n;
        }
    }

    public void setDrawQuickInterior(boolean bl, int n) {
        this.drawQuickInterior = bl;
        this.interiorTransparency = Math.max(0, Math.min(n, 255));
    }

    private void drawColorCoded(Graphics2D graphics2D, int n) {
        int n2;
        int n3;
        double d;
        int n4;
        int n5 = this.vertex[n].length;
        int[] nArray = new int[n5];
        double[] dArray = this.element.getColorLevels();
        if (this.element.getColorBelowWhenEqual()) {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = 0;
                d = this.element.levelScalarProduct(this.vertex[n][n4]);
                n3 = dArray.length - 1;
                while (n3 >= 0) {
                    if (d > dArray[n3]) {
                        nArray[n4] = n3 + 1;
                        break;
                    }
                    --n3;
                }
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = dArray.length;
                d = this.element.levelScalarProduct(this.vertex[n][n4]);
                n3 = 0;
                n2 = dArray.length;
                while (n3 < n2) {
                    if (d < dArray[n3]) {
                        nArray[n4] = n3;
                        break;
                    }
                    ++n3;
                }
                ++n4;
            }
        }
        int[] nArray2 = new int[n5 * 2];
        int[] nArray3 = new int[n5 * 2];
        Color[] colorArray = this.element.getColorPalette();
        n3 = 0;
        n2 = dArray.length;
        while (n3 <= n2) {
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                double d2;
                int n8 = (n7 + 1) % n5;
                if (nArray[n7] <= n3 && nArray[n8] >= n3) {
                    if (nArray[n7] == n3) {
                        nArray2[n6] = this.a[n][n7];
                        nArray3[n6] = this.b[n][n7];
                        ++n6;
                    } else {
                        d2 = this.element.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (dArray[n3 - 1] - d2) / (this.element.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n6] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n6] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n6;
                    }
                    if (nArray[n8] > n3) {
                        d2 = this.element.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (dArray[n3] - d2) / (this.element.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n6] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n6] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n6;
                    }
                } else if (nArray[n7] >= n3 && nArray[n8] <= n3) {
                    if (nArray[n7] == n3) {
                        nArray2[n6] = this.a[n][n7];
                        nArray3[n6] = this.b[n][n7];
                        ++n6;
                    } else {
                        d2 = this.element.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (dArray[n3] - d2) / (this.element.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n6] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n6] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n6;
                    }
                    if (nArray[n8] < n3) {
                        d2 = this.element.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (dArray[n3 - 1] - d2) / (this.element.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n6] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n6] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n6;
                    }
                }
                ++n7;
            }
            if (n6 > 0) {
                Color color = n3 >= colorArray.length ? colorArray[colorArray.length - 1] : colorArray[n3];
                graphics2D.setPaint(color);
                graphics2D.fillPolygon(nArray2, nArray3, n6);
            }
            ++n3;
        }
        graphics2D.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.drawPolygon(this.a[n], this.b[n], n5);
    }
}

