/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Vector3f;
import org.opensourcephysics.drawing3d.ElementSurface;
import org.opensourcephysics.drawing3d.java3d.Java3dAbstractTile;

public class Java3dElementSurface
extends Java3dAbstractTile {
    private BranchGroup bgSurface;
    private QuadArray lines = null;
    private Shape3D shape = null;
    private Appearance appLines = this.getAppLines();

    public Java3dElementSurface(ElementSurface elementSurface) {
        super(elementSurface);
    }

    public boolean isPrimitive() {
        return false;
    }

    protected Vector3f[] createStandardNormals(double[][][] dArray, int n, int n2, int n3) {
        int n4 = dArray.length;
        Vector3f[] vector3fArray = new Vector3f[n4];
        int n5 = 0;
        while (n5 < n4) {
            Vector3f vector3f = new Vector3f();
            vector3f.sub(new Vector3f((float)dArray[n5][0][0], (float)dArray[n5][0][1], (float)dArray[n5][0][2]), new Vector3f((float)dArray[n5][1][0], (float)dArray[n5][1][1], (float)dArray[n5][1][2]));
            Vector3f vector3f2 = new Vector3f();
            vector3f2.sub(new Vector3f((float)dArray[n5][1][0], (float)dArray[n5][1][1], (float)dArray[n5][1][2]), new Vector3f((float)dArray[n5][2][0], (float)dArray[n5][2][1], (float)dArray[n5][2][2]));
            vector3fArray[n5] = new Vector3f();
            vector3fArray[n5].cross(vector3f, vector3f2);
            vector3fArray[n5].normalize();
            ++n5;
        }
        return vector3fArray;
    }

    protected double[][][] createStandardTile(int n, int n2, int n3) {
        double[][][] dArray = ((ElementSurface)this.element).getData();
        if (dArray == null) {
            return new double[0][0][3];
        }
        int n4 = dArray.length - 1;
        int n5 = dArray[0].length - 1;
        double[][][] dArray2 = new double[n4 * n5][4][3];
        int n6 = 0;
        int n7 = 0;
        int n8 = n4 * n5 * 4;
        this.lines = new QuadArray(n8 * 2, 3);
        this.lines.setCapability(0);
        this.lines.setCapability(1);
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n4) {
                int n11 = 0;
                while (n11 < 3) {
                    dArray2[n6][0][n11] = dArray[n10][n9][n11];
                    dArray2[n6][1][n11] = dArray[n10 + 1][n9][n11];
                    dArray2[n6][2][n11] = dArray[n10 + 1][n9 + 1][n11];
                    dArray2[n6][3][n11] = dArray[n10][n9 + 1][n11];
                    ++n11;
                }
                this.lines.setCoordinate(n7++, dArray2[n6][0]);
                this.lines.setCoordinate(n7++, dArray2[n6][1]);
                this.lines.setCoordinate(n7++, dArray2[n6][2]);
                this.lines.setCoordinate(n7++, dArray2[n6][3]);
                this.lines.setCoordinate(n7++, dArray2[n6][3]);
                this.lines.setCoordinate(n7++, dArray2[n6][2]);
                this.lines.setCoordinate(n7++, dArray2[n6][1]);
                this.lines.setCoordinate(n7++, dArray2[n6][0]);
                ++n10;
                ++n6;
            }
            ++n9;
        }
        this.setLines();
        return dArray2;
    }

    private void setLines() {
        if (this.lines == null) {
            return;
        }
        this.shape = new Shape3D();
        this.shape.setGeometry((Geometry)this.lines);
        this.shape.setAppearance(this.appLines);
        int n = this.bg.indexOfChild((Node)this.bgSurface);
        this.bgSurface = new BranchGroup();
        this.bgSurface.setCapability(17);
        this.bgSurface.setCapability(14);
        this.bgSurface.setCapability(13);
        this.bgSurface.setCapability(12);
        this.bgSurface.addChild((Node)this.shape);
        if (this.bg.numChildren() > 1 && n != -1) {
            this.bg.setChild((Node)this.bgSurface, n);
        } else if (this.bg.numChildren() > 1 && n == -1) {
            this.bg.setChild((Node)this.bgSurface, 1);
        } else {
            this.bg.addChild((Node)this.bgSurface);
        }
    }

    private Appearance getAppLines() {
        Appearance appearance = new Appearance();
        appearance.setCapability(15);
        appearance.setCapability(14);
        appearance.setCapability(9);
        appearance.setCapability(12);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(1);
        polygonAttributes.setCapability(3);
        polygonAttributes.setCapability(5);
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.getPolygonAttributes().setPolygonMode(1);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineAntialiasingEnable(true);
        lineAttributes.setLineWidth(1.0f);
        lineAttributes.setCapability(0);
        lineAttributes.setCapability(1);
        appearance.setLineAttributes(lineAttributes);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        renderingAttributes.setCapability(10);
        appearance.setRenderingAttributes(renderingAttributes);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        appearance.setTransparencyAttributes(transparencyAttributes);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setCapability(1);
        appearance.setColoringAttributes(coloringAttributes);
        appearance.getColoringAttributes().setColor(0.0f, 0.0f, 0.0f);
        return appearance;
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 1) != 0) {
            this.appLines.getRenderingAttributes().setVisible(this.element.isVisible());
        }
    }

    public void styleChanged(int n) {
        if (this.appLines == null) {
            return;
        }
        if (n == 4) {
            if (!this.element.getStyle().isDrawingLines()) {
                this.appLines.getRenderingAttributes().setVisible(false);
            } else {
                this.appLines.getRenderingAttributes().setVisible(true);
            }
        } else if (n == 1) {
            this.appLines.getLineAttributes().setLineWidth(this.element.getStyle().getLineWidth());
        } else if (n == 0) {
            Color color = this.element.getStyle().getLineColor();
            float[] fArray = color.getRGBComponents(null);
            this.appLines.getRenderingAttributes().setIgnoreVertexColors(true);
            this.appLines.getColoringAttributes().setColor(fArray[0], fArray[1], fArray[2]);
            this.appLines.getPolygonAttributes().setCullFace(0);
            this.appLines.getTransparencyAttributes().setTransparencyMode(4);
        } else if (n == 10) {
            if (this.element.getStyle().getTextures()[0] == null && this.element.getStyle().getTextures()[1] == null) {
                this.appLines.getRenderingAttributes().setVisible(this.element.getStyle().isDrawingLines());
            } else {
                this.appLines.getRenderingAttributes().setVisible(false);
            }
            super.styleChanged(n);
        } else {
            super.styleChanged(n);
        }
    }
}

