/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Cone;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Vector3d;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.java3d.Java3dElementSegment;

public class Java3dElementArrow
extends Java3dElementSegment {
    private static final double HEAD_SCALE = 0.075;
    private double size = 1.25;
    private TransformGroup coneTg;
    private Transform3D coneTransform;

    public Java3dElementArrow(ElementArrow elementArrow) {
        super(elementArrow);
        this.element.getStyle().setDrawingFill(true);
        Cone cone = new Cone(0.5f, 1.0f, 3, 10, 10, this.getAppearance());
        this.size = ((ElementArrow)this.element).getHeadSize();
        this.coneTransform = new Transform3D();
        this.coneTg = new TransformGroup();
        this.coneTg.setCapability(18);
        this.coneTg.setCapability(13);
        this.coneTg.setCapability(14);
        this.coneTg.setTransform(this.coneTransform);
        this.coneTg.addChild((Node)cone);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.addChild((Node)this.coneTg);
        this.getBranchGroup().addChild((Node)branchGroup);
        this.resetConePosition();
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 0x66) != 0) {
            this.resetConePosition();
        }
    }

    public void styleChanged(int n) {
        super.styleChanged(n);
        switch (n) {
            case 1: {
                this.size = 1.25;
                if (this.element.getStyle().getLineWidth() > 1.0f) {
                    this.size += (double)(this.element.getStyle().getLineWidth() - 1.0f) * 0.5;
                }
                this.resetConePosition();
            }
        }
    }

    public boolean isPrimitive() {
        return false;
    }

    private void resetConePosition() {
        Vector3d vector3d = new Vector3d(0.0, 1.0, 0.0);
        Vector3d vector3d2 = new Vector3d(this.getSizeVector());
        vector3d2.normalize();
        vector3d2.x = Double.isNaN(vector3d2.x) ? 0.0 : vector3d2.x;
        vector3d2.y = Double.isNaN(vector3d2.y) ? 0.0 : vector3d2.y;
        vector3d2.z = Double.isNaN(vector3d2.z) ? 0.0 : vector3d2.z;
        AxisAngle4d axisAngle4d = new AxisAngle4d();
        axisAngle4d.angle = Math.acos(vector3d.dot(vector3d2));
        Vector3d vector3d3 = this.getSizeVector();
        if (vector3d3.x == 0.0 && vector3d3.y < 0.0 && vector3d3.z == 0.0) {
            vector3d3.z = 1.0E-5;
        }
        vector3d.cross(vector3d, vector3d3);
        axisAngle4d.x = vector3d.x;
        axisAngle4d.y = vector3d.y;
        axisAngle4d.z = vector3d.z;
        double d = vector3d3.length() * 0.075 * this.size;
        vector3d2.scale(vector3d3.length() * 0.075 * 0.5);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.x = this.getPositionVector().x;
        vector3d4.y = this.getPositionVector().y;
        vector3d4.z = this.getPositionVector().z;
        vector3d2.sub(vector3d4);
        vector3d2.sub(vector3d3, vector3d2);
        this.coneTransform.set(axisAngle4d);
        this.coneTransform.setTranslation(vector3d2);
        this.coneTransform.setScale(d);
        this.coneTg.setTransform(this.coneTransform);
    }
}

