/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d.utils;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.utils.ControlTransformation3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.utils.transformations.QuaternionRotation;
import org.opensourcephysics.numerics.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlQuaternionTransformation
extends ControlTransformation3D {
    private static final int QUATERNION_ADDED = 6;
    protected QuaternionRotation quaternion;
    protected double[] origin;
    private double q0;
    private double q1;
    private double q2;
    private double q3;
    private static List<String> infoList = null;

    @Override
    protected Transformation createTransformation() {
        this.origin = new double[]{0.0, 0.0, 0.0};
        this.q0 = 1.0;
        this.q3 = 0.0;
        this.q2 = 0.0;
        this.q1 = 0.0;
        this.quaternion = new QuaternionRotation(this.q0, this.q1, this.q2, this.q3);
        return this.quaternion;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.utils.transformations.QuaternionRotation";
    }

    @Override
    protected void setAffectedElement(Element element) {
        this.quaternion.setElement(element);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("origin");
            infoList.add("q");
            infoList.add("q0");
            infoList.add("q1");
            infoList.add("q2");
            infoList.add("q3");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("origin")) {
            return "double[]";
        }
        if (string.equals("q")) {
            return "double[]";
        }
        if (string.equals("q0")) {
            return "double";
        }
        if (string.equals("q1")) {
            return "double";
        }
        if (string.equals("q2")) {
            return "double";
        }
        if (string.equals("q3")) {
            return "double";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                double[] dArray = null;
                if (value.getObject() instanceof double[]) {
                    dArray = (double[])value.getObject();
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    dArray = new double[]{nArray[0], nArray[1], nArray[2]};
                }
                if (dArray == null || dArray.equals(this.origin)) break;
                System.arraycopy(dArray, 0, this.origin, 0, 3);
                this.quaternion.setOrigin(dArray);
                break;
            }
            case 1: {
                boolean bl = false;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (this.q0 != dArray[0]) {
                        this.q0 = dArray[0];
                        bl = true;
                    }
                    if (this.q1 != dArray[1]) {
                        this.q1 = dArray[1];
                        bl = true;
                    }
                    if (this.q2 != dArray[2]) {
                        this.q2 = dArray[2];
                        bl = true;
                    }
                    if (this.q3 != dArray[3]) {
                        this.q3 = dArray[3];
                        bl = true;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    if (this.q0 != (double)nArray[0]) {
                        this.q0 = nArray[0];
                        bl = true;
                    }
                    if (this.q1 != (double)nArray[1]) {
                        this.q1 = nArray[1];
                        bl = true;
                    }
                    if (this.q2 != (double)nArray[2]) {
                        this.q2 = nArray[2];
                        bl = true;
                    }
                    if (this.q3 != (double)nArray[3]) {
                        this.q3 = nArray[3];
                        bl = true;
                    }
                }
                if (!bl) break;
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 2: {
                if (value.getDouble() == this.q0) break;
                this.q0 = value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 3: {
                if (value.getDouble() == this.q1) break;
                this.q1 = value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 4: {
                if (value.getDouble() == this.q2) break;
                this.q2 = value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            case 5: {
                if (value.getDouble() == this.q3) break;
                this.q3 = value.getDouble();
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, this.q3);
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.origin = new double[]{0.0, 0.0, 0.0};
                this.quaternion.setOrigin(this.origin);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.q0 = 1.0;
                this.quaternion.setCoordinates(1.0, this.q1, this.q2, this.q3);
                break;
            }
            case 3: {
                this.q1 = 0.0;
                this.quaternion.setCoordinates(this.q0, 0.0, this.q2, this.q3);
                break;
            }
            case 4: {
                this.q2 = 0.0;
                this.quaternion.setCoordinates(this.q0, this.q1, 0.0, this.q3);
                break;
            }
            case 5: {
                this.q3 = 0.0;
                this.quaternion.setCoordinates(this.q0, this.q1, this.q2, 0.0);
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "new double[]{0,0,0}";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "1";
            }
            case 3: {
                return "0";
            }
            case 4: {
                return "0";
            }
            case 5: {
                return "0";
            }
        }
        return super.getDefaultValueString(n - 6);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }

    @Override
    public Object clone() {
        ControlQuaternionTransformation controlQuaternionTransformation = new ControlQuaternionTransformation();
        controlQuaternionTransformation.enabled = this.enabled;
        controlQuaternionTransformation.transformation = (Transformation)this.transformation.clone();
        controlQuaternionTransformation.myParent = null;
        controlQuaternionTransformation.quaternion = (QuaternionRotation)controlQuaternionTransformation.transformation;
        controlQuaternionTransformation.origin = (double[])this.origin.clone();
        controlQuaternionTransformation.q0 = this.q0;
        controlQuaternionTransformation.q1 = this.q1;
        controlQuaternionTransformation.q2 = this.q2;
        controlQuaternionTransformation.q3 = this.q3;
        return controlQuaternionTransformation;
    }
}

