/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigDevice;
import com.sun.j3d.utils.universe.ConfigObject;
import com.sun.j3d.utils.universe.ConfigPhysicalBody;
import com.sun.j3d.utils.universe.ConfigPhysicalEnvironment;
import com.sun.j3d.utils.universe.ConfigScreen;
import com.sun.j3d.utils.universe.ConfigSensor;
import com.sun.j3d.utils.universe.ConfigSexpression;
import com.sun.j3d.utils.universe.ConfigView;
import com.sun.j3d.utils.universe.ConfigViewPlatform;
import com.sun.j3d.utils.universe.ConfigViewPlatformBehavior;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.Canvas3D;

public class ConfigContainer {
    private Map baseNameMap = new HashMap();
    private Map viewCanvasMap = new HashMap();
    private ReadOnlyMap bodyMap = null;
    private ReadOnlyMap environmentMap = null;
    private ReadOnlyMap viewerMap = null;
    private ReadOnlyMap deviceMap = null;
    private ReadOnlyMap sensorMap = null;
    private ReadOnlyMap behaviorMap = null;
    private ReadOnlyMap platformMap = null;
    private ReadOnlyMap genericObjectMap = null;
    private ReadOnlySet bodies = null;
    private ReadOnlySet environments = null;
    private ReadOnlySet viewers = null;
    private ReadOnlySet devices = null;
    private ReadOnlySet sensors = null;
    private ReadOnlySet behaviors = null;
    private ReadOnlySet platforms = null;
    private ReadOnlySet genericObjects = null;
    private int transformCount = 1;
    private boolean setVisible = false;
    private ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    String currentFileName = null;

    public ConfigContainer(URL uRL) {
        this(uRL, false, 1, true);
    }

    public ConfigContainer(URL uRL, ClassLoader classLoader) {
        this(uRL, false, 1, true, classLoader);
    }

    public ConfigContainer(URL uRL, boolean bl, int n) {
        this(uRL, bl, n, true);
    }

    public ConfigContainer(URL uRL, boolean bl, int n, ClassLoader classLoader) {
        this(uRL, bl, n, true, classLoader);
    }

    ConfigContainer(URL uRL, boolean bl, int n, boolean bl2) {
        if (n < 1) {
            throw new IllegalArgumentException("transformCount must be greater than 0");
        }
        this.loadConfig(uRL);
        this.processConfig(bl, n, bl2);
    }

    ConfigContainer(URL uRL, boolean bl, int n, boolean bl2, ClassLoader classLoader) {
        this(uRL, bl, n, bl2);
        this.classLoader = classLoader;
    }

    private void loadConfig(URL uRL) {
        Object object;
        InputStream inputStream = null;
        StreamTokenizer streamTokenizer = null;
        String string = this.currentFileName;
        this.currentFileName = uRL.toString();
        try {
            inputStream = uRL.openStream();
            object = new BufferedReader(new InputStreamReader(inputStream));
            streamTokenizer = new StreamTokenizer((Reader)object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException + "\nUnable to open " + this.currentFileName);
        }
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(123, 125);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        object = new ConfigSexpression();
        while (((ConfigSexpression)object).parseAndEval(this, streamTokenizer, 0) != Boolean.FALSE) {
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException + "\nUnable to close " + this.currentFileName);
        }
        this.currentFileName = string;
    }

    void evaluateCommand(ArrayList arrayList, int n) {
        ConfigCommand configCommand = new ConfigCommand(arrayList, this.currentFileName, n);
        switch (configCommand.type) {
            case 0: {
                ConfigObject configObject = this.createConfigObject(configCommand);
                this.addConfigObject(configObject);
                break;
            }
            case 3: {
                ConfigObject configObject = this.createConfigAlias(configCommand);
                this.addConfigObject(configObject);
                break;
            }
            case 2: {
                ConfigObject configObject = this.findConfigObject(configCommand.baseName, configCommand.instanceName);
                configObject.setProperty(configCommand);
                break;
            }
            case 5: {
                if (!(configCommand.argv[1] instanceof String)) {
                    throw new IllegalArgumentException("Include file must be a URL string");
                }
                URL uRL = null;
                String string = (String)configCommand.argv[1];
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException(malformedURLException.toString());
                }
                this.loadConfig(uRL);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command \"" + configCommand.commandName + "\"");
            }
        }
    }

    private ConfigObject createConfigObject(ConfigCommand configCommand) {
        Class<?> clazz = null;
        ConfigObject configObject = null;
        try {
            clazz = Class.forName("com.sun.j3d.utils.universe.Config" + configCommand.baseName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("\"" + configCommand.baseName + "\"" + " is not a configurable object; ignoring command");
        }
        try {
            configObject = (ConfigObject)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            throw new IllegalArgumentException("Ignoring command");
        }
        catch (InstantiationException instantiationException) {
            System.out.println(instantiationException);
            throw new IllegalArgumentException("Ignoring command");
        }
        for (int i = 2; i < configCommand.argc; ++i) {
            if (!(configCommand.argv[i] instanceof String) || !((String)configCommand.argv[i]).equals("Alias")) continue;
            if (i == configCommand.argc - 2 && configCommand.argv[i + 1] instanceof String) {
                this.addConfigObject(new ConfigAlias(configCommand.baseName, (String)configCommand.argv[i + 1], configObject));
                configCommand.argc -= 2;
                continue;
            }
            throw new IllegalArgumentException("The alias name must be a string and must be the last command argument");
        }
        configObject.baseName = configCommand.baseName;
        configObject.instanceName = configCommand.instanceName;
        configObject.creatingCommand = configCommand;
        configObject.configContainer = this;
        configObject.setClassLoader(this.classLoader);
        configObject.initialize(configCommand);
        return configObject;
    }

    private ConfigObject createConfigAlias(ConfigCommand configCommand) {
        if (configCommand.argc != 3 || !(configCommand.argv[2] instanceof String)) {
            throw new IllegalArgumentException("Command \"" + configCommand.commandName + "\" requires an instance name as second argument");
        }
        ConfigObject configObject = this.findConfigObject(configCommand.baseName, (String)configCommand.argv[2]);
        return new ConfigAlias(configCommand.baseName, configCommand.instanceName, configObject);
    }

    private void addConfigObject(ConfigObject configObject) {
        ArrayList<ConfigObject> arrayList = (ArrayList<ConfigObject>)this.baseNameMap.get(configObject.baseName);
        if (arrayList == null) {
            arrayList = new ArrayList<ConfigObject>();
            this.baseNameMap.put(configObject.baseName, arrayList);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ConfigObject configObject2 = (ConfigObject)arrayList.get(i);
            if (!configObject2.instanceName.equals(configObject.instanceName)) continue;
            String string = configObject.baseName;
            if (string.equals("Screen")) {
                string = "Screen or Window";
            }
            throw new IllegalArgumentException("Duplicate " + string + " instance name \"" + configObject.instanceName + "\" ignored");
        }
        arrayList.add(configObject);
    }

    ConfigObject findConfigObject(String string, String string2) {
        ArrayList arrayList = (ArrayList)this.baseNameMap.get(string);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ConfigObject configObject = (ConfigObject)arrayList.get(i);
                if (!configObject.instanceName.equals(string2)) continue;
                if (configObject.isAlias) {
                    return configObject.original;
                }
                return configObject;
            }
        }
        if (string.equals("Screen")) {
            string = "Screen or Window";
        }
        throw new IllegalArgumentException(string + " \"" + string2 + "\" not found");
    }

    Collection findConfigObjects(String string) {
        return this.findConfigObjects(string, true);
    }

    Collection findConfigObjects(String string, boolean bl) {
        ArrayList arrayList = (ArrayList)this.baseNameMap.get(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        if (bl) {
            ArrayList<ConfigObject> arrayList2 = new ArrayList<ConfigObject>();
            for (int i = 0; i < arrayList.size(); ++i) {
                ConfigObject configObject = (ConfigObject)arrayList.get(i);
                if (configObject.isAlias) continue;
                arrayList2.add(configObject);
            }
            return arrayList2;
        }
        return arrayList;
    }

    private ConfigObject findConfigObject(String string, ConfigCommand configCommand) {
        if (configCommand.argc != 2 || !(configCommand.argv[1] instanceof String)) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, "Parameter must be a single string"));
        }
        try {
            return this.findConfigObject(string, (String)configCommand.argv[1]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, illegalArgumentException.getMessage()));
        }
    }

    Object evaluateBuiltIn(ConfigCommand configCommand) {
        int n = configCommand.argc;
        Object[] objectArray = configCommand.argv;
        if (configCommand.commandName.equals("ConfigContainer")) {
            return this;
        }
        if (configCommand.commandName.equals("Canvas3D")) {
            return ((ConfigScreen)this.findConfigObject((String)"Screen", (ConfigCommand)configCommand)).j3dCanvas;
        }
        if (this.baseNameMap.get(configCommand.commandName) != null) {
            return this.findConfigObject((String)configCommand.commandName, (ConfigCommand)configCommand).targetObject;
        }
        throw new IllegalArgumentException(ConfigObject.errorMessage(configCommand, "Unknown built-in command \"" + configCommand.commandName + "\""));
    }

    private void processConfig(boolean bl, int n, boolean bl2) {
        Collection collection;
        Collection collection2;
        this.setVisible = bl;
        this.transformCount = n;
        Collection collection3 = this.findConfigObjects("PhysicalBody");
        if (collection3 != null) {
            this.processPhysicalBodies(collection3);
        }
        if ((collection2 = this.findConfigObjects("PhysicalEnvironment")) != null) {
            this.processPhysicalEnvironments(collection2);
        }
        if ((collection3 = this.findConfigObjects("View")) != null) {
            this.processViews(collection3, bl);
        }
        collection3 = this.findConfigObjects("Device");
        Collection collection4 = this.findConfigObjects("Sensor");
        if (collection3 != null) {
            this.processDevices(collection3, collection4, collection2);
        }
        if ((collection = this.findConfigObjects("ViewPlatform")) != null) {
            this.processViewPlatforms(collection, n);
        }
        if ((collection3 = this.findConfigObjects("ViewPlatformBehavior")) != null) {
            this.processViewPlatformBehaviors(collection3, collection, bl2);
        }
        if ((collection3 = this.findConfigObjects("Object")) != null) {
            this.processGenericObjects(collection3);
        }
    }

    private void processPhysicalEnvironments(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConfigPhysicalEnvironment configPhysicalEnvironment = (ConfigPhysicalEnvironment)iterator.next();
            configPhysicalEnvironment.targetObject = configPhysicalEnvironment.createJ3dPhysicalEnvironment();
        }
    }

    private void processPhysicalBodies(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConfigPhysicalBody configPhysicalBody = (ConfigPhysicalBody)iterator.next();
            configPhysicalBody.targetObject = configPhysicalBody.createJ3dPhysicalBody();
        }
    }

    private void processViews(Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConfigView configView = (ConfigView)iterator.next();
            configView.targetObject = configView.createViewer(bl);
        }
    }

    private void processDevices(Collection collection, Collection collection2, Collection collection3) {
        ConfigDevice configDevice = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            configDevice = (ConfigDevice)iterator.next();
            configDevice.targetObject = configDevice.createInputDevice();
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((ConfigDevice)iterator.next()).processProperties();
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            configDevice = (ConfigDevice)iterator.next();
            if (configDevice.j3dInputDevice.initialize()) continue;
            throw new RuntimeException(ConfigDevice.errorMessage(configDevice.creatingCommand, "could not initialize device \"" + configDevice.instanceName + "\""));
        }
        if (collection2 != null) {
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                ConfigSensor configSensor = (ConfigSensor)iterator.next();
                configSensor.configureSensor();
                configSensor.targetObject = configSensor.j3dSensor;
            }
        }
        if (collection3 != null) {
            iterator = collection3.iterator();
            while (iterator.hasNext()) {
                ((ConfigPhysicalEnvironment)iterator.next()).processDevices();
            }
        }
    }

    private void processViewPlatforms(Collection collection, int n) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConfigViewPlatform configViewPlatform = (ConfigViewPlatform)iterator.next();
            configViewPlatform.targetObject = configViewPlatform.createViewingPlatform(n);
        }
    }

    private void processViewPlatformBehaviors(Collection collection, Collection collection2, boolean bl) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConfigViewPlatformBehavior configViewPlatformBehavior = (ConfigViewPlatformBehavior)iterator.next();
            configViewPlatformBehavior.targetObject = configViewPlatformBehavior.createViewPlatformBehavior();
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((ConfigViewPlatformBehavior)iterator.next()).processProperties();
        }
        if (bl && collection2 != null) {
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                ((ConfigViewPlatform)iterator.next()).processBehavior();
            }
        }
    }

    private void processGenericObjects(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConfigObject configObject = (ConfigObject)iterator.next();
            configObject.targetObject = configObject.createTargetObject();
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((ConfigObject)iterator.next()).processProperties();
        }
    }

    private ReadOnlySet createSet(String string) {
        Collection collection = this.findConfigObjects(string, true);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Iterator iterator = collection.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            arrayList.add(((ConfigObject)iterator.next()).targetObject);
        }
        return new ReadOnlySet(arrayList);
    }

    private ReadOnlyMap createMap(String string) {
        Collection collection = this.findConfigObjects(string, false);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Iterator iterator = collection.iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            ConfigObject configObject = (ConfigObject)iterator.next();
            if (configObject.isAlias) {
                hashMap.put(configObject.instanceName, configObject.original.targetObject);
                continue;
            }
            hashMap.put(configObject.instanceName, configObject.targetObject);
        }
        return new ReadOnlyMap(hashMap);
    }

    public Set getPhysicalBodies() {
        if (this.bodies != null) {
            return this.bodies;
        }
        this.bodies = this.createSet("PhysicalBody");
        return this.bodies;
    }

    public Map getNamedPhysicalBodies() {
        if (this.bodyMap != null) {
            return this.bodyMap;
        }
        this.bodyMap = this.createMap("PhysicalBody");
        return this.bodyMap;
    }

    public Set getPhysicalEnvironments() {
        if (this.environments != null) {
            return this.environments;
        }
        this.environments = this.createSet("PhysicalEnvironment");
        return this.environments;
    }

    public Map getNamedPhysicalEnvironments() {
        if (this.environmentMap != null) {
            return this.environmentMap;
        }
        this.environmentMap = this.createMap("PhysicalEnvironment");
        return this.environmentMap;
    }

    public Set getViewers() {
        if (this.viewers != null) {
            return this.viewers;
        }
        this.viewers = this.createSet("View");
        return this.viewers;
    }

    public Map getNamedViewers() {
        if (this.viewerMap != null) {
            return this.viewerMap;
        }
        this.viewerMap = this.createMap("View");
        return this.viewerMap;
    }

    public Set getInputDevices() {
        if (this.devices != null) {
            return this.devices;
        }
        this.devices = this.createSet("Device");
        return this.devices;
    }

    public Map getNamedInputDevices() {
        if (this.deviceMap != null) {
            return this.deviceMap;
        }
        this.deviceMap = this.createMap("Device");
        return this.deviceMap;
    }

    public Set getSensors() {
        if (this.sensors != null) {
            return this.sensors;
        }
        this.sensors = this.createSet("Sensor");
        return this.sensors;
    }

    public Map getNamedSensors() {
        if (this.sensorMap != null) {
            return this.sensorMap;
        }
        this.sensorMap = this.createMap("Sensor");
        return this.sensorMap;
    }

    public Set getViewingPlatforms() {
        if (this.platforms != null) {
            return this.platforms;
        }
        this.platforms = this.createSet("ViewPlatform");
        return this.platforms;
    }

    public Map getNamedViewingPlatforms() {
        if (this.platformMap != null) {
            return this.platformMap;
        }
        this.platformMap = this.createMap("ViewPlatform");
        return this.platformMap;
    }

    public Set getViewPlatformBehaviors() {
        if (this.behaviors != null) {
            return this.behaviors;
        }
        this.behaviors = this.createSet("ViewPlatformBehavior");
        return this.behaviors;
    }

    public Map getNamedViewPlatformBehaviors() {
        if (this.behaviorMap != null) {
            return this.behaviorMap;
        }
        this.behaviorMap = this.createMap("ViewPlatformBehavior");
        return this.behaviorMap;
    }

    public Map getNamedCanvases(String string) {
        AbstractMap abstractMap = (HashMap<String, Canvas3D>)this.viewCanvasMap.get(string);
        if (abstractMap != null) {
            return abstractMap;
        }
        abstractMap = new HashMap<String, Canvas3D>();
        ConfigView configView = (ConfigView)this.findConfigObject("View", string);
        Iterator iterator = configView.screens.iterator();
        while (iterator.hasNext()) {
            ConfigScreen configScreen = (ConfigScreen)iterator.next();
            abstractMap.put(configScreen.instanceName, configScreen.j3dCanvas);
            Iterator iterator2 = configScreen.aliases.iterator();
            while (iterator2.hasNext()) {
                abstractMap.put(iterator2.next(), configScreen.j3dCanvas);
            }
        }
        abstractMap = new ReadOnlyMap(abstractMap);
        this.viewCanvasMap.put(string, abstractMap);
        return abstractMap;
    }

    public Set getGenericObjects() {
        if (this.genericObjects != null) {
            return this.genericObjects;
        }
        this.genericObjects = this.createSet("Object");
        return this.genericObjects;
    }

    public Map getNamedGenericObjects() {
        if (this.genericObjectMap != null) {
            return this.genericObjectMap;
        }
        this.genericObjectMap = this.createMap("Object");
        return this.genericObjectMap;
    }

    public int getViewPlatformTransformCount() {
        return this.transformCount;
    }

    public boolean getViewerVisibility() {
        return this.setVisible;
    }

    public void clear() {
        Iterator iterator = this.baseNameMap.values().iterator();
        while (iterator.hasNext()) {
            ((Collection)iterator.next()).clear();
        }
        this.baseNameMap.clear();
        iterator = this.viewCanvasMap.values().iterator();
        while (iterator.hasNext()) {
            ((ReadOnlyMap)iterator.next()).map.clear();
        }
        this.viewCanvasMap.clear();
        this.currentFileName = null;
        if (this.bodies != null) {
            this.bodies.collection.clear();
            this.bodies = null;
        }
        if (this.environments != null) {
            this.environments.collection.clear();
            this.environments = null;
        }
        if (this.devices != null) {
            this.devices.collection.clear();
            this.devices = null;
        }
        if (this.sensors != null) {
            this.sensors.collection.clear();
            this.sensors = null;
        }
        if (this.behaviors != null) {
            this.behaviors.collection.clear();
            this.behaviors = null;
        }
        if (this.platforms != null) {
            this.platforms.collection.clear();
            this.platforms = null;
        }
        if (this.viewers != null) {
            this.viewers.collection.clear();
            this.viewers = null;
        }
        if (this.genericObjects != null) {
            this.genericObjects.collection.clear();
            this.genericObjects = null;
        }
        if (this.bodyMap != null) {
            this.bodyMap.map.clear();
            this.bodyMap = null;
        }
        if (this.environmentMap != null) {
            this.environmentMap.map.clear();
            this.environmentMap = null;
        }
        if (this.deviceMap != null) {
            this.deviceMap.map.clear();
            this.deviceMap = null;
        }
        if (this.sensorMap != null) {
            this.sensorMap.map.clear();
            this.sensorMap = null;
        }
        if (this.behaviorMap != null) {
            this.behaviorMap.map.clear();
            this.behaviorMap = null;
        }
        if (this.platformMap != null) {
            this.platformMap.map.clear();
            this.platformMap = null;
        }
        if (this.viewerMap != null) {
            this.viewerMap.map.clear();
            this.viewerMap = null;
        }
        if (this.genericObjectMap != null) {
            this.genericObjectMap.map.clear();
            this.genericObjectMap = null;
        }
    }

    public static URL getConfigURL() {
        return ConfigContainer.getConfigURL(null);
    }

    public static URL getConfigURL(String string) {
        URL uRL = null;
        String string2 = null;
        final String string3 = string;
        string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.configURL", string3);
            }
        });
        if (string2 == null) {
            return null;
        }
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
            return null;
        }
        return uRL;
    }

    private static class ReadOnlyIterator
    implements Iterator {
        private Iterator i;

        ReadOnlyIterator(Iterator iterator) {
            this.i = iterator;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadOnlySet
    extends AbstractSet {
        Collection collection = null;

        ReadOnlySet(Collection collection) {
            this.collection = collection;
        }

        public int size() {
            return this.collection.size();
        }

        public Iterator iterator() {
            return new ReadOnlyIterator(this.collection.iterator());
        }
    }

    private static class ReadOnlyMap
    extends AbstractMap {
        HashMap map;
        private Set entrySet = null;

        ReadOnlyMap(Map map) {
            this.map = new HashMap(map);
        }

        public Object get(Object object) {
            return this.map.get(object);
        }

        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new ReadOnlySet(this.map.entrySet());
            }
            return this.entrySet;
        }
    }

    private static class ConfigAlias
    extends ConfigObject {
        ConfigAlias(String string, String string2, ConfigObject configObject) {
            this.baseName = string;
            this.instanceName = string2;
            this.isAlias = true;
            this.original = configObject;
            configObject.aliases.add(string2);
        }
    }
}

