/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.special_relativity.train;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.special_relativity.train.trainSimulation;
import users.ehu.jma.special_relativity.train.trainView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class train
extends AbstractModel {
    public trainSimulation _simulation = null;
    public trainView _view = null;
    public train _model = this;
    public double beta = 0.6;
    public double gamma = 0.0;
    public double L = 0.8;
    public double t = 0.0;
    public double t1 = 0.0;
    public double x1 = 0.0;
    public double t2 = 0.0;
    public double x2 = 0.0;
    public double td = 0.0;
    public double xd = 0.0;
    public double xu1 = 0.0;
    public double xu2 = 0.0;
    public double xup1 = 0.0;
    public double xup2 = 0.0;
    public double xr1 = 0.0;
    public double xr2 = 0.0;
    public double xrp1 = 0.0;
    public double xrp2 = 0.0;
    public boolean showTrain = false;
    public boolean showDiagram = false;
    public boolean showAxes = false;
    public double dt = 0.02;
    public double u1 = 0.0;
    public double u2 = 0.0;
    public double r1 = 0.0;
    public double r2 = 0.0;
    public double t0 = -1.0;
    public double xmin = -2.0;
    public double xmax = 2.0;
    public double ymin = -0.1;
    public double ymax = 1.0;
    public double htunnel = 0.5;
    public boolean stopEvent = true;
    public boolean stopped1 = false;
    public boolean stopped2 = false;
    public boolean stoppedd = false;
    public double sina = 0.0;
    public double cosa = 0.0;

    public static String _getEjsModel() {
        return "users/ehu/jma/special_relativity/train.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/special_relativity/train3.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/special_relativity/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        train train2 = new train(stringArray);
    }

    public train() {
        this(null, null, null, null, null, false);
    }

    public train(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public train(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new trainSimulation(this, string, frame, uRL, bl);
        this._view = (trainView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.initial();
    }

    public void _evolution1() {
        this.update(this.t + this.dt);
    }

    public void _constraints1() {
        if (this.beta <= 0.0 || this.beta >= 1.0) {
            this.beta = 0.6;
        }
        this.gamma = 1.0 / Math.sqrt(1.0 - this.beta * this.beta);
        if (this.gamma * this.L < 1.0) {
            this.L = 1.0 / this.gamma;
        }
    }

    public void set_velocity() {
        if (this.beta <= 0.0 || this.beta >= 1.0) {
            this.beta = 0.6;
        }
        this.gamma = 1.0 / Math.sqrt(1.0 - this.beta * this.beta);
        this.sina = this.beta;
        if (this.showTrain) {
            this.sina = -this.sina;
        }
        this.cosa = 1.0 / Math.sqrt(1.0 + this.sina * this.sina);
        this.sina *= this.cosa;
        this.sina *= 4.0;
        this.cosa *= 4.0;
    }

    public void events() {
        if (this.showTrain) {
            this.td = this.L / this.gamma / this.beta;
            this.t1 = 1.0 / this.beta;
            this.t2 = this.t1 - this.gamma * this.beta * this.L;
            this.x1 = -1.0;
            this.x2 = this.gamma * this.L - 1.0;
            this.xd = 0.0;
        } else {
            this.td = this.L / this.beta;
            this.t1 = this.t2 = 1.0 / this.beta / this.gamma;
            this.x1 = 0.0;
            this.x2 = this.xd = this.L;
        }
    }

    public void initial() {
        this.set_velocity();
        this.events();
        this._view.resetTraces();
        this.stoppedd = false;
        this.stopped2 = false;
        this.stopped1 = false;
        this.update(this.t0);
    }

    public void checkEvents() {
        boolean bl = false;
        if (Math.abs(this.t - this.t1) < 0.5 * this.dt && !this.stopped1) {
            bl = true;
            this.stopped1 = true;
        }
        if (Math.abs(this.t - this.t2) < 0.5 * this.dt && !this.stopped2) {
            bl = true;
            this.stopped2 = true;
        }
        if (Math.abs(this.t - this.td) < 0.5 * this.dt && !this.stoppedd) {
            bl = true;
            this.stoppedd = true;
        }
        if (bl) {
            this._pause();
        }
    }

    public void update(double d) {
        this.t = d;
        this.xu1 = 0.0;
        this.xu2 = this.L;
        this.xup1 = -this.beta * this.t;
        this.xup2 = this.L / this.gamma - this.beta * this.t;
        this.xrp1 = -1.0;
        this.xrp2 = 0.0;
        this.xr1 = -1.0 / this.gamma + this.beta * this.t;
        this.xr2 = this.beta * this.t;
        if (this.showTrain) {
            this.u1 = this.xup1;
            this.u2 = this.xup2;
            this.r1 = this.xrp1;
            this.r2 = this.xrp2;
        } else {
            this.u1 = this.xu1;
            this.u2 = this.xu2;
            this.r1 = this.xr1;
            this.r2 = this.xr2;
        }
        if (this.stopEvent) {
            this.checkEvents();
        }
        if (this.u2 < this.xmin || this.r1 > this.xmax) {
            this.stoppedd = false;
            this.stopped2 = false;
            this.stopped1 = false;
            this._pause();
        }
    }

    public double _method_for_Rails_sizex() {
        return this.xmax - this.xmin;
    }

    public double _method_for_Loco0_sizex() {
        return this.r2 - this.r1;
    }

    public double _method_for_Tunnel_sizex() {
        return this.u2 - this.u1;
    }

    public double _method_for_LeftDoor_y() {
        return this.t < this.t1 - 0.5 * this.dt ? this.htunnel : 0.0;
    }

    public double _method_for_RightDoor_x() {
        return this.t < this.td ? this.u2 : this.r2;
    }

    public double _method_for_RightDoor_y() {
        return this.t < this.t2 - 0.5 * this.dt ? this.htunnel : 0.0;
    }

    public double _method_for_Inside_x() {
        return 0.5 * (this.u1 + this.u2);
    }

    public double _method_for_Inside_y() {
        return this.htunnel + 0.3;
    }

    public boolean _method_for_Inside_visible() {
        return this.t >= this.t1 - 0.5 * this.dt && this.t <= this.td + 0.5 * this.dt;
    }

    public double _method_for_Broken_x() {
        return this.r2 + 0.15;
    }

    public double _method_for_Broken_y() {
        return 0.5 * this.htunnel;
    }

    public boolean _method_for_Broken_visible() {
        return this.t > this.td + 0.5 * this.dt;
    }

    public double _method_for_TunnelName_x() {
        return 0.5 * (this.u1 + this.u2);
    }

    public double _method_for_TunnelName_y() {
        return this.htunnel + 0.1;
    }

    public void _method_for_Stun_actionon() {
        this._simulation.disableLoop();
        this.showTrain = false;
        this.initial();
        this._simulation.enableLoop();
    }

    public void _method_for_Stun_actionoff() {
        this._simulation.disableLoop();
        this.showTrain = true;
        this.initial();
        this._simulation.enableLoop();
    }

    public void _method_for_Stra_actionon() {
        this._simulation.disableLoop();
        this.showTrain = true;
        this.initial();
        this._simulation.enableLoop();
    }

    public void _method_for_Stra_actionoff() {
        this._simulation.disableLoop();
        this.showTrain = false;
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Velocity_editable() {
        return this._isPaused();
    }

    public void _method_for_Velocity_action() {
        this._simulation.disableLoop();
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Luzera_editable() {
        return this._isPaused();
    }

    public void _method_for_Luzera_action() {
        this._simulation.disableLoop();
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_StepLength_editable() {
        return this._isPaused();
    }

    public boolean _method_for_StopEvents_enabled() {
        return this._isPaused();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Diagram_maximumY() {
        return this.t0 + this.xmax - this.xmin;
    }

    public double _method_for_time1_x() {
        return this.x1 - this.cosa;
    }

    public double _method_for_time1_y() {
        return this.t1 - this.sina;
    }

    public double _method_for_time1_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time1_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time1_visible() {
        return this.showAxes && !this.showTrain && this.t >= this.t1;
    }

    public double _method_for_time2_x() {
        return this.x2 - this.cosa;
    }

    public double _method_for_time2_y() {
        return this.t2 - this.sina;
    }

    public double _method_for_time2_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time2_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time2_visible() {
        return this.showAxes && !this.showTrain && this.t >= this.t2;
    }

    public double _method_for_time3_x() {
        return this.xd - this.cosa;
    }

    public double _method_for_time3_y() {
        return this.td - this.sina;
    }

    public double _method_for_time3_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time3_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time3_visible() {
        return this.showAxes && !this.showTrain && this.t >= this.td;
    }

    public double _method_for_time4_x() {
        return this.x1 - this.cosa;
    }

    public double _method_for_time4_y() {
        return this.t1 - this.sina;
    }

    public double _method_for_time4_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time4_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time4_visible() {
        return this.showAxes && this.showTrain && this.t >= this.t1;
    }

    public double _method_for_time5_x() {
        return this.x2 - this.cosa;
    }

    public double _method_for_time5_y() {
        return this.t2 - this.sina;
    }

    public double _method_for_time5_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time5_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time5_visible() {
        return this.showAxes && this.showTrain && this.t >= this.t2;
    }

    public double _method_for_time6_x() {
        return this.xd - this.cosa;
    }

    public double _method_for_time6_y() {
        return this.td - this.sina;
    }

    public double _method_for_time6_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time6_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time6_visible() {
        return this.showAxes && this.showTrain && this.t >= this.td;
    }

    public boolean _method_for_Event1_visible() {
        return this.t >= this.t1 + 0.5 * this.dt;
    }

    public boolean _method_for_Event2_visible() {
        return this.t >= this.t2 + 0.5 * this.dt;
    }

    public boolean _method_for_Eventd_visible() {
        return this.t >= this.td + 0.5 * this.dt;
    }

    @Override
    public synchronized void reset() {
        this.beta = 0.6;
        this.gamma = 0.0;
        this.L = 0.8;
        this.t = 0.0;
        this.t1 = 0.0;
        this.x1 = 0.0;
        this.t2 = 0.0;
        this.x2 = 0.0;
        this.td = 0.0;
        this.xd = 0.0;
        this.xu1 = 0.0;
        this.xu2 = 0.0;
        this.xup1 = 0.0;
        this.xup2 = 0.0;
        this.xr1 = 0.0;
        this.xr2 = 0.0;
        this.xrp1 = 0.0;
        this.xrp2 = 0.0;
        this.showTrain = false;
        this.showDiagram = false;
        this.showAxes = false;
        this.dt = 0.02;
        this.u1 = 0.0;
        this.u2 = 0.0;
        this.r1 = 0.0;
        this.r2 = 0.0;
        this.t0 = -1.0;
        this.xmin = -2.0;
        this.xmax = 2.0;
        this.ymin = -0.1;
        this.ymax = 1.0;
        this.htunnel = 0.5;
        this.stopEvent = true;
        this.stopped1 = false;
        this.stopped2 = false;
        this.stoppedd = false;
        this.sina = 0.0;
        this.cosa = 0.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

