/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.special_relativity.simultaneity;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlText;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlRadioButton;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.special_relativity.simultaneity.simultaneity;
import users.ehu.jma.special_relativity.simultaneity.simultaneitySimulation;

class simultaneityView
extends EjsControl
implements View {
    private simultaneitySimulation _simulation = null;
    private simultaneity _model = null;
    public Component Main;
    public JPanel Upper;
    public DrawingPanel2D Space;
    public InteractiveArrow XRedAxis;
    public InteractiveArrow RedAxis;
    public InteractiveArrow GreenAxis;
    public InteractiveArrow Xaxis;
    public InteractiveText RedLabel;
    public InteractiveText GreenLabel;
    public InteractiveText RedOrigin;
    public InteractiveText GreenOrigin;
    public InteractiveText Xlabel;
    public InteractiveParticle Source;
    public InteractiveParticle LeftDetector;
    public InteractiveParticle RightDetector;
    public InteractiveParticle Wavefront;
    public JPanel Lower;
    public JPanel Radio;
    public JPanel Systems;
    public JRadioButton Ssystem;
    public JRadioButton Sprime;
    public JPanel Waves;
    public JRadioButton Argia;
    public JRadioButton Sound;
    public JPanel Control;
    public JTextField Velocity;
    public JTextField StepLength;
    public JCheckBox StopEvents;
    public JCheckBox ShowDiagrama;
    public JTextField Gamma;
    public JButton startButton;
    public JButton continueButton;
    public JButton resetButton;
    public JDialog Minkowski;
    public PlottingPanel2D Diagram;
    public InteractiveTrace SourceWL;
    public InteractiveTrace LeftWL;
    public InteractiveTrace RightWL;
    public InteractiveTrace BackWL;
    public InteractiveTrace ForwardWL;
    public InteractiveArrow time1;
    public InteractiveArrow time2;
    public InteractiveArrow time3;
    public InteractiveArrow time4;
    public InteractiveArrow time5;
    public InteractiveArrow time6;
    public InteractiveParticle Event1;
    public InteractiveParticle Event2;
    public InteractiveParticle Event0;
    public JPanel Status;
    public JCheckBox ShowAxes;

    public simultaneityView(simultaneitySimulation simultaneitySimulation2, String string, Frame frame) {
        super(simultaneitySimulation2, string, frame);
        this._simulation = simultaneitySimulation2;
        this._model = (simultaneity)simultaneitySimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("beta", "apply(\"beta\")");
        this.addListener("gamma", "apply(\"gamma\")");
        this.addListener("d", "apply(\"d\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("t1", "apply(\"t1\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("t2", "apply(\"t2\")");
        this.addListener("x2", "apply(\"x2\")");
        this.addListener("x0", "apply(\"x0\")");
        this.addListener("wr", "apply(\"wr\")");
        this.addListener("wg", "apply(\"wg\")");
        this.addListener("w0", "apply(\"w0\")");
        this.addListener("w1", "apply(\"w1\")");
        this.addListener("w2", "apply(\"w2\")");
        this.addListener("u1", "apply(\"u1\")");
        this.addListener("u2", "apply(\"u2\")");
        this.addListener("showRed", "apply(\"showRed\")");
        this.addListener("showDiagram", "apply(\"showDiagram\")");
        this.addListener("showAxes", "apply(\"showAxes\")");
        this.addListener("showLight", "apply(\"showLight\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymin", "apply(\"ymin\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("hvert", "apply(\"hvert\")");
        this.addListener("xx0", "apply(\"xx0\")");
        this.addListener("y0", "apply(\"y0\")");
        this.addListener("stopEvent", "apply(\"stopEvent\")");
        this.addListener("stopped1", "apply(\"stopped1\")");
        this.addListener("stopped2", "apply(\"stopped2\")");
        this.addListener("stoppedd", "apply(\"stoppedd\")");
        this.addListener("sina", "apply(\"sina\")");
        this.addListener("cosa", "apply(\"cosa\")");
        this.addListener("xw", "apply(\"xw\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("beta".equals(string)) {
            this._model.beta = this.getDouble("beta");
        }
        if ("gamma".equals(string)) {
            this._model.gamma = this.getDouble("gamma");
        }
        if ("d".equals(string)) {
            this._model.d = this.getDouble("d");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("t1".equals(string)) {
            this._model.t1 = this.getDouble("t1");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("t2".equals(string)) {
            this._model.t2 = this.getDouble("t2");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
        if ("x0".equals(string)) {
            this._model.x0 = this.getDouble("x0");
        }
        if ("wr".equals(string)) {
            this._model.wr = this.getDouble("wr");
        }
        if ("wg".equals(string)) {
            this._model.wg = this.getDouble("wg");
        }
        if ("w0".equals(string)) {
            this._model.w0 = this.getDouble("w0");
        }
        if ("w1".equals(string)) {
            this._model.w1 = this.getDouble("w1");
        }
        if ("w2".equals(string)) {
            this._model.w2 = this.getDouble("w2");
        }
        if ("u1".equals(string)) {
            this._model.u1 = this.getDouble("u1");
        }
        if ("u2".equals(string)) {
            this._model.u2 = this.getDouble("u2");
        }
        if ("showRed".equals(string)) {
            this._model.showRed = this.getBoolean("showRed");
        }
        if ("showDiagram".equals(string)) {
            this._model.showDiagram = this.getBoolean("showDiagram");
        }
        if ("showAxes".equals(string)) {
            this._model.showAxes = this.getBoolean("showAxes");
        }
        if ("showLight".equals(string)) {
            this._model.showLight = this.getBoolean("showLight");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymin".equals(string)) {
            this._model.ymin = this.getDouble("ymin");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("hvert".equals(string)) {
            this._model.hvert = this.getDouble("hvert");
        }
        if ("xx0".equals(string)) {
            this._model.xx0 = this.getDouble("xx0");
        }
        if ("y0".equals(string)) {
            this._model.y0 = this.getDouble("y0");
        }
        if ("stopEvent".equals(string)) {
            this._model.stopEvent = this.getBoolean("stopEvent");
        }
        if ("stopped1".equals(string)) {
            this._model.stopped1 = this.getBoolean("stopped1");
        }
        if ("stopped2".equals(string)) {
            this._model.stopped2 = this.getBoolean("stopped2");
        }
        if ("stoppedd".equals(string)) {
            this._model.stoppedd = this.getBoolean("stoppedd");
        }
        if ("sina".equals(string)) {
            this._model.sina = this.getDouble("sina");
        }
        if ("cosa".equals(string)) {
            this._model.cosa = this.getDouble("cosa");
        }
        if ("xw".equals(string)) {
            this._model.xw = this.getDouble("xw");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("beta", this._model.beta);
        this.setValue("gamma", this._model.gamma);
        this.setValue("d", this._model.d);
        this.setValue("t", this._model.t);
        this.setValue("t1", this._model.t1);
        this.setValue("x1", this._model.x1);
        this.setValue("t2", this._model.t2);
        this.setValue("x2", this._model.x2);
        this.setValue("x0", this._model.x0);
        this.setValue("wr", this._model.wr);
        this.setValue("wg", this._model.wg);
        this.setValue("w0", this._model.w0);
        this.setValue("w1", this._model.w1);
        this.setValue("w2", this._model.w2);
        this.setValue("u1", this._model.u1);
        this.setValue("u2", this._model.u2);
        this.setValue("showRed", this._model.showRed);
        this.setValue("showDiagram", this._model.showDiagram);
        this.setValue("showAxes", this._model.showAxes);
        this.setValue("showLight", this._model.showLight);
        this.setValue("dt", this._model.dt);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymin", this._model.ymin);
        this.setValue("ymax", this._model.ymax);
        this.setValue("hvert", this._model.hvert);
        this.setValue("xx0", this._model.xx0);
        this.setValue("y0", this._model.y0);
        this.setValue("stopEvent", this._model.stopEvent);
        this.setValue("stopped1", this._model.stopped1);
        this.setValue("stopped2", this._model.stopped2);
        this.setValue("stoppedd", this._model.stoppedd);
        this.setValue("sina", this._model.sina);
        this.setValue("cosa", this._model.cosa);
        this.setValue("xw", this._model.xw);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Simultaneity")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "691,276")).getObject();
        this.Upper = (JPanel)this.addElement(new ControlPanel(), "Upper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border:0,0").getObject();
        this.Space = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Upper").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "ymin").setProperty("maximumY", "ymax").setProperty("square", "true").setProperty("background", "white").getObject();
        this.XRedAxis = (InteractiveArrow)this.addElement(new ControlArrow(), "XRedAxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "wr").setProperty("y", "0").setProperty("sizex", "%_model._method_for_XRedAxis_sizex()%").setProperty("sizey", "0").setProperty("visible", "%_model._method_for_XRedAxis_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("secondaryColor", "red").setProperty("stroke", "3").getObject();
        this.RedAxis = (InteractiveArrow)this.addElement(new ControlArrow(), "RedAxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "wr").setProperty("sizex", "0").setProperty("sizey", "hvert").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red").setProperty("stroke", "3").getObject();
        this.GreenAxis = (InteractiveArrow)this.addElement(new ControlArrow(), "GreenAxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "wg").setProperty("sizex", "0").setProperty("sizey", "hvert").setProperty("enabled", "false").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3").getObject();
        this.Xaxis = (InteractiveArrow)this.addElement(new ControlArrow(), "Xaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "wg").setProperty("sizex", "%_model._method_for_Xaxis_sizex()%").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("style", "ARROW").setProperty("color", "0,0,128,255").setProperty("secondaryColor", "0,0,128,255").setProperty("stroke", "3").getObject();
        this.RedLabel = (InteractiveText)this.addElement(new ControlText(), "RedLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_RedLabel_x()%").setProperty("y", "hvert").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.RedLabel.text", "Y")).setProperty("color", "red").setProperty("font", "Dialog,ITALIC,18").getObject();
        this.GreenLabel = (InteractiveText)this.addElement(new ControlText(), "GreenLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_GreenLabel_x()%").setProperty("y", "hvert").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.GreenLabel.text", "Y'")).setProperty("color", "0,128,0,255").setProperty("font", "Dialog,ITALIC,18").getObject();
        this.RedOrigin = (InteractiveText)this.addElement(new ControlText(), "RedOrigin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_RedOrigin_x()%").setProperty("y", ".075").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.RedOrigin.text", "O")).setProperty("color", "red").setProperty("font", "Dialog,ITALIC,18").getObject();
        this.GreenOrigin = (InteractiveText)this.addElement(new ControlText(), "GreenOrigin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_GreenOrigin_x()%").setProperty("y", ".075").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.GreenOrigin.text", "O'")).setProperty("color", "0,128,0,255").setProperty("font", "Dialog,ITALIC,18").getObject();
        this.Xlabel = (InteractiveText)this.addElement(new ControlText(), "Xlabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_Xlabel_x()%").setProperty("y", ".075").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.Xlabel.text", "X = X'")).setProperty("color", "0,0,128,255").setProperty("font", "Dialog,ITALIC,18").getObject();
        this.Source = (InteractiveParticle)this.addElement(new ControlParticle(), "Source").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "w0").setProperty("y", "y0").setProperty("enabled", "false").setProperty("color", "orange").getObject();
        this.LeftDetector = (InteractiveParticle)this.addElement(new ControlParticle(), "LeftDetector").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "w1").setProperty("y", "y0").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("color", "magenta").getObject();
        this.RightDetector = (InteractiveParticle)this.addElement(new ControlParticle(), "RightDetector").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "w2").setProperty("y", "y0").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("color", "magenta").getObject();
        this.Wavefront = (InteractiveParticle)this.addElement(new ControlParticle(), "Wavefront").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "xw").setProperty("y", "y0").setProperty("sizex", "%_model._method_for_Wavefront_sizex()%").setProperty("sizey", "%_model._method_for_Wavefront_sizey()%").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "null").getObject();
        this.Lower = (JPanel)this.addElement(new ControlPanel(), "Lower").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border:0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Radio = (JPanel)this.addElement(new ControlPanel(), "Radio").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Lower").setProperty("layout", "hbox").getObject();
        this.Systems = (JPanel)this.addElement(new ControlPanel(), "Systems").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Radio").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Ssystem = (JRadioButton)this.addElement(new ControlRadioButton(), "Ssystem").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Systems").setProperty("text", this._simulation.translateString("View.Ssystem.text", "S system")).setProperty("mnemonic", this._simulation.translateString("View.Ssystem.mnemonic", "y")).setProperty("enabled", "%_model._method_for_Ssystem_enabled()%").setProperty("actionon", "_model._method_for_Ssystem_actionon()").setProperty("actionoff", "_model._method_for_Ssystem_actionoff()").setProperty("foreground", "RED").setProperty("tooltip", this._simulation.translateString("View.Ssystem.tooltip", "In this system source and detectors are in motion")).getObject();
        this.Sprime = (JRadioButton)this.addElement(new ControlRadioButton(), "Sprime").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Systems").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Sprime.text", "S' system")).setProperty("mnemonic", this._simulation.translateString("View.Sprime.mnemonic", "m")).setProperty("enabled", "%_model._method_for_Sprime_enabled()%").setProperty("actionon", "_model._method_for_Sprime_actionon()").setProperty("actionoff", "_model._method_for_Sprime_actionoff()").setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.Sprime.tooltip", "In this system source and detectors are at rest")).getObject();
        this.Waves = (JPanel)this.addElement(new ControlPanel(), "Waves").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Radio").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Argia = (JRadioButton)this.addElement(new ControlRadioButton(), "Argia").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Waves").setProperty("text", this._simulation.translateString("View.Argia.text", "Light")).setProperty("mnemonic", this._simulation.translateString("View.Argia.mnemonic", "l")).setProperty("enabled", "%_model._method_for_Argia_enabled()%").setProperty("actionon", "_model._method_for_Argia_actionon()").setProperty("actionoff", "_model._method_for_Argia_actionoff()").setProperty("foreground", "BLUE").setProperty("tooltip", this._simulation.translateString("View.Argia.tooltip", "Choose the relativistic case with light")).getObject();
        this.Sound = (JRadioButton)this.addElement(new ControlRadioButton(), "Sound").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Waves").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Sound.text", "Sound")).setProperty("mnemonic", this._simulation.translateString("View.Sound.mnemonic", "o")).setProperty("enabled", "%_model._method_for_Sound_enabled()%").setProperty("actionon", "_model._method_for_Sound_actionon()").setProperty("actionoff", "_model._method_for_Sound_actionoff()").setProperty("foreground", "BLUE").setProperty("tooltip", this._simulation.translateString("View.Sound.tooltip", "Choose the Galilean case")).getObject();
        this.Control = (JPanel)this.addElement(new ControlPanel(), "Control").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Lower").setProperty("layout", "grid:2,6,0,0").getObject();
        this.Velocity = (JTextField)this.addElement(new ControlNumberField(), "Velocity").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Control").setProperty("variable", "beta").setProperty("format", this._simulation.translateString("View.Velocity.format", "v/c = 0.##")).setProperty("editable", "%_model._method_for_Velocity_editable()%").setProperty("action", "_model._method_for_Velocity_action()").setProperty("tooltip", this._simulation.translateString("View.Velocity.tooltip", "Dimensionless velocity")).getObject();
        this.StepLength = (JTextField)this.addElement(new ControlNumberField(), "StepLength").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Control").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.StepLength.format", "$\\Delta$t = 0.###")).setProperty("editable", "%_model._method_for_StepLength_editable()%").setProperty("tooltip", this._simulation.translateString("View.StepLength.tooltip", "Animation step")).getObject();
        this.StopEvents = (JCheckBox)this.addElement(new ControlCheckBox(), "StopEvents").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Control").setProperty("variable", "stopEvent").setProperty("text", this._simulation.translateString("View.StopEvents.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.StopEvents.mnemonic", "e")).setProperty("enabled", "%_model._method_for_StopEvents_enabled()%").setProperty("tooltip", this._simulation.translateString("View.StopEvents.tooltip", "Pause after detection")).getObject();
        this.ShowDiagrama = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowDiagrama").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Control").setProperty("variable", "showDiagram").setProperty("text", this._simulation.translateString("View.ShowDiagrama.text", "Minkowski")).setProperty("mnemonic", this._simulation.translateString("View.ShowDiagrama.mnemonic", "m")).setProperty("tooltip", this._simulation.translateString("View.ShowDiagrama.tooltip", "Show Minkowski's diagram")).getObject();
        this.Gamma = (JTextField)this.addElement(new ControlNumberField(), "Gamma").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Control").setProperty("variable", "gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Lorentz factor")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Control").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Control").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Control").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.Minkowski = (JDialog)this.addElement(new ControlDialog(), "Minkowski").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Minkowski.title", "Minkowski")).setProperty("layout", "border").setProperty("visible", "showDiagram").setProperty("location", "648,0").setProperty("size", this._simulation.translateString("View.Minkowski.size", "300,340")).getObject();
        this.Diagram = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Diagram").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Minkowski").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-0.5").setProperty("maximumX", "%_model._method_for_Diagram_maximumX()%").setProperty("minimumY", "-0.5").setProperty("maximumY", "%_model._method_for_Diagram_maximumY()%").setProperty("title", this._simulation.translateString("View.Diagram.title", "(ct,x)")).setProperty("axesType", "Cartesian3").setProperty("titleX", this._simulation.translateString("View.Diagram.titleX", "x")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.Diagram.titleY", "ct")).setProperty("majorTicksY", "false").setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.Diagram.xFormat", "x = 0.##")).setProperty("yFormat", this._simulation.translateString("View.Diagram.yFormat", "ct = 0.##")).getObject();
        this.SourceWL = (InteractiveTrace)this.addElement(new ControlTrace(), "SourceWL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "w0").setProperty("y", "t").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "orange").getObject();
        this.LeftWL = (InteractiveTrace)this.addElement(new ControlTrace(), "LeftWL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "w1").setProperty("y", "t").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "magenta").getObject();
        this.RightWL = (InteractiveTrace)this.addElement(new ControlTrace(), "RightWL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "w2").setProperty("y", "t").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "magenta").getObject();
        this.BackWL = (InteractiveTrace)this.addElement(new ControlTrace(), "BackWL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "u1").setProperty("y", "t").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "blue").getObject();
        this.ForwardWL = (InteractiveTrace)this.addElement(new ControlTrace(), "ForwardWL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "u2").setProperty("y", "t").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "blue").getObject();
        this.time1 = (InteractiveArrow)this.addElement(new ControlArrow(), "time1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "%_model._method_for_time1_x()%").setProperty("y", "%_model._method_for_time1_y()%").setProperty("sizex", "%_model._method_for_time1_sizex()%").setProperty("sizey", "%_model._method_for_time1_sizey()%").setProperty("visible", "%_model._method_for_time1_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,128").getObject();
        this.time2 = (InteractiveArrow)this.addElement(new ControlArrow(), "time2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "%_model._method_for_time2_x()%").setProperty("y", "%_model._method_for_time2_y()%").setProperty("sizex", "%_model._method_for_time2_sizex()%").setProperty("sizey", "%_model._method_for_time2_sizey()%").setProperty("visible", "%_model._method_for_time2_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,128").getObject();
        this.time3 = (InteractiveArrow)this.addElement(new ControlArrow(), "time3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "%_model._method_for_time3_x()%").setProperty("y", "%_model._method_for_time3_y()%").setProperty("sizex", "%_model._method_for_time3_sizex()%").setProperty("sizey", "%_model._method_for_time3_sizey()%").setProperty("visible", "%_model._method_for_time3_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,128").getObject();
        this.time4 = (InteractiveArrow)this.addElement(new ControlArrow(), "time4").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "%_model._method_for_time4_x()%").setProperty("y", "%_model._method_for_time4_y()%").setProperty("sizex", "%_model._method_for_time4_sizex()%").setProperty("sizey", "%_model._method_for_time4_sizey()%").setProperty("visible", "%_model._method_for_time4_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.time5 = (InteractiveArrow)this.addElement(new ControlArrow(), "time5").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "%_model._method_for_time5_x()%").setProperty("y", "%_model._method_for_time5_y()%").setProperty("sizex", "%_model._method_for_time5_sizex()%").setProperty("sizey", "%_model._method_for_time5_sizey()%").setProperty("visible", "%_model._method_for_time5_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.time6 = (InteractiveArrow)this.addElement(new ControlArrow(), "time6").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "%_model._method_for_time6_x()%").setProperty("y", "%_model._method_for_time6_y()%").setProperty("sizex", "%_model._method_for_time6_sizex()%").setProperty("sizey", "%_model._method_for_time6_sizey()%").setProperty("visible", "%_model._method_for_time6_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").getObject();
        this.Event1 = (InteractiveParticle)this.addElement(new ControlParticle(), "Event1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "x1").setProperty("y", "t1").setProperty("sizex", ".15").setProperty("sizey", ".15").setProperty("visible", "%_model._method_for_Event1_visible()%").setProperty("enabled", "false").setProperty("color", "magenta").getObject();
        this.Event2 = (InteractiveParticle)this.addElement(new ControlParticle(), "Event2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "x2").setProperty("y", "t2").setProperty("sizex", ".15").setProperty("sizey", ".15").setProperty("visible", "%_model._method_for_Event2_visible()%").setProperty("enabled", "false").setProperty("color", "magenta").getObject();
        this.createControl50();
    }

    private void createControl50() {
        this.Event0 = (InteractiveParticle)this.addElement(new ControlParticle(), "Event0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Diagram").setProperty("x", "x0").setProperty("y", "0").setProperty("sizex", ".15").setProperty("sizey", ".15").setProperty("visible", "%_model._method_for_Event0_visible()%").setProperty("enabled", "false").setProperty("color", "orange").getObject();
        this.Status = (JPanel)this.addElement(new ControlPanel(), "Status").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Minkowski").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").setProperty("background", "WHITE").getObject();
        this.ShowAxes = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowAxes").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Status").setProperty("variable", "showAxes").setProperty("text", this._simulation.translateString("View.ShowAxes.text", "Show simultaneous")).setProperty("mnemonic", this._simulation.translateString("View.ShowAxes.mnemonic", "h")).setProperty("alignment", "CENTER").setProperty("enabled", "showLight").setProperty("tooltip", this._simulation.translateString("View.ShowAxes.tooltip", "Show the events simultaneous in the other frame")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Simultaneity")).setProperty("visible", "true");
        this.getElement("Upper");
        this.getElement("Space").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("background", "white");
        this.getElement("XRedAxis").setProperty("y", "0").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("secondaryColor", "red").setProperty("stroke", "3");
        this.getElement("RedAxis").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red").setProperty("stroke", "3");
        this.getElement("GreenAxis").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3");
        this.getElement("Xaxis").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("style", "ARROW").setProperty("color", "0,0,128,255").setProperty("secondaryColor", "0,0,128,255").setProperty("stroke", "3");
        this.getElement("RedLabel").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.RedLabel.text", "Y")).setProperty("color", "red").setProperty("font", "Dialog,ITALIC,18");
        this.getElement("GreenLabel").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.GreenLabel.text", "Y'")).setProperty("color", "0,128,0,255").setProperty("font", "Dialog,ITALIC,18");
        this.getElement("RedOrigin").setProperty("y", ".075").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.RedOrigin.text", "O")).setProperty("color", "red").setProperty("font", "Dialog,ITALIC,18");
        this.getElement("GreenOrigin").setProperty("y", ".075").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.GreenOrigin.text", "O'")).setProperty("color", "0,128,0,255").setProperty("font", "Dialog,ITALIC,18");
        this.getElement("Xlabel").setProperty("y", ".075").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.Xlabel.text", "X = X'")).setProperty("color", "0,0,128,255").setProperty("font", "Dialog,ITALIC,18");
        this.getElement("Source").setProperty("enabled", "false").setProperty("color", "orange");
        this.getElement("LeftDetector").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("color", "magenta");
        this.getElement("RightDetector").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("color", "magenta");
        this.getElement("Wavefront").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "null");
        this.getElement("Lower").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Radio");
        this.getElement("Systems");
        this.getElement("Ssystem").setProperty("text", this._simulation.translateString("View.Ssystem.text", "S system")).setProperty("mnemonic", this._simulation.translateString("View.Ssystem.mnemonic", "y")).setProperty("foreground", "RED").setProperty("tooltip", this._simulation.translateString("View.Ssystem.tooltip", "In this system source and detectors are in motion"));
        this.getElement("Sprime").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Sprime.text", "S' system")).setProperty("mnemonic", this._simulation.translateString("View.Sprime.mnemonic", "m")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.Sprime.tooltip", "In this system source and detectors are at rest"));
        this.getElement("Waves");
        this.getElement("Argia").setProperty("text", this._simulation.translateString("View.Argia.text", "Light")).setProperty("mnemonic", this._simulation.translateString("View.Argia.mnemonic", "l")).setProperty("foreground", "BLUE").setProperty("tooltip", this._simulation.translateString("View.Argia.tooltip", "Choose the relativistic case with light"));
        this.getElement("Sound").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Sound.text", "Sound")).setProperty("mnemonic", this._simulation.translateString("View.Sound.mnemonic", "o")).setProperty("foreground", "BLUE").setProperty("tooltip", this._simulation.translateString("View.Sound.tooltip", "Choose the Galilean case"));
        this.getElement("Control");
        this.getElement("Velocity").setProperty("format", this._simulation.translateString("View.Velocity.format", "v/c = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Velocity.tooltip", "Dimensionless velocity"));
        this.getElement("StepLength").setProperty("format", this._simulation.translateString("View.StepLength.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.StepLength.tooltip", "Animation step"));
        this.getElement("StopEvents").setProperty("text", this._simulation.translateString("View.StopEvents.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.StopEvents.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.StopEvents.tooltip", "Pause after detection"));
        this.getElement("ShowDiagrama").setProperty("text", this._simulation.translateString("View.ShowDiagrama.text", "Minkowski")).setProperty("mnemonic", this._simulation.translateString("View.ShowDiagrama.mnemonic", "m")).setProperty("tooltip", this._simulation.translateString("View.ShowDiagrama.tooltip", "Show Minkowski's diagram"));
        this.getElement("Gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Lorentz factor"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("Minkowski").setProperty("title", this._simulation.translateString("View.Minkowski.title", "Minkowski"));
        this.getElement("Diagram").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-0.5").setProperty("minimumY", "-0.5").setProperty("title", this._simulation.translateString("View.Diagram.title", "(ct,x)")).setProperty("axesType", "Cartesian3").setProperty("titleX", this._simulation.translateString("View.Diagram.titleX", "x")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.Diagram.titleY", "ct")).setProperty("majorTicksY", "false").setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.Diagram.xFormat", "x = 0.##")).setProperty("yFormat", this._simulation.translateString("View.Diagram.yFormat", "ct = 0.##"));
        this.getElement("SourceWL").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "orange");
        this.getElement("LeftWL").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "magenta");
        this.getElement("RightWL").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "magenta");
        this.getElement("BackWL").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "blue");
        this.getElement("ForwardWL").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "blue");
        this.getElement("time1").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,128");
        this.getElement("time2").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,128");
        this.getElement("time3").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,128");
        this.getElement("time4").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("time5").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("time6").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "red");
        this.getElement("Event1").setProperty("sizex", ".15").setProperty("sizey", ".15").setProperty("enabled", "false").setProperty("color", "magenta");
        this.getElement("Event2").setProperty("sizex", ".15").setProperty("sizey", ".15").setProperty("enabled", "false").setProperty("color", "magenta");
        this.getElement("Event0").setProperty("y", "0").setProperty("sizex", ".15").setProperty("sizey", ".15").setProperty("enabled", "false").setProperty("color", "orange");
        this.getElement("Status").setProperty("borderType", "LOWERED_ETCHED").setProperty("background", "WHITE");
        this.getElement("ShowAxes").setProperty("text", this._simulation.translateString("View.ShowAxes.text", "Show simultaneous")).setProperty("mnemonic", this._simulation.translateString("View.ShowAxes.mnemonic", "h")).setProperty("alignment", "CENTER").setProperty("tooltip", this._simulation.translateString("View.ShowAxes.tooltip", "Show the events simultaneous in the other frame"));
        super.reset();
    }
}

