/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.special_relativity.simultaneity;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.special_relativity.simultaneity.simultaneitySimulation;
import users.ehu.jma.special_relativity.simultaneity.simultaneityView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class simultaneity
extends AbstractModel {
    public simultaneitySimulation _simulation = null;
    public simultaneityView _view = null;
    public simultaneity _model = this;
    public double beta = 0.6;
    public double gamma = 0.0;
    public double d = 0.75;
    public double t = 0.0;
    public double t1 = 0.0;
    public double x1 = 0.0;
    public double t2 = 0.0;
    public double x2 = 0.0;
    public double x0 = 0.0;
    public double wr = 0.0;
    public double wg = 0.0;
    public double w0 = 0.0;
    public double w1 = 0.0;
    public double w2 = 0.0;
    public double u1 = 0.0;
    public double u2 = 0.0;
    public boolean showRed = false;
    public boolean showDiagram = true;
    public boolean showAxes = false;
    public boolean showLight = false;
    public double dt = 0.01;
    public double xmin = -1.0;
    public double xmax = 3.0;
    public double ymin = -0.1;
    public double ymax = 1.0;
    public double hvert = 0.9;
    public double xx0 = 1.0;
    public double y0 = 0.5;
    public boolean stopEvent = true;
    public boolean stopped1 = false;
    public boolean stopped2 = false;
    public boolean stoppedd = false;
    public double sina = 0.0;
    public double cosa = 0.0;
    public double xw = 0.0;

    public static String _getEjsModel() {
        return "users/ehu/jma/special_relativity/simultaneity.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/special_relativity/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        simultaneity simultaneity2 = new simultaneity(stringArray);
    }

    public simultaneity() {
        this(null, null, null, null, null, false);
    }

    public simultaneity(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public simultaneity(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new simultaneitySimulation(this, string, frame, uRL, bl);
        this._view = (simultaneityView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.initial();
    }

    public void _evolution1() {
        this.update(this.t + this.dt);
    }

    public void _constraints1() {
        if (this.beta <= 0.0 || this.beta >= 1.0) {
            this.beta = 0.6;
        }
        this.gamma = this.showLight ? 1.0 / Math.sqrt(1.0 - this.beta * this.beta) : 1.0;
    }

    public void set_velocity() {
        if (this.beta <= 0.0 || this.beta >= 1.0) {
            this.beta = 0.6;
        }
        this.gamma = this.showLight ? 1.0 / Math.sqrt(1.0 - this.beta * this.beta) : 1.0;
        this.sina = this.beta;
        if (!this.showRed) {
            this.sina = -this.sina;
        }
        this.cosa = 1.0 / Math.sqrt(1.0 + this.sina * this.sina);
        this.sina *= this.cosa;
        this.sina *= 4.0;
        this.cosa *= 4.0;
    }

    public void events() {
        if (this.showRed) {
            if (this.showLight) {
                this.x0 = this.xx0 / this.gamma;
                this.x1 = this.x0 - this.d / this.gamma / (1.0 + this.beta);
                this.x2 = this.x0 + this.d / this.gamma / (1.0 - this.beta);
                this.t1 = this.d / this.gamma / (1.0 + this.beta);
                this.t2 = this.d / this.gamma / (1.0 - this.beta);
                this.u1 = this.u2 = this.xx0 / this.gamma + this.t;
            } else {
                this.x0 = this.xx0;
                this.x1 = this.x0 - this.d + this.beta * this.d;
                this.x2 = this.x0 + this.d + this.beta * this.d;
                this.t1 = this.t2 = this.d;
                this.u1 = this.u2 = this.x0;
            }
        } else {
            this.x0 = this.xx0;
            this.x1 = this.x0 - this.d;
            this.x2 = this.x0 + this.d;
            this.t1 = this.t2 = this.d;
            this.u1 = this.u2 = this.x0;
        }
    }

    public void initial() {
        this.set_velocity();
        this.events();
        this._view.resetTraces();
        this.stoppedd = false;
        this.stopped2 = false;
        this.stopped1 = false;
        this.update(0.0);
    }

    public void checkEvents() {
        boolean bl = false;
        if (Math.abs(this.t - this.t1) < 0.5 * this.dt && !this.stopped1) {
            bl = true;
            this.stopped1 = true;
        }
        if (Math.abs(this.t - this.t2) < 0.5 * this.dt && !this.stopped2) {
            bl = true;
            this.stopped2 = true;
        }
        if (Math.abs(this.t) < 0.5 * this.dt && !this.stoppedd) {
            bl = true;
            this.stoppedd = true;
        }
        if (bl) {
            this._pause();
        }
    }

    public void update(double d) {
        this.t = d;
        if (this.showRed) {
            this.wr = 0.0;
            this.wg = this.beta * this.t;
            this.w0 = this.x0 + this.beta * this.t;
            if (this.showLight) {
                this.w1 = this.w0 - this.d / this.gamma;
                this.w2 = this.w0 + this.d / this.gamma;
                this.u1 = this.xx0 / this.gamma - this.t;
                this.u2 = this.xx0 / this.gamma + this.t;
            } else {
                this.w1 = this.w0 - this.d;
                this.w2 = this.w0 + this.d;
                this.u1 = this.x0 - (1.0 - this.beta) * this.t;
                this.u2 = this.x0 + (1.0 + this.beta) * this.t;
            }
        } else {
            this.wr = -this.beta * this.t;
            this.wg = 0.0;
            this.w0 = this.x0;
            this.w1 = this.x1;
            this.w2 = this.x2;
            this.u1 = this.x0 - this.t;
            this.u2 = this.x0 + this.t;
        }
        double d2 = this.showRed ? (this.showLight ? this.x0 : this.xx0 + this.beta * this.t) : (this.xw = this.xx0);
        if (this.stopEvent) {
            this.checkEvents();
        }
        if (this.wr < -this.xmax || this.wg > this.xmax) {
            this.stoppedd = false;
            this.stopped2 = false;
            this.stopped1 = false;
            this._pause();
        }
    }

    public boolean tobeContinued() {
        return this._isPaused() && (this.stopped1 || this.stopped2);
    }

    public double _method_for_XRedAxis_sizex() {
        return this.wg - this.wr;
    }

    public boolean _method_for_XRedAxis_visible() {
        return this.wr < this.wg;
    }

    public double _method_for_Xaxis_sizex() {
        return this.xmax - this.wg;
    }

    public double _method_for_RedLabel_x() {
        return this.wr - 0.1;
    }

    public double _method_for_GreenLabel_x() {
        return this.wg + 0.1;
    }

    public double _method_for_RedOrigin_x() {
        return this.wr - 0.1;
    }

    public double _method_for_GreenOrigin_x() {
        return this.wg + 0.1;
    }

    public double _method_for_Xlabel_x() {
        return this.xmax - 0.3;
    }

    public double _method_for_Wavefront_sizex() {
        return 2.0 * this.t;
    }

    public double _method_for_Wavefront_sizey() {
        return 2.0 * this.t;
    }

    public boolean _method_for_Ssystem_enabled() {
        return this._isPaused();
    }

    public void _method_for_Ssystem_actionon() {
        this._simulation.disableLoop();
        this.showRed = true;
        this.initial();
        this._simulation.enableLoop();
    }

    public void _method_for_Ssystem_actionoff() {
        this._simulation.disableLoop();
        this.showRed = false;
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Sprime_enabled() {
        return this._isPaused();
    }

    public void _method_for_Sprime_actionon() {
        this._simulation.disableLoop();
        this.showRed = false;
        this.initial();
        this._simulation.enableLoop();
    }

    public void _method_for_Sprime_actionoff() {
        this._simulation.disableLoop();
        this.showRed = true;
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Argia_enabled() {
        return this._isPaused();
    }

    public void _method_for_Argia_actionon() {
        this._simulation.disableLoop();
        this.showLight = true;
        this.initial();
        this._simulation.enableLoop();
    }

    public void _method_for_Argia_actionoff() {
        this._simulation.disableLoop();
        this.showLight = false;
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Sound_enabled() {
        return this._isPaused();
    }

    public void _method_for_Sound_actionon() {
        this._simulation.disableLoop();
        this.showLight = false;
        this.initial();
        this._simulation.enableLoop();
    }

    public void _method_for_Sound_actionoff() {
        this._simulation.disableLoop();
        this.showLight = true;
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Velocity_editable() {
        return this._isPaused();
    }

    public void _method_for_Velocity_action() {
        this._simulation.disableLoop();
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_StepLength_editable() {
        return this._isPaused();
    }

    public boolean _method_for_StopEvents_enabled() {
        return this._isPaused();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Diagram_maximumX() {
        return -0.5 + this.xmax - this.xmin;
    }

    public double _method_for_Diagram_maximumY() {
        return -0.5 + this.xmax - this.xmin;
    }

    public double _method_for_time1_x() {
        return this.x1 - this.cosa;
    }

    public double _method_for_time1_y() {
        return this.t1 - this.sina;
    }

    public double _method_for_time1_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time1_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time1_visible() {
        return this.showAxes && this.showLight && !this.showRed && this.t >= this.t1 + 0.5 * this.dt;
    }

    public double _method_for_time2_x() {
        return this.x2 - this.cosa;
    }

    public double _method_for_time2_y() {
        return this.t2 - this.sina;
    }

    public double _method_for_time2_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time2_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time2_visible() {
        return this.showAxes && this.showLight && !this.showRed && this.t >= this.t2 + 0.5 * this.dt;
    }

    public double _method_for_time3_x() {
        return this.x0 - this.cosa;
    }

    public double _method_for_time3_y() {
        return -this.sina;
    }

    public double _method_for_time3_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time3_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time3_visible() {
        return this.showAxes && this.showLight && !this.showRed && this.t >= 0.5 * this.dt;
    }

    public double _method_for_time4_x() {
        return this.x1 - this.cosa;
    }

    public double _method_for_time4_y() {
        return this.t1 - this.sina;
    }

    public double _method_for_time4_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time4_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time4_visible() {
        return this.showAxes && this.showLight && this.showRed && this.t >= this.t1 + 0.5 * this.dt;
    }

    public double _method_for_time5_x() {
        return this.x2 - this.cosa;
    }

    public double _method_for_time5_y() {
        return this.t2 - this.sina;
    }

    public double _method_for_time5_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time5_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time5_visible() {
        return this.showAxes && this.showLight && this.showRed && this.t >= this.t2 + 0.5 * this.dt;
    }

    public double _method_for_time6_x() {
        return this.x0 - this.cosa;
    }

    public double _method_for_time6_y() {
        return -this.sina;
    }

    public double _method_for_time6_sizex() {
        return 2.0 * this.cosa;
    }

    public double _method_for_time6_sizey() {
        return 2.0 * this.sina;
    }

    public boolean _method_for_time6_visible() {
        return this.showAxes && this.showLight && this.showRed && this.t >= 0.5 * this.dt;
    }

    public boolean _method_for_Event1_visible() {
        return this.t >= this.t1 + 0.5 * this.dt;
    }

    public boolean _method_for_Event2_visible() {
        return this.t >= this.t2 + 0.5 * this.dt;
    }

    public boolean _method_for_Event0_visible() {
        return this.t >= 0.5 * this.dt;
    }

    @Override
    public synchronized void reset() {
        this.beta = 0.6;
        this.gamma = 0.0;
        this.d = 0.75;
        this.t = 0.0;
        this.t1 = 0.0;
        this.x1 = 0.0;
        this.t2 = 0.0;
        this.x2 = 0.0;
        this.x0 = 0.0;
        this.wr = 0.0;
        this.wg = 0.0;
        this.w0 = 0.0;
        this.w1 = 0.0;
        this.w2 = 0.0;
        this.u1 = 0.0;
        this.u2 = 0.0;
        this.showRed = false;
        this.showDiagram = true;
        this.showAxes = false;
        this.showLight = false;
        this.dt = 0.01;
        this.xmin = -1.0;
        this.xmax = 3.0;
        this.ymin = -0.1;
        this.ymax = 1.0;
        this.hvert = 0.9;
        this.xx0 = 1.0;
        this.y0 = 0.5;
        this.stopEvent = true;
        this.stopped1 = false;
        this.stopped2 = false;
        this.stoppedd = false;
        this.sina = 0.0;
        this.cosa = 0.0;
        this.xw = 0.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

