/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.tworods;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.rigid_bodies.tworods.tworods;
import users.ehu.jma.rigid_bodies.tworods.tworodsSimulation;

class tworodsView
extends EjsControl
implements View {
    private tworodsSimulation _simulation = null;
    private tworods _model = null;
    public Component Main;
    public JPanel Left;
    public JPanel Void;
    public JSlider Height;
    public JPanel Center;
    public JPanel Graph;
    public PlottingPanel2D Angles;
    public InteractiveTrace LeftAngle;
    public InteractiveTrace RightAngle;
    public DrawingPanel2D Rods;
    public InteractiveArrow LeftRod;
    public InteractiveArrow RightRod;
    public InteractiveParticle Articulation;
    public InteractiveParticle Axis;
    public InteractiveArrow Table;
    public InteractiveTrace LeftTrace;
    public InteractiveTrace LeftTrace2;
    public InteractiveTrace RightTrace;
    public InteractiveTrace RightTrace2;
    public JPanel Bottom;
    public JPanel Controls;
    public JPanel Display;
    public JTextField z0;
    public JTextField dt;
    public JCheckBox Trajectories;
    public JCheckBox Pause;
    public JPanel Buttons;
    public JButton startButton;
    public JButton continueButton;
    public JButton stepButton;
    public JButton resetButton;

    public tworodsView(tworodsSimulation tworodsSimulation2, String string, Frame frame) {
        super(tworodsSimulation2, string, frame);
        this._simulation = tworodsSimulation2;
        this._model = (tworods)tworodsSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("phi1", "apply(\"phi1\")");
        this.addListener("phi2", "apply(\"phi2\")");
        this.addListener("phi0", "apply(\"phi0\")");
        this.addListener("z0", "apply(\"z0\")");
        this.addListener("t1", "apply(\"t1\")");
        this.addListener("t2", "apply(\"t2\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("state", "apply(\"state\")");
        this.addListener("eps", "apply(\"eps\")");
        this.addListener("stopEvents", "apply(\"stopEvents\")");
        this.addListener("showTraj", "apply(\"showTraj\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("x2", "apply(\"x2\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("phi1".equals(string)) {
            this._model.phi1 = this.getDouble("phi1");
        }
        if ("phi2".equals(string)) {
            this._model.phi2 = this.getDouble("phi2");
        }
        if ("phi0".equals(string)) {
            this._model.phi0 = this.getDouble("phi0");
        }
        if ("z0".equals(string)) {
            this._model.z0 = this.getDouble("z0");
        }
        if ("t1".equals(string)) {
            this._model.t1 = this.getDouble("t1");
        }
        if ("t2".equals(string)) {
            this._model.t2 = this.getDouble("t2");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("state".equals(string)) {
            double[] dArray = (double[])this.getValue("state").getObject();
            int n = dArray.length;
            if (n > this._model.state.length) {
                n = this._model.state.length;
            }
            for (int i = 0; i < n; ++i) {
                this._model.state[i] = dArray[i];
            }
        }
        if ("eps".equals(string)) {
            this._model.eps = this.getDouble("eps");
        }
        if ("stopEvents".equals(string)) {
            this._model.stopEvents = this.getBoolean("stopEvents");
        }
        if ("showTraj".equals(string)) {
            this._model.showTraj = this.getBoolean("showTraj");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("phi1", this._model.phi1);
        this.setValue("phi2", this._model.phi2);
        this.setValue("phi0", this._model.phi0);
        this.setValue("z0", this._model.z0);
        this.setValue("t1", this._model.t1);
        this.setValue("t2", this._model.t2);
        this.setValue("dt", this._model.dt);
        this.setValue("tol", this._model.tol);
        this.setValue("state", this._model.state);
        this.setValue("eps", this._model.eps);
        this.setValue("stopEvents", this._model.stopEvents);
        this.setValue("showTraj", this._model.showTraj);
        this.setValue("x1", this._model.x1);
        this.setValue("x2", this._model.x2);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Falling rods")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,-4").setProperty("size", this._simulation.translateString("View.Main.size", "640,460")).getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Void = (JPanel)this.addElement(new ControlPanel(), "Void").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("layout", "border").setProperty("background", "239,239,255,255").getObject();
        this.Height = (JSlider)this.addElement(new ControlSlider(), "Height").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Left").setProperty("variable", "phi0").setProperty("minimum", "0.0").setProperty("maximum", "89.9").setProperty("orientation", "VERTICAL").setProperty("enabled", "_isPaused").setProperty("dragaction", "_model._method_for_Height_dragaction()").setProperty("action", "_model._method_for_Height_action()").setProperty("background", "239,239,255,255").setProperty("tooltip", this._simulation.translateString("View.Height.tooltip", "Initial height of the free end")).getObject();
        this.Center = (JPanel)this.addElement(new ControlPanel(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Graph = (JPanel)this.addElement(new ControlPanel(), "Graph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Center").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Angles = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Angles").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-5").setProperty("maximumY", "95").setProperty("title", this._simulation.translateString("View.Angles.title", "Angles")).setProperty("titleX", this._simulation.translateString("View.Angles.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Angles.titleY", "\u00b0")).setProperty("xFormat", this._simulation.translateString("View.Angles.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Angles.yFormat", "$\\phi$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Angles.tooltip", "Evolution of the free ends")).getObject();
        this.LeftAngle = (InteractiveTrace)this.addElement(new ControlTrace(), "LeftAngle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Angles").setProperty("x", "t").setProperty("y", "%_model._method_for_LeftAngle_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").getObject();
        this.RightAngle = (InteractiveTrace)this.addElement(new ControlTrace(), "RightAngle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Angles").setProperty("x", "t").setProperty("y", "%_model._method_for_RightAngle_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").getObject();
        this.Rods = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Rods").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1").setProperty("maximumX", "1.6").setProperty("minimumY", "-.05").setProperty("maximumY", "1.").setProperty("square", "true").setProperty("showCoordinates", "false").getObject();
        this.LeftRod = (InteractiveArrow)this.addElement(new ControlArrow(), "LeftRod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "x1").setProperty("y", "0").setProperty("sizex", "%_model._method_for_LeftRod_sizex()%").setProperty("sizey", "%_model._method_for_LeftRod_sizey()%").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("stroke", "3").getObject();
        this.RightRod = (InteractiveArrow)this.addElement(new ControlArrow(), "RightRod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "%_model._method_for_RightRod_x()%").setProperty("y", "0").setProperty("sizex", "%_model._method_for_RightRod_sizex()%").setProperty("sizey", "%_model._method_for_RightRod_sizey()%").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "blue").setProperty("stroke", "3").getObject();
        this.Articulation = (InteractiveParticle)this.addElement(new ControlParticle(), "Articulation").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "x1").setProperty("sizex", ".1").setProperty("enabled", "false").getObject();
        this.Axis = (InteractiveParticle)this.addElement(new ControlParticle(), "Axis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "x1").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("color", "red").getObject();
        this.Table = (InteractiveArrow)this.addElement(new ControlArrow(), "Table").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "green").setProperty("stroke", "9").getObject();
        this.LeftTrace = (InteractiveTrace)this.addElement(new ControlTrace(), "LeftTrace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "%_model._method_for_LeftTrace_x()%").setProperty("y", "%_model._method_for_LeftTrace_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "showTraj").setProperty("color", "255,128,128,255").getObject();
        this.LeftTrace2 = (InteractiveTrace)this.addElement(new ControlTrace(), "LeftTrace2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "%_model._method_for_LeftTrace2_x()%").setProperty("y", "%_model._method_for_LeftTrace2_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "showTraj").setProperty("color", "255,128,128,255").getObject();
        this.RightTrace = (InteractiveTrace)this.addElement(new ControlTrace(), "RightTrace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "%_model._method_for_RightTrace_x()%").setProperty("y", "%_model._method_for_RightTrace_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "showTraj").setProperty("color", "128,128,255,255").getObject();
        this.RightTrace2 = (InteractiveTrace)this.addElement(new ControlTrace(), "RightTrace2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Rods").setProperty("x", "x2").setProperty("y", "%_model._method_for_RightTrace2_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "showTraj").setProperty("color", "128,128,255,255").getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "border").getObject();
        this.Display = (JPanel)this.addElement(new ControlPanel(), "Display").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("layout", "hbox").getObject();
        this.z0 = (JTextField)this.addElement(new ControlNumberField(), "z0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "phi0").setProperty("format", this._simulation.translateString("View.z0.format", "$\\phi$ = 0.##")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_z0_action()").setProperty("tooltip", this._simulation.translateString("View.z0.tooltip", "Initial orientation (in degrees)")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step")).getObject();
        this.Trajectories = (JCheckBox)this.addElement(new ControlCheckBox(), "Trajectories").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "showTraj").setProperty("text", this._simulation.translateString("View.Trajectories.text", "Trajectories")).setProperty("mnemonic", this._simulation.translateString("View.Trajectories.mnemonic", "t")).setProperty("tooltip", this._simulation.translateString("View.Trajectories.tooltip", "Show trajectories of center-of-mass and free end")).getObject();
        this.Pause = (JCheckBox)this.addElement(new ControlCheckBox(), "Pause").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "stopEvents").setProperty("text", this._simulation.translateString("View.Pause.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.Pause.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Pause.tooltip", "Pause when a rod reaches the horizontal")).getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Controls").setProperty("layout", "grid:1,4,0,0").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "COntinue simulation")).getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Falling rods")).setProperty("visible", "true");
        this.getElement("Left");
        this.getElement("Void").setProperty("background", "239,239,255,255");
        this.getElement("Height").setProperty("minimum", "0.0").setProperty("maximum", "89.9").setProperty("orientation", "VERTICAL").setProperty("background", "239,239,255,255").setProperty("tooltip", this._simulation.translateString("View.Height.tooltip", "Initial height of the free end"));
        this.getElement("Center");
        this.getElement("Graph");
        this.getElement("Angles").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-5").setProperty("maximumY", "95").setProperty("title", this._simulation.translateString("View.Angles.title", "Angles")).setProperty("titleY", this._simulation.translateString("View.Angles.titleY", "\u00b0")).setProperty("xFormat", this._simulation.translateString("View.Angles.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Angles.yFormat", "$\\phi$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Angles.tooltip", "Evolution of the free ends"));
        this.getElement("LeftAngle").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("RightAngle").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Rods").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1").setProperty("maximumX", "1.6").setProperty("minimumY", "-.05").setProperty("maximumY", "1.").setProperty("square", "true").setProperty("showCoordinates", "false");
        this.getElement("LeftRod").setProperty("y", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("stroke", "3");
        this.getElement("RightRod").setProperty("y", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "blue").setProperty("stroke", "3");
        this.getElement("Articulation").setProperty("sizex", ".1").setProperty("enabled", "false");
        this.getElement("Axis").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("color", "red");
        this.getElement("Table").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "green").setProperty("stroke", "9");
        this.getElement("LeftTrace").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "255,128,128,255");
        this.getElement("LeftTrace2").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "255,128,128,255");
        this.getElement("RightTrace").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "128,128,255,255");
        this.getElement("RightTrace2").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "128,128,255,255");
        this.getElement("Bottom");
        this.getElement("Controls");
        this.getElement("Display");
        this.getElement("z0").setProperty("format", this._simulation.translateString("View.z0.format", "$\\phi$ = 0.##")).setProperty("tooltip", this._simulation.translateString("View.z0.tooltip", "Initial orientation (in degrees)"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step"));
        this.getElement("Trajectories").setProperty("text", this._simulation.translateString("View.Trajectories.text", "Trajectories")).setProperty("tooltip", this._simulation.translateString("View.Trajectories.tooltip", "Show trajectories of center-of-mass and free end"));
        this.getElement("Pause").setProperty("text", this._simulation.translateString("View.Pause.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.Pause.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Pause.tooltip", "Pause when a rod reaches the horizontal"));
        this.getElement("Buttons");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "COntinue simulation"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        super.reset();
    }
}

