/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.tworods;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.tworods.tworodsSimulation;
import users.ehu.jma.rigid_bodies.tworods.tworodsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class tworods
extends AbstractModel {
    public tworodsSimulation _simulation = null;
    public tworodsView _view = null;
    public tworods _model = this;
    public double t = 0.0;
    public double phi1 = 0.0;
    public double phi2 = 0.0;
    public double phi0 = 89.0;
    public double z0 = 0.99;
    public double t1 = 0.0;
    public double t2 = 0.0;
    public double dt = 0.01;
    public double tol = 1.0E-6;
    public double[] state;
    public double eps = 0.001;
    public boolean stopEvents = false;
    public boolean showTraj = false;
    public double x1 = -1.0;
    public double x2 = 1.0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/tworods.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        tworods tworods2 = new tworods(stringArray);
    }

    public tworods() {
        this(null, null, null, null, null, false);
    }

    public tworods(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public tworods(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new tworodsSimulation(this, string, frame, uRL, bl);
        this._view = (tworodsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.state[3] = 0.0;
        this.state[2] = 0.0;
        this.t2 = 0.0;
        this.t1 = 0.0;
        this.t = 0.0;
        if (this.phi0 < 0.0) {
            this.phi0 = 0.0;
        } else if (this.phi0 >= 89.9) {
            this.phi0 = 89.9;
        }
        this.state[0] = this.state[1] = Math.toRadians(this.phi0);
        this.z0 = Math.sin(this.state[1]);
        this._view.resetTraces();
    }

    public void _constraints1() {
        this.phi1 = Math.max(0.0, this.state[0]);
        this.phi2 = Math.max(0.0, this.state[1]);
    }

    public double[] derivatives(double d, double[] dArray) {
        double[] dArray2 = new double[4];
        dArray2[0] = dArray[2];
        dArray2[1] = dArray[3];
        dArray2[2] = -1.5 * Math.cos(dArray[0]);
        double d2 = Math.cos(dArray[1]);
        dArray2[3] = 3.0 * d2 * (dArray[3] * dArray[3] * Math.sin(dArray[1]) - 2.0) / (1.0 + 3.0 * d2 * d2);
        return dArray2;
    }

    public void _method_for_Height_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Height_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public double _method_for_LeftAngle_y() {
        return Math.toDegrees(this.phi1);
    }

    public double _method_for_RightAngle_y() {
        return Math.toDegrees(this.phi2);
    }

    public double _method_for_LeftRod_sizex() {
        return Math.cos(this.phi1);
    }

    public double _method_for_LeftRod_sizey() {
        return Math.sin(this.phi1);
    }

    public double _method_for_RightRod_x() {
        return this.x2 - 0.5 * Math.cos(this.phi2);
    }

    public double _method_for_RightRod_sizex() {
        return Math.cos(this.phi2);
    }

    public double _method_for_RightRod_sizey() {
        return Math.sin(this.phi2);
    }

    public double _method_for_LeftTrace_x() {
        return this.x1 + Math.cos(this.phi1);
    }

    public double _method_for_LeftTrace_y() {
        return Math.sin(this.phi1);
    }

    public double _method_for_LeftTrace2_x() {
        return this.x1 + 0.5 * Math.cos(this.phi1);
    }

    public double _method_for_LeftTrace2_y() {
        return 0.5 * Math.sin(this.phi1);
    }

    public double _method_for_RightTrace_x() {
        return this.x2 + 0.5 * Math.cos(this.phi2);
    }

    public double _method_for_RightTrace_y() {
        return Math.sin(this.phi2);
    }

    public double _method_for_RightTrace2_y() {
        return 0.5 * Math.sin(this.phi2);
    }

    public void _method_for_z0_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this.initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.phi1 = 0.0;
        this.phi2 = 0.0;
        this.phi0 = 89.0;
        this.z0 = 0.99;
        this.t1 = 0.0;
        this.t2 = 0.0;
        this.dt = 0.01;
        this.tol = 1.0E-6;
        this.state = new double[4];
        for (int i = 0; i < 4; ++i) {
            this.state[i] = 0.0;
        }
        this.eps = 0.001;
        this.stopEvents = false;
        this.showTraj = false;
        this.x1 = -1.0;
        this.x2 = 1.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.state = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double[] _state;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + tworods.this.state.length];
            this._state = new double[tworods.this.state.length];
        }

        private boolean arraysChanged() {
            return tworods.this.state.length != this._state.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : tworods.this.state) {
            }
            this.__state[n++] = tworods.this.t;
            this.__solver = new ODEBisectionEventSolver(this, EulerRichardson.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.addEvent(new _ODE_evolution1_Event2());
            this.__solver.initialize(tworods.this.dt);
        }

        void step() {
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (tworods.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(tworods.this.dt);
            }
            int n = 0;
            for (double this.__state[n++] : tworods.this.state) {
            }
            this.__state[n++] = tworods.this.t;
            this.__solver.step();
            n = 0;
            int n2 = tworods.this.state.length;
            for (int i = 0; i < n2; ++i) {
                tworods.this.state[i] = this.__state[n++];
            }
            tworods.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            int n2 = tworods.this.state.length;
            for (int i = 0; i < n2; ++i) {
                this._state[i] = dArray[n++];
            }
            this._t = dArray[n++];
            n = 0;
            System.arraycopy(this._ODE_evolution1_1(this._state, this._t), 0, dArray2, n, tworods.this.state.length);
            n += tworods.this.state.length;
            dArray2[n++] = 1.0;
        }

        private double[] _ODE_evolution1_1(double[] dArray, double d) {
            return tworods.this.derivatives(d, dArray);
        }

        private class _ODE_evolution1_Event2
        implements StateEvent {
            private _ODE_evolution1_Event2() {
            }

            public String toString() {
                return "Second horizontal";
            }

            public double getTolerance() {
                return tworods.this.eps;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                int n2 = tworods.this.state.length;
                for (int i = 0; i < n2; ++i) {
                    ((_ODE_evolution1)_ODE_evolution1.this)._state[i] = dArray[n++];
                }
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._state, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double[] dArray, double d) {
                return tworods.this.t2 > 0.0 ? 1.0 : dArray[1];
            }

            public boolean action() {
                int n = 0;
                int n2 = tworods.this.state.length;
                for (int i = 0; i < n2; ++i) {
                    tworods.this.state[i] = _ODE_evolution1.this.__state[n++];
                }
                tworods.this.t2 = tworods.this.t = _ODE_evolution1.this.__state[n++];
                if (tworods.this.stopEvents || tworods.this.t1 > 0.0) {
                    tworods.this._pause();
                }
                n = 0;
                for (double ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] : tworods.this.state) {
                }
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = tworods.this.t;
                return true;
            }
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "First horizontal";
            }

            public double getTolerance() {
                return tworods.this.eps;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                int n2 = tworods.this.state.length;
                for (int i = 0; i < n2; ++i) {
                    ((_ODE_evolution1)_ODE_evolution1.this)._state[i] = dArray[n++];
                }
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._state, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double[] dArray, double d) {
                return tworods.this.t1 > 0.0 ? 1.0 : dArray[0];
            }

            public boolean action() {
                int n = 0;
                int n2 = tworods.this.state.length;
                for (int i = 0; i < n2; ++i) {
                    tworods.this.state[i] = _ODE_evolution1.this.__state[n++];
                }
                tworods.this.t1 = tworods.this.t = _ODE_evolution1.this.__state[n++];
                if (tworods.this.stopEvents || tworods.this.t2 > 0.0) {
                    tworods.this._pause();
                }
                n = 0;
                for (double ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] : tworods.this.state) {
                }
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = tworods.this.t;
                return true;
            }
        }
    }
}

