/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.symmetric;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.symmetric.symmetricSimulation;
import users.ehu.jma.rigid_bodies.symmetric.symmetricView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class symmetric
extends AbstractModel {
    public symmetricSimulation _simulation = null;
    public symmetricView _view = null;
    public symmetric _model = this;
    public double h = 1.0;
    public double dx = 0.0;
    public double dy = 0.0;
    public double dz = 0.0;
    public double Ix = 1.0;
    public double Iz = 0.5;
    public double[] axes;
    public double t = 0.0;
    public double thetaDegrees = 60.0;
    public double thetad0 = 2.0;
    public double phid0 = 3.0;
    public double psid0 = 4.0;
    public double[] state;
    public double scaleL = 0.0;
    public double scaleW = 0.0;
    public double wx = 0.0;
    public double wy = 0.0;
    public double wz = 0.0;
    public double wsx = 0.0;
    public double wsy = 0.0;
    public double wsz = 0.0;
    public double Lx = 0.0;
    public double Ly = 0.0;
    public double Lz = 0.0;
    public double Lsx = 0.0;
    public double Lsy = 0.0;
    public double Lsz = 0.0;
    public double[] axesB;
    public double bd = 0.0;
    public double bh = 0.0;
    public double bx = 0.0;
    public double by = 0.0;
    public double bz = 0.0;
    public double scaleC = 0.0;
    public double[] axesS;
    public double sd = 0.0;
    public double sh = 0.0;
    public double sx = 0.0;
    public double sy = 0.0;
    public double sz = 0.0;
    public double scaleS = 0.0;
    public double dt = 0.01;
    public double tol = 1.0E-6;
    public double alpha = 0.15;
    public double alphab = 0.15;
    public double beta = 0.3;
    public double betab = 0.3;
    public boolean showBody = true;
    public boolean showEuler = false;
    public boolean showAxes = true;
    public boolean showVelocities = false;
    public boolean showVectors = false;
    public boolean showTrajectories = false;
    public boolean showCones = false;
    public int Nvel = 10000;
    public double dd = 0.0;
    public double xmax = 0.7;
    public boolean canContinue = true;
    public double zoom = 1.0;
    public String labelZ0;
    public String labelZ = this.labelZ0 = "Principal axis Z";
    public String labelL0 = "Angular momentum";
    public String labelL = " ";
    public String labelOmega0 = "Angular velocity";
    public String labelOmega = " ";
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/symmetric.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/rigid_bodies/euler.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        symmetric symmetric2 = new symmetric(stringArray);
    }

    public symmetric() {
        this(null, null, null, null, null, false);
    }

    public symmetric(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public symmetric(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new symmetricSimulation(this, string, frame, uRL, bl);
        this._view = (symmetricView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.state[0] = 0.0;
        this.state[1] = Math.toRadians(this.thetaDegrees);
        this.state[2] = 0.0;
        this.state[3] = this.phid0;
        this.state[4] = this.thetad0;
        this.state[5] = this.psid0;
        this.axesB[7] = 0.0;
        this.axesB[6] = 0.0;
        this.axesB[5] = 0.0;
        this.axesB[3] = 0.0;
        this.axesB[2] = 0.0;
        this.axesB[1] = 0.0;
        this.axesB[8] = 1.0;
        this.axesB[4] = 1.0;
        this.axesB[0] = 1.0;
    }

    public void _initialization3() {
        this.canContinue = false;
        this._view.resetTraces();
    }

    public void _constraints1() {
        if (this.Iz < this.tol) {
            this.Iz = this.tol;
        } else if (this.Iz >= 2.0 * this.Ix) {
            this.Iz = 2.0 * this.Ix;
        }
        this.dx = this.dy = Math.sqrt(this.Iz);
        this.dz = Math.sqrt(2.0 * this.Ix - this.Iz);
        this.dd = this.dx;
        if (this.dz > this.dd) {
            this.dd = this.dz;
        }
        this.dd *= 0.7;
    }

    public void _constraints2() {
        double d = Math.cos(this.state[0]);
        double d2 = Math.sin(this.state[0]);
        double d3 = Math.cos(this.state[1]);
        double d4 = Math.sin(this.state[1]);
        double d5 = Math.cos(this.state[2]);
        double d6 = Math.sin(this.state[2]);
        double d7 = this.state[3];
        double d8 = this.state[4];
        double d9 = this.state[5];
        this.axes[0] = d * d5 - d3 * d2 * d6;
        this.axes[1] = d5 * d2 + d * d3 * d6;
        this.axes[2] = d4 * d6;
        this.axes[3] = -(d3 * d5 * d2) - d * d6;
        this.axes[4] = d * d3 * d5 - d2 * d6;
        this.axes[5] = d5 * d4;
        this.axes[6] = d2 * d4;
        this.axes[7] = -(d * d4);
        this.axes[8] = d3;
        this.wx = d7 * d4 * d6 + d8 * d5;
        this.wy = d7 * d4 * d5 - d8 * d6;
        this.wz = d7 * d3 + d9;
        this.scaleW = 1.1 * this.dd / Math.sqrt(this.wx * this.wx + this.wy * this.wy + this.wz * this.wz);
        this.Lx = this.Ix * this.wx;
        this.Ly = this.Ix * this.wy;
        this.Lz = this.Iz * this.wz;
        this.scaleL = 1.2 * this.dd / Math.sqrt(this.Lx * this.Lx + this.Ly * this.Ly + this.Lz * this.Lz);
        this.wsx = d8 * d + d9 * d2 * d4;
        this.wsy = d8 * d2 - d9 * d * d4;
        this.wsz = d7 + d9 * d3;
        this.Lsx = (d * d5 - d2 * d3 * d6) * this.Lx + (-d * d6 - d2 * d3 * d5) * this.Ly + d2 * d4 * this.Lz;
        this.Lsy = (d2 * d5 + d * d3 * d6) * this.Lx + (-d2 * d6 + d * d3 * d5) * this.Ly + -d * d4 * this.Lz;
        this.Lsz = d4 * d6 * this.Lx + d4 * d5 * this.Ly + d3 * this.Lz;
    }

    public void _constraints3() {
        this.scaleC = 0.75 * this.scaleW;
        double d = Math.sqrt(this.wx * this.wx + this.wy * this.wy);
        this.bd = 2.0 * d * this.scaleC;
        this.by = 0.0;
        this.bx = 0.0;
        this.bz = this.wz * this.scaleC;
        this.bh = -this.bz;
    }

    public void _constraints4() {
        double d = this.Lx * this.Lx + this.Ly * this.Ly + this.Lz * this.Lz;
        double d2 = (this.wx * this.Lx + this.wy * this.Ly + this.wz * this.Lz) / d;
        double d3 = d2 * this.Lx;
        double d4 = d2 * this.Ly;
        double d5 = d2 * this.Lz;
        double d6 = this.wx - d3;
        double d7 = this.wy - d4;
        double d8 = this.wz - d5;
        double d9 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
        double d10 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8);
        this.scaleS = this.scaleC;
        this.sx = d3 * this.scaleS;
        this.sy = d4 * this.scaleS;
        this.sz = d5 * this.scaleS;
        this.sh = -d9 * this.scaleS;
        this.sd = 2.0 * d10 * this.scaleS;
        this.axesS[6] = d3 /= d9;
        this.axesS[7] = d4 /= d9;
        this.axesS[8] = d5 /= d9;
        d6 /= d10;
        d7 /= d10;
        d8 /= d10;
        double d11 = (this.Iz / this.Ix - 1.0) * this.wz * this.bd / this.sd;
        if (d11 > 0.0) {
            d11 = -d11;
        }
        double d12 = Math.cos(d11 * this.t);
        double d13 = Math.sin(d11 * this.t);
        double d14 = (d12 + d3 * d3 * (1.0 - d12)) * d6 + (-d5 * d13 + d3 * d4 * (1.0 - d12)) * d7 + (d4 * d13 + d3 * d5 * (1.0 - d12)) * d8;
        double d15 = (d5 * d13 + d3 * d4 * (1.0 - d12)) * d6 + (d12 + d4 * d4 * (1.0 - d12)) * d7 + (-d3 * d13 + d4 * d5 * (1.0 - d12)) * d8;
        double d16 = (-d4 * d13 + d3 * d5 * (1.0 - d12)) * d6 + (d3 * d13 + d4 * d5 * (1.0 - d12)) * d7 + (d12 + d5 * d5 * (1.0 - d12)) * d8;
        this.axesS[0] = d14;
        this.axesS[1] = d15;
        this.axesS[2] = d16;
        this.axesS[3] = d4 * d16 - d5 * d15;
        this.axesS[4] = d5 * d14 - d3 * d16;
        this.axesS[5] = d3 * d15 - d4 * d14;
    }

    public double[] eqs(double d, double[] dArray) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        double d8 = Math.cos(d3);
        double d9 = Math.sin(d3);
        double[] dArray2 = new double[]{d5, d6, d7, (d8 * (-2.0 * this.Ix + this.Iz) * d5 + this.Iz * d7) * d6 / (this.Ix * d9), d5 * (d8 * (this.Ix - this.Iz) * d5 - this.Iz * d7) * d9 / this.Ix, ((1.0 + d8 * d8) * this.Ix * d5 - d8 * this.Iz * (d8 * d5 + d7)) * d6 / (this.Ix * d9)};
        return dArray2;
    }

    public void resetVelocities() {
        this._view.getElement("Wx").reset();
        this._view.getElement("Wy").reset();
        this._view.getElement("Wz").reset();
        this._view.getElement("Wsx").reset();
        this._view.getElement("Wsy").reset();
        this._view.getElement("Wsz").reset();
    }

    public void resetTrajectories() {
        this._view.getElement("OmegaTraj").reset();
        this._view.getElement("ZTraj").reset();
        this._view.getElement("OmegaTrajB").reset();
        this._view.getElement("Ltraj").reset();
    }

    public void setLabelAxis() {
        this.labelZ = this.showAxes ? this.labelZ0 : " ";
    }

    public void setLabelVectors() {
        this.labelL = this.showVectors ? this.labelL0 : " ";
        this.labelOmega = this.showVectors ? this.labelOmega0 : " ";
    }

    public void _method_for_Iz_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Theta_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_PhiD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_ThetaD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_PsiD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Alpha_minimum() {
        return -Math.PI;
    }

    public double _method_for_Alpha_maximum() {
        return Math.PI;
    }

    public double _method_for_Beta_minimum() {
        return -Math.PI;
    }

    public double _method_for_Beta_maximum() {
        return Math.PI;
    }

    public double _method_for_Projection_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Projection_minimumY() {
        return -this.xmax;
    }

    public double _method_for_Projection_minimumZ() {
        return -this.xmax;
    }

    public double _method_for_AxisX_sizex() {
        return this.dd * this.axes[0];
    }

    public double _method_for_AxisX_sizey() {
        return this.dd * this.axes[1];
    }

    public double _method_for_AxisX_sizez() {
        return this.dd * this.axes[2];
    }

    public double _method_for_AxisY_sizex() {
        return this.dd * this.axes[3];
    }

    public double _method_for_AxisY_sizey() {
        return this.dd * this.axes[4];
    }

    public double _method_for_AxisY_sizez() {
        return this.dd * this.axes[5];
    }

    public double _method_for_AxisZ_sizex() {
        return this.dd * this.axes[6];
    }

    public double _method_for_AxisZ_sizey() {
        return this.dd * this.axes[7];
    }

    public double _method_for_AxisZ_sizez() {
        return this.dd * this.axes[8];
    }

    public double _method_for_OmegaTraj_x() {
        return this.wsx * this.scaleW;
    }

    public double _method_for_OmegaTraj_y() {
        return this.wsy * this.scaleW;
    }

    public double _method_for_OmegaTraj_z() {
        return this.wsz * this.scaleW;
    }

    public boolean _method_for_OmegaTraj_visible() {
        return this.showTrajectories && this.showVectors;
    }

    public double _method_for_ZTraj_x() {
        return this.dd * this.axes[6];
    }

    public double _method_for_ZTraj_y() {
        return this.dd * this.axes[7];
    }

    public double _method_for_ZTraj_z() {
        return this.dd * this.axes[8];
    }

    public boolean _method_for_ZTraj_visible() {
        return this.showTrajectories && this.showAxes;
    }

    public double _method_for_AlphaB_minimum() {
        return -Math.PI;
    }

    public double _method_for_AlphaB_maximum() {
        return Math.PI;
    }

    public double _method_for_BetaB_minimum() {
        return -Math.PI;
    }

    public double _method_for_BetaB_maximum() {
        return Math.PI;
    }

    public double _method_for_ProjectionB_minimumX() {
        return -this.xmax;
    }

    public double _method_for_ProjectionB_minimumY() {
        return -this.xmax;
    }

    public double _method_for_ProjectionB_minimumZ() {
        return -this.xmax;
    }

    public double _method_for_OmegaTrajB_x() {
        return this.wx * this.scaleW;
    }

    public double _method_for_OmegaTrajB_y() {
        return this.wy * this.scaleW;
    }

    public double _method_for_OmegaTrajB_z() {
        return this.wz * this.scaleW;
    }

    public boolean _method_for_OmegaTrajB_visible() {
        return this.showTrajectories && this.showVectors;
    }

    public double _method_for_Ltraj_x() {
        return this.Lx * this.scaleL;
    }

    public double _method_for_Ltraj_y() {
        return this.Ly * this.scaleL;
    }

    public double _method_for_Ltraj_z() {
        return this.Lz * this.scaleL;
    }

    public boolean _method_for_Ltraj_visible() {
        return this.showTrajectories && this.showVectors;
    }

    public boolean _method_for_ConeB_visible() {
        return this.showCones && this.scaleW > 0.001;
    }

    public boolean _method_for_ConeS_visible() {
        return this.showCones && this.scaleW > 0.001;
    }

    public void _method_for_ShowVelocities_action() {
        this._simulation.disableLoop();
        this.resetVelocities();
        this._simulation.enableLoop();
    }

    public void _method_for_ShowAxes_action() {
        this._simulation.disableLoop();
        this.setLabelAxis();
        this._simulation.enableLoop();
    }

    public void _method_for_ShowVectors_action() {
        this._simulation.disableLoop();
        this.setLabelVectors();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.resetTrajectories();
        this._simulation.enableLoop();
    }

    public void _method_for_ResetTraj_action() {
        this._simulation.disableLoop();
        this.resetVelocities();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.h = 1.0;
        this.dx = 0.0;
        this.dy = 0.0;
        this.dz = 0.0;
        this.Ix = 1.0;
        this.Iz = 0.5;
        this.axes = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axes[n] = 0.0;
        }
        this.t = 0.0;
        this.thetaDegrees = 60.0;
        this.thetad0 = 2.0;
        this.phid0 = 3.0;
        this.psid0 = 4.0;
        this.state = new double[6];
        for (n = 0; n < 6; ++n) {
            this.state[n] = 0.0;
        }
        this.scaleL = 0.0;
        this.scaleW = 0.0;
        this.wx = 0.0;
        this.wy = 0.0;
        this.wz = 0.0;
        this.wsx = 0.0;
        this.wsy = 0.0;
        this.wsz = 0.0;
        this.Lx = 0.0;
        this.Ly = 0.0;
        this.Lz = 0.0;
        this.Lsx = 0.0;
        this.Lsy = 0.0;
        this.Lsz = 0.0;
        this.axesB = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axesB[n] = 0.0;
        }
        this.bd = 0.0;
        this.bh = 0.0;
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        this.scaleC = 0.0;
        this.axesS = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axesS[n] = 0.0;
        }
        this.sd = 0.0;
        this.sh = 0.0;
        this.sx = 0.0;
        this.sy = 0.0;
        this.sz = 0.0;
        this.scaleS = 0.0;
        this.dt = 0.01;
        this.tol = 1.0E-6;
        this.alpha = 0.15;
        this.alphab = 0.15;
        this.beta = 0.3;
        this.betab = 0.3;
        this.showBody = true;
        this.showEuler = false;
        this.showAxes = true;
        this.showVelocities = false;
        this.showVectors = false;
        this.showTrajectories = false;
        this.showCones = false;
        this.Nvel = 10000;
        this.dd = 0.0;
        this.xmax = 0.7;
        this.canContinue = true;
        this.zoom = 1.0;
        this.labelZ = this.labelZ0 = "Principal axis Z";
        this.labelL0 = "Angular momentum";
        this.labelL = " ";
        this.labelOmega0 = "Angular velocity";
        this.labelOmega = " ";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._initialization3();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
        this._constraints4();
    }

    @Override
    public void _freeMemory() {
        this.axes = null;
        this.state = null;
        this.axesB = null;
        this.axesS = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double[] _state;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + symmetric.this.state.length];
            this._state = new double[symmetric.this.state.length];
        }

        private boolean arraysChanged() {
            return symmetric.this.state.length != this._state.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : symmetric.this.state) {
            }
            this.__state[n++] = symmetric.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(symmetric.this.dt);
        }

        void step() {
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (symmetric.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(symmetric.this.tol);
            }
            if (symmetric.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(symmetric.this.dt);
            }
            int n = 0;
            for (double this.__state[n++] : symmetric.this.state) {
            }
            this.__state[n++] = symmetric.this.t;
            this.__solver.step();
            n = 0;
            int n2 = symmetric.this.state.length;
            for (int i = 0; i < n2; ++i) {
                symmetric.this.state[i] = this.__state[n++];
            }
            symmetric.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            int n2 = symmetric.this.state.length;
            for (int i = 0; i < n2; ++i) {
                this._state[i] = dArray[n++];
            }
            this._t = dArray[n++];
            n = 0;
            System.arraycopy(this._ODE_evolution1_1(this._state, this._t), 0, dArray2, n, symmetric.this.state.length);
            n += symmetric.this.state.length;
            dArray2[n++] = 1.0;
        }

        private double[] _ODE_evolution1_1(double[] dArray, double d) {
            return symmetric.this.eqs(d, dArray);
        }
    }
}

