/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.platform;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlArrowSet;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import users.ehu.jma.rigid_bodies.platform.platform;
import users.ehu.jma.rigid_bodies.platform.platformSimulation;

class platformView
extends EjsControl
implements View {
    private platformSimulation _simulation = null;
    private platform _model = null;
    public Component Main;
    public DrawingPanel2D Space;
    public InteractiveParticle Floor;
    public InteractiveParticle Platform;
    public InteractiveParticle Cylinder;
    public ElementSet VField;
    public InteractiveArrow V;
    public ElementSet vPlatform;
    public JPanel Down;
    public JPanel Controls;
    public JPanel Values;
    public JTextField vValue;
    public JTextField aValue;
    public JTextField XValue;
    public JTextField VValue;
    public JTextField nPoints;
    public JTextField Scale;
    public JTextField dt;
    public JPanel Buttons;
    public JPanel lButtons;
    public JCheckBox ShowV;
    public JButton refFrame;
    public JPanel rButtons;
    public JButton startButton;
    public JButton continueButton;
    public JButton stepButton;
    public JButton resetButton;

    public platformView(platformSimulation platformSimulation2, String string, Frame frame) {
        super(platformSimulation2, string, frame);
        this._simulation = platformSimulation2;
        this._model = (platform)platformSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("X", "apply(\"X\")");
        this.addListener("R", "apply(\"R\")");
        this.addListener("Y", "apply(\"Y\")");
        this.addListener("X0", "apply(\"X0\")");
        this.addListener("V", "apply(\"V\")");
        this.addListener("V0", "apply(\"V0\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("v0", "apply(\"v0\")");
        this.addListener("a", "apply(\"a\")");
        this.addListener("D", "apply(\"D\")");
        this.addListener("maxPoints", "apply(\"maxPoints\")");
        this.addListener("nPoints", "apply(\"nPoints\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("omega", "apply(\"omega\")");
        this.addListener("omega0", "apply(\"omega0\")");
        this.addListener("xp", "apply(\"xp\")");
        this.addListener("yp", "apply(\"yp\")");
        this.addListener("up", "apply(\"up\")");
        this.addListener("vp", "apply(\"vp\")");
        this.addListener("nVel", "apply(\"nVel\")");
        this.addListener("xv", "apply(\"xv\")");
        this.addListener("scaleV", "apply(\"scaleV\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("platform", "apply(\"platform\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("depth", "apply(\"depth\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("showV", "apply(\"showV\")");
        this.addListener("PI2", "apply(\"PI2\")");
        this.addListener("setInitial", "apply(\"setInitial\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("X".equals(string)) {
            this._model.X = this.getDouble("X");
        }
        if ("R".equals(string)) {
            this._model.R = this.getDouble("R");
        }
        if ("Y".equals(string)) {
            this._model.Y = this.getDouble("Y");
        }
        if ("X0".equals(string)) {
            this._model.X0 = this.getDouble("X0");
        }
        if ("V".equals(string)) {
            this._model.V = this.getDouble("V");
        }
        if ("V0".equals(string)) {
            this._model.V0 = this.getDouble("V0");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("v0".equals(string)) {
            this._model.v0 = this.getDouble("v0");
        }
        if ("a".equals(string)) {
            this._model.a = this.getDouble("a");
        }
        if ("D".equals(string)) {
            this._model.D = this.getDouble("D");
        }
        if ("maxPoints".equals(string)) {
            this._model.maxPoints = this.getInt("maxPoints");
        }
        if ("nPoints".equals(string)) {
            this._model.nPoints = this.getInt("nPoints");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("omega".equals(string)) {
            this._model.omega = this.getDouble("omega");
        }
        if ("omega0".equals(string)) {
            this._model.omega0 = this.getDouble("omega0");
        }
        if ("xp".equals(string)) {
            dArray = (double[])this.getValue("xp").getObject();
            n2 = dArray.length;
            if (n2 > this._model.xp.length) {
                n2 = this._model.xp.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.xp[n] = dArray[n];
            }
        }
        if ("yp".equals(string)) {
            dArray = (double[])this.getValue("yp").getObject();
            n2 = dArray.length;
            if (n2 > this._model.yp.length) {
                n2 = this._model.yp.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.yp[n] = dArray[n];
            }
        }
        if ("up".equals(string)) {
            dArray = (double[])this.getValue("up").getObject();
            n2 = dArray.length;
            if (n2 > this._model.up.length) {
                n2 = this._model.up.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.up[n] = dArray[n];
            }
        }
        if ("vp".equals(string)) {
            dArray = (double[])this.getValue("vp").getObject();
            n2 = dArray.length;
            if (n2 > this._model.vp.length) {
                n2 = this._model.vp.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.vp[n] = dArray[n];
            }
        }
        if ("nVel".equals(string)) {
            this._model.nVel = this.getInt("nVel");
        }
        if ("xv".equals(string)) {
            dArray = (double[])this.getValue("xv").getObject();
            n2 = dArray.length;
            if (n2 > this._model.xv.length) {
                n2 = this._model.xv.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.xv[n] = dArray[n];
            }
        }
        if ("scaleV".equals(string)) {
            this._model.scaleV = this.getDouble("scaleV");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("platform".equals(string)) {
            this._model.platform = this.getBoolean("platform");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("depth".equals(string)) {
            this._model.depth = this.getDouble("depth");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("showV".equals(string)) {
            this._model.showV = this.getBoolean("showV");
        }
        if ("PI2".equals(string)) {
            this._model.PI2 = this.getDouble("PI2");
        }
        if ("setInitial".equals(string)) {
            this._model.setInitial = this.getBoolean("setInitial");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("X", this._model.X);
        this.setValue("R", this._model.R);
        this.setValue("Y", this._model.Y);
        this.setValue("X0", this._model.X0);
        this.setValue("V", this._model.V);
        this.setValue("V0", this._model.V0);
        this.setValue("x", this._model.x);
        this.setValue("v", this._model.v);
        this.setValue("v0", this._model.v0);
        this.setValue("a", this._model.a);
        this.setValue("D", this._model.D);
        this.setValue("maxPoints", this._model.maxPoints);
        this.setValue("nPoints", this._model.nPoints);
        this.setValue("phi", this._model.phi);
        this.setValue("omega", this._model.omega);
        this.setValue("omega0", this._model.omega0);
        this.setValue("xp", this._model.xp);
        this.setValue("yp", this._model.yp);
        this.setValue("up", this._model.up);
        this.setValue("vp", this._model.vp);
        this.setValue("nVel", this._model.nVel);
        this.setValue("xv", this._model.xv);
        this.setValue("scaleV", this._model.scaleV);
        this.setValue("dt", this._model.dt);
        this.setValue("platform", this._model.platform);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("depth", this._model.depth);
        this.setValue("ymax", this._model.ymax);
        this.setValue("showV", this._model.showV);
        this.setValue("PI2", this._model.PI2);
        this.setValue("setInitial", this._model.setInitial);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Accelerated platform and cylinder")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "2,0").setProperty("size", this._simulation.translateString("View.Main.size", "640,218")).getObject();
        this.Space = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Space_minimumY()%").setProperty("maximumY", "ymax").setProperty("pressaction", "_model._method_for_Space_pressaction()").setProperty("square", "true").setProperty("tooltip", this._simulation.translateString("View.Space.tooltip", "Use the mouse to move the cylinder (when the simulation is paused)")).getObject();
        this.Floor = (InteractiveParticle)this.addElement(new ControlParticle(), "Floor").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_Floor_x()%").setProperty("y", "%_model._method_for_Floor_y()%").setProperty("sizex", "%_model._method_for_Floor_sizex()%").setProperty("sizey", "depth").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH_WEST").setProperty("secondaryColor", "0,160,0,255").setProperty("color", "0,160,0,255").getObject();
        this.Platform = (InteractiveParticle)this.addElement(new ControlParticle(), "Platform").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_Platform_x()%").setProperty("y", "%_model._method_for_Platform_y()%").setProperty("sizex", "%_model._method_for_Platform_sizex()%").setProperty("sizey", "depth").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH_WEST").setProperty("secondaryColor", "blue").setProperty("color", "blue").getObject();
        this.Cylinder = (InteractiveParticle)this.addElement(new ControlParticle(), "Cylinder").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "X").setProperty("y", "Y").setProperty("sizex", "D").setProperty("sizey", "D").setProperty("enabled", "%_model._method_for_Cylinder_enabled()%").setProperty("pressaction", "_model._method_for_Cylinder_pressaction()").setProperty("dragaction", "_model._method_for_Cylinder_dragaction()").setProperty("action", "_model._method_for_Cylinder_action()").setProperty("style", "WHEEL").setProperty("angle", "%_model._method_for_Cylinder_angle()%").setProperty("secondaryColor", "black").setProperty("color", "green").getObject();
        this.VField = (ElementSet)this.addElement(new ControlArrowSet(), "VField").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("elementnumber", "nPoints").setProperty("x", "xp").setProperty("y", "yp").setProperty("sizex", "up").setProperty("sizey", "vp").setProperty("scalex", "scaleV").setProperty("scaley", "scaleV").setProperty("visible", "%_model._method_for_VField_visible()%").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red").getObject();
        this.V = (InteractiveArrow)this.addElement(new ControlArrow(), "V").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "X").setProperty("y", "Y").setProperty("sizex", "V").setProperty("sizey", "0").setProperty("scalex", "scaleV").setProperty("visible", "showV").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta").getObject();
        this.vPlatform = (ElementSet)this.addElement(new ControlArrowSet(), "vPlatform").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("elementnumber", "nVel").setProperty("x", "xv").setProperty("y", "%_model._method_for_vPlatform_y()%").setProperty("sizex", "%_model._method_for_vPlatform_sizex()%").setProperty("sizey", "0").setProperty("scalex", "scaleV").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "white").setProperty("secondaryColor", "white").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Down").setProperty("layout", "VBOX").getObject();
        this.Values = (JPanel)this.addElement(new ControlPanel(), "Values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("layout", "GRID:1,8,0,0").getObject();
        this.vValue = (JTextField)this.addElement(new ControlNumberField(), "vValue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Values").setProperty("variable", "v0").setProperty("format", this._simulation.translateString("View.vValue.format", "v = 0.###")).setProperty("editable", "%_model._method_for_vValue_editable()%").setProperty("action", "_model._method_for_vValue_action()").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.vValue.tooltip", "Platform initial velocity")).getObject();
        this.aValue = (JTextField)this.addElement(new ControlNumberField(), "aValue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "a").setProperty("format", this._simulation.translateString("View.aValue.format", "a = 0.###")).setProperty("editable", "%_model._method_for_aValue_editable()%").setProperty("action", "_model._method_for_aValue_action()").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.aValue.tooltip", "Platform acceleration")).getObject();
        this.XValue = (JTextField)this.addElement(new ControlNumberField(), "XValue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "X0").setProperty("format", this._simulation.translateString("View.XValue.format", "X = 0.###")).setProperty("editable", "%_model._method_for_XValue_editable()%").setProperty("action", "_model._method_for_XValue_action()").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.XValue.tooltip", "Cylinder initial position")).getObject();
        this.VValue = (JTextField)this.addElement(new ControlNumberField(), "VValue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "V0").setProperty("format", this._simulation.translateString("View.VValue.format", "V = 0.###")).setProperty("editable", "%_model._method_for_VValue_editable()%").setProperty("action", "_model._method_for_VValue_action()").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.VValue.tooltip", "Cylinder initial velocity")).getObject();
        this.nPoints = (JTextField)this.addElement(new ControlNumberField(), "nPoints").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "nPoints").setProperty("format", this._simulation.translateString("View.nPoints.format", "N = 0")).setProperty("editable", "%_model._method_for_nPoints_editable()%").setProperty("action", "_model._method_for_nPoints_action()").setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.nPoints.tooltip", "Number of points in velocity field")).getObject();
        this.Scale = (JTextField)this.addElement(new ControlNumberField(), "Scale").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "scaleV").setProperty("format", this._simulation.translateString("View.Scale.format", "scale = 0.###")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Scale.tooltip", "Scale for velocities")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation step length")).getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("layout", "BORDER:0,0").getObject();
        this.lButtons = (JPanel)this.addElement(new ControlPanel(), "lButtons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Buttons").setProperty("layout", "GRID:1,2,0,0").getObject();
        this.ShowV = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowV").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "lButtons").setProperty("variable", "showV").setProperty("text", this._simulation.translateString("View.ShowV.text", "V                         ")).setProperty("mnemonic", this._simulation.translateString("View.ShowV.mnemonic", "v")).setProperty("background", "white").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.ShowV.tooltip", "Show the velocity of the center of mass")).getObject();
        this.refFrame = (JButton)this.addElement(new ControlTwoStateButton(), "refFrame").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "lButtons").setProperty("variable", "platform").setProperty("tooltip", this._simulation.translateString("View.refFrame.tooltip", "Select the reference frame: laboratory (green) or platform (blue)")).setProperty("textOn", this._simulation.translateString("View.refFrame.textOn", "Platform frame")).setProperty("actionOn", "_model._method_for_refFrame_actionOn()").setProperty("foreground", "WHITE").setProperty("background", "BLUE").setProperty("textOff", this._simulation.translateString("View.refFrame.textOff", "Laboratory frame")).setProperty("actionOff", "_model._method_for_refFrame_actionOff()").setProperty("foregroundOff", "WHITE").setProperty("backgroundOff", "0,128,0,255").getObject();
        this.rButtons = (JPanel)this.addElement(new ControlPanel(), "rButtons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Buttons").setProperty("layout", "FLOW:left,0,0").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "rButtons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "rButtons").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue simulation")).getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "rButtons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "rButtons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Accelerated platform and cylinder")).setProperty("visible", "true");
        this.getElement("Space").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("tooltip", this._simulation.translateString("View.Space.tooltip", "Use the mouse to move the cylinder (when the simulation is paused)"));
        this.getElement("Floor").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH_WEST").setProperty("secondaryColor", "0,160,0,255").setProperty("color", "0,160,0,255");
        this.getElement("Platform").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH_WEST").setProperty("secondaryColor", "blue").setProperty("color", "blue");
        this.getElement("Cylinder").setProperty("style", "WHEEL").setProperty("secondaryColor", "black").setProperty("color", "green");
        this.getElement("VField").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red");
        this.getElement("V").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta");
        this.getElement("vPlatform").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("color", "white").setProperty("secondaryColor", "white");
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Controls");
        this.getElement("Values");
        this.getElement("vValue").setProperty("format", this._simulation.translateString("View.vValue.format", "v = 0.###")).setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.vValue.tooltip", "Platform initial velocity"));
        this.getElement("aValue").setProperty("format", this._simulation.translateString("View.aValue.format", "a = 0.###")).setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.aValue.tooltip", "Platform acceleration"));
        this.getElement("XValue").setProperty("format", this._simulation.translateString("View.XValue.format", "X = 0.###")).setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.XValue.tooltip", "Cylinder initial position"));
        this.getElement("VValue").setProperty("format", this._simulation.translateString("View.VValue.format", "V = 0.###")).setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.VValue.tooltip", "Cylinder initial velocity"));
        this.getElement("nPoints").setProperty("format", this._simulation.translateString("View.nPoints.format", "N = 0")).setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.nPoints.tooltip", "Number of points in velocity field"));
        this.getElement("Scale").setProperty("format", this._simulation.translateString("View.Scale.format", "scale = 0.###")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Scale.tooltip", "Scale for velocities"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation step length"));
        this.getElement("Buttons");
        this.getElement("lButtons");
        this.getElement("ShowV").setProperty("text", this._simulation.translateString("View.ShowV.text", "V                         ")).setProperty("background", "white").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.ShowV.tooltip", "Show the velocity of the center of mass"));
        this.getElement("refFrame").setProperty("tooltip", this._simulation.translateString("View.refFrame.tooltip", "Select the reference frame: laboratory (green) or platform (blue)")).setProperty("textOn", this._simulation.translateString("View.refFrame.textOn", "Platform frame")).setProperty("foreground", "WHITE").setProperty("background", "BLUE").setProperty("textOff", this._simulation.translateString("View.refFrame.textOff", "Laboratory frame")).setProperty("foregroundOff", "WHITE").setProperty("backgroundOff", "0,128,0,255");
        this.getElement("rButtons");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue simulation"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        super.reset();
    }
}

