/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.platform;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.platform.platformSimulation;
import users.ehu.jma.rigid_bodies.platform.platformView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class platform
extends AbstractModel {
    public platformSimulation _simulation = null;
    public platformView _view = null;
    public platform _model = this;
    public double t = 0.0;
    public double X = 2.5;
    public double R;
    public double Y = this.R = 0.5;
    public double X0 = 0.0;
    public double V = 0.0;
    public double V0 = -0.1;
    public double x = 0.0;
    public double v = 0.0;
    public double v0 = 0.0;
    public double a = 0.04;
    public double D = 2.0 * this.R;
    public int maxPoints = 32;
    public int nPoints = 8;
    public double phi = 0.0;
    public double omega = 0.0;
    public double omega0 = 0.0;
    public double[] xp;
    public double[] yp;
    public double[] up;
    public double[] vp;
    public int nVel = 6;
    public double[] xv;
    public double scaleV = 1.0;
    public double dt = 0.02;
    public boolean platform = false;
    public double xmin = -4.0;
    public double xmax = 4.0;
    public double depth = 0.2;
    public double ymax = 1.5;
    public boolean showV = true;
    public double PI2 = Math.PI * 2;
    public boolean setInitial = false;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/platform.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        platform platform2 = new platform(stringArray);
    }

    public platform() {
        this(null, null, null, null, null, false);
    }

    public platform(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public platform(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new platformSimulation(this, string, frame, uRL, bl);
        this._view = (platformView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.X = this.X0;
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        this.Y = this.R;
    }

    public void _constraints2() {
        this.x = (this.v0 + 0.5 * this.a * this.t) * this.t;
        this.v = this.v0 + this.a * this.t;
        this.omega0 = (this.V0 - this.v0) / this.R;
        this.omega = this.omega0 - 0.6666666666666666 * this.a * this.t / this.R;
        this.phi = (this.omega0 - 0.3333333333333333 * this.a * this.t / this.R) * this.t;
        this.V = this.V0 + (this.v - this.v0) + this.R * (this.omega - this.omega0);
        if (!this.setInitial) {
            this.X = this.X0 + this.x + this.R * this.phi;
        }
        if (this.platform) {
            this.V -= this.v;
            this.X -= this.x;
        }
        if (this.nPoints == 0) {
            this.xp[0] = this.X + this.R * Math.sin(this.phi);
            this.yp[0] = this.Y + this.R * Math.cos(this.phi);
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                double d = this.phi + this.PI2 / (double)this.nPoints * (double)i;
                this.xp[i] = this.X + this.R * Math.sin(d);
                this.yp[i] = this.Y + this.R * Math.cos(d);
                this.up[i] = this.V + this.R * this.omega * Math.cos(d);
                this.vp[i] = -this.R * this.omega * Math.sin(d);
            }
        }
    }

    public void _constraints3() {
        for (int i = 0; i < this.nVel; ++i) {
            double d = this.x + (this.xmax - this.xmin) / (double)(this.nVel - 1) * (double)i;
            if (this.platform) {
                d = -d;
            }
            while (d > this.xmax && d + this.v * this.scaleV > this.xmax) {
                d -= this.xmax - this.xmin;
            }
            while (d < this.xmin && d + this.v * this.scaleV < this.xmin) {
                d += this.xmax - this.xmin;
            }
            this.xv[i] = d;
        }
    }

    public void _constraints4() {
        if (this.X > 1.5 * this.xmax || this.X < 1.5 * this.xmin) {
            this._pause();
        }
    }

    public double _method_for_Space_minimumY() {
        return -2.0 * this.depth;
    }

    public void _method_for_Space_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Floor_x() {
        return 2.0 * this.xmin;
    }

    public double _method_for_Floor_y() {
        return -2.0 * this.depth;
    }

    public double _method_for_Floor_sizex() {
        return 2.0 * (this.xmax - this.xmin);
    }

    public double _method_for_Platform_x() {
        return 2.0 * this.xmin;
    }

    public double _method_for_Platform_y() {
        return -this.depth;
    }

    public double _method_for_Platform_sizex() {
        return 2.0 * (this.xmax - this.xmin);
    }

    public boolean _method_for_Cylinder_enabled() {
        return this._isPaused();
    }

    public void _method_for_Cylinder_pressaction() {
        this._simulation.disableLoop();
        this.setInitial = true;
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_Cylinder_dragaction() {
        this._simulation.disableLoop();
        this.X0 = this.X;
        this._simulation.enableLoop();
    }

    public void _method_for_Cylinder_action() {
        this._simulation.disableLoop();
        this.setInitial = false;
        this._simulation.enableLoop();
    }

    public double _method_for_Cylinder_angle() {
        return -this.phi;
    }

    public boolean _method_for_VField_visible() {
        return this.nPoints > 0;
    }

    public double _method_for_vPlatform_y() {
        return (this.platform ? -1.5 : -0.5) * this.depth;
    }

    public double _method_for_vPlatform_sizex() {
        return this.platform ? -this.v : this.v;
    }

    public boolean _method_for_vValue_editable() {
        return this._isPaused();
    }

    public void _method_for_vValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_aValue_editable() {
        return this._isPaused();
    }

    public void _method_for_aValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_XValue_editable() {
        return this._isPaused();
    }

    public void _method_for_XValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_VValue_editable() {
        return this._isPaused();
    }

    public void _method_for_VValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_nPoints_editable() {
        return this._isPaused();
    }

    public void _method_for_nPoints_action() {
        this._simulation.disableLoop();
        if (this.nPoints < 0) {
            this.nPoints = 0;
        } else if (this.nPoints > this.maxPoints) {
            this.nPoints = this.maxPoints;
        }
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_refFrame_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_refFrame_actionOff() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.X = 2.5;
        this.Y = this.R = 0.5;
        this.X0 = 0.0;
        this.V = 0.0;
        this.V0 = -0.1;
        this.x = 0.0;
        this.v = 0.0;
        this.v0 = 0.0;
        this.a = 0.04;
        this.D = 2.0 * this.R;
        this.maxPoints = 32;
        this.nPoints = 8;
        this.phi = 0.0;
        this.omega = 0.0;
        this.omega0 = 0.0;
        this.xp = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.xp[n] = 0.0;
        }
        this.yp = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.yp[n] = 0.0;
        }
        this.up = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.up[n] = 0.0;
        }
        this.vp = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.vp[n] = 0.0;
        }
        this.nVel = 6;
        this.xv = new double[this.nVel];
        for (n = 0; n < this.nVel; ++n) {
            this.xv[n] = 0.0;
        }
        this.scaleV = 1.0;
        this.dt = 0.02;
        this.platform = false;
        this.xmin = -4.0;
        this.xmax = 4.0;
        this.depth = 0.2;
        this.ymax = 1.5;
        this.showV = true;
        this.PI2 = Math.PI * 2;
        this.setInitial = false;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
        this._constraints4();
    }

    @Override
    public void _freeMemory() {
        this.xp = null;
        this.yp = null;
        this.up = null;
        this.vp = null;
        this.xv = null;
        System.gc();
    }
}

