/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.free;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.free.freeSimulation;
import users.ehu.jma.rigid_bodies.free.freeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class free
extends AbstractModel {
    public freeSimulation _simulation = null;
    public freeView _view = null;
    public free _model = this;
    public double h = 1.0;
    public double dx = 0.0;
    public double dy = 0.0;
    public double dz = 0.0;
    public double Ix = 1.0;
    public double Iy = 1.5;
    public double Iz = 1.2;
    public double[] axes;
    public double t = 0.0;
    public double thetaDegrees = 60.0;
    public double phiDegrees = 0.0;
    public double psiDegrees = 0.0;
    public double thetad0 = 0.2;
    public double phid0 = -0.3;
    public double psid0 = 10.0;
    public double[] state;
    public double scaleW = 0.0;
    public double scaleL = 0.0;
    public double wx = 0.0;
    public double wy = 0.0;
    public double wz = 0.0;
    public double wsx = 0.0;
    public double wsy = 0.0;
    public double wsz = 0.0;
    public double Lx = 0.0;
    public double Ly = 0.0;
    public double Lz = 0.0;
    public double Lsx = 0.0;
    public double Lsy = 0.0;
    public double Lsz = 0.0;
    public double dt = 0.01;
    public double tol = 1.0E-6;
    public double alpha = 0.15;
    public double alphab = 0.15;
    public double beta = 0.3;
    public double betab = 0.3;
    public boolean showBody;
    public boolean showEuler;
    public boolean showAxes;
    public boolean showVelocities;
    public boolean showVectors;
    public boolean showTrajectories;
    public int Nvel = 10000;
    public double dd = 0.0;
    public double xmax = 0.7;
    public boolean canContinue = true;
    public double zoom = 1.0;
    public String labelZ0;
    public String labelZ = this.labelZ0 = "Principal axis Z";
    public String labelL0 = "Angular momentum";
    public String labelL = " ";
    public String labelOmega0 = "Angular velocity";
    public String labelOmega = " ";
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/free.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/rigid_bodies/euler.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        free free2 = new free(stringArray);
    }

    public free() {
        this(null, null, null, null, null, false);
    }

    public free(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public free(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new freeSimulation(this, string, frame, uRL, bl);
        this._view = (freeView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.state[0] = Math.toRadians(this.phiDegrees);
        this.state[1] = Math.toRadians(this.thetaDegrees);
        this.state[2] = Math.toRadians(this.psiDegrees);
        this.state[3] = this.phid0;
        this.state[4] = this.thetad0;
        this.state[5] = this.psid0;
        this.scaleW = 0.0;
        this.canContinue = false;
        this._view.resetTraces();
    }

    public void _constraints1() {
        if (this.Ix < this.tol) {
            this.Ix = this.tol;
        } else if (this.Ix > 2.0) {
            this.Ix = 2.0;
        }
        if (this.Iy < this.tol) {
            this.Iy = this.tol;
        } else if (this.Iy > 2.0) {
            this.Iy = 2.0;
        }
        if (this.Iz < this.tol) {
            this.Iz = this.tol;
        } else if (this.Iz > 2.0) {
            this.Iz = 2.0;
        }
        if (this.Ix >= this.Iy + this.Iz) {
            this.Ix = this.Iy + this.Iz;
        }
        if (this.Iy >= this.Ix + this.Iz) {
            this.Iy = this.Ix + this.Iz;
        }
        if (this.Iz >= this.Ix + this.Iy) {
            this.Iz = this.Ix + this.Iy;
        }
        this.dx = Math.sqrt(this.Iy + this.Iz - this.Ix);
        this.dy = Math.sqrt(this.Ix + this.Iz - this.Iy);
        this.dz = Math.sqrt(this.Ix + this.Iy - this.Iz);
        this.dd = this.dx;
        if (this.dy > this.dd) {
            this.dd = this.dy;
        }
        if (this.dz > this.dd) {
            this.dd = this.dz;
        }
        this.dd *= 0.7;
    }

    public void _constraints2() {
        double d = Math.cos(this.state[0]);
        double d2 = Math.sin(this.state[0]);
        double d3 = Math.cos(this.state[1]);
        double d4 = Math.sin(this.state[1]);
        double d5 = Math.cos(this.state[2]);
        double d6 = Math.sin(this.state[2]);
        double d7 = this.state[3];
        double d8 = this.state[4];
        double d9 = this.state[5];
        this.axes[0] = d * d5 - d3 * d2 * d6;
        this.axes[1] = d5 * d2 + d * d3 * d6;
        this.axes[2] = d4 * d6;
        this.axes[3] = -(d3 * d5 * d2) - d * d6;
        this.axes[4] = d * d3 * d5 - d2 * d6;
        this.axes[5] = d5 * d4;
        this.axes[6] = d2 * d4;
        this.axes[7] = -(d * d4);
        this.axes[8] = d3;
        this.wx = d7 * d4 * d6 + d8 * d5;
        this.wy = d7 * d4 * d5 - d8 * d6;
        this.wz = d7 * d3 + d9;
        this.Lx = this.Ix * this.wx;
        this.Ly = this.Iy * this.wy;
        this.Lz = this.Iz * this.wz;
        this.wsx = d8 * d + d9 * d2 * d4;
        this.wsy = d8 * d2 - d9 * d * d4;
        this.wsz = d7 + d9 * d3;
        this.Lsx = (d * d5 - d2 * d3 * d6) * this.Lx + (-d * d6 - d2 * d3 * d5) * this.Ly + d2 * d4 * this.Lz;
        this.Lsy = (d2 * d5 + d * d3 * d6) * this.Lx + (-d2 * d6 + d * d3 * d5) * this.Ly + -d * d4 * this.Lz;
        this.Lsz = d4 * d6 * this.Lx + d4 * d5 * this.Ly + d3 * this.Lz;
    }

    public void _constraints3() {
        if (this.scaleW == 0.0) {
            this.scaleW = 1.1 * this.dd / Math.sqrt(this.wx * this.wx + this.wy * this.wy + this.wz * this.wz);
            this.scaleL = 1.2 * this.dd / Math.sqrt(this.Lx * this.Lx + this.Ly * this.Ly + this.Lz * this.Lz);
        }
    }

    public double[] eqs(double d, double[] dArray) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        double d8 = Math.cos(d3);
        double d9 = Math.sin(d3);
        double d10 = Math.cos(d2);
        double d11 = Math.sin(d2);
        double d12 = Math.cos(d4);
        double d13 = Math.sin(d4);
        double[] dArray2 = new double[]{d5, d6, d7, -((d12 * (this.Ix - this.Iy) * (this.Ix + this.Iy - this.Iz) * d5 * (d8 * d5 + d7) * d9 * d13 + (d8 * (d12 * d12 * (this.Ix - this.Iy) + this.Iy) * (this.Ix + this.Iy - this.Iz) * d5 + (this.Iy * (-this.Ix + this.Iy - this.Iz) + d12 * d12 * (this.Ix - this.Iy) * (this.Ix + this.Iy - this.Iz)) * d7) * d6) / (this.Ix * this.Iy * d9)), -((-1.0 + 2.0 * d12 * d12) * (this.Ix - this.Iy) * (this.Ix + this.Iy - this.Iz) * d5 * (d8 * d5 + d7) * d9 + d5 * (-(d8 * (this.Ix * this.Ix + this.Iy * this.Iy - (this.Ix + this.Iy) * this.Iz) * d5) + (-(this.Ix - this.Iy) * (this.Ix - this.Iy) + (this.Ix + this.Iy) * this.Iz) * d7) * d9 - 2.0 * d12 * (this.Ix - this.Iy) * (this.Ix + this.Iy - this.Iz) * (d8 * d5 + d7) * d13 * d6) / (2.0 * this.Ix * this.Iy), (d12 * d12 * (this.Ix - this.Iy) * (d8 * (this.Ix + this.Iy - this.Iz) * this.Iz * (d8 * d5 + d7) + 2.0 * this.Ix * this.Iy * d5 * d9 * d9) * d6 + this.Iy * (d8 * d8 * (this.Ix + this.Iy - this.Iz) * this.Iz * d5 - d8 * this.Iz * (this.Ix - this.Iy + this.Iz) * d7 + this.Ix * (-this.Ix + this.Iy + this.Iz) * d5 * d9 * d9) * d6 + d12 * (this.Ix - this.Iy) * d9 * d13 * (d8 * (this.Iy - this.Iz) * this.Iz * d5 * (d8 * d5 + d7) + this.Ix * (d8 * this.Iz * d5 * (d8 * d5 + d7) - this.Iy * ((-1.0 + d8 * d8) * d5 * d5 + d6 * d6)))) / (this.Ix * this.Iy * this.Iz * d9)};
        return dArray2;
    }

    public void resetVelocities() {
        this._view.getElement("Wx").reset();
        this._view.getElement("Wy").reset();
        this._view.getElement("Wz").reset();
        this._view.getElement("Wsx").reset();
        this._view.getElement("Wsy").reset();
        this._view.getElement("Wsz").reset();
    }

    public void resetTrajectories() {
        this._view.getElement("OmegaTraj").reset();
        this._view.getElement("ZTraj").reset();
        this._view.getElement("OmegaTrajB").reset();
        this._view.getElement("Ltraj").reset();
    }

    public void setLabelAxis() {
        this.labelZ = this.showAxes ? this.labelZ0 : " ";
    }

    public void setLabelVectors() {
        this.labelL = this.showVectors ? this.labelL0 : " ";
        this.labelOmega = this.showVectors ? this.labelOmega0 : " ";
    }

    public void _method_for_Ix_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Iy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Iz_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Phi_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Theta_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Psi_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_PhiD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_ThetaD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_PsiD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this.initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Alpha_minimum() {
        return -Math.PI;
    }

    public double _method_for_Alpha_maximum() {
        return Math.PI;
    }

    public double _method_for_Beta_minimum() {
        return -Math.PI;
    }

    public double _method_for_Beta_maximum() {
        return Math.PI;
    }

    public double _method_for_Projection_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Projection_minimumY() {
        return -this.xmax;
    }

    public double _method_for_Projection_minimumZ() {
        return -this.xmax;
    }

    public double _method_for_AxisX_sizex() {
        return this.dd * this.axes[0];
    }

    public double _method_for_AxisX_sizey() {
        return this.dd * this.axes[1];
    }

    public double _method_for_AxisX_sizez() {
        return this.dd * this.axes[2];
    }

    public double _method_for_AxisY_sizex() {
        return this.dd * this.axes[3];
    }

    public double _method_for_AxisY_sizey() {
        return this.dd * this.axes[4];
    }

    public double _method_for_AxisY_sizez() {
        return this.dd * this.axes[5];
    }

    public double _method_for_AxisZ_sizex() {
        return this.dd * this.axes[6];
    }

    public double _method_for_AxisZ_sizey() {
        return this.dd * this.axes[7];
    }

    public double _method_for_AxisZ_sizez() {
        return this.dd * this.axes[8];
    }

    public double _method_for_OmegaTraj_x() {
        return this.wsx * this.scaleW;
    }

    public double _method_for_OmegaTraj_y() {
        return this.wsy * this.scaleW;
    }

    public double _method_for_OmegaTraj_z() {
        return this.wsz * this.scaleW;
    }

    public boolean _method_for_OmegaTraj_visible() {
        return this.showTrajectories && this.showVectors;
    }

    public double _method_for_ZTraj_x() {
        return this.dd * this.axes[6];
    }

    public double _method_for_ZTraj_y() {
        return this.dd * this.axes[7];
    }

    public double _method_for_ZTraj_z() {
        return this.dd * this.axes[8];
    }

    public boolean _method_for_ZTraj_visible() {
        return this.showTrajectories && this.showAxes;
    }

    public double _method_for_AlphaB_minimum() {
        return -Math.PI;
    }

    public double _method_for_AlphaB_maximum() {
        return Math.PI;
    }

    public double _method_for_BetaB_minimum() {
        return -Math.PI;
    }

    public double _method_for_BetaB_maximum() {
        return Math.PI;
    }

    public double _method_for_ProjectionB_minimumX() {
        return -this.xmax;
    }

    public double _method_for_ProjectionB_minimumY() {
        return -this.xmax;
    }

    public double _method_for_ProjectionB_minimumZ() {
        return -this.xmax;
    }

    public double _method_for_OmegaTrajB_x() {
        return this.wx * this.scaleW;
    }

    public double _method_for_OmegaTrajB_y() {
        return this.wy * this.scaleW;
    }

    public double _method_for_OmegaTrajB_z() {
        return this.wz * this.scaleW;
    }

    public boolean _method_for_OmegaTrajB_visible() {
        return this.showTrajectories && this.showVectors;
    }

    public double _method_for_Ltraj_x() {
        return this.Lx * this.scaleL;
    }

    public double _method_for_Ltraj_y() {
        return this.Ly * this.scaleL;
    }

    public double _method_for_Ltraj_z() {
        return this.Lz * this.scaleL;
    }

    public boolean _method_for_Ltraj_visible() {
        return this.showTrajectories && this.showVectors;
    }

    public void _method_for_ShowVelocities_action() {
        this._simulation.disableLoop();
        this.resetVelocities();
        this._simulation.enableLoop();
    }

    public void _method_for_ShowAxes_action() {
        this._simulation.disableLoop();
        this.setLabelAxis();
        this._simulation.enableLoop();
    }

    public void _method_for_ShowVectors_action() {
        this._simulation.disableLoop();
        this.setLabelVectors();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.resetTrajectories();
        this._simulation.enableLoop();
    }

    public void _method_for_ResetTraj_action() {
        this._simulation.disableLoop();
        this.resetVelocities();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.h = 1.0;
        this.dx = 0.0;
        this.dy = 0.0;
        this.dz = 0.0;
        this.Ix = 1.0;
        this.Iy = 1.5;
        this.Iz = 1.2;
        this.axes = new double[9];
        for (n = 0; n < 9; ++n) {
            this.axes[n] = 0.0;
        }
        this.t = 0.0;
        this.thetaDegrees = 60.0;
        this.phiDegrees = 0.0;
        this.psiDegrees = 0.0;
        this.thetad0 = 0.2;
        this.phid0 = -0.3;
        this.psid0 = 10.0;
        this.state = new double[6];
        for (n = 0; n < 6; ++n) {
            this.state[n] = 0.0;
        }
        this.scaleW = 0.0;
        this.scaleL = 0.0;
        this.wx = 0.0;
        this.wy = 0.0;
        this.wz = 0.0;
        this.wsx = 0.0;
        this.wsy = 0.0;
        this.wsz = 0.0;
        this.Lx = 0.0;
        this.Ly = 0.0;
        this.Lz = 0.0;
        this.Lsx = 0.0;
        this.Lsy = 0.0;
        this.Lsz = 0.0;
        this.dt = 0.01;
        this.tol = 1.0E-6;
        this.alpha = 0.15;
        this.alphab = 0.15;
        this.beta = 0.3;
        this.betab = 0.3;
        this.Nvel = 10000;
        this.dd = 0.0;
        this.xmax = 0.7;
        this.canContinue = true;
        this.zoom = 1.0;
        this.labelZ = this.labelZ0 = "Principal axis Z";
        this.labelL0 = "Angular momentum";
        this.labelL = " ";
        this.labelOmega0 = "Angular velocity";
        this.labelOmega = " ";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        this.axes = null;
        this.state = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double[] _state;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + free.this.state.length];
            this._state = new double[free.this.state.length];
        }

        private boolean arraysChanged() {
            return free.this.state.length != this._state.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : free.this.state) {
            }
            this.__state[n++] = free.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(free.this.dt);
        }

        void step() {
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (free.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(free.this.tol);
            }
            if (free.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(free.this.dt);
            }
            int n = 0;
            for (double this.__state[n++] : free.this.state) {
            }
            this.__state[n++] = free.this.t;
            this.__solver.step();
            n = 0;
            int n2 = free.this.state.length;
            for (int i = 0; i < n2; ++i) {
                free.this.state[i] = this.__state[n++];
            }
            free.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            int n2 = free.this.state.length;
            for (int i = 0; i < n2; ++i) {
                this._state[i] = dArray[n++];
            }
            this._t = dArray[n++];
            n = 0;
            System.arraycopy(this._ODE_evolution1_1(this._state, this._t), 0, dArray2, n, free.this.state.length);
            n += free.this.state.length;
            dArray2[n++] = 1.0;
        }

        private double[] _ODE_evolution1_1(double[] dArray, double d) {
            return free.this.eqs(d, dArray);
        }
    }
}

