/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.faster;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.rigid_bodies.faster.faster;
import users.ehu.jma.rigid_bodies.faster.fasterSimulation;

class fasterView
extends EjsControl
implements View {
    private fasterSimulation _simulation = null;
    private faster _model = null;
    public Component Main;
    public JPanel Left;
    public JPanel Void;
    public JSlider Height;
    public JPanel Center;
    public JPanel Graph;
    public PlottingPanel2D Heights;
    public InteractiveTrace LeftHeight;
    public InteractiveTrace RightHeight;
    public DrawingPanel2D Space;
    public InteractiveArrow Rod;
    public InteractiveParticle Articulation;
    public InteractiveParticle Axis;
    public InteractiveParticle Particle;
    public InteractiveArrow Table;
    public InteractiveTrace RodTrace;
    public InteractiveTrace ParticleTrace;
    public JPanel Times;
    public JLabel t1;
    public JLabel t2;
    public JPanel Bottom;
    public JPanel Controls;
    public JPanel Display;
    public JTextField z0;
    public JTextField dt;
    public JCheckBox ShowVelocities;
    public JCheckBox Pause;
    public JPanel Buttons;
    public JButton startButton;
    public JButton continueButton;
    public JButton stepButton;
    public JButton resetButton;
    public JDialog VelocitiesDialog;
    public PlottingPanel2D Velocities;
    public InteractiveTrace vel1;
    public InteractiveTrace vel2;

    public fasterView(fasterSimulation fasterSimulation2, String string, Frame frame) {
        super(fasterSimulation2, string, frame);
        this._simulation = fasterSimulation2;
        this._model = (faster)fasterSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("phid", "apply(\"phid\")");
        this.addListener("z", "apply(\"z\")");
        this.addListener("phi0", "apply(\"phi0\")");
        this.addListener("z0", "apply(\"z0\")");
        this.addListener("t1", "apply(\"t1\")");
        this.addListener("t2", "apply(\"t2\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("eps", "apply(\"eps\")");
        this.addListener("stopEvents", "apply(\"stopEvents\")");
        this.addListener("showVelocities", "apply(\"showVelocities\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("x2", "apply(\"x2\")");
        this.addListener("t1Label", "apply(\"t1Label\")");
        this.addListener("t2Label", "apply(\"t2Label\")");
        this.addListener("formatString", "apply(\"formatString\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("phid".equals(string)) {
            this._model.phid = this.getDouble("phid");
        }
        if ("z".equals(string)) {
            this._model.z = this.getDouble("z");
        }
        if ("phi0".equals(string)) {
            this._model.phi0 = this.getDouble("phi0");
        }
        if ("z0".equals(string)) {
            this._model.z0 = this.getDouble("z0");
        }
        if ("t1".equals(string)) {
            this._model.t1 = this.getDouble("t1");
        }
        if ("t2".equals(string)) {
            this._model.t2 = this.getDouble("t2");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("eps".equals(string)) {
            this._model.eps = this.getDouble("eps");
        }
        if ("stopEvents".equals(string)) {
            this._model.stopEvents = this.getBoolean("stopEvents");
        }
        if ("showVelocities".equals(string)) {
            this._model.showVelocities = this.getBoolean("showVelocities");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
        if ("t1Label".equals(string)) {
            this._model.t1Label = this.getString("t1Label");
        }
        if ("t2Label".equals(string)) {
            this._model.t2Label = this.getString("t2Label");
        }
        if ("formatString".equals(string)) {
            this._model.formatString = this.getString("formatString");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("phi", this._model.phi);
        this.setValue("phid", this._model.phid);
        this.setValue("z", this._model.z);
        this.setValue("phi0", this._model.phi0);
        this.setValue("z0", this._model.z0);
        this.setValue("t1", this._model.t1);
        this.setValue("t2", this._model.t2);
        this.setValue("dt", this._model.dt);
        this.setValue("tol", this._model.tol);
        this.setValue("eps", this._model.eps);
        this.setValue("stopEvents", this._model.stopEvents);
        this.setValue("showVelocities", this._model.showVelocities);
        this.setValue("x1", this._model.x1);
        this.setValue("x2", this._model.x2);
        this.setValue("t1Label", this._model.t1Label);
        this.setValue("t2Label", this._model.t2Label);
        this.setValue("formatString", this._model.formatString);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Faster than g")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,-4").setProperty("size", this._simulation.translateString("View.Main.size", "640,460")).getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Void = (JPanel)this.addElement(new ControlPanel(), "Void").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("layout", "border").setProperty("background", "239,239,255,255").getObject();
        this.Height = (JSlider)this.addElement(new ControlSlider(), "Height").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Left").setProperty("variable", "phi0").setProperty("minimum", "0.0").setProperty("maximum", "89.9").setProperty("orientation", "VERTICAL").setProperty("enabled", "_isPaused").setProperty("dragaction", "_model._method_for_Height_dragaction()").setProperty("action", "_model._method_for_Height_action()").setProperty("background", "239,239,255,255").setProperty("tooltip", this._simulation.translateString("View.Height.tooltip", "Initial height")).getObject();
        this.Center = (JPanel)this.addElement(new ControlPanel(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Graph = (JPanel)this.addElement(new ControlPanel(), "Graph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Center").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Heights = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Heights").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("title", this._simulation.translateString("View.Heights.title", "Heights")).setProperty("titleX", this._simulation.translateString("View.Heights.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Heights.titleY", "z")).setProperty("xFormat", this._simulation.translateString("View.Heights.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Heights.yFormat", "z = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Heights.tooltip", "Height evolution")).getObject();
        this.LeftHeight = (InteractiveTrace)this.addElement(new ControlTrace(), "LeftHeight").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Heights").setProperty("x", "t").setProperty("y", "%_model._method_for_LeftHeight_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").setProperty("stroke", "2").getObject();
        this.RightHeight = (InteractiveTrace)this.addElement(new ControlTrace(), "RightHeight").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Heights").setProperty("x", "t").setProperty("y", "z").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").setProperty("stroke", "2").getObject();
        this.Space = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.").setProperty("maximumX", "1.").setProperty("minimumY", "-.05").setProperty("maximumY", "1.05").setProperty("square", "true").setProperty("showCoordinates", "false").getObject();
        this.Rod = (InteractiveArrow)this.addElement(new ControlArrow(), "Rod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("y", "0").setProperty("sizex", "%_model._method_for_Rod_sizex()%").setProperty("sizey", "%_model._method_for_Rod_sizey()%").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("stroke", "3").getObject();
        this.Articulation = (InteractiveParticle)this.addElement(new ControlParticle(), "Articulation").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("sizex", ".1").setProperty("enabled", "false").getObject();
        this.Axis = (InteractiveParticle)this.addElement(new ControlParticle(), "Axis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("color", "red").getObject();
        this.Particle = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x2").setProperty("y", "z").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").getObject();
        this.Table = (InteractiveArrow)this.addElement(new ControlArrow(), "Table").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "green").setProperty("stroke", "9").getObject();
        this.RodTrace = (InteractiveTrace)this.addElement(new ControlTrace(), "RodTrace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "%_model._method_for_RodTrace_x()%").setProperty("y", "%_model._method_for_RodTrace_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "255,128,128,255").getObject();
        this.ParticleTrace = (InteractiveTrace)this.addElement(new ControlTrace(), "ParticleTrace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x2").setProperty("y", "z").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "128,128,255,255").getObject();
        this.Times = (JPanel)this.addElement(new ControlPanel(), "Times").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Center").setProperty("layout", "grid:1,2,0,0").getObject();
        this.t1 = (JLabel)this.addElement(new ControlLabel(), "t1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("text", this._simulation.translateString("View.t1.text", "%t1Label%")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.t1.tooltip", "Time the rod needs to reach the horizontal")).getObject();
        this.t2 = (JLabel)this.addElement(new ControlLabel(), "t2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("text", this._simulation.translateString("View.t2.text", "%t2Label%")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.t2.tooltip", "Time the particle needs to reach the table")).getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "border").getObject();
        this.Display = (JPanel)this.addElement(new ControlPanel(), "Display").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("layout", "hbox").getObject();
        this.z0 = (JTextField)this.addElement(new ControlNumberField(), "z0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "phi0").setProperty("format", this._simulation.translateString("View.z0.format", "$\\phi$ = 0.##")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_z0_action()").setProperty("tooltip", this._simulation.translateString("View.z0.tooltip", "Initial angle (in degrees)")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step")).getObject();
        this.ShowVelocities = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowVelocities").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "showVelocities").setProperty("text", this._simulation.translateString("View.ShowVelocities.text", "Velocities")).setProperty("mnemonic", this._simulation.translateString("View.ShowVelocities.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.ShowVelocities.tooltip", "Show the velocities of particle and rod free end")).getObject();
        this.Pause = (JCheckBox)this.addElement(new ControlCheckBox(), "Pause").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "stopEvents").setProperty("text", this._simulation.translateString("View.Pause.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.Pause.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Pause.tooltip", "Pause when the rod or the particle reaches the table")).getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Controls").setProperty("layout", "grid:1,3,0,0").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simualtion")).getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.VelocitiesDialog = (JDialog)this.addElement(new ControlDialog(), "VelocitiesDialog").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.VelocitiesDialog.title", "Velocities")).setProperty("layout", "border").setProperty("visible", "showVelocities").setProperty("location", "648,0").setProperty("size", this._simulation.translateString("View.VelocitiesDialog.size", "300,300")).getObject();
        this.Velocities = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Velocities").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "VelocitiesDialog").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("pressaction", "_model._method_for_Velocities_pressaction()").setProperty("title", this._simulation.translateString("View.Velocities.title", "Velocities vs height")).setProperty("titleX", this._simulation.translateString("View.Velocities.titleX", "z")).setProperty("titleY", this._simulation.translateString("View.Velocities.titleY", "v")).setProperty("xFormat", this._simulation.translateString("View.Velocities.xFormat", "z = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Velocities.yFormat", "v = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Velocities.tooltip", "Click to clear")).getObject();
        this.vel1 = (InteractiveTrace)this.addElement(new ControlTrace(), "vel1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Velocities").setProperty("x", "%_model._method_for_vel1_x()%").setProperty("y", "%_model._method_for_vel1_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "%_model._method_for_vel1_enabled()%").setProperty("color", "red").getObject();
        this.vel2 = (InteractiveTrace)this.addElement(new ControlTrace(), "vel2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Velocities").setProperty("x", "z").setProperty("y", "%_model._method_for_vel2_y()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "%_model._method_for_vel2_enabled()%").setProperty("color", "blue").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Faster than g")).setProperty("visible", "true");
        this.getElement("Left");
        this.getElement("Void").setProperty("background", "239,239,255,255");
        this.getElement("Height").setProperty("minimum", "0.0").setProperty("maximum", "89.9").setProperty("orientation", "VERTICAL").setProperty("background", "239,239,255,255").setProperty("tooltip", this._simulation.translateString("View.Height.tooltip", "Initial height"));
        this.getElement("Center");
        this.getElement("Graph");
        this.getElement("Heights").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("title", this._simulation.translateString("View.Heights.title", "Heights")).setProperty("xFormat", this._simulation.translateString("View.Heights.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Heights.yFormat", "z = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Heights.tooltip", "Height evolution"));
        this.getElement("LeftHeight").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").setProperty("stroke", "2");
        this.getElement("RightHeight").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").setProperty("stroke", "2");
        this.getElement("Space").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.").setProperty("maximumX", "1.").setProperty("minimumY", "-.05").setProperty("maximumY", "1.05").setProperty("square", "true").setProperty("showCoordinates", "false");
        this.getElement("Rod").setProperty("y", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "red").setProperty("stroke", "3");
        this.getElement("Articulation").setProperty("sizex", ".1").setProperty("enabled", "false");
        this.getElement("Axis").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("color", "red");
        this.getElement("Particle").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false");
        this.getElement("Table").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "green").setProperty("stroke", "9");
        this.getElement("RodTrace").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "255,128,128,255");
        this.getElement("ParticleTrace").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "128,128,255,255");
        this.getElement("Times");
        this.getElement("t1").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.t1.tooltip", "Time the rod needs to reach the horizontal"));
        this.getElement("t2").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.t2.tooltip", "Time the particle needs to reach the table"));
        this.getElement("Bottom").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Controls");
        this.getElement("Display");
        this.getElement("z0").setProperty("format", this._simulation.translateString("View.z0.format", "$\\phi$ = 0.##")).setProperty("tooltip", this._simulation.translateString("View.z0.tooltip", "Initial angle (in degrees)"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step"));
        this.getElement("ShowVelocities").setProperty("text", this._simulation.translateString("View.ShowVelocities.text", "Velocities")).setProperty("mnemonic", this._simulation.translateString("View.ShowVelocities.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.ShowVelocities.tooltip", "Show the velocities of particle and rod free end"));
        this.getElement("Pause").setProperty("text", this._simulation.translateString("View.Pause.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.Pause.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Pause.tooltip", "Pause when the rod or the particle reaches the table"));
        this.getElement("Buttons");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simualtion"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("VelocitiesDialog").setProperty("title", this._simulation.translateString("View.VelocitiesDialog.title", "Velocities"));
        this.getElement("Velocities").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("title", this._simulation.translateString("View.Velocities.title", "Velocities vs height")).setProperty("titleY", this._simulation.translateString("View.Velocities.titleY", "v")).setProperty("xFormat", this._simulation.translateString("View.Velocities.xFormat", "z = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Velocities.yFormat", "v = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Velocities.tooltip", "Click to clear"));
        this.getElement("vel1").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("vel2").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        super.reset();
    }
}

