/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.faster;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.faster.fasterSimulation;
import users.ehu.jma.rigid_bodies.faster.fasterView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class faster
extends AbstractModel {
    public fasterSimulation _simulation = null;
    public fasterView _view = null;
    public faster _model = this;
    public double t = 0.0;
    public double phi = 0.0;
    public double phid = 0.0;
    public double z = 0.0;
    public double phi0 = 89.0;
    public double z0 = 0.99;
    public double t1 = 0.0;
    public double t2 = 0.0;
    public double dt = 0.01;
    public double tol = 1.0E-6;
    public double eps = 1.0E-6;
    public boolean stopEvents = false;
    public boolean showVelocities = false;
    public double x1 = -0.75;
    public double x2 = 0.75;
    public String t1Label = " ";
    public String t2Label = " ";
    public String formatString = "0.0000";
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/faster.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        faster faster2 = new faster(stringArray);
    }

    public faster() {
        this(null, null, null, null, null, false);
    }

    public faster(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public faster(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new fasterSimulation(this, string, frame, uRL, bl);
        this._view = (fasterView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.phid = 0.0;
        this.t2 = 0.0;
        this.t1 = 0.0;
        this.t = 0.0;
        if (this.phi0 < 0.0) {
            this.phi0 = 0.0;
        } else if (this.phi0 >= 89.9) {
            this.phi0 = 89.9;
        }
        this.phi = Math.toRadians(this.phi0);
        this.z = this.z0 = Math.sin(this.phi);
        this._view.resetTraces();
        this.t2Label = " ";
        this.t1Label = " ";
    }

    public void _evolution2() {
        this.z = this.z0 - 0.5 * this.t * this.t;
        if (this.z < 0.0 && this.t2 == 0.0) {
            this.t2 = Math.sqrt(2.0 * this.z0);
            if (this.stopEvents || this.t1 != 0.0) {
                this._pause();
            }
            this.t2Label = "t = " + this._format(this.t2, this.formatString);
        }
    }

    public void _constraints1() {
        if (this.phi < 0.0) {
            this.phi = 0.0;
        }
        if (this.z < 0.0) {
            this.z = 0.0;
        }
    }

    public void _method_for_Height_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Height_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public double _method_for_LeftHeight_y() {
        return Math.sin(this.phi);
    }

    public double _method_for_Rod_sizex() {
        return Math.cos(this.phi);
    }

    public double _method_for_Rod_sizey() {
        return Math.sin(this.phi);
    }

    public double _method_for_RodTrace_x() {
        return this.x1 + Math.cos(this.phi);
    }

    public double _method_for_RodTrace_y() {
        return Math.sin(this.phi);
    }

    public void _method_for_z0_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Velocities_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("vel1").reset();
        this._view.getElement("vel2").reset();
        this._simulation.enableLoop();
    }

    public double _method_for_vel1_x() {
        return Math.sin(this.phi);
    }

    public double _method_for_vel1_y() {
        return this.phi > 0.0 ? -this.phid * Math.cos(this.phi) : Math.sqrt(3.0 * this.z0);
    }

    public boolean _method_for_vel1_enabled() {
        return this.t1 == 0.0;
    }

    public double _method_for_vel2_y() {
        return Math.sqrt(2.0 * (this.z0 - this.z));
    }

    public boolean _method_for_vel2_enabled() {
        return this.t2 == 0.0;
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.phi = 0.0;
        this.phid = 0.0;
        this.z = 0.0;
        this.phi0 = 89.0;
        this.z0 = 0.99;
        this.t1 = 0.0;
        this.t2 = 0.0;
        this.dt = 0.01;
        this.tol = 1.0E-6;
        this.eps = 1.0E-6;
        this.stopEvents = false;
        this.showVelocities = false;
        this.x1 = -0.75;
        this.x2 = 0.75;
        this.t1Label = " ";
        this.t2Label = " ";
        this.formatString = "0.0000";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _phi;
        private double _phid;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = faster.this.phi;
            this.__state[n++] = faster.this.phid;
            this.__state[n++] = faster.this.t;
            this.__solver = new ODEBisectionEventSolver(this, EulerRichardson.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(faster.this.dt);
        }

        void step() {
            if (faster.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(faster.this.dt);
            }
            int n = 0;
            this.__state[n++] = faster.this.phi;
            this.__state[n++] = faster.this.phid;
            this.__state[n++] = faster.this.t;
            this.__solver.step();
            n = 0;
            faster.this.phi = this.__state[n++];
            faster.this.phid = this.__state[n++];
            faster.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._phi = dArray[n++];
            this._phid = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._phi, this._phid, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._phi, this._phid, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3) {
            return -1.5 * Math.cos(d);
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Rod horizontal";
            }

            public double getTolerance() {
                return faster.this.eps;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._phi = dArray[n++];
                _ODE_evolution1.this._phid = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._phi, _ODE_evolution1.this._phid, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3) {
                return faster.this.t1 > 0.0 ? 1.0 : d;
            }

            public boolean action() {
                int n = 0;
                faster.this.phi = _ODE_evolution1.this.__state[n++];
                faster.this.phid = _ODE_evolution1.this.__state[n++];
                faster.this.t1 = faster.this.t = _ODE_evolution1.this.__state[n++];
                faster.this.phid = 0.0;
                faster.this.phi = 0.0;
                faster.this.t1Label = "t = " + faster.this._format(faster.this.t1, faster.this.formatString);
                if (faster.this.stopEvents || faster.this.t2 != 0.0) {
                    faster.this._pause();
                }
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = faster.this.phi;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = faster.this.phid;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = faster.this.t;
                return true;
            }
        }
    }
}

