/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.dumbbell;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlDrawingPanel3D;
import org.colos.ejs.library.control.displayejs.ControlSphere;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveSphere;
import users.ehu.jma.rigid_bodies.dumbbell.dumbbell;
import users.ehu.jma.rigid_bodies.dumbbell.dumbbellSimulation;

class dumbbellView
extends EjsControl
implements View {
    private dumbbellSimulation _simulation = null;
    private dumbbell _model = null;
    public Component Main;
    public JPanel Right;
    public JTextField Omega;
    public JTextField Theta;
    public JCheckBox trajectories;
    public JCheckBox vectors;
    public JLabel OmegaLabel;
    public JLabel L;
    public JLabel Torque;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JPanel Panel3D;
    public DrawingPanel3D D3;
    public InteractiveArrow Bomega;
    public InteractiveArrow BL;
    public InteractiveArrow BN;
    public InteractiveArrow Rod;
    public InteractiveArrow Axis;
    public InteractiveSphere m1;
    public InteractiveSphere m2;
    public InteractivePoligon i1;
    public InteractivePoligon i2;
    public JSlider Alpha;
    public JSlider Beta;

    public dumbbellView(dumbbellSimulation dumbbellSimulation2, String string, Frame frame) {
        super(dumbbellSimulation2, string, frame);
        this._simulation = dumbbellSimulation2;
        this._model = (dumbbell)dumbbellSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("th", "apply(\"th\")");
        this.addListener("ph", "apply(\"ph\")");
        this.addListener("om", "apply(\"om\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("z", "apply(\"z\")");
        this.addListener("cs", "apply(\"cs\")");
        this.addListener("sn", "apply(\"sn\")");
        this.addListener("theta", "apply(\"theta\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("pi", "apply(\"pi\")");
        this.addListener("pi2", "apply(\"pi2\")");
        this.addListener("alpha", "apply(\"alpha\")");
        this.addListener("beta", "apply(\"beta\")");
        this.addListener("rho", "apply(\"rho\")");
        this.addListener("vectors", "apply(\"vectors\")");
        this.addListener("trajectories", "apply(\"trajectories\")");
        this.addListener("r", "apply(\"r\")");
        this.addListener("xh", "apply(\"xh\")");
        this.addListener("yh", "apply(\"yh\")");
        this.addListener("zh", "apply(\"zh\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("th".equals(string)) {
            this._model.th = this.getDouble("th");
        }
        if ("ph".equals(string)) {
            this._model.ph = this.getDouble("ph");
        }
        if ("om".equals(string)) {
            this._model.om = this.getDouble("om");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
        }
        if ("z".equals(string)) {
            this._model.z = this.getDouble("z");
        }
        if ("cs".equals(string)) {
            this._model.cs = this.getDouble("cs");
        }
        if ("sn".equals(string)) {
            this._model.sn = this.getDouble("sn");
        }
        if ("theta".equals(string)) {
            this._model.theta = this.getDouble("theta");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("pi".equals(string)) {
            this._model.pi = this.getDouble("pi");
        }
        if ("pi2".equals(string)) {
            this._model.pi2 = this.getDouble("pi2");
        }
        if ("alpha".equals(string)) {
            this._model.alpha = this.getDouble("alpha");
        }
        if ("beta".equals(string)) {
            this._model.beta = this.getDouble("beta");
        }
        if ("rho".equals(string)) {
            this._model.rho = this.getDouble("rho");
        }
        if ("vectors".equals(string)) {
            this._model.vectors = this.getBoolean("vectors");
        }
        if ("trajectories".equals(string)) {
            this._model.trajectories = this.getBoolean("trajectories");
        }
        if ("r".equals(string)) {
            this._model.r = this.getDouble("r");
        }
        if ("xh".equals(string)) {
            this._model.xh = this.getDouble("xh");
        }
        if ("yh".equals(string)) {
            this._model.yh = this.getDouble("yh");
        }
        if ("zh".equals(string)) {
            this._model.zh = this.getDouble("zh");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("th", this._model.th);
        this.setValue("ph", this._model.ph);
        this.setValue("om", this._model.om);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("z", this._model.z);
        this.setValue("cs", this._model.cs);
        this.setValue("sn", this._model.sn);
        this.setValue("theta", this._model.theta);
        this.setValue("dt", this._model.dt);
        this.setValue("pi", this._model.pi);
        this.setValue("pi2", this._model.pi2);
        this.setValue("alpha", this._model.alpha);
        this.setValue("beta", this._model.beta);
        this.setValue("rho", this._model.rho);
        this.setValue("vectors", this._model.vectors);
        this.setValue("trajectories", this._model.trajectories);
        this.setValue("r", this._model.r);
        this.setValue("xh", this._model.xh);
        this.setValue("yh", this._model.yh);
        this.setValue("zh", this._model.zh);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Dumbbell")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "480,317")).getObject();
        this.Right = (JPanel)this.addElement(new ControlPanel(), "Right").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:10,1,0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Omega = (JTextField)this.addElement(new ControlNumberField(), "Omega").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("variable", "om").setProperty("format", this._simulation.translateString("View.Omega.format", "$\\omega$ = 0.##")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.Omega.tooltip", "Angular velocity")).getObject();
        this.Theta = (JTextField)this.addElement(new ControlNumberField(), "Theta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("variable", "theta").setProperty("format", this._simulation.translateString("View.Theta.format", "$\\theta$ = 0")).setProperty("tooltip", this._simulation.translateString("View.Theta.tooltip", "Angle between angular velocity and momentum")).getObject();
        this.trajectories = (JCheckBox)this.addElement(new ControlCheckBox(), "trajectories").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("variable", "trajectories").setProperty("text", this._simulation.translateString("View.trajectories.text", "Trajectories")).setProperty("mnemonic", this._simulation.translateString("View.trajectories.mnemonic", "t")).setProperty("tooltip", this._simulation.translateString("View.trajectories.tooltip", "Display the trajectories of both masses")).getObject();
        this.vectors = (JCheckBox)this.addElement(new ControlCheckBox(), "vectors").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("variable", "vectors").setProperty("text", this._simulation.translateString("View.vectors.text", "Vectors:")).setProperty("mnemonic", this._simulation.translateString("View.vectors.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.vectors.tooltip", "Show angular velocity and momentum, as well as the torque")).getObject();
        this.OmegaLabel = (JLabel)this.addElement(new ControlLabel(), "OmegaLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Right").setProperty("text", this._simulation.translateString("View.OmegaLabel.text", "Angular velocity")).setProperty("alignment", "CENTER").setProperty("foreground", "blue").getObject();
        this.L = (JLabel)this.addElement(new ControlLabel(), "L").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("text", this._simulation.translateString("View.L.text", "Angular momentum")).setProperty("alignment", "CENTER").setProperty("foreground", "0,128,0,255").getObject();
        this.Torque = (JLabel)this.addElement(new ControlLabel(), "Torque").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("text", this._simulation.translateString("View.Torque.text", "Torque")).setProperty("alignment", "CENTER").setProperty("foreground", "red").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Right").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.Panel3D = (JPanel)this.addElement(new ControlPanel(), "Panel3D").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.D3 = (DrawingPanel3D)this.addElement(new ControlDrawingPanel3D(), "D3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Panel3D").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("autoscaleZ", "false").setProperty("minimumX", "-.75").setProperty("maximumX", ".75").setProperty("minimumY", "-.75").setProperty("maximumY", ".75").setProperty("minimumZ", "-.75").setProperty("maximumZ", ".75").setProperty("displayMode", "PERSPECTIVE").setProperty("square", "true").setProperty("hideLines", "true").setProperty("alpha", "alpha").setProperty("beta", "beta").setProperty("panx", "0.75").setProperty("pany", "0.75").setProperty("pressaction", "_model._method_for_D3_pressaction()").setProperty("action", "_model._method_for_D3_action()").setProperty("decoration", "AXES").getObject();
        this.Bomega = (InteractiveArrow)this.addElement(new ControlArrow(), "Bomega").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("x", "0").setProperty("y", "0").setProperty("z", ".6").setProperty("sizex", "0").setProperty("sizey", "0").setProperty("sizez", ".5").setProperty("visible", "vectors").setProperty("enabled", "true").setProperty("style", "ARROW").setProperty("color", "blue").setProperty("secondaryColor", "blue").setProperty("stroke", "3").getObject();
        this.BL = (InteractiveArrow)this.addElement(new ControlArrow(), "BL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("x", "0").setProperty("y", "0").setProperty("z", "0").setProperty("sizex", "%_model._method_for_BL_sizex()%").setProperty("sizey", "%_model._method_for_BL_sizey()%").setProperty("sizez", "%_model._method_for_BL_sizez()%").setProperty("visible", "vectors").setProperty("enabled", "true").setProperty("style", "ARROW").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3").getObject();
        this.BN = (InteractiveArrow)this.addElement(new ControlArrow(), "BN").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("x", "0").setProperty("y", "0").setProperty("z", "0").setProperty("sizex", "%_model._method_for_BN_sizex()%").setProperty("sizey", "%_model._method_for_BN_sizey()%").setProperty("sizez", "0").setProperty("visible", "vectors").setProperty("enabled", "true").setProperty("style", "ARROW").setProperty("color", "red").setProperty("secondaryColor", "red").setProperty("stroke", "3").getObject();
        this.Rod = (InteractiveArrow)this.addElement(new ControlArrow(), "Rod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("x", "%_model._method_for_Rod_x()%").setProperty("y", "%_model._method_for_Rod_y()%").setProperty("z", "%_model._method_for_Rod_z()%").setProperty("sizex", "%_model._method_for_Rod_sizex()%").setProperty("sizey", "%_model._method_for_Rod_sizey()%").setProperty("sizez", "%_model._method_for_Rod_sizez()%").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "gray").setProperty("secondaryColor", "gray").setProperty("stroke", "5").getObject();
        this.Axis = (InteractiveArrow)this.addElement(new ControlArrow(), "Axis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("x", "0").setProperty("y", "0").setProperty("z", "-.5").setProperty("sizex", "0").setProperty("sizey", "0").setProperty("sizez", "1").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("stroke", "5").getObject();
        this.m1 = (InteractiveSphere)this.addElement(new ControlSphere(), "m1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("x", "x").setProperty("y", "y").setProperty("z", "z").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("sizez", ".2").setProperty("secondaryColor", "gray").setProperty("color", "lightGray").getObject();
        this.m2 = (InteractiveSphere)this.addElement(new ControlSphere(), "m2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("x", "%_model._method_for_m2_x()%").setProperty("y", "%_model._method_for_m2_y()%").setProperty("z", "%_model._method_for_m2_z()%").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("sizez", ".2").setProperty("enabled", "false").setProperty("secondaryColor", "gray").setProperty("color", "lightGray").getObject();
        this.i1 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "i1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("points", "100").setProperty("min", "%_model._method_for_i1_min()%").setProperty("max", "pi").setProperty("variable", "s").setProperty("functionx", "rho*cos(s)").setProperty("functiony", "rho*sin(s)").setProperty("functionz", "z").setProperty("javaSyntax", "false").setProperty("color", "magenta").setProperty("visible", "trajectories").setProperty("enabled", "false").getObject();
        this.i2 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "i2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "D3").setProperty("points", "100").setProperty("min", "%_model._method_for_i2_min()%").setProperty("max", "pi").setProperty("variable", "s").setProperty("functionx", "rho*cos(s)").setProperty("functiony", "rho*sin(s)").setProperty("functionz", "-z").setProperty("javaSyntax", "false").setProperty("color", "magenta").setProperty("visible", "trajectories").setProperty("enabled", "false").getObject();
        this.Alpha = (JSlider)this.addElement(new ControlSlider(), "Alpha").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Panel3D").setProperty("variable", "alpha").setProperty("value", "0.46790880982566385").setProperty("minimum", "%_model._method_for_Alpha_minimum()%").setProperty("maximum", "pi").setProperty("tooltip", this._simulation.translateString("View.Alpha.tooltip", "Point of view")).getObject();
        this.Beta = (JSlider)this.addElement(new ControlSlider(), "Beta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Panel3D").setProperty("variable", "beta").setProperty("value", "0.5035973023704439").setProperty("minimum", "%_model._method_for_Beta_minimum()%").setProperty("maximum", "pi").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Beta.tooltip", "Point of view")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Dumbbell")).setProperty("visible", "true");
        this.getElement("Right").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Omega").setProperty("format", this._simulation.translateString("View.Omega.format", "$\\omega$ = 0.##")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.Omega.tooltip", "Angular velocity"));
        this.getElement("Theta").setProperty("format", this._simulation.translateString("View.Theta.format", "$\\theta$ = 0")).setProperty("tooltip", this._simulation.translateString("View.Theta.tooltip", "Angle between angular velocity and momentum"));
        this.getElement("trajectories").setProperty("text", this._simulation.translateString("View.trajectories.text", "Trajectories")).setProperty("mnemonic", this._simulation.translateString("View.trajectories.mnemonic", "t")).setProperty("tooltip", this._simulation.translateString("View.trajectories.tooltip", "Display the trajectories of both masses"));
        this.getElement("vectors").setProperty("text", this._simulation.translateString("View.vectors.text", "Vectors:")).setProperty("mnemonic", this._simulation.translateString("View.vectors.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.vectors.tooltip", "Show angular velocity and momentum, as well as the torque"));
        this.getElement("OmegaLabel").setProperty("text", this._simulation.translateString("View.OmegaLabel.text", "Angular velocity")).setProperty("alignment", "CENTER").setProperty("foreground", "blue");
        this.getElement("L").setProperty("text", this._simulation.translateString("View.L.text", "Angular momentum")).setProperty("alignment", "CENTER").setProperty("foreground", "0,128,0,255");
        this.getElement("Torque").setProperty("text", this._simulation.translateString("View.Torque.text", "Torque")).setProperty("alignment", "CENTER").setProperty("foreground", "red");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("Panel3D");
        this.getElement("D3").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("autoscaleZ", "false").setProperty("minimumX", "-.75").setProperty("maximumX", ".75").setProperty("minimumY", "-.75").setProperty("maximumY", ".75").setProperty("minimumZ", "-.75").setProperty("maximumZ", ".75").setProperty("displayMode", "PERSPECTIVE").setProperty("square", "true").setProperty("hideLines", "true").setProperty("panx", "0.75").setProperty("pany", "0.75").setProperty("decoration", "AXES");
        this.getElement("Bomega").setProperty("x", "0").setProperty("y", "0").setProperty("z", ".6").setProperty("sizex", "0").setProperty("sizey", "0").setProperty("sizez", ".5").setProperty("enabled", "true").setProperty("style", "ARROW").setProperty("color", "blue").setProperty("secondaryColor", "blue").setProperty("stroke", "3");
        this.getElement("BL").setProperty("x", "0").setProperty("y", "0").setProperty("z", "0").setProperty("enabled", "true").setProperty("style", "ARROW").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3");
        this.getElement("BN").setProperty("x", "0").setProperty("y", "0").setProperty("z", "0").setProperty("sizez", "0").setProperty("enabled", "true").setProperty("style", "ARROW").setProperty("color", "red").setProperty("secondaryColor", "red").setProperty("stroke", "3");
        this.getElement("Rod").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "gray").setProperty("secondaryColor", "gray").setProperty("stroke", "5");
        this.getElement("Axis").setProperty("x", "0").setProperty("y", "0").setProperty("z", "-.5").setProperty("sizex", "0").setProperty("sizey", "0").setProperty("sizez", "1").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("stroke", "5");
        this.getElement("m1").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("sizez", ".2").setProperty("secondaryColor", "gray").setProperty("color", "lightGray");
        this.getElement("m2").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("sizez", ".2").setProperty("enabled", "false").setProperty("secondaryColor", "gray").setProperty("color", "lightGray");
        this.getElement("i1").setProperty("points", "100").setProperty("variable", "s").setProperty("functionx", "rho*cos(s)").setProperty("functiony", "rho*sin(s)").setProperty("javaSyntax", "false").setProperty("color", "magenta").setProperty("enabled", "false");
        this.getElement("i2").setProperty("points", "100").setProperty("variable", "s").setProperty("functionx", "rho*cos(s)").setProperty("functiony", "rho*sin(s)").setProperty("functionz", "-z").setProperty("javaSyntax", "false").setProperty("color", "magenta").setProperty("enabled", "false");
        this.getElement("Alpha").setProperty("value", "0.46790880982566385").setProperty("tooltip", this._simulation.translateString("View.Alpha.tooltip", "Point of view"));
        this.getElement("Beta").setProperty("value", "0.5035973023704439").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Beta.tooltip", "Point of view"));
        super.reset();
    }
}

