/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.dumbbell;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.dumbbell.dumbbellSimulation;
import users.ehu.jma.rigid_bodies.dumbbell.dumbbellView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dumbbell
extends AbstractModel {
    public dumbbellSimulation _simulation = null;
    public dumbbellView _view = null;
    public dumbbell _model = this;
    public double th = 0.0;
    public double ph = 0.0;
    public double om = 1.0;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double cs = 0.0;
    public double sn = 0.0;
    public double theta = 45.0;
    public double dt = 0.01;
    public double pi = Math.PI;
    public double pi2 = 2.0 * this.pi;
    public double alpha = 0.14790880982566373;
    public double beta = 0.28359730237044367;
    public double rho = 0.0;
    public boolean vectors;
    public boolean trajectories;
    public double r = 0.1;
    public double xh = 0.0;
    public double yh = 0.0;
    public double zh = 0.0;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/dumbbell.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        dumbbell dumbbell2 = new dumbbell(stringArray);
    }

    public dumbbell() {
        this(null, null, null, null, null, false);
    }

    public dumbbell(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public dumbbell(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new dumbbellSimulation(this, string, frame, uRL, bl);
        this._view = (dumbbellView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _evolution1() {
        this.ph += this.om * this.dt;
    }

    public void _constraints1() {
        this.th = this.theta * Math.PI / 180.0;
        this.rho = Math.sin(this.th);
        this.z = Math.cos(this.th);
        this.cs = Math.cos(this.ph);
        this.sn = Math.sin(this.ph);
        this.x = this.rho * this.cs;
        this.y = this.rho * this.sn;
        this.xh = (1.0 - this.r) * this.x;
        this.yh = (1.0 - this.r) * this.y;
        this.zh = (1.0 - this.r) * this.z;
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_D3_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_D3_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public double _method_for_BL_sizex() {
        return -this.z * this.x;
    }

    public double _method_for_BL_sizey() {
        return -this.z * this.y;
    }

    public double _method_for_BL_sizez() {
        return this.rho * this.rho;
    }

    public double _method_for_BN_sizex() {
        return this.z * this.y;
    }

    public double _method_for_BN_sizey() {
        return -this.z * this.x;
    }

    public double _method_for_Rod_x() {
        return -this.xh;
    }

    public double _method_for_Rod_y() {
        return -this.yh;
    }

    public double _method_for_Rod_z() {
        return -this.zh;
    }

    public double _method_for_Rod_sizex() {
        return 2.0 * this.xh;
    }

    public double _method_for_Rod_sizey() {
        return 2.0 * this.yh;
    }

    public double _method_for_Rod_sizez() {
        return 2.0 * this.zh;
    }

    public double _method_for_m2_x() {
        return -this.x;
    }

    public double _method_for_m2_y() {
        return -this.y;
    }

    public double _method_for_m2_z() {
        return -this.z;
    }

    public double _method_for_i1_min() {
        return -this.pi;
    }

    public double _method_for_i2_min() {
        return -this.pi;
    }

    public double _method_for_Alpha_minimum() {
        return -this.pi;
    }

    public double _method_for_Beta_minimum() {
        return -this.pi;
    }

    @Override
    public synchronized void reset() {
        this.th = 0.0;
        this.ph = 0.0;
        this.om = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.cs = 0.0;
        this.sn = 0.0;
        this.theta = 45.0;
        this.dt = 0.01;
        this.pi = Math.PI;
        this.pi2 = 2.0 * this.pi;
        this.alpha = 0.14790880982566373;
        this.beta = 0.28359730237044367;
        this.rho = 0.0;
        this.r = 0.1;
        this.xh = 0.0;
        this.yh = 0.0;
        this.zh = 0.0;
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

