/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.coin;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.coin.coinSimulation;
import users.ehu.jma.rigid_bodies.coin.coinView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class coin
extends AbstractModel {
    public coinSimulation _simulation = null;
    public coinView _view = null;
    public coin _model = this;
    public double t = 0.0;
    public double x = 2.5;
    public double R;
    public double y = this.R = 1.0;
    public double x0 = -2.0;
    public double x1 = 0.0;
    public double v = 0.0;
    public double v0 = -0.1;
    public double v1 = 0.0;
    public double omega = 0.0;
    public double omega0 = 3.0;
    public double omega1 = 0.0;
    public double D = 2.0 * this.R;
    public double mu = 0.2;
    public double t1 = 0.0;
    public int maxPoints = 32;
    public int nPoints = 8;
    public double phi = 0.0;
    public double phi1 = 0.0;
    public double[] xp;
    public double[] yp;
    public double[] up;
    public double[] vp;
    public double scaleV = 0.3;
    public double dt = 0.02;
    public double xmin = -4.0;
    public double xmax = 4.0;
    public double depth = 0.2;
    public double ymax = 2.5;
    public boolean showV;
    public boolean graphics;
    public double PI2 = Math.PI * 2;
    public boolean setInitial = false;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/coin.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        coin coin2 = new coin(stringArray);
    }

    public coin() {
        this(null, null, null, null, null, false);
    }

    public coin(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public coin(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new coinSimulation(this, string, frame, uRL, bl);
        this._view = (coinView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.x = this.x0;
        this._view.resetTraces();
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        this.y = this.R;
    }

    public void _constraints2() {
        this.omega1 = this.omega0 / 3.0;
        this.v1 = this.omega1 * this.R;
        this.t1 = this.v1 / this.mu;
        this.x1 = this.x0 + 0.5 * this.mu * this.t1 * this.t1;
        this.phi1 = this.omega0 * this.t1 - this.mu * this.t1 * this.t1 / this.R;
        this.omega = this.t >= this.t1 ? this.omega1 : this.omega0 - 2.0 * this.mu * this.t / this.R;
        double d = this.v = this.t >= this.t1 ? this.v1 : this.mu * this.t;
        if (!this.setInitial) {
            this.x = this.t >= this.t1 ? this.x1 + this.v1 * (this.t - this.t1) : this.x0 + 0.5 * this.mu * this.t * this.t;
        }
        double d2 = this.phi = this.t >= this.t1 ? this.phi1 + this.omega1 * (this.t - this.t1) : this.omega0 * this.t - this.mu * this.t * this.t / this.R;
        if (this.nPoints == 0) {
            this.xp[0] = this.x + this.R * Math.sin(this.phi);
            this.yp[0] = this.y + this.R * Math.cos(this.phi);
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                double d3 = this.phi + this.PI2 / (double)this.nPoints * (double)i;
                this.xp[i] = this.x + this.R * Math.sin(d3);
                this.yp[i] = this.y + this.R * Math.cos(d3);
                this.up[i] = this.v + this.R * this.omega * Math.cos(d3);
                this.vp[i] = -this.R * this.omega * Math.sin(d3);
            }
        }
    }

    public void _constraints3() {
        if (this.x > 1.5 * this.xmax || this.x < 1.5 * this.xmin) {
            this._pause();
        }
    }

    public double _method_for_Space_minimumY() {
        return -this.depth;
    }

    public void _method_for_Space_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Floor_x() {
        return 2.0 * this.xmin;
    }

    public double _method_for_Floor_y() {
        return -this.depth;
    }

    public double _method_for_Floor_sizex() {
        return 2.0 * (this.xmax - this.xmin);
    }

    public boolean _method_for_Coin_enabled() {
        return this._isPaused();
    }

    public void _method_for_Coin_pressaction() {
        this._simulation.disableLoop();
        this.setInitial = true;
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_Coin_dragaction() {
        this._simulation.disableLoop();
        this.x0 = this.x;
        this._simulation.enableLoop();
    }

    public void _method_for_Coin_action() {
        this._simulation.disableLoop();
        this.setInitial = false;
        this._simulation.enableLoop();
    }

    public double _method_for_Coin_angle() {
        return -this.phi;
    }

    public boolean _method_for_VField_visible() {
        return this.nPoints > 0 && this.t > 0.0;
    }

    public boolean _method_for_Sliding_visible() {
        return this.t > 0.0 && this.t < this.t1;
    }

    public boolean _method_for_Omega_editable() {
        return this._isPaused();
    }

    public void _method_for_Omega_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Mu_editable() {
        return this._isPaused();
    }

    public void _method_for_Mu_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_nPoints_editable() {
        return this._isPaused();
    }

    public void _method_for_nPoints_action() {
        this._simulation.disableLoop();
        if (this.nPoints < 0) {
            this.nPoints = 0;
        } else if (this.nPoints > this.maxPoints) {
            this.nPoints = this.maxPoints;
        }
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_vContact_y() {
        return this.v - this.omega * this.R;
    }

    public double _method_for_OmegaR_y() {
        return this.omega * this.R;
    }

    public void _method_for_Erase_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.x = 2.5;
        this.y = this.R = 1.0;
        this.x0 = -2.0;
        this.x1 = 0.0;
        this.v = 0.0;
        this.v0 = -0.1;
        this.v1 = 0.0;
        this.omega = 0.0;
        this.omega0 = 3.0;
        this.omega1 = 0.0;
        this.D = 2.0 * this.R;
        this.mu = 0.2;
        this.t1 = 0.0;
        this.maxPoints = 32;
        this.nPoints = 8;
        this.phi = 0.0;
        this.phi1 = 0.0;
        this.xp = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.xp[n] = 0.0;
        }
        this.yp = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.yp[n] = 0.0;
        }
        this.up = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.up[n] = 0.0;
        }
        this.vp = new double[this.maxPoints];
        for (n = 0; n < this.maxPoints; ++n) {
            this.vp[n] = 0.0;
        }
        this.scaleV = 0.3;
        this.dt = 0.02;
        this.xmin = -4.0;
        this.xmax = 4.0;
        this.depth = 0.2;
        this.ymax = 2.5;
        this.PI2 = Math.PI * 2;
        this.setInitial = false;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        this.xp = null;
        this.yp = null;
        this.up = null;
        this.vp = null;
        System.gc();
    }
}

