/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.Lagrange;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlCone;
import org.colos.ejs.library.control.displayejs.ControlCylinder;
import org.colos.ejs.library.control.displayejs.ControlDrawingPanel3D;
import org.colos.ejs.library.control.displayejs.ControlImage;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractiveCone;
import org.opensourcephysics.displayejs.InteractiveCylinder;
import org.opensourcephysics.displayejs.InteractiveImage;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.rigid_bodies.Lagrange.Lagrange;
import users.ehu.jma.rigid_bodies.Lagrange.LagrangeSimulation;

class LagrangeView
extends EjsControl
implements View {
    private LagrangeSimulation _simulation = null;
    private Lagrange _model = null;
    public Component Main;
    public JPanel Graphics;
    public JSlider Alpha;
    public JSlider Beta;
    public DrawingPanel3D Panel3D;
    public InteractiveCone Fixed;
    public InteractiveCone Cone;
    public InteractiveCylinder Body;
    public InteractiveTrace Orbit;
    public JPanel Values;
    public JTextField dt;
    public JTextField N;
    public JCheckBox ShowBody;
    public JCheckBox ShowEuler;
    public JCheckBox ShowVelocities;
    public JLabel Initial;
    public JTextField Theta;
    public JTextField PhiD;
    public JTextField ThetaD;
    public JTextField PsiD;
    public JPanel Bottom;
    public JPanel Buttons;
    public JButton startButton;
    public JButton continueButton;
    public JButton stepButton;
    public JButton resetButton;
    public JPanel sliderPanel;
    public JSlider Izx;
    public JTextField IzxField;
    public JLabel IzxLabel;
    public JDialog Angles;
    public DrawingPanel2D Definition;
    public InteractiveImage Euler;
    public JDialog Velocities;
    public PlottingPanel2D Graph;
    public InteractiveTrace Precession;
    public InteractiveTrace Nutation;
    public InteractiveTrace Spin;
    public JPanel Text;
    public JLabel lPrecession;
    public JLabel lNutation;
    public JLabel lSpin;

    public LagrangeView(LagrangeSimulation lagrangeSimulation, String string, Frame frame) {
        super(lagrangeSimulation, string, frame);
        this._simulation = lagrangeSimulation;
        this._model = (Lagrange)lagrangeSimulation.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("h", "apply(\"h\")");
        this.addListener("r", "apply(\"r\")");
        this.addListener("Ix", "apply(\"Ix\")");
        this.addListener("Izx", "apply(\"Izx\")");
        this.addListener("R", "apply(\"R\")");
        this.addListener("g", "apply(\"g\")");
        this.addListener("cx", "apply(\"cx\")");
        this.addListener("cy", "apply(\"cy\")");
        this.addListener("cz", "apply(\"cz\")");
        this.addListener("axes", "apply(\"axes\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("theta", "apply(\"theta\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("psi", "apply(\"psi\")");
        this.addListener("thetaDegrees", "apply(\"thetaDegrees\")");
        this.addListener("thetad", "apply(\"thetad\")");
        this.addListener("phid", "apply(\"phid\")");
        this.addListener("psid", "apply(\"psid\")");
        this.addListener("ptheta", "apply(\"ptheta\")");
        this.addListener("pphi", "apply(\"pphi\")");
        this.addListener("ppsi", "apply(\"ppsi\")");
        this.addListener("vp", "apply(\"vp\")");
        this.addListener("vn", "apply(\"vn\")");
        this.addListener("vs", "apply(\"vs\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("alpha", "apply(\"alpha\")");
        this.addListener("beta", "apply(\"beta\")");
        this.addListener("N", "apply(\"N\")");
        this.addListener("showBody", "apply(\"showBody\")");
        this.addListener("showEuler", "apply(\"showEuler\")");
        this.addListener("showVelocities", "apply(\"showVelocities\")");
        this.addListener("Nvel", "apply(\"Nvel\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("h".equals(string)) {
            this._model.h = this.getDouble("h");
        }
        if ("r".equals(string)) {
            this._model.r = this.getDouble("r");
        }
        if ("Ix".equals(string)) {
            this._model.Ix = this.getDouble("Ix");
        }
        if ("Izx".equals(string)) {
            this._model.Izx = this.getDouble("Izx");
        }
        if ("R".equals(string)) {
            this._model.R = this.getDouble("R");
        }
        if ("g".equals(string)) {
            this._model.g = this.getDouble("g");
        }
        if ("cx".equals(string)) {
            this._model.cx = this.getDouble("cx");
        }
        if ("cy".equals(string)) {
            this._model.cy = this.getDouble("cy");
        }
        if ("cz".equals(string)) {
            this._model.cz = this.getDouble("cz");
        }
        if ("axes".equals(string)) {
            double[] dArray = (double[])this.getValue("axes").getObject();
            int n = dArray.length;
            if (n > this._model.axes.length) {
                n = this._model.axes.length;
            }
            for (int i = 0; i < n; ++i) {
                this._model.axes[i] = dArray[i];
            }
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("theta".equals(string)) {
            this._model.theta = this.getDouble("theta");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("psi".equals(string)) {
            this._model.psi = this.getDouble("psi");
        }
        if ("thetaDegrees".equals(string)) {
            this._model.thetaDegrees = this.getDouble("thetaDegrees");
        }
        if ("thetad".equals(string)) {
            this._model.thetad = this.getDouble("thetad");
        }
        if ("phid".equals(string)) {
            this._model.phid = this.getDouble("phid");
        }
        if ("psid".equals(string)) {
            this._model.psid = this.getDouble("psid");
        }
        if ("ptheta".equals(string)) {
            this._model.ptheta = this.getDouble("ptheta");
        }
        if ("pphi".equals(string)) {
            this._model.pphi = this.getDouble("pphi");
        }
        if ("ppsi".equals(string)) {
            this._model.ppsi = this.getDouble("ppsi");
        }
        if ("vp".equals(string)) {
            this._model.vp = this.getDouble("vp");
        }
        if ("vn".equals(string)) {
            this._model.vn = this.getDouble("vn");
        }
        if ("vs".equals(string)) {
            this._model.vs = this.getDouble("vs");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("alpha".equals(string)) {
            this._model.alpha = this.getDouble("alpha");
        }
        if ("beta".equals(string)) {
            this._model.beta = this.getDouble("beta");
        }
        if ("N".equals(string)) {
            this._model.N = this.getInt("N");
        }
        if ("showBody".equals(string)) {
            this._model.showBody = this.getBoolean("showBody");
        }
        if ("showEuler".equals(string)) {
            this._model.showEuler = this.getBoolean("showEuler");
        }
        if ("showVelocities".equals(string)) {
            this._model.showVelocities = this.getBoolean("showVelocities");
        }
        if ("Nvel".equals(string)) {
            this._model.Nvel = this.getInt("Nvel");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("h", this._model.h);
        this.setValue("r", this._model.r);
        this.setValue("Ix", this._model.Ix);
        this.setValue("Izx", this._model.Izx);
        this.setValue("R", this._model.R);
        this.setValue("g", this._model.g);
        this.setValue("cx", this._model.cx);
        this.setValue("cy", this._model.cy);
        this.setValue("cz", this._model.cz);
        this.setValue("axes", this._model.axes);
        this.setValue("t", this._model.t);
        this.setValue("theta", this._model.theta);
        this.setValue("phi", this._model.phi);
        this.setValue("psi", this._model.psi);
        this.setValue("thetaDegrees", this._model.thetaDegrees);
        this.setValue("thetad", this._model.thetad);
        this.setValue("phid", this._model.phid);
        this.setValue("psid", this._model.psid);
        this.setValue("ptheta", this._model.ptheta);
        this.setValue("pphi", this._model.pphi);
        this.setValue("ppsi", this._model.ppsi);
        this.setValue("vp", this._model.vp);
        this.setValue("vn", this._model.vn);
        this.setValue("vs", this._model.vs);
        this.setValue("dt", this._model.dt);
        this.setValue("alpha", this._model.alpha);
        this.setValue("beta", this._model.beta);
        this.setValue("N", this._model.N);
        this.setValue("showBody", this._model.showBody);
        this.setValue("showEuler", this._model.showEuler);
        this.setValue("showVelocities", this._model.showVelocities);
        this.setValue("Nvel", this._model.Nvel);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Lagrange top")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "535,476")).getObject();
        this.Graphics = (JPanel)this.addElement(new ControlPanel(), "Graphics").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Alpha = (JSlider)this.addElement(new ControlSlider(), "Alpha").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Graphics").setProperty("variable", "alpha").setProperty("minimum", "%_model._method_for_Alpha_minimum()%").setProperty("maximum", "%_model._method_for_Alpha_maximum()%").setProperty("tooltip", this._simulation.translateString("View.Alpha.tooltip", "Orientation")).getObject();
        this.Beta = (JSlider)this.addElement(new ControlSlider(), "Beta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Graphics").setProperty("variable", "beta").setProperty("minimum", "%_model._method_for_Beta_minimum()%").setProperty("maximum", "%_model._method_for_Beta_maximum()%").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Beta.tooltip", "Orientation")).getObject();
        this.Panel3D = (DrawingPanel3D)this.addElement(new ControlDrawingPanel3D(), "Panel3D").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Graphics").setProperty("minimumX", "-1.1").setProperty("maximumX", "1.1").setProperty("minimumY", "-1.1").setProperty("maximumY", "1.1").setProperty("minimumZ", "-.1").setProperty("maximumZ", "2.1").setProperty("alpha", "alpha").setProperty("beta", "beta").setProperty("pressaction", "_model._method_for_Panel3D_pressaction()").setProperty("decoration", "AXES").setProperty("tooltip", this._simulation.translateString("View.Panel3D.tooltip", "Click to erase")).getObject();
        this.Fixed = (InteractiveCone)this.addElement(new ControlCone(), "Fixed").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Panel3D").setProperty("x", "0").setProperty("y", "0").setProperty("z", "-.3").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("sizez", ".3").setProperty("visible", "showBody").setProperty("enabled", "false").setProperty("secondaryColor", "gray").setProperty("color", "lightGray").getObject();
        this.Cone = (InteractiveCone)this.addElement(new ControlCone(), "Cone").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Panel3D").setProperty("x", "%_model._method_for_Cone_x()%").setProperty("y", "%_model._method_for_Cone_y()%").setProperty("z", "%_model._method_for_Cone_z()%").setProperty("sizex", ".1").setProperty("sizey", ".1").setProperty("sizez", "%_model._method_for_Cone_sizez()%").setProperty("enabled", "false").setProperty("axes", "axes").setProperty("secondaryColor", "gray").setProperty("color", "lightGray").getObject();
        this.Body = (InteractiveCylinder)this.addElement(new ControlCylinder(), "Body").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Panel3D").setProperty("x", "%_model._method_for_Body_x()%").setProperty("y", "%_model._method_for_Body_y()%").setProperty("z", "%_model._method_for_Body_z()%").setProperty("sizex", "r").setProperty("sizey", "r").setProperty("sizez", "h").setProperty("visible", "showBody").setProperty("enabled", "false").setProperty("axes", "axes").setProperty("secondaryColor", "gray").setProperty("color", "lightGray").getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Panel3D").setProperty("x", "%_model._method_for_Orbit_x()%").setProperty("y", "%_model._method_for_Orbit_y()%").setProperty("z", "%_model._method_for_Orbit_z()%").setProperty("maxpoints", "N").setProperty("active", "%_model._method_for_Orbit_active()%").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "red").getObject();
        this.Values = (JPanel)this.addElement(new ControlPanel(), "Values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:10,1,0,0").setProperty("size", this._simulation.translateString("View.Values.size", "120,0")).setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation step")).getObject();
        this.N = (JTextField)this.addElement(new ControlNumberField(), "N").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "N").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("action", "_model._method_for_N_action()").setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of orbit points")).getObject();
        this.ShowBody = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowBody").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "showBody").setProperty("text", this._simulation.translateString("View.ShowBody.text", "Body?")).setProperty("mnemonic", this._simulation.translateString("View.ShowBody.mnemonic", "b")).setProperty("tooltip", this._simulation.translateString("View.ShowBody.tooltip", "Show body (or only the axis)?")).getObject();
        this.ShowEuler = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowEuler").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "showEuler").setProperty("text", this._simulation.translateString("View.ShowEuler.text", "Euler angles")).setProperty("mnemonic", this._simulation.translateString("View.ShowEuler.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.ShowEuler.tooltip", "Show the definitions of Euler angles?")).getObject();
        this.ShowVelocities = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowVelocities").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "showVelocities").setProperty("text", this._simulation.translateString("View.ShowVelocities.text", "Velocities")).setProperty("mnemonic", this._simulation.translateString("View.ShowVelocities.mnemonic", "e")).setProperty("action", "_model._method_for_ShowVelocities_action()").setProperty("tooltip", this._simulation.translateString("View.ShowVelocities.tooltip", "Show precession, nutation and spin?")).getObject();
        this.Initial = (JLabel)this.addElement(new ControlLabel(), "Initial").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("text", this._simulation.translateString("View.Initial.text", "Initial values")).setProperty("alignment", "CENTER").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Initial.tooltip", "Choose below the initial conditions")).getObject();
        this.Theta = (JTextField)this.addElement(new ControlNumberField(), "Theta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "thetaDegrees").setProperty("format", this._simulation.translateString("View.Theta.format", "$\\theta$ = 0.##")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_Theta_action()").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Theta.tooltip", "Euler angle theta")).getObject();
        this.PhiD = (JTextField)this.addElement(new ControlNumberField(), "PhiD").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "phid").setProperty("format", this._simulation.translateString("View.PhiD.format", "d$\\phi$ / dt = 0.##")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_PhiD_action()").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.PhiD.tooltip", "Derivative of Euler angle phi (precession)")).getObject();
        this.ThetaD = (JTextField)this.addElement(new ControlNumberField(), "ThetaD").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "thetad").setProperty("format", this._simulation.translateString("View.ThetaD.format", "d$\\theta$ / dt = 0.##")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_ThetaD_action()").setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.ThetaD.tooltip", "Derivative of Euler angle theta (nutation)")).getObject();
        this.PsiD = (JTextField)this.addElement(new ControlNumberField(), "PsiD").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "psid").setProperty("format", this._simulation.translateString("View.PsiD.format", "d$\\psi$ / dt = 0.##")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_PsiD_action()").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.PsiD.tooltip", "Derivative of Euler angle psi (spin)")).getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "BORDER:5,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Bottom").setProperty("layout", "GRID:1,4,0,0").setProperty("border", "1,1,1,1").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simulation")).getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.sliderPanel = (JPanel)this.addElement(new ControlPanel(), "sliderPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "border").getObject();
        this.Izx = (JSlider)this.addElement(new ControlSlider(), "Izx").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "sliderPanel").setProperty("variable", "Izx").setProperty("value", "0.49995999999999996").setProperty("minimum", "0.1").setProperty("maximum", "1.2").setProperty("closest", "true").setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_Izx_action()").setProperty("tooltip", this._simulation.translateString("View.Izx.tooltip", "Iz/Ix")).getObject();
        this.IzxField = (JTextField)this.addElement(new ControlParsedNumberField(), "IzxField").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "sliderPanel").setProperty("variable", "Izx").setProperty("format", this._simulation.translateString("View.IzxField.format", "0.##")).setProperty("size", this._simulation.translateString("View.IzxField.size", "40,15")).getObject();
        this.IzxLabel = (JLabel)this.addElement(new ControlLabel(), "IzxLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "sliderPanel").setProperty("text", this._simulation.translateString("View.IzxLabel.text", "  Iz / Ix = ")).getObject();
        this.Angles = (JDialog)this.addElement(new ControlDialog(), "Angles").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Angles.title", "Euler angles")).setProperty("layout", "border").setProperty("visible", "showEuler").setProperty("location", "530,2").setProperty("size", this._simulation.translateString("View.Angles.size", "398,398")).setProperty("resizable", "true").getObject();
        this.Definition = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Definition").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Angles").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("maximumX", "1.0").setProperty("minimumY", "0").setProperty("maximumY", "1.0").setProperty("square", "false").setProperty("size", this._simulation.translateString("View.Definition.size", "386,336")).setProperty("tooltip", this._simulation.translateString("View.Definition.tooltip", "Definition of Euler angles")).getObject();
        this.Euler = (InteractiveImage)this.addElement(new ControlImage(), "Euler").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Definition").setProperty("x", ".5").setProperty("y", ".5").setProperty("trueSize", "true").setProperty("sizex", "1").setProperty("sizey", "1").setProperty("scalex", "1").setProperty("scaley", "1").setProperty("enabled", "false").setProperty("image", this._simulation.translateString("View.Euler.image", "./euler.gif")).setProperty("elementposition", "CENTERED").getObject();
        this.Velocities = (JDialog)this.addElement(new ControlDialog(), "Velocities").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Velocities.title", "Velocities")).setProperty("layout", "border").setProperty("visible", "showVelocities").setProperty("location", "540,3").setProperty("size", this._simulation.translateString("View.Velocities.size", "500,300")).getObject();
        this.Graph = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Graph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Velocities").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("yMarginPercentage", "10").setProperty("pressaction", "_model._method_for_Graph_pressaction()").setProperty("titleX", this._simulation.translateString("View.Graph.titleX", "t")).setProperty("xFormat", this._simulation.translateString("View.Graph.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Graph.yFormat", "$\\omega$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Graph.tooltip", "Click to erase")).getObject();
        this.Precession = (InteractiveTrace)this.addElement(new ControlTrace(), "Precession").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("x", "t").setProperty("y", "vp").setProperty("maxpoints", "Nvel").setProperty("active", "showVelocities").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").getObject();
        this.Nutation = (InteractiveTrace)this.addElement(new ControlTrace(), "Nutation").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("x", "t").setProperty("y", "vn").setProperty("maxpoints", "Nvel").setProperty("active", "showVelocities").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "0,128,0,255").getObject();
        this.Spin = (InteractiveTrace)this.addElement(new ControlTrace(), "Spin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("x", "t").setProperty("y", "vs").setProperty("maxpoints", "Nvel").setProperty("active", "showVelocities").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").getObject();
        this.Text = (JPanel)this.addElement(new ControlPanel(), "Text").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Velocities").setProperty("layout", "grid:1,4,0,0").setProperty("border", "0,2,0,2").getObject();
        this.lPrecession = (JLabel)this.addElement(new ControlLabel(), "lPrecession").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Text").setProperty("text", this._simulation.translateString("View.lPrecession.text", "Precession (d $\\phi$ / dt)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red").getObject();
        this.lNutation = (JLabel)this.addElement(new ControlLabel(), "lNutation").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Text").setProperty("text", this._simulation.translateString("View.lNutation.text", "Nutation (d $\\theta$ / dt)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "0,128,0,255").getObject();
        this.lSpin = (JLabel)this.addElement(new ControlLabel(), "lSpin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Text").setProperty("text", this._simulation.translateString("View.lSpin.text", "Spin (d $\\psi$ / dt)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Lagrange top")).setProperty("visible", "true");
        this.getElement("Graphics");
        this.getElement("Alpha").setProperty("tooltip", this._simulation.translateString("View.Alpha.tooltip", "Orientation"));
        this.getElement("Beta").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Beta.tooltip", "Orientation"));
        this.getElement("Panel3D").setProperty("minimumX", "-1.1").setProperty("maximumX", "1.1").setProperty("minimumY", "-1.1").setProperty("maximumY", "1.1").setProperty("minimumZ", "-.1").setProperty("maximumZ", "2.1").setProperty("decoration", "AXES").setProperty("tooltip", this._simulation.translateString("View.Panel3D.tooltip", "Click to erase"));
        this.getElement("Fixed").setProperty("x", "0").setProperty("y", "0").setProperty("z", "-.3").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("sizez", ".3").setProperty("enabled", "false").setProperty("secondaryColor", "gray").setProperty("color", "lightGray");
        this.getElement("Cone").setProperty("sizex", ".1").setProperty("sizey", ".1").setProperty("enabled", "false").setProperty("secondaryColor", "gray").setProperty("color", "lightGray");
        this.getElement("Body").setProperty("enabled", "false").setProperty("secondaryColor", "gray").setProperty("color", "lightGray");
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "red");
        this.getElement("Values").setProperty("size", this._simulation.translateString("View.Values.size", "120,0")).setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Animation step"));
        this.getElement("N").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of orbit points"));
        this.getElement("ShowBody").setProperty("text", this._simulation.translateString("View.ShowBody.text", "Body?")).setProperty("mnemonic", this._simulation.translateString("View.ShowBody.mnemonic", "b")).setProperty("tooltip", this._simulation.translateString("View.ShowBody.tooltip", "Show body (or only the axis)?"));
        this.getElement("ShowEuler").setProperty("text", this._simulation.translateString("View.ShowEuler.text", "Euler angles")).setProperty("mnemonic", this._simulation.translateString("View.ShowEuler.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.ShowEuler.tooltip", "Show the definitions of Euler angles?"));
        this.getElement("ShowVelocities").setProperty("text", this._simulation.translateString("View.ShowVelocities.text", "Velocities")).setProperty("mnemonic", this._simulation.translateString("View.ShowVelocities.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.ShowVelocities.tooltip", "Show precession, nutation and spin?"));
        this.getElement("Initial").setProperty("text", this._simulation.translateString("View.Initial.text", "Initial values")).setProperty("alignment", "CENTER").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Initial.tooltip", "Choose below the initial conditions"));
        this.getElement("Theta").setProperty("format", this._simulation.translateString("View.Theta.format", "$\\theta$ = 0.##")).setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Theta.tooltip", "Euler angle theta"));
        this.getElement("PhiD").setProperty("format", this._simulation.translateString("View.PhiD.format", "d$\\phi$ / dt = 0.##")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.PhiD.tooltip", "Derivative of Euler angle phi (precession)"));
        this.getElement("ThetaD").setProperty("format", this._simulation.translateString("View.ThetaD.format", "d$\\theta$ / dt = 0.##")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.ThetaD.tooltip", "Derivative of Euler angle theta (nutation)"));
        this.getElement("PsiD").setProperty("format", this._simulation.translateString("View.PsiD.format", "d$\\psi$ / dt = 0.##")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.PsiD.tooltip", "Derivative of Euler angle psi (spin)"));
        this.getElement("Bottom").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Buttons").setProperty("border", "1,1,1,1");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simulation"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("sliderPanel");
        this.getElement("Izx").setProperty("value", "0.49995999999999996").setProperty("minimum", "0.1").setProperty("maximum", "1.2").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Izx.tooltip", "Iz/Ix"));
        this.getElement("IzxField").setProperty("format", this._simulation.translateString("View.IzxField.format", "0.##")).setProperty("size", this._simulation.translateString("View.IzxField.size", "40,15"));
        this.getElement("IzxLabel").setProperty("text", this._simulation.translateString("View.IzxLabel.text", "  Iz / Ix = "));
        this.getElement("Angles").setProperty("title", this._simulation.translateString("View.Angles.title", "Euler angles")).setProperty("resizable", "true");
        this.getElement("Definition").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("maximumX", "1.0").setProperty("minimumY", "0").setProperty("maximumY", "1.0").setProperty("square", "false").setProperty("size", this._simulation.translateString("View.Definition.size", "386,336")).setProperty("tooltip", this._simulation.translateString("View.Definition.tooltip", "Definition of Euler angles"));
        this.getElement("Euler").setProperty("x", ".5").setProperty("y", ".5").setProperty("trueSize", "true").setProperty("sizex", "1").setProperty("sizey", "1").setProperty("scalex", "1").setProperty("scaley", "1").setProperty("enabled", "false").setProperty("image", this._simulation.translateString("View.Euler.image", "./euler.gif")).setProperty("elementposition", "CENTERED");
        this.getElement("Velocities").setProperty("title", this._simulation.translateString("View.Velocities.title", "Velocities"));
        this.getElement("Graph").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("yMarginPercentage", "10").setProperty("xFormat", this._simulation.translateString("View.Graph.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Graph.yFormat", "$\\omega$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Graph.tooltip", "Click to erase"));
        this.getElement("Precession").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("Nutation").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "0,128,0,255");
        this.getElement("Spin").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Text").setProperty("border", "0,2,0,2");
        this.getElement("lPrecession").setProperty("text", this._simulation.translateString("View.lPrecession.text", "Precession (d $\\phi$ / dt)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red");
        this.getElement("lNutation").setProperty("text", this._simulation.translateString("View.lNutation.text", "Nutation (d $\\theta$ / dt)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "0,128,0,255");
        this.getElement("lSpin").setProperty("text", this._simulation.translateString("View.lSpin.text", "Spin (d $\\psi$ / dt)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue");
        super.reset();
    }
}

