/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.Lagrange;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import org.colos.ejs.library.Simulation;
import users.ehu.jma.rigid_bodies.Lagrange.Lagrange;
import users.ehu.jma.rigid_bodies.Lagrange.LagrangeView;

class LagrangeSimulation
extends Simulation {
    public LagrangeSimulation(Lagrange lagrange, String string, Frame frame, URL uRL, boolean bl) {
        try {
            this.setUnderEjs("true".equals(System.getProperty("osp_ejs")));
        }
        catch (Exception exception) {
            this.setUnderEjs(false);
        }
        this.setCodebase(uRL);
        this.setModel(lagrange);
        lagrange._simulation = this;
        lagrange._view = new LagrangeView(this, string, frame);
        this.setView(lagrange._view);
        this.setFPS(25);
        this.setStepsPerDisplay(1);
        if (bl) {
            this.setAutoplay(false);
            this.reset();
        } else {
            this.reset();
            this.setAutoplay(false);
        }
    }

    public ArrayList getWindowsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Main");
        arrayList.add("Angles");
        arrayList.add("Velocities");
        return arrayList;
    }

    public String getMainWindow() {
        return "Main";
    }

    protected void setViewLocale() {
        this.getView().getElement("Main").setProperty("title", this.translateString("View.Main.title", "Lagrange top")).setProperty("size", this.translateString("View.Main.size", "535,476"));
        this.getView().getElement("Graphics");
        this.getView().getElement("Alpha").setProperty("tooltip", this.translateString("View.Alpha.tooltip", "Orientation"));
        this.getView().getElement("Beta").setProperty("tooltip", this.translateString("View.Beta.tooltip", "Orientation"));
        this.getView().getElement("Panel3D").setProperty("tooltip", this.translateString("View.Panel3D.tooltip", "Click to erase"));
        this.getView().getElement("Fixed");
        this.getView().getElement("Cone");
        this.getView().getElement("Body");
        this.getView().getElement("Orbit");
        this.getView().getElement("Values").setProperty("size", this.translateString("View.Values.size", "120,0"));
        this.getView().getElement("dt").setProperty("format", this.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this.translateString("View.dt.tooltip", "Animation step"));
        this.getView().getElement("N").setProperty("format", this.translateString("View.N.format", "N = 0")).setProperty("tooltip", this.translateString("View.N.tooltip", "Number of orbit points"));
        this.getView().getElement("ShowBody").setProperty("text", this.translateString("View.ShowBody.text", "Body?")).setProperty("mnemonic", this.translateString("View.ShowBody.mnemonic", "b")).setProperty("tooltip", this.translateString("View.ShowBody.tooltip", "Show body (or only the axis)?"));
        this.getView().getElement("ShowEuler").setProperty("text", this.translateString("View.ShowEuler.text", "Euler angles")).setProperty("mnemonic", this.translateString("View.ShowEuler.mnemonic", "v")).setProperty("tooltip", this.translateString("View.ShowEuler.tooltip", "Show the definitions of Euler angles?"));
        this.getView().getElement("ShowVelocities").setProperty("text", this.translateString("View.ShowVelocities.text", "Velocities")).setProperty("mnemonic", this.translateString("View.ShowVelocities.mnemonic", "e")).setProperty("tooltip", this.translateString("View.ShowVelocities.tooltip", "Show precession, nutation and spin?"));
        this.getView().getElement("Initial").setProperty("text", this.translateString("View.Initial.text", "Initial values")).setProperty("tooltip", this.translateString("View.Initial.tooltip", "Choose below the initial conditions"));
        this.getView().getElement("Theta").setProperty("format", this.translateString("View.Theta.format", "$\\theta$ = 0.##")).setProperty("tooltip", this.translateString("View.Theta.tooltip", "Euler angle theta"));
        this.getView().getElement("PhiD").setProperty("format", this.translateString("View.PhiD.format", "d$\\phi$ / dt = 0.##")).setProperty("tooltip", this.translateString("View.PhiD.tooltip", "Derivative of Euler angle phi (precession)"));
        this.getView().getElement("ThetaD").setProperty("format", this.translateString("View.ThetaD.format", "d$\\theta$ / dt = 0.##")).setProperty("tooltip", this.translateString("View.ThetaD.tooltip", "Derivative of Euler angle theta (nutation)"));
        this.getView().getElement("PsiD").setProperty("format", this.translateString("View.PsiD.format", "d$\\psi$ / dt = 0.##")).setProperty("tooltip", this.translateString("View.PsiD.tooltip", "Derivative of Euler angle psi (spin)"));
        this.getView().getElement("Bottom");
        this.getView().getElement("Buttons");
        this.getView().getElement("startButton").setProperty("tooltip", this.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this.translateString("View.startButton.mnemonicOff", "s"));
        this.getView().getElement("continueButton").setProperty("image", this.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this.translateString("View.continueButton.tooltip", "Continue previous simulation"));
        this.getView().getElement("stepButton").setProperty("image", this.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getView().getElement("resetButton").setProperty("image", this.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("tooltip", this.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getView().getElement("sliderPanel");
        this.getView().getElement("Izx").setProperty("tooltip", this.translateString("View.Izx.tooltip", "Iz/Ix"));
        this.getView().getElement("IzxField").setProperty("format", this.translateString("View.IzxField.format", "0.##")).setProperty("size", this.translateString("View.IzxField.size", "40,15"));
        this.getView().getElement("IzxLabel").setProperty("text", this.translateString("View.IzxLabel.text", "  Iz / Ix = "));
        this.getView().getElement("Angles").setProperty("title", this.translateString("View.Angles.title", "Euler angles")).setProperty("size", this.translateString("View.Angles.size", "398,398"));
        this.getView().getElement("Definition").setProperty("size", this.translateString("View.Definition.size", "386,336")).setProperty("tooltip", this.translateString("View.Definition.tooltip", "Definition of Euler angles"));
        this.getView().getElement("Euler").setProperty("image", this.translateString("View.Euler.image", "./euler.gif"));
        this.getView().getElement("Velocities").setProperty("title", this.translateString("View.Velocities.title", "Velocities")).setProperty("size", this.translateString("View.Velocities.size", "500,300"));
        this.getView().getElement("Graph").setProperty("xFormat", this.translateString("View.Graph.xFormat", "t = 0.###")).setProperty("yFormat", this.translateString("View.Graph.yFormat", "$\\omega$ = 0.###")).setProperty("tooltip", this.translateString("View.Graph.tooltip", "Click to erase"));
        this.getView().getElement("Precession");
        this.getView().getElement("Nutation");
        this.getView().getElement("Spin");
        this.getView().getElement("Text");
        this.getView().getElement("lPrecession").setProperty("text", this.translateString("View.lPrecession.text", "Precession (d $\\phi$ / dt)"));
        this.getView().getElement("lNutation").setProperty("text", this.translateString("View.lNutation.text", "Nutation (d $\\theta$ / dt)"));
        this.getView().getElement("lSpin").setProperty("text", this.translateString("View.lSpin.text", "Spin (d $\\psi$ / dt)"));
        super.setViewLocale();
    }
}

