/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.rigid_bodies.Lagrange;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.rigid_bodies.Lagrange.LagrangeSimulation;
import users.ehu.jma.rigid_bodies.Lagrange.LagrangeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lagrange
extends AbstractModel {
    public LagrangeSimulation _simulation = null;
    public LagrangeView _view = null;
    public Lagrange _model = this;
    public double h = 1.0;
    public double r = 0.0;
    public double Ix = 1.0;
    public double Izx = 0.49995999999999996;
    public double R = 1.0;
    public double g = 9.81;
    public double cx = 0.0;
    public double cy = 0.0;
    public double cz = 0.0;
    public double[] axes;
    public double t = 0.0;
    public double theta = 0.0;
    public double phi = 0.0;
    public double psi = 0.0;
    public double thetaDegrees = 60.0;
    public double thetad = 0.0;
    public double phid = 2.0;
    public double psid = 20.0;
    public double ptheta = 0.0;
    public double pphi = 0.0;
    public double ppsi = 0.0;
    public double vp = 0.0;
    public double vn = 0.0;
    public double vs = 0.0;
    public double dt = 0.01;
    public double alpha = 0.15;
    public double beta = 0.3;
    public int N = 1000;
    public boolean showBody = true;
    public boolean showEuler = false;
    public boolean showVelocities = false;
    public int Nvel = 100;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/rigid_bodies/Lagrange.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/rigid_bodies/euler.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/rigid_bodies/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Lagrange lagrange = new Lagrange(stringArray);
    }

    public Lagrange() {
        this(null, null, null, null, null, false);
    }

    public Lagrange(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Lagrange(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new LagrangeSimulation(this, string, frame, uRL, bl);
        this._view = (LagrangeView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.theta = Math.toRadians(this.thetaDegrees);
        this.psi = 0.0;
        this.phi = 0.0;
        double d = Math.cos(this.theta);
        double d2 = Math.sin(this.theta);
        this.ptheta = this.Ix * this.thetad;
        this.ppsi = this.Izx * this.Ix * (this.phid * d + this.psid);
        this.pphi = this.Ix * this.phid * d2 * d2 + this.ppsi * d;
        this._view.resetTraces();
    }

    public void _constraints1() {
        if (this.Izx < 0.1) {
            this.Izx = 0.1;
        } else if (this.Izx > 1.9) {
            this.Izx = 1.9;
        }
        this.r = Math.sqrt((this.h * this.h + 12.0 * this.R * this.R) / (6.0 / this.Izx - 3.0));
    }

    public void _constraints2() {
        double d = Math.cos(this.theta);
        double d2 = Math.sin(this.theta);
        double d3 = Math.cos(this.phi);
        double d4 = Math.sin(this.phi);
        double d5 = Math.cos(this.psi);
        double d6 = Math.sin(this.psi);
        this.axes[0] = d3 * d5 - d * d4 * d6;
        this.axes[1] = d5 * d4 + d3 * d * d6;
        this.axes[2] = d2 * d6;
        this.axes[3] = -(d * d5 * d4) - d3 * d6;
        this.axes[4] = d3 * d * d5 - d4 * d6;
        this.axes[5] = d5 * d2;
        this.cx = this.axes[6] = d4 * d2;
        this.cy = this.axes[7] = -(d3 * d2);
        this.cz = this.axes[8] = d;
        this.vn = this.ptheta / this.Ix / this.Izx;
        this.vp = (this.pphi - this.ppsi * d) / this.Ix / d2 / d2;
        this.vs = (this.ppsi / this.Izx + d * (d * this.ppsi - this.pphi) / d2 / d2) / this.Ix;
    }

    public double _method_for_Alpha_minimum() {
        return -Math.PI;
    }

    public double _method_for_Alpha_maximum() {
        return Math.PI;
    }

    public double _method_for_Beta_minimum() {
        return -Math.PI;
    }

    public double _method_for_Beta_maximum() {
        return Math.PI;
    }

    public void _method_for_Panel3D_pressaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_Cone_x() {
        return 2.0 * this.h * this.cx;
    }

    public double _method_for_Cone_y() {
        return 2.0 * this.h * this.cy;
    }

    public double _method_for_Cone_z() {
        return 2.0 * this.h * this.cz;
    }

    public double _method_for_Cone_sizez() {
        return -2.0 * this.h;
    }

    public double _method_for_Body_x() {
        return (this.R - 0.5 * this.h) * this.cx;
    }

    public double _method_for_Body_y() {
        return (this.R - 0.5 * this.h) * this.cy;
    }

    public double _method_for_Body_z() {
        return (this.R - 0.5 * this.h) * this.cz;
    }

    public double _method_for_Orbit_x() {
        return 2.0 * this.cx;
    }

    public double _method_for_Orbit_y() {
        return 2.0 * this.cy;
    }

    public double _method_for_Orbit_z() {
        return 2.0 * this.cz;
    }

    public boolean _method_for_Orbit_active() {
        return this.N > 0;
    }

    public void _method_for_N_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_ShowVelocities_action() {
        this._simulation.disableLoop();
        this._view.getElement("Precession").reset();
        this._view.getElement("Nutation").reset();
        this._view.getElement("Spin").reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Theta_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_PhiD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_ThetaD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_PsiD_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this.initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Izx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Graph_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("Precession").reset();
        this._view.getElement("Nutation").reset();
        this._view.getElement("Spin").reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.h = 1.0;
        this.r = 0.0;
        this.Ix = 1.0;
        this.Izx = 0.49995999999999996;
        this.R = 1.0;
        this.g = 9.81;
        this.cx = 0.0;
        this.cy = 0.0;
        this.cz = 0.0;
        this.axes = new double[9];
        for (int i = 0; i < 9; ++i) {
            this.axes[i] = 0.0;
        }
        this.t = 0.0;
        this.theta = 0.0;
        this.phi = 0.0;
        this.psi = 0.0;
        this.thetaDegrees = 60.0;
        this.thetad = 0.0;
        this.phid = 2.0;
        this.psid = 20.0;
        this.ptheta = 0.0;
        this.pphi = 0.0;
        this.ppsi = 0.0;
        this.vp = 0.0;
        this.vn = 0.0;
        this.vs = 0.0;
        this.dt = 0.01;
        this.alpha = 0.15;
        this.beta = 0.3;
        this.N = 1000;
        this.showBody = true;
        this.showEuler = false;
        this.showVelocities = false;
        this.Nvel = 100;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this.axes = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _theta;
        private double _phi;
        private double _psi;
        private double _ptheta;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Lagrange.this.theta;
            this.__state[n++] = Lagrange.this.phi;
            this.__state[n++] = Lagrange.this.psi;
            this.__state[n++] = Lagrange.this.ptheta;
            this.__state[n++] = Lagrange.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(Lagrange.this.dt);
        }

        void step() {
            if (Lagrange.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Lagrange.this.dt);
            }
            int n = 0;
            this.__state[n++] = Lagrange.this.theta;
            this.__state[n++] = Lagrange.this.phi;
            this.__state[n++] = Lagrange.this.psi;
            this.__state[n++] = Lagrange.this.ptheta;
            this.__state[n++] = Lagrange.this.t;
            this.__solver.step();
            n = 0;
            Lagrange.this.theta = this.__state[n++];
            Lagrange.this.phi = this.__state[n++];
            Lagrange.this.psi = this.__state[n++];
            Lagrange.this.ptheta = this.__state[n++];
            Lagrange.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._theta = dArray[n++];
            this._phi = dArray[n++];
            this._psi = dArray[n++];
            this._ptheta = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._theta, this._phi, this._psi, this._ptheta, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._theta, this._phi, this._psi, this._ptheta, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._theta, this._phi, this._psi, this._ptheta, this._t);
            dArray2[n++] = this._ODE_evolution1_4(this._theta, this._phi, this._psi, this._ptheta, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return d4 / Lagrange.this.Ix;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return (Lagrange.this.pphi - Lagrange.this.ppsi * Math.cos(d)) / Lagrange.this.Ix / Math.pow(Math.sin(d), 2.0);
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return Lagrange.this.ppsi / Lagrange.this.Izx / Lagrange.this.Ix + (Lagrange.this.ppsi * Math.cos(d) - Lagrange.this.pphi) * Math.cos(d) / Lagrange.this.Ix / Math.pow(Math.sin(d), 2.0);
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return Lagrange.this.g * Lagrange.this.R * Math.sin(d) - (Lagrange.this.pphi * Math.cos(d) - Lagrange.this.ppsi) * (Lagrange.this.ppsi * Math.cos(d) - Lagrange.this.pphi) / Lagrange.this.Ix / Math.pow(Math.sin(d), 3.0);
        }
    }
}

