/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.quartic;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlSpring;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.oscillations.quartic.quartic;
import users.ehu.jma.oscillations.quartic.quarticSimulation;

class quarticView
extends EjsControl
implements View {
    private quarticSimulation _simulation = null;
    private quartic _model = null;
    public Component Main;
    public JPanel PhaseSpace;
    public PlottingPanel2D Phase;
    public InteractiveTrace Orbit;
    public JPanel Middle;
    public DrawingPanel2D Table;
    public InteractiveParticle Wall1;
    public InteractiveParticle Wall2;
    public InteractiveSpring Spring1;
    public InteractiveSpring Spring2;
    public InteractiveParticle Rod;
    public InteractiveParticle Bead;
    public JPanel Down;
    public JPanel Buttons;
    public JPanel Values;
    public JTextField Length;
    public JTextField Step;
    public JPanel But;
    public JButton startButton;
    public JButton continueButton;
    public JButton resetButton;
    public JButton Clear;
    public JButton Equilibrium;

    public quarticView(quarticSimulation quarticSimulation2, String string, Frame frame) {
        super(quarticSimulation2, string, frame);
        this._simulation = quarticSimulation2;
        this._model = (quartic)quarticSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("q", "apply(\"q\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("L", "apply(\"L\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("npoints", "apply(\"npoints\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("q".equals(string)) {
            this._model.q = this.getDouble("q");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("L".equals(string)) {
            this._model.L = this.getDouble("L");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("npoints".equals(string)) {
            this._model.npoints = this.getInt("npoints");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("q", this._model.q);
        this.setValue("v", this._model.v);
        this.setValue("L", this._model.L);
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("dt", this._model.dt);
        this.setValue("npoints", this._model.npoints);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Quartic oscillator")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "628,300")).getObject();
        this.PhaseSpace = (JPanel)this.addElement(new ControlPanel(), "PhaseSpace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Phase = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Phase").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "PhaseSpace").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("xMarginPercentage", "10").setProperty("yMarginPercentage", "10").setProperty("title", this._simulation.translateString("View.Phase.title", "Phase-space")).setProperty("axesType", "Cartesian1").setProperty("titleX", this._simulation.translateString("View.Phase.titleX", "q")).setProperty("titleY", this._simulation.translateString("View.Phase.titleY", "v")).setProperty("xFormat", this._simulation.translateString("View.Phase.xFormat", "q=0.###")).setProperty("yFormat", this._simulation.translateString("View.Phase.yFormat", "v=0.##")).getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Phase").setProperty("x", "q").setProperty("y", "v").setProperty("maxpoints", "npoints").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").getObject();
        this.Middle = (JPanel)this.addElement(new ControlPanel(), "Middle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Table = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Table").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Middle").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-0.25").setProperty("maximumX", "2.25").setProperty("minimumY", "-0.5").setProperty("maximumY", "0.5").setProperty("pressaction", "_model._method_for_Table_pressaction()").setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.Table.xFormat", "null")).setProperty("yFormat", this._simulation.translateString("View.Table.yFormat", "q = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Table.tooltip", "Use mouse to change position")).getObject();
        this.Wall1 = (InteractiveParticle)this.addElement(new ControlParticle(), "Wall1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Table").setProperty("x", "-.025").setProperty("y", "0").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "orange").getObject();
        this.Wall2 = (InteractiveParticle)this.addElement(new ControlParticle(), "Wall2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Table").setProperty("x", "2.025").setProperty("y", "0").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "orange").getObject();
        this.Spring1 = (InteractiveSpring)this.addElement(new ControlSpring(), "Spring1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Table").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "1").setProperty("sizey", "q").setProperty("enabled", "false").setProperty("radius", "0.05").getObject();
        this.Spring2 = (InteractiveSpring)this.addElement(new ControlSpring(), "Spring2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Table").setProperty("x", "2").setProperty("y", "0").setProperty("sizex", "-1").setProperty("sizey", "q").setProperty("enabled", "false").setProperty("radius", "0.05").getObject();
        this.Rod = (InteractiveParticle)this.addElement(new ControlParticle(), "Rod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Table").setProperty("x", "1").setProperty("y", "0").setProperty("sizex", "0.02").setProperty("sizey", "2").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("secondaryColor", "0,128,128,255").setProperty("color", "0,128,128,255").getObject();
        this.Bead = (InteractiveParticle)this.addElement(new ControlParticle(), "Bead").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Table").setProperty("x", "x").setProperty("y", "q").setProperty("enabled", "true").setProperty("action", "_model._method_for_Bead_action()").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "HBOX").getObject();
        this.Values = (JPanel)this.addElement(new ControlPanel(), "Values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("layout", "GRID:1,2,0,0").getObject();
        this.Length = (JTextField)this.addElement(new ControlNumberField(), "Length").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "L").setProperty("format", this._simulation.translateString("View.Length.format", "L = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Length.tooltip", "Proper length of both springs")).getObject();
        this.Step = (JTextField)this.addElement(new ControlNumberField(), "Step").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.Step.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Step.tooltip", "Time interval between solution points")).getObject();
        this.But = (JPanel)this.addElement(new ControlPanel(), "But").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("layout", "GRID:1,5,0,0").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "But").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "But").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "%_model._method_for_continueButton_enabled()%").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "But").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.Clear = (JButton)this.addElement(new ControlButton(), "Clear").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "But").setProperty("image", this._simulation.translateString("View.Clear.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Clear.mnemonic", "c")).setProperty("action", "_model._method_for_Clear_action()").setProperty("tooltip", this._simulation.translateString("View.Clear.tooltip", "Clear phase space")).getObject();
        this.Equilibrium = (JButton)this.addElement(new ControlButton(), "Equilibrium").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "But").setProperty("text", this._simulation.translateString("View.Equilibrium.text", "Center")).setProperty("image", this._simulation.translateString("View.Equilibrium.image", "./center.gif")).setProperty("mnemonic", this._simulation.translateString("View.Equilibrium.mnemonic", "e")).setProperty("enabled", "%_model._method_for_Equilibrium_enabled()%").setProperty("action", "_model._method_for_Equilibrium_action()").setProperty("tooltip", this._simulation.translateString("View.Equilibrium.tooltip", "Set particle at the center point")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Quartic oscillator")).setProperty("visible", "true");
        this.getElement("PhaseSpace");
        this.getElement("Phase").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("xMarginPercentage", "10").setProperty("yMarginPercentage", "10").setProperty("title", this._simulation.translateString("View.Phase.title", "Phase-space")).setProperty("axesType", "Cartesian1").setProperty("xFormat", this._simulation.translateString("View.Phase.xFormat", "q=0.###")).setProperty("yFormat", this._simulation.translateString("View.Phase.yFormat", "v=0.##"));
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Middle");
        this.getElement("Table").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-0.25").setProperty("maximumX", "2.25").setProperty("minimumY", "-0.5").setProperty("maximumY", "0.5").setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.Table.xFormat", "null")).setProperty("yFormat", this._simulation.translateString("View.Table.yFormat", "q = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Table.tooltip", "Use mouse to change position"));
        this.getElement("Wall1").setProperty("x", "-.025").setProperty("y", "0").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "orange");
        this.getElement("Wall2").setProperty("x", "2.025").setProperty("y", "0").setProperty("sizex", ".05").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "orange");
        this.getElement("Spring1").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "1").setProperty("enabled", "false").setProperty("radius", "0.05");
        this.getElement("Spring2").setProperty("x", "2").setProperty("y", "0").setProperty("sizex", "-1").setProperty("enabled", "false").setProperty("radius", "0.05");
        this.getElement("Rod").setProperty("x", "1").setProperty("y", "0").setProperty("sizex", "0.02").setProperty("sizey", "2").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("secondaryColor", "0,128,128,255").setProperty("color", "0,128,128,255");
        this.getElement("Bead").setProperty("enabled", "true");
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Buttons");
        this.getElement("Values");
        this.getElement("Length").setProperty("format", this._simulation.translateString("View.Length.format", "L = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Length.tooltip", "Proper length of both springs"));
        this.getElement("Step").setProperty("format", this._simulation.translateString("View.Step.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Step.tooltip", "Time interval between solution points"));
        this.getElement("But");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("Clear").setProperty("image", this._simulation.translateString("View.Clear.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Clear.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.Clear.tooltip", "Clear phase space"));
        this.getElement("Equilibrium").setProperty("text", this._simulation.translateString("View.Equilibrium.text", "Center")).setProperty("image", this._simulation.translateString("View.Equilibrium.image", "./center.gif")).setProperty("mnemonic", this._simulation.translateString("View.Equilibrium.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Equilibrium.tooltip", "Set particle at the center point"));
        super.reset();
    }
}

