/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.quartic;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.quartic.quarticSimulation;
import users.ehu.jma.oscillations.quartic.quarticView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class quartic
extends AbstractModel {
    public quarticSimulation _simulation = null;
    public quarticView _view = null;
    public quartic _model = this;
    public double q = 0.0;
    public double v = 0.0;
    public double L = 1.0;
    public double t = 0.0;
    public double x = 1.0;
    public double dt = 0.1;
    public int npoints = 1000;
    private _ODE_evolution1 _ODEi_evolution1;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/quartic.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/oscillations/center.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        quartic quartic2 = new quartic(stringArray);
    }

    public quartic() {
        this(null, null, null, null, null, false);
    }

    public quartic(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public quartic(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new quarticSimulation(this, string, frame, uRL, bl);
        this._view = (quarticView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _constraints1() {
        this.x = 1.0;
    }

    public void equilibrium() {
        this._pause();
        this.v = 0.0;
        this.q = 0.0;
        this.t = 0.0;
        this._view.resetTraces();
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void _method_for_Table_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Bead_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this.v = 0.0;
        this.t = 0.0;
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this.v = 0.0;
        this.t = 0.0;
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public boolean _method_for_continueButton_enabled() {
        return this._isPaused() && this.t > 0.0;
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Equilibrium_enabled() {
        return this._isPaused();
    }

    public void _method_for_Equilibrium_action() {
        this._simulation.disableLoop();
        this.equilibrium();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.q = 0.0;
        this.v = 0.0;
        this.L = 1.0;
        this.t = 0.0;
        this.x = 1.0;
        this.dt = 0.1;
        this.npoints = 1000;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private EulerRichardson __solver = null;
        private double[] __state = null;
        private double _q;
        private double _v;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = quartic.this.q;
            this.__state[n++] = quartic.this.v;
            this.__state[n++] = quartic.this.t;
            this.__solver = new EulerRichardson(this);
            this.__solver.initialize(quartic.this.dt);
        }

        void step() {
            if (quartic.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(quartic.this.dt);
            }
            int n = 0;
            this.__state[n++] = quartic.this.q;
            this.__state[n++] = quartic.this.v;
            this.__state[n++] = quartic.this.t;
            this.__solver.step();
            n = 0;
            quartic.this.q = this.__state[n++];
            quartic.this.v = this.__state[n++];
            quartic.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._q = dArray[n++];
            this._v = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._q, this._v, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._q, this._v, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3) {
            return -d * (1.0 - quartic.this.L / quartic.this.hypot(d, 1.0));
        }
    }
}

