/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.phasors;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.phasors.phasorsSimulation;
import users.ehu.jma.oscillations.phasors.phasorsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class phasors
extends AbstractModel {
    public phasorsSimulation _simulation = null;
    public phasorsView _view = null;
    public phasors _model = this;
    public double t = 0.0;
    public double x = 1.0;
    public double y = 0.0;
    public double vx = 0.0;
    public double vy = 0.0;
    public double ax = 0.0;
    public double ay = 0.0;
    public double w = 1.0;
    public double wg = 0.0;
    public double gamma = 0.0;
    public double F = 0.0;
    public double delta = 0.0;
    public double W = 1.2;
    public double A = 0.0;
    public double phi = 0.0;
    public double B = 0.0;
    public double alpha = 0.0;
    public double fx = 0.0;
    public double fy = 0.0;
    public double dt = 0.05;
    public double xmax = 1.2;
    public boolean velocity = false;
    public boolean acceleration = false;
    public boolean force = false;
    public int N = 500;
    public int Nmax = 10000;
    public double eps = 0.001;
    public double rp = 0.075;
    public double rv = 0.05;
    public boolean graph = false;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/phasors.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        phasors phasors2 = new phasors(stringArray);
    }

    public phasors() {
        this(null, null, null, null, null, false);
    }

    public phasors(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public phasors(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new phasorsSimulation(this, string, frame, uRL, bl);
        this._view = (phasorsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.initial();
    }

    public void _evolution1() {
        this.t += this.dt;
        this.putxy();
    }

    public void _constraints1() {
        if (this.w <= 0.0) {
            this.w = 1.0;
        }
        if (this.W < 0.0) {
            this.W = 1.0;
        }
        if (this.gamma < 0.0) {
            this.gamma = 0.0;
        } else if (this.gamma >= this.w) {
            this.gamma = 0.1 * this.w;
        }
        this.wg = Math.sqrt(this.w * this.w - this.gamma * this.gamma);
        if (this.gamma == 0.0 && this.W == this.w) {
            this.W += this.eps;
        }
    }

    public void initial() {
        this.t = 0.0;
        this.B = this.F == 0.0 ? 0.0 : this.F / this.hypot(this.W * this.W - this.w * this.w, 2.0 * this.gamma * this.W);
        this.alpha = this.delta + Math.atan2(-2.0 * this.gamma * this.W, this.w * this.w - this.W * this.W);
        double d = this.x - this.B * Math.cos(this.alpha);
        double d2 = this.y - this.B * Math.sin(this.alpha);
        this.A = this.hypot(d, d2);
        this.phi = Math.atan2(d2, d);
        this._view.resetTraces();
    }

    public void putxy() {
        double d = this.A * Math.exp(-this.gamma * this.t) * Math.cos(this.wg * this.t + this.phi);
        double d2 = this.A * Math.exp(-this.gamma * this.t) * Math.sin(this.wg * this.t + this.phi);
        double d3 = this.B * Math.cos(this.W * this.t + this.alpha);
        double d4 = this.B * Math.sin(this.W * this.t + this.alpha);
        this.x = d + d3;
        this.y = d2 + d4;
        this.vx = -this.gamma * d - this.wg * d2 - this.W * d4;
        this.vy = -this.gamma * d2 + this.wg * d + this.W * d3;
        this.ax = (this.gamma * this.gamma - this.wg * this.wg) * d + 2.0 * this.gamma * this.wg * d2 - this.W * this.W * d3;
        this.ay = (this.gamma * this.gamma - this.wg * this.wg) * d2 - 2.0 * this.gamma * this.wg * d - this.W * this.W * d4;
        this.fx = this.F * Math.cos(this.W * this.t + this.delta);
        this.fy = this.F * Math.sin(this.W * this.t + this.delta);
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void _method_for_w_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_gamma_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_F_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_W_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_delta_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Figure_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Figure_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Figure_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public boolean _method_for_trajectory_visible() {
        return this.N > 0;
    }

    public void _method_for_fz_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_xp_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Graphics_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.x = 1.0;
        this.y = 0.0;
        this.vx = 0.0;
        this.vy = 0.0;
        this.ax = 0.0;
        this.ay = 0.0;
        this.w = 1.0;
        this.wg = 0.0;
        this.gamma = 0.0;
        this.F = 0.0;
        this.delta = 0.0;
        this.W = 1.2;
        this.A = 0.0;
        this.phi = 0.0;
        this.B = 0.0;
        this.alpha = 0.0;
        this.fx = 0.0;
        this.fy = 0.0;
        this.dt = 0.05;
        this.xmax = 1.2;
        this.velocity = false;
        this.acceleration = false;
        this.force = false;
        this.N = 500;
        this.Nmax = 10000;
        this.eps = 0.001;
        this.rp = 0.075;
        this.rv = 0.05;
        this.graph = false;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

