/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.oscillator;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.oscillations.oscillator.oscillator;
import users.ehu.jma.oscillations.oscillator.oscillatorSimulation;

class oscillatorView
extends EjsControl
implements View {
    private oscillatorSimulation _simulation = null;
    private oscillator _model = null;
    public Component Main;
    public JPanel Left;
    public JTextField xx;
    public JTextField vv;
    public JTextField Gamma;
    public JTextField Force;
    public JTextField Omega;
    public JTextField Phase;
    public JTextField ddt;
    public JTextField Tolerance;
    public JTextField N;
    public JCheckBox ShowV;
    public JButton startButton;
    public JButton continueButton;
    public JButton stepButton;
    public JButton resetButton;
    public JButton Erase;
    public JPanel DisplayOrbit;
    public PlottingPanel2D PhaseSpace;
    public InteractiveTrace Orbit;
    public InteractiveParticle Point;
    public PlottingPanel2D Evolution;
    public InteractiveTrace xt;
    public JSlider Zoom;
    public JDialog VDialog;
    public PlottingPanel2D Energiak;
    public InteractivePoligon Vgraph;
    public InteractiveTrace Egraph;
    public InteractiveParticle PointE;

    public oscillatorView(oscillatorSimulation oscillatorSimulation2, String string, Frame frame) {
        super(oscillatorSimulation2, string, frame);
        this._simulation = oscillatorSimulation2;
        this._model = (oscillator)oscillatorSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("Omega", "apply(\"Omega\")");
        this.addListener("phase0", "apply(\"phase0\")");
        this.addListener("gamma", "apply(\"gamma\")");
        this.addListener("f", "apply(\"f\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("x0", "apply(\"x0\")");
        this.addListener("v0", "apply(\"v0\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("y1", "apply(\"y1\")");
        this.addListener("x2", "apply(\"x2\")");
        this.addListener("y2", "apply(\"y2\")");
        this.addListener("N", "apply(\"N\")");
        this.addListener("Pi2", "apply(\"Pi2\")");
        this.addListener("showV", "apply(\"showV\")");
        this.addListener("v1", "apply(\"v1\")");
        this.addListener("v2", "apply(\"v2\")");
        this.addListener("scale", "apply(\"scale\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("Omega".equals(string)) {
            this._model.Omega = this.getDouble("Omega");
        }
        if ("phase0".equals(string)) {
            this._model.phase0 = this.getDouble("phase0");
        }
        if ("gamma".equals(string)) {
            this._model.gamma = this.getDouble("gamma");
        }
        if ("f".equals(string)) {
            this._model.f = this.getDouble("f");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("x0".equals(string)) {
            this._model.x0 = this.getDouble("x0");
        }
        if ("v0".equals(string)) {
            this._model.v0 = this.getDouble("v0");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("y1".equals(string)) {
            this._model.y1 = this.getDouble("y1");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
        if ("y2".equals(string)) {
            this._model.y2 = this.getDouble("y2");
        }
        if ("N".equals(string)) {
            this._model.N = this.getInt("N");
        }
        if ("Pi2".equals(string)) {
            this._model.Pi2 = this.getDouble("Pi2");
        }
        if ("showV".equals(string)) {
            this._model.showV = this.getBoolean("showV");
        }
        if ("v1".equals(string)) {
            this._model.v1 = this.getDouble("v1");
        }
        if ("v2".equals(string)) {
            this._model.v2 = this.getDouble("v2");
        }
        if ("scale".equals(string)) {
            this._model.scale = this.getDouble("scale");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("v", this._model.v);
        this.setValue("Omega", this._model.Omega);
        this.setValue("phase0", this._model.phase0);
        this.setValue("gamma", this._model.gamma);
        this.setValue("f", this._model.f);
        this.setValue("dt", this._model.dt);
        this.setValue("x0", this._model.x0);
        this.setValue("v0", this._model.v0);
        this.setValue("tol", this._model.tol);
        this.setValue("x1", this._model.x1);
        this.setValue("y1", this._model.y1);
        this.setValue("x2", this._model.x2);
        this.setValue("y2", this._model.y2);
        this.setValue("N", this._model.N);
        this.setValue("Pi2", this._model.Pi2);
        this.setValue("showV", this._model.showV);
        this.setValue("v1", this._model.v1);
        this.setValue("v2", this._model.v2);
        this.setValue("scale", this._model.scale);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Linear oscillator")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,0").setProperty("size", this._simulation.translateString("View.Main.size", "638,443")).getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:15,1,0,1").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.xx = (JTextField)this.addElement(new ControlNumberField(), "xx").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "x0").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("editable", "%_model._method_for_xx_editable()%").setProperty("action", "_model._method_for_xx_action()").setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "Initial elongation")).getObject();
        this.vv = (JTextField)this.addElement(new ControlNumberField(), "vv").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "v0").setProperty("format", this._simulation.translateString("View.vv.format", "v = 0.##")).setProperty("editable", "%_model._method_for_vv_editable()%").setProperty("action", "_model._method_for_vv_action()").setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "Initial velocity")).getObject();
        this.Gamma = (JTextField)this.addElement(new ControlNumberField(), "Gamma").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("editable", "%_model._method_for_Gamma_editable()%").setProperty("action", "_model._method_for_Gamma_action()").setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Damping coefficient")).getObject();
        this.Force = (JTextField)this.addElement(new ControlNumberField(), "Force").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "f").setProperty("format", this._simulation.translateString("View.Force.format", "f = 0.###")).setProperty("editable", "%_model._method_for_Force_editable()%").setProperty("action", "_model._method_for_Force_action()").setProperty("tooltip", this._simulation.translateString("View.Force.tooltip", "Amplitude of external force")).getObject();
        this.Omega = (JTextField)this.addElement(new ControlNumberField(), "Omega").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "Omega").setProperty("format", this._simulation.translateString("View.Omega.format", "$\\Omega$ = 0.###")).setProperty("editable", "%_model._method_for_Omega_editable()%").setProperty("tooltip", this._simulation.translateString("View.Omega.tooltip", "Frequency of external force")).getObject();
        this.Phase = (JTextField)this.addElement(new ControlNumberField(), "Phase").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "phase0").setProperty("format", this._simulation.translateString("View.Phase.format", "$\\delta$ = 0.###")).setProperty("editable", "%_model._method_for_Phase_editable()%").setProperty("tooltip", this._simulation.translateString("View.Phase.tooltip", "Initial phase of external force")).getObject();
        this.ddt = (JTextField)this.addElement(new ControlNumberField(), "ddt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Time interval between frames")).getObject();
        this.Tolerance = (JTextField)this.addElement(new ControlNumberField(), "Tolerance").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "tol").setProperty("format", this._simulation.translateString("View.Tolerance.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.Tolerance.tooltip", "Maximum relative error in integration")).getObject();
        this.N = (JTextField)this.addElement(new ControlNumberField(), "N").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "N").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("action", "_model._method_for_N_action()").setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of displayed solution points")).getObject();
        this.ShowV = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowV").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "showV").setProperty("text", this._simulation.translateString("View.ShowV.text", "Energy")).setProperty("mnemonic", this._simulation.translateString("View.ShowV.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.ShowV.tooltip", "Show potential and mechanical energies")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simulation")).getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.Erase = (JButton)this.addElement(new ControlButton(), "Erase").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.Erase.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Erase.mnemonic", "a")).setProperty("action", "_model._method_for_Erase_action()").setProperty("tooltip", this._simulation.translateString("View.Erase.tooltip", "Clear graphs")).getObject();
        this.DisplayOrbit = (JPanel)this.addElement(new ControlPanel(), "DisplayOrbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "grid:2,1,0,0").getObject();
        this.PhaseSpace = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "PhaseSpace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "DisplayOrbit").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_PhaseSpace_minimumX()%").setProperty("maximumX", "%_model._method_for_PhaseSpace_maximumX()%").setProperty("minimumY", "%_model._method_for_PhaseSpace_minimumY()%").setProperty("maximumY", "%_model._method_for_PhaseSpace_maximumY()%").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase space")).setProperty("titleX", this._simulation.translateString("View.PhaseSpace.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "v = x'")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "v = 0.###")).getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "x").setProperty("y", "v").setProperty("maxpoints", "N").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_Orbit_visible()%").setProperty("color", "blue").getObject();
        this.Point = (InteractiveParticle)this.addElement(new ControlParticle(), "Point").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "x").setProperty("y", "v").setProperty("sizex", ".04").setProperty("sizey", ".1").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_Point_dragaction()").setProperty("action", "_model._method_for_Point_action()").getObject();
        this.Evolution = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "DisplayOrbit").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("yMarginPercentage", "5").setProperty("title", this._simulation.translateString("View.Evolution.title", "x(t) solution")).setProperty("titleX", this._simulation.translateString("View.Evolution.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Evolution.titleY", "x")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Evolution.yFormat", "x = 0.###")).getObject();
        this.xt = (InteractiveTrace)this.addElement(new ControlTrace(), "xt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "t").setProperty("y", "x").setProperty("maxpoints", "N").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_xt_visible()%").setProperty("color", "red").getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("variable", "scale").setProperty("minimum", "0.25").setProperty("maximum", "5.0").setProperty("orientation", "VERTICAL").setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom")).getObject();
        this.VDialog = (JDialog)this.addElement(new ControlDialog(), "VDialog").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.VDialog.title", "Energy")).setProperty("layout", "border").setProperty("visible", "showV").setProperty("location", "101,280").setProperty("size", this._simulation.translateString("View.VDialog.size", "506,300")).getObject();
        this.Energiak = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Energiak").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "VDialog").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Energiak_minimumX()%").setProperty("maximumX", "%_model._method_for_Energiak_maximumX()%").setProperty("minimumY", "%_model._method_for_Energiak_minimumY()%").setProperty("maximumY", "%_model._method_for_Energiak_maximumY()%").setProperty("title", this._simulation.translateString("View.Energiak.title", "Mechanical energy")).setProperty("titleX", this._simulation.translateString("View.Energiak.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.Energiak.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Energiak.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Energiak.yFormat", "E = 0.###")).getObject();
        this.Vgraph = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "Vgraph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Energiak").setProperty("min", "%_model._method_for_Vgraph_min()%").setProperty("max", "%_model._method_for_Vgraph_max()%").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", ".5*s*s").setProperty("color", "red").setProperty("stroke", "2").setProperty("visible", "%_model._method_for_Vgraph_visible()%").setProperty("enabled", "false").getObject();
        this.Egraph = (InteractiveTrace)this.addElement(new ControlTrace(), "Egraph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Energiak").setProperty("x", "x").setProperty("y", "%_model._method_for_Egraph_y()%").setProperty("maxpoints", "N").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_Egraph_visible()%").setProperty("color", "blue").getObject();
        this.PointE = (InteractiveParticle)this.addElement(new ControlParticle(), "PointE").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Energiak").setProperty("x", "x").setProperty("y", "%_model._method_for_PointE_y()%").setProperty("sizex", ".04").setProperty("sizey", ".02").setProperty("enabled", "false").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Linear oscillator")).setProperty("visible", "true");
        this.getElement("Left").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("xx").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "Initial elongation"));
        this.getElement("vv").setProperty("format", this._simulation.translateString("View.vv.format", "v = 0.##")).setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "Initial velocity"));
        this.getElement("Gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Damping coefficient"));
        this.getElement("Force").setProperty("format", this._simulation.translateString("View.Force.format", "f = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Force.tooltip", "Amplitude of external force"));
        this.getElement("Omega").setProperty("format", this._simulation.translateString("View.Omega.format", "$\\Omega$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Omega.tooltip", "Frequency of external force"));
        this.getElement("Phase").setProperty("format", this._simulation.translateString("View.Phase.format", "$\\delta$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Phase.tooltip", "Initial phase of external force"));
        this.getElement("ddt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Time interval between frames"));
        this.getElement("Tolerance").setProperty("format", this._simulation.translateString("View.Tolerance.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.Tolerance.tooltip", "Maximum relative error in integration"));
        this.getElement("N").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of displayed solution points"));
        this.getElement("ShowV").setProperty("text", this._simulation.translateString("View.ShowV.text", "Energy")).setProperty("mnemonic", this._simulation.translateString("View.ShowV.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.ShowV.tooltip", "Show potential and mechanical energies"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simulation"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("Erase").setProperty("image", this._simulation.translateString("View.Erase.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Erase.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.Erase.tooltip", "Clear graphs"));
        this.getElement("DisplayOrbit");
        this.getElement("PhaseSpace").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase space")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "v = x'")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "v = 0.###"));
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Point").setProperty("sizex", ".04").setProperty("sizey", ".1").setProperty("enabled", "true");
        this.getElement("Evolution").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("yMarginPercentage", "5").setProperty("title", this._simulation.translateString("View.Evolution.title", "x(t) solution")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Evolution.yFormat", "x = 0.###"));
        this.getElement("xt").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("Zoom").setProperty("minimum", "0.25").setProperty("maximum", "5.0").setProperty("orientation", "VERTICAL").setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom"));
        this.getElement("VDialog").setProperty("title", this._simulation.translateString("View.VDialog.title", "Energy"));
        this.getElement("Energiak").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.Energiak.title", "Mechanical energy")).setProperty("titleY", this._simulation.translateString("View.Energiak.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Energiak.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Energiak.yFormat", "E = 0.###"));
        this.getElement("Vgraph").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", ".5*s*s").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("Egraph").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("PointE").setProperty("sizex", ".04").setProperty("sizey", ".02").setProperty("enabled", "false");
        super.reset();
    }
}

