/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.oscillator;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.oscillator.oscillatorSimulation;
import users.ehu.jma.oscillations.oscillator.oscillatorView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class oscillator
extends AbstractModel {
    public oscillatorSimulation _simulation = null;
    public oscillatorView _view = null;
    public oscillator _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double v = 0.0;
    public double Omega = 1.5;
    public double phase0 = 0.0;
    public double gamma = 0.0;
    public double f = 0.0;
    public double dt = 0.1;
    public double x0 = 0.9;
    public double v0 = 0.0;
    public double tol = 1.0E-5;
    public double x1 = -1.0;
    public double y1 = -1.0;
    public double x2 = 1.0;
    public double y2 = 1.0;
    public int N = 1000;
    public double Pi2 = Math.PI * 2;
    public boolean showV = false;
    public double v1 = -0.1;
    public double v2 = 0.5;
    public double scale = 1.0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/oscillator.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        oscillator oscillator2 = new oscillator(stringArray);
    }

    public oscillator() {
        this(null, null, null, null, null, false);
    }

    public oscillator(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public oscillator(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new oscillatorSimulation(this, string, frame, uRL, bl);
        this._view = (oscillatorView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.setZero();
    }

    public void setZero() {
        this.t = 0.0;
        this.x = this.x0;
        this.v = this.v0;
        this._view.resetTraces();
        this._resetSolvers();
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Gamma_editable() {
        return this._isPaused();
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Force_editable() {
        return this._isPaused();
    }

    public void _method_for_Force_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Omega_editable() {
        return this._isPaused();
    }

    public boolean _method_for_Phase_editable() {
        return this._isPaused();
    }

    public void _method_for_N_action() {
        this._simulation.disableLoop();
        if (this.N < 0) {
            this.N = 0;
        }
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this.setZero();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Erase_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_PhaseSpace_minimumX() {
        return this.x1 * this.scale;
    }

    public double _method_for_PhaseSpace_maximumX() {
        return this.x2 * this.scale;
    }

    public double _method_for_PhaseSpace_minimumY() {
        return this.y1 * this.scale;
    }

    public double _method_for_PhaseSpace_maximumY() {
        return this.y2 * this.scale;
    }

    public boolean _method_for_Orbit_visible() {
        return this.N > 0;
    }

    public void _method_for_Point_dragaction() {
        this._simulation.disableLoop();
        this.x0 = this.x;
        this.v0 = this.v;
        this._simulation.enableLoop();
    }

    public void _method_for_Point_action() {
        this._simulation.disableLoop();
        this.x0 = this.x;
        this.v0 = this.v;
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_xt_visible() {
        return this.N > 0;
    }

    public double _method_for_Energiak_minimumX() {
        return this.x1 * this.scale;
    }

    public double _method_for_Energiak_maximumX() {
        return this.x2 * this.scale;
    }

    public double _method_for_Energiak_minimumY() {
        return this.v1 * this.scale;
    }

    public double _method_for_Energiak_maximumY() {
        return this.v2 * this.scale;
    }

    public double _method_for_Vgraph_min() {
        return this.x1 * this.scale;
    }

    public double _method_for_Vgraph_max() {
        return this.x2 * this.scale;
    }

    public boolean _method_for_Vgraph_visible() {
        return this.f == 0.0;
    }

    public double _method_for_Egraph_y() {
        return 0.5 * this.v * this.v + 0.5 * this.x * this.x;
    }

    public boolean _method_for_Egraph_visible() {
        return this.N > 0;
    }

    public double _method_for_PointE_y() {
        return 0.5 * this.v * this.v + 0.5 * this.x * this.x;
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.x = 0.0;
        this.v = 0.0;
        this.Omega = 1.5;
        this.phase0 = 0.0;
        this.gamma = 0.0;
        this.f = 0.0;
        this.dt = 0.1;
        this.x0 = 0.9;
        this.v0 = 0.0;
        this.tol = 1.0E-5;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.x2 = 1.0;
        this.y2 = 1.0;
        this.N = 1000;
        this.Pi2 = Math.PI * 2;
        this.showV = false;
        this.v1 = -0.1;
        this.v2 = 0.5;
        this.scale = 1.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _v;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = oscillator.this.x;
            this.__state[n++] = oscillator.this.v;
            this.__state[n++] = oscillator.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(oscillator.this.dt);
        }

        void step() {
            if (oscillator.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(oscillator.this.tol);
            }
            if (oscillator.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(oscillator.this.dt);
            }
            int n = 0;
            this.__state[n++] = oscillator.this.x;
            this.__state[n++] = oscillator.this.v;
            this.__state[n++] = oscillator.this.t;
            this.__solver.step();
            n = 0;
            oscillator.this.x = this.__state[n++];
            oscillator.this.v = this.__state[n++];
            oscillator.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._v = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._v, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._v, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3) {
            return -2.0 * oscillator.this.gamma * d2 - d + oscillator.this.f * Math.cos(oscillator.this.Omega * d3 + oscillator.this.phase0);
        }
    }
}

