/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.normal;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.normal.normalSimulation;
import users.ehu.jma.oscillations.normal.normalView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class normal
extends AbstractModel {
    public normalSimulation _simulation = null;
    public normalView _view = null;
    public normal _model = this;
    public double x1 = 0.0;
    public double x2 = 0.0;
    public double v1 = 0.0;
    public double v2 = 0.0;
    public double k = 1.0;
    public double kk = 1.0;
    public double t = 0.0;
    public double f = 0.0;
    public double W = 2.0;
    public double Q1 = 0.0;
    public double Q2 = 0.0;
    public double SQRT2 = Math.sqrt(2.0);
    public double g1 = 0.0;
    public double g2 = 0.0;
    public double dt = 0.05;
    public double sl = 1.0;
    public double d = 0.2;
    public double pos1 = this.sl;
    public double pos2 = 2.0 * this.sl + this.d;
    public double y1 = 0.0;
    public double y2 = 0.0;
    public boolean vectors = false;
    public boolean phase = false;
    public boolean graphicsi = false;
    public int npoints = 200;
    public boolean fvisible = false;
    public boolean showx1 = true;
    public boolean showx2 = true;
    public boolean showq1 = false;
    public boolean showq2 = false;
    public boolean showf;
    public boolean shownormal = false;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/normal.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        normal normal2 = new normal(stringArray);
    }

    public normal() {
        this(null, null, null, null, null, false);
    }

    public normal(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public normal(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new normalSimulation(this, string, frame, uRL, bl);
        this._view = (normalView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _evolution2() {
        this.putpos(this.x1, this.x2);
    }

    public void _constraints1() {
        this.y1 = 0.0;
        this.y2 = 0.0;
        if (this.x1 < -this.sl + this.d || this.x2 > this.sl || this.x2 - this.x1 < -this.sl + this.d) {
            this._pause();
            this._alert("bhasi", "The simulation is over", "At least one spring became too short");
            this.v2 = 0.0;
            this.v1 = 0.0;
            this.x2 = 0.0;
            this.x1 = 0.0;
            this.putpos(this.x1, this.x2);
        }
    }

    public void _constraints2() {
        this.fvisible = this.vectors && this.f != 0.0;
        this.Q1 = (this.x1 + this.x2) / this.SQRT2;
        this.Q2 = (this.x1 - this.x2) / this.SQRT2;
    }

    public void putpos(double d, double d2) {
        this.pos1 = this.sl + d;
        this.pos2 = 2.0 * this.sl + this.d + d2;
    }

    public void setkaputt() {
        this.x2 = 0.0;
        this.x1 = 0.0;
        this.putpos(this.x1, this.x2);
    }

    public void eraseEvolution() {
        this._view.getElement("tx1").reset();
        this._view.getElement("tx2").reset();
        this._view.getElement("tq1").reset();
        this._view.getElement("tq2").reset();
        this._view.getElement("tf").reset();
    }

    public void erasePhase() {
        this._view.getElement("x1x2").reset();
        this._view.getElement("q1q2").reset();
    }

    public void restart() {
        this.v2 = 0.0;
        this.v1 = 0.0;
        this.x2 = 0.0;
        this.x1 = 0.0;
        this.t = 0.0;
        this.putpos(this.x1, this.x2);
        this._view.resetTraces();
    }

    public void axes() {
        this._view.getElement("Configuration").setProperty("titleX", this.shownormal ? "Q1" : "x1");
        this._view.getElement("Configuration").setProperty("titleY", this.shownormal ? "Q2" : "x2");
        this._view.getElement("Configuration").setProperty("title", this.shownormal ? "(Q1,Q2)" : "(x1,x2)");
    }

    public boolean _method_for_p1_enabled() {
        return this._isPaused();
    }

    public void _method_for_p1_dragaction() {
        this._simulation.disableLoop();
        this.x1 = this.pos1 - this.sl;
        this._simulation.enableLoop();
    }

    public void _method_for_p1_action() {
        this._simulation.disableLoop();
        this.x1 = this.pos1 - this.sl;
        this.v2 = 0.0;
        this.v1 = 0.0;
        this.t = 0.0;
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public boolean _method_for_p2_enabled() {
        return this._isPaused();
    }

    public void _method_for_p2_dragaction() {
        this._simulation.disableLoop();
        this.x2 = this.pos2 - 2.0 * this.sl - this.d;
        this._simulation.enableLoop();
    }

    public void _method_for_p2_action() {
        this._simulation.disableLoop();
        this.x2 = this.pos2 - 2.0 * this.sl - this.d;
        this.v2 = 0.0;
        this.v1 = 0.0;
        this.t = 0.0;
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_spring1_x() {
        return -this.d / 2.0;
    }

    public double _method_for_spring2_x() {
        return this.pos1 + this.d / 2.0;
    }

    public double _method_for_spring2_sizex() {
        return this.pos2 - this.pos1 - this.d;
    }

    public double _method_for_spring3_x() {
        return this.pos2 + this.d / 2.0;
    }

    public double _method_for_spring3_sizex() {
        return 3.0 * this.sl + 2.0 * this.d - this.pos2;
    }

    public double _method_for_table_x() {
        return -this.d;
    }

    public double _method_for_table_y() {
        return -this.d / 2.0 - 0.11;
    }

    public double _method_for_table_sizex() {
        return 3.0 * this.sl + 4.0 * this.d;
    }

    public double _method_for_wall1_x() {
        return -this.d;
    }

    public double _method_for_wall1_y() {
        return -this.d / 2.0;
    }

    public double _method_for_wall1_sizey() {
        return 2.0 * this.d;
    }

    public double _method_for_wall2_x() {
        return 3.0 * this.sl + 2.5 * this.d;
    }

    public double _method_for_wall2_y() {
        return -this.d / 2.0;
    }

    public double _method_for_wall2_sizey() {
        return 2.0 * this.d;
    }

    public double _method_for_v2_x() {
        return 2.0 * this.sl + this.d;
    }

    public double _method_for_vf_x() {
        return this.sl + this.x1;
    }

    public double _method_for_vf_sizex() {
        return this.f * Math.cos(this.W * this.t);
    }

    public void _method_for_kx1_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this.putpos(this.x1, this.x2);
        this._simulation.enableLoop();
    }

    public void _method_for_kx2_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this.putpos(this.x1, this.x2);
        this._simulation.enableLoop();
    }

    public void _method_for_kk1_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_kk3_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_kg1_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_kg2_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_fb_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_wb_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_tf_y() {
        return this.f * Math.cos(this.W * this.t);
    }

    public void _method_for_EraseE_action() {
        this._simulation.disableLoop();
        this.eraseEvolution();
        this._simulation.enableLoop();
    }

    public boolean _method_for_x1x2_visible() {
        return !this.shownormal;
    }

    public void _method_for_shq1q2_action() {
        this._simulation.disableLoop();
        this.axes();
        this._simulation.enableLoop();
    }

    public void _method_for_EraseP_action() {
        this._simulation.disableLoop();
        this.erasePhase();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.x1 = 0.0;
        this.x2 = 0.0;
        this.v1 = 0.0;
        this.v2 = 0.0;
        this.k = 1.0;
        this.kk = 1.0;
        this.t = 0.0;
        this.f = 0.0;
        this.W = 2.0;
        this.Q1 = 0.0;
        this.Q2 = 0.0;
        this.SQRT2 = Math.sqrt(2.0);
        this.g1 = 0.0;
        this.g2 = 0.0;
        this.dt = 0.05;
        this.sl = 1.0;
        this.d = 0.2;
        this.pos1 = this.sl;
        this.pos2 = 2.0 * this.sl + this.d;
        this.y1 = 0.0;
        this.y2 = 0.0;
        this.vectors = false;
        this.phase = false;
        this.graphicsi = false;
        this.npoints = 200;
        this.fvisible = false;
        this.showx1 = true;
        this.showx2 = true;
        this.showq1 = false;
        this.showq2 = false;
        this.shownormal = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _x1;
        private double _x2;
        private double _v1;
        private double _v2;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = normal.this.x1;
            this.__state[n++] = normal.this.x2;
            this.__state[n++] = normal.this.v1;
            this.__state[n++] = normal.this.v2;
            this.__state[n++] = normal.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(normal.this.dt);
        }

        void step() {
            if (1.0E-6 != this.__solver.getTolerance()) {
                this.__solver.setTolerance(1.0E-6);
            }
            if (normal.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(normal.this.dt);
            }
            int n = 0;
            this.__state[n++] = normal.this.x1;
            this.__state[n++] = normal.this.x2;
            this.__state[n++] = normal.this.v1;
            this.__state[n++] = normal.this.v2;
            this.__state[n++] = normal.this.t;
            this.__solver.step();
            n = 0;
            normal.this.x1 = this.__state[n++];
            normal.this.x2 = this.__state[n++];
            normal.this.v1 = this.__state[n++];
            normal.this.v2 = this.__state[n++];
            normal.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x1 = dArray[n++];
            this._x2 = dArray[n++];
            this._v1 = dArray[n++];
            this._v2 = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x1, this._x2, this._v1, this._v2, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x1, this._x2, this._v1, this._v2, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x1, this._x2, this._v1, this._v2, this._t);
            dArray2[n++] = this._ODE_evolution1_4(this._x1, this._x2, this._v1, this._v2, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return d3;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return d4;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return -(normal.this.k * d + normal.this.kk * (d - d2)) + normal.this.f * Math.cos(normal.this.W * d5) - 2.0 * normal.this.g1 * d3;
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return -(normal.this.kk * (d2 - d) + normal.this.k * d2) - 2.0 * normal.this.g2 * d4;
        }
    }
}

