/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.inelastic;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Dopri853;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.inelastic.inelasticSimulation;
import users.ehu.jma.oscillations.inelastic.inelasticView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class inelastic
extends AbstractModel {
    public inelasticSimulation _simulation = null;
    public inelasticView _view = null;
    public inelastic _model = this;
    public double t;
    public double x = 1.0;
    public double y = 2.0;
    public double vx;
    public double vy;
    public double L = 2.0;
    public double alpha = 0.5;
    public double dt = 0.1;
    public double tol = 1.0E-7;
    public double a = 0.75;
    public double b = 0.375;
    public double xmax = 8.0;
    public boolean stopcol;
    public int ncol;
    public boolean computed = false;
    public boolean com = true;
    public boolean boxed = true;
    public double massX = this.x + 0.5 * this.a;
    public double massY = this.y + this.a + 0.5 * this.b;
    public double partX = (this.x + this.alpha * this.y) / (1.0 + this.alpha) + 0.5 * (this.a + this.b);
    public double R = this.a / 4.0;
    public double boxX = 0.5 * this.a + 0.5 * this.b + 0.5 * (this.x + this.y);
    public double boxSize = this.a + this.b + this.y - this.x;
    public boolean showVelocities;
    public boolean showElements = true;
    public double alphaMin = 0.001;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/inelastic.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        inelastic inelastic2 = new inelastic(stringArray);
    }

    public inelastic() {
        this(null, null, null, null, null, false);
    }

    public inelastic(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public inelastic(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new inelasticSimulation(this, string, frame, uRL, bl);
        this._view = (inelasticView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.x = 1.0;
        this.y = this.x + this.L;
        this.vy = -1.0;
        this.vx = -1.0;
        this.t = this.x / this.vx;
        this.ncol = 0;
        this.computed = false;
    }

    public void _constraints1() {
        if (this.alpha < this.alphaMin) {
            this.alpha = this.alphaMin;
        }
        this.b = this.alpha * this.a;
        this.massX = this.x + 0.5 * this.a;
        this.massY = this.y + this.a + 0.5 * this.b;
        this.partX = (this.x + this.alpha * this.y) / (1.0 + this.alpha) + 0.5 * (this.a + this.b);
        this.boxX = 0.5 * this.a + 0.5 * this.b + 0.5 * (this.x + this.y);
        this.boxSize = this.a + this.b + this.y - this.x;
    }

    public double _method_for_Drawing_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Drawing_minimumY() {
        return -0.2 * this.a;
    }

    public void _method_for_Drawing_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Axis_y() {
        return -0.5 * this.a;
    }

    public double _method_for_Axis_sizey() {
        return 2.5 * this.a;
    }

    public double _method_for_xLeft_x() {
        return -this.massX;
    }

    public double _method_for_yLeft_x() {
        return -this.massY;
    }

    public double _method_for_springLeft_x() {
        return -this.y - this.a;
    }

    public double _method_for_springLeft_sizex() {
        return this.y - this.x;
    }

    public double _method_for_springRight_x() {
        return this.x + this.a;
    }

    public double _method_for_springRight_sizex() {
        return this.y - this.x;
    }

    public double _method_for_partLeft_x() {
        return -this.partX;
    }

    public double _method_for_Table_y() {
        return -0.75 * this.a;
    }

    public double _method_for_Table_sizex() {
        return 4.0 * this.xmax;
    }

    public double _method_for_Table_sizey() {
        return this.a / 2.0;
    }

    public double _method_for_boxLeft_x() {
        return -this.boxX;
    }

    public boolean _method_for_v1right_visible() {
        return this.showVelocities && this.showElements;
    }

    public double _method_for_v1left_x() {
        return -this.massX;
    }

    public double _method_for_v1left_sizex() {
        return -this.vx;
    }

    public boolean _method_for_v1left_visible() {
        return this.showVelocities && this.showElements;
    }

    public boolean _method_for_v2right_visible() {
        return this.showVelocities && this.showElements;
    }

    public double _method_for_v2left_x() {
        return -this.massY;
    }

    public double _method_for_v2left_sizex() {
        return -this.vy;
    }

    public boolean _method_for_v2left_visible() {
        return this.showVelocities && this.showElements;
    }

    public double _method_for_Vright_y() {
        return 1.5 * this.a;
    }

    public double _method_for_Vright_sizex() {
        return (this.vx + this.alpha * this.vy) / (1.0 + this.alpha);
    }

    public boolean _method_for_Vright_visible() {
        return this.showVelocities && this.com;
    }

    public double _method_for_Vleft_x() {
        return -this.partX;
    }

    public double _method_for_Vleft_y() {
        return 1.5 * this.a;
    }

    public double _method_for_Vleft_sizex() {
        return -(this.vx + this.alpha * this.vy) / (1.0 + this.alpha);
    }

    public boolean _method_for_Vleft_visible() {
        return this.showVelocities && this.com;
    }

    public boolean _method_for_Alphavalue_editable() {
        return this._isPaused();
    }

    public void _method_for_Alphavalue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Lvalue_editable() {
        return this._isPaused();
    }

    public void _method_for_Lvalue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public double _method_for_vxValue_variable() {
        return (this.vx + this.alpha * this.vy) / (1.0 + this.alpha);
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this.initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_initialButton_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.x = 1.0;
        this.y = 2.0;
        this.L = 2.0;
        this.alpha = 0.5;
        this.dt = 0.1;
        this.tol = 1.0E-7;
        this.a = 0.75;
        this.b = 0.375;
        this.xmax = 8.0;
        this.computed = false;
        this.com = true;
        this.boxed = true;
        this.massX = this.x + 0.5 * this.a;
        this.massY = this.y + this.a + 0.5 * this.b;
        this.partX = (this.x + this.alpha * this.y) / (1.0 + this.alpha) + 0.5 * (this.a + this.b);
        this.R = this.a / 4.0;
        this.boxX = 0.5 * this.a + 0.5 * this.b + 0.5 * (this.x + this.y);
        this.boxSize = this.a + this.b + this.y - this.x;
        this.showElements = true;
        this.alphaMin = 0.001;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _y;
        private double _vx;
        private double _vy;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = inelastic.this.x;
            this.__state[n++] = inelastic.this.y;
            this.__state[n++] = inelastic.this.vx;
            this.__state[n++] = inelastic.this.vy;
            this.__state[n++] = inelastic.this.t;
            this.__solver = new ODEBisectionEventSolver(this, Dopri853.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.addEvent(new _ODE_evolution1_Event2());
            this.__solver.addEvent(new _ODE_evolution1_Event3());
            this.__solver.initialize(inelastic.this.dt);
        }

        void step() {
            if (inelastic.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(inelastic.this.tol);
            }
            if (inelastic.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(inelastic.this.dt);
            }
            int n = 0;
            this.__state[n++] = inelastic.this.x;
            this.__state[n++] = inelastic.this.y;
            this.__state[n++] = inelastic.this.vx;
            this.__state[n++] = inelastic.this.vy;
            this.__state[n++] = inelastic.this.t;
            this.__solver.step();
            n = 0;
            inelastic.this.x = this.__state[n++];
            inelastic.this.y = this.__state[n++];
            inelastic.this.vx = this.__state[n++];
            inelastic.this.vy = this.__state[n++];
            inelastic.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._y = dArray[n++];
            this._vx = dArray[n++];
            this._vy = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._y, this._vx, this._vy, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._y, this._vx, this._vy, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._y, this._vx, this._vy, this._t);
            dArray2[n++] = this._ODE_evolution1_4(this._x, this._y, this._vx, this._vy, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return d3;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return d4;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return d2 - d - inelastic.this.L;
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return -(d2 - d - inelastic.this.L) / inelastic.this.alpha;
        }

        private class _ODE_evolution1_Event3
        implements StateEvent {
            private _ODE_evolution1_Event3() {
            }

            public String toString() {
                return "Infinity";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._y = dArray[n++];
                _ODE_evolution1.this._vx = dArray[n++];
                _ODE_evolution1.this._vy = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._y, _ODE_evolution1.this._vx, _ODE_evolution1.this._vy, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4, double d5) {
                return inelastic.this.xmax + inelastic.this.a - d;
            }

            public boolean action() {
                int n = 0;
                inelastic.this.x = _ODE_evolution1.this.__state[n++];
                inelastic.this.y = _ODE_evolution1.this.__state[n++];
                inelastic.this.vx = _ODE_evolution1.this.__state[n++];
                inelastic.this.vy = _ODE_evolution1.this.__state[n++];
                inelastic.this.t = _ODE_evolution1.this.__state[n++];
                inelastic.this._pause();
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.vx;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.t;
                return true;
            }
        }

        private class _ODE_evolution1_Event2
        implements StateEvent {
            private _ODE_evolution1_Event2() {
            }

            public String toString() {
                return "Spring";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._y = dArray[n++];
                _ODE_evolution1.this._vx = dArray[n++];
                _ODE_evolution1.this._vy = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._y, _ODE_evolution1.this._vx, _ODE_evolution1.this._vy, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4, double d5) {
                return d2 - d;
            }

            public boolean action() {
                int n = 0;
                inelastic.this.x = _ODE_evolution1.this.__state[n++];
                inelastic.this.y = _ODE_evolution1.this.__state[n++];
                inelastic.this.vx = _ODE_evolution1.this.__state[n++];
                inelastic.this.vy = _ODE_evolution1.this.__state[n++];
                inelastic.this.t = _ODE_evolution1.this.__state[n++];
                inelastic.this._alert("Main", "Simulation stopped", "Spring too short");
                inelastic.this._resetSolvers();
                inelastic.this._pause();
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.vx;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.t;
                return true;
            }
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Collision";
            }

            public double getTolerance() {
                return inelastic.this.tol;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._y = dArray[n++];
                _ODE_evolution1.this._vx = dArray[n++];
                _ODE_evolution1.this._vy = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._y, _ODE_evolution1.this._vx, _ODE_evolution1.this._vy, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4, double d5) {
                return d;
            }

            public boolean action() {
                int n = 0;
                inelastic.this.x = _ODE_evolution1.this.__state[n++];
                inelastic.this.y = _ODE_evolution1.this.__state[n++];
                inelastic.this.vx = _ODE_evolution1.this.__state[n++];
                inelastic.this.vy = _ODE_evolution1.this.__state[n++];
                inelastic.this.t = _ODE_evolution1.this.__state[n++];
                inelastic.this.vx = Math.abs(inelastic.this.vx);
                ++inelastic.this.ncol;
                inelastic.this._resetSolvers();
                if (inelastic.this.stopcol) {
                    inelastic.this._pause();
                }
                inelastic.this.computed = true;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.vx;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = inelastic.this.t;
                return true;
            }
        }
    }
}

