/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.harmonics;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.harmonics.harmonicsSimulation;
import users.ehu.jma.oscillations.harmonics.harmonicsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class harmonics
extends AbstractModel {
    public harmonicsSimulation _simulation = null;
    public harmonicsView _view = null;
    public harmonics _model = this;
    public int nmax = 1000;
    public int N = 1000;
    public double[] x;
    public double[] xf;
    public double[] t;
    public int kmaxx = 1000;
    public int kmax = 50;
    public double[] kk;
    public double[] A;
    public double[] f;
    public double xmin = -0.25;
    public double xmax = Math.PI * 2 - this.xmin;
    public double ymin = -2.0;
    public double ymax = 2.0;
    public String type = "0";
    public int nA = 0;
    public int nf = 0;
    public boolean full = false;
    public double PI = Math.PI;
    public double PI2 = Math.PI * 2;
    public double dt = 0.0;
    public double dk = 0.0;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/harmonics.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        harmonics harmonics2 = new harmonics(stringArray);
    }

    public harmonics() {
        this(null, null, null, null, null, false);
    }

    public harmonics(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public harmonics(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new harmonicsSimulation(this, string, frame, uRL, bl);
        this._view = (harmonicsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.chooseType();
    }

    public void _constraints1() {
        if (this.kmax < 1) {
            this.kmax = 1;
        } else if (this.kmax > this.kmaxx) {
            this.kmax = this.kmaxx;
        }
        this.dt = this.PI2 / (double)this.N;
        this.dk = this.PI2 / (double)this.kmax;
        for (int i = 0; i <= this.kmax; ++i) {
            this.kk[i] = (double)i * this.dk;
            this.A[i] = Math.max(0.0, this.A[i]);
            this.f[i] = Math.max(0.0, Math.min(1.0, this.f[i]));
        }
        this.f[0] = 0.0;
    }

    public void setx() {
        this.dt = this.PI2 / (double)this.N;
        for (int i = 0; i <= this.N; ++i) {
            this.t[i] = (double)i * this.dt;
            this.x[i] = this.A[0];
            for (int j = 1; j <= this.kmax; ++j) {
                int n = i;
                this.x[n] = this.x[n] + this.A[j] * Math.cos((double)j * this.t[i] + this.PI2 * this.f[j]);
            }
        }
    }

    public void setA(boolean bl) {
        if (bl) {
            this.A[this.nA] = Math.min(1.0, Math.max(0.0, this.A[this.nA]));
        }
        this._view.getElement("InfoA").setProperty("text", "A[" + this.nA + "] = " + this._format(this.A[this.nA], "0.##"));
        if (bl) {
            this.setx();
        }
    }

    public void setf(boolean bl) {
        if (bl) {
            this.f[this.nf] = Math.min(1.0, Math.max(0.0, this.f[this.nf]));
        }
        this._view.getElement("InfoF").setProperty("text", "f[" + this.nf + "] = " + this._format(this.f[this.nf] * 360.0, "0.##"));
        if (bl) {
            this.setx();
        }
    }

    public void setSaw() {
        int n;
        for (n = 0; n <= this.kmax; ++n) {
            double d = this.A[n] = n % 2 == 0 ? 0.0 : 4.0 / this.PI / (double)n / (double)n;
            this.f[n] = n % 2 == 0 ? 0.0 : (n % 4 == 1 ? 0.75 : 0.25);
        }
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = (double)(n < this.N / 4 ? n : (n < 3 * this.N / 4 ? this.N / 2 - n : n - this.N)) * this.dt;
        }
    }

    public void chooseType() {
        if (this.type.equals("0")) {
            this.set0();
        } else if (this.type.equals("Fundamental")) {
            this.setFundamental();
        } else if (this.type.equals("Linear")) {
            this.sett();
        } else if (this.type.equals("Triangle")) {
            this.setTriangle();
        } else if (this.type.equals("Saw")) {
            this.setSaw();
        } else if (this.type.equals("Square")) {
            this.setSquare();
        } else if (this.type.equals("Parabola")) {
            this.setParabola();
        } else if (this.type.equals("Direct")) {
            this.setDirect();
        } else if (this.type.equals("Half cycle")) {
            this.setHalfCycle();
        }
        this.setx();
    }

    public void setHalfCycle() {
        int n;
        this.A[0] = 1.5 / this.PI;
        this.f[0] = 0.0;
        for (n = 1; n <= this.kmax; ++n) {
            this.A[n] = n % 2 == 0 ? 3.0 / this.PI / (double)(n - 1) / (double)(n + 1) : 0.0;
            this.f[n] = n % 2 == 0 ? 0.5 : 0.0;
        }
        this.A[1] = 0.75;
        this.f[1] = 0.75;
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = n < this.N / 2 ? 1.5 * Math.abs(Math.sin((double)n * this.dt)) : 0.0;
        }
    }

    public void setDirect() {
        int n;
        this.A[0] = 3.0 / this.PI;
        this.f[0] = 0.0;
        for (n = 1; n <= this.kmax; ++n) {
            this.A[n] = n % 2 == 0 ? 6.0 / this.PI / (double)(n - 1) / (double)(n + 1) : 0.0;
            this.f[n] = n % 2 == 0 ? 0.5 : 0.0;
        }
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = 1.5 * Math.abs(Math.sin((double)n * this.dt));
        }
    }

    public void setTriangle() {
        int n;
        this.A[0] = 0.75;
        this.f[0] = 0.0;
        for (n = 1; n <= this.kmax; ++n) {
            this.A[n] = n % 2 == 1 ? 6.0 / this.PI / this.PI / (double)n / (double)n : 0.0;
            this.f[n] = n % 2 == 1 ? 0.5 : 0.0;
        }
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = (double)(n < this.N / 2 ? n : this.N - n) * this.dt / this.PI * 1.5;
        }
    }

    public void setParabola() {
        int n;
        this.A[0] = this.PI / 6.0;
        this.f[0] = 0.0;
        for (n = 1; n <= this.kmax; ++n) {
            this.A[n] = 2.0 / this.PI / (double)n / (double)n;
            this.f[n] = n % 2 == 1 ? 0.5 : 0.0;
        }
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = (double)(n < this.N / 2 ? n * n : (this.N - n) * (this.N - n)) * this.dt * this.dt / this.PI2;
        }
    }

    public void setSquare() {
        int n;
        for (n = 0; n <= this.kmax; ++n) {
            this.A[n] = n % 2 == 0 ? 0.0 : 4.0 / this.PI / (double)n;
            this.f[n] = 0.75;
        }
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = n < this.N / 2 ? 1.0 : -1.0;
        }
    }

    public void sett() {
        int n;
        this.A[0] = 0.0;
        for (n = 1; n <= this.kmax; ++n) {
            this.A[n] = 1.0 / (double)n;
            this.f[n] = n % 2 == 0 ? 0.25 : 0.75;
        }
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = 0.5 * (n < this.N / 2 ? (double)n * this.dt : (double)(n - this.N) * this.dt);
        }
    }

    public void setFundamental() {
        this.set0();
        this.A[1] = 1.0;
        for (int i = 0; i <= this.N; ++i) {
            this.xf[i] = Math.cos((double)i * this.dt);
        }
    }

    public void set0() {
        int n;
        for (n = 0; n <= this.kmax; ++n) {
            this.f[n] = 0.0;
            this.A[n] = 0.0;
        }
        for (n = 0; n <= this.N; ++n) {
            this.xf[n] = 0.0;
        }
    }

    public int _method_for_xgraf_maxpoints() {
        return this.N + 1;
    }

    public int _method_for_gFull_maxpoints() {
        return this.N + 1;
    }

    public int _method_for_amp_elementnumber() {
        return this.kmax + 1;
    }

    public void _method_for_amp_action() {
        this._simulation.disableLoop();
        this.setA(true);
        this._simulation.enableLoop();
    }

    public int _method_for_avect_elementnumber() {
        return this.kmax + 1;
    }

    public int _method_for_phas_elementnumber() {
        return this.kmax + 1;
    }

    public void _method_for_phas_action() {
        this._simulation.disableLoop();
        this.setf(true);
        this._simulation.enableLoop();
    }

    public int _method_for_phasvect_elementnumber() {
        return this.kmax + 1;
    }

    public void _method_for_Type_action() {
        this._simulation.disableLoop();
        this.chooseType();
        this._simulation.enableLoop();
    }

    public void _method_for_bkmax_action() {
        this._simulation.disableLoop();
        this.chooseType();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.nmax = 1000;
        this.N = 1000;
        this.x = new double[this.nmax + 1];
        for (n = 0; n < this.nmax + 1; ++n) {
            this.x[n] = 0.0;
        }
        this.xf = new double[this.nmax + 1];
        for (n = 0; n < this.nmax + 1; ++n) {
            this.xf[n] = 0.0;
        }
        this.t = new double[this.nmax + 1];
        for (n = 0; n < this.nmax + 1; ++n) {
            this.t[n] = 0.0;
        }
        this.kmaxx = 1000;
        this.kmax = 50;
        this.kk = new double[this.kmaxx + 1];
        for (n = 0; n < this.kmaxx + 1; ++n) {
            this.kk[n] = 0.0;
        }
        this.A = new double[this.kmaxx + 1];
        for (n = 0; n < this.kmaxx + 1; ++n) {
            this.A[n] = 0.0;
        }
        this.f = new double[this.kmaxx + 1];
        for (n = 0; n < this.kmaxx + 1; ++n) {
            this.f[n] = 0.0;
        }
        this.xmin = -0.25;
        this.xmax = Math.PI * 2 - this.xmin;
        this.ymin = -2.0;
        this.ymax = 2.0;
        this.type = "0";
        this.nA = 0;
        this.nf = 0;
        this.full = false;
        this.PI = Math.PI;
        this.PI2 = Math.PI * 2;
        this.dt = 0.0;
        this.dk = 0.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.xf = null;
        this.t = null;
        this.kk = null;
        this.A = null;
        this.f = null;
        System.gc();
    }
}

