/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.elastic;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.displayejs.ControlSpring;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.oscillations.elastic.elastic;
import users.ehu.jma.oscillations.elastic.elasticSimulation;

class elasticView
extends EjsControl
implements View {
    private elasticSimulation _simulation = null;
    private elastic _model = null;
    public Component Main;
    public JPanel Upper;
    public DrawingPanel2D Evolution;
    public InteractiveArrow Rod;
    public InteractiveSpring Spring;
    public InteractiveParticle Particle;
    public InteractiveParticle Center;
    public PlottingPanel2D Drawing;
    public InteractiveTrace Orbit;
    public ElementSet PoincarePoints;
    public JPanel Down;
    public JPanel Values;
    public JTextField k;
    public JTextField xx;
    public JTextField yy;
    public JTextField uu;
    public JTextField vv;
    public JTextField ddt;
    public JCheckBox ShowOrbit;
    public JCheckBox ShowAngle;
    public JCheckBox ShowPoincare;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JSlider Zoom;
    public JDialog GraphL;
    public JPanel Title;
    public JLabel Labelr;
    public JLabel Labelphi;
    public PlottingPanel2D Graphs;
    public InteractiveTrace Evolutionr;
    public InteractiveTrace Evolutionphi;

    public elasticView(elasticSimulation elasticSimulation2, String string, Frame frame) {
        super(elasticSimulation2, string, frame);
        this._simulation = elasticSimulation2;
        this._model = (elastic)elasticSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("u", "apply(\"u\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("E", "apply(\"E\")");
        this.addListener("L", "apply(\"L\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("r", "apply(\"r\")");
        this.addListener("rd", "apply(\"rd\")");
        this.addListener("phid", "apply(\"phid\")");
        this.addListener("k", "apply(\"k\")");
        this.addListener("L0", "apply(\"L0\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("graph", "apply(\"graph\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("Emax", "apply(\"Emax\")");
        this.addListener("a", "apply(\"a\")");
        this.addListener("showOrbit", "apply(\"showOrbit\")");
        this.addListener("showPoincare", "apply(\"showPoincare\")");
        this.addListener("PoincareMax", "apply(\"PoincareMax\")");
        this.addListener("nPoincare", "apply(\"nPoincare\")");
        this.addListener("PoincareX", "apply(\"PoincareX\")");
        this.addListener("PoincareY", "apply(\"PoincareY\")");
        this.addListener("sign", "apply(\"sign\")");
        this.addListener("epsPoincare", "apply(\"epsPoincare\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
        }
        if ("u".equals(string)) {
            this._model.u = this.getDouble("u");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("E".equals(string)) {
            this._model.E = this.getDouble("E");
        }
        if ("L".equals(string)) {
            this._model.L = this.getDouble("L");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("r".equals(string)) {
            this._model.r = this.getDouble("r");
        }
        if ("rd".equals(string)) {
            this._model.rd = this.getDouble("rd");
        }
        if ("phid".equals(string)) {
            this._model.phid = this.getDouble("phid");
        }
        if ("k".equals(string)) {
            this._model.k = this.getDouble("k");
        }
        if ("L0".equals(string)) {
            this._model.L0 = this.getDouble("L0");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("graph".equals(string)) {
            this._model.graph = this.getBoolean("graph");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("Emax".equals(string)) {
            this._model.Emax = this.getDouble("Emax");
        }
        if ("a".equals(string)) {
            this._model.a = this.getDouble("a");
        }
        if ("showOrbit".equals(string)) {
            this._model.showOrbit = this.getBoolean("showOrbit");
        }
        if ("showPoincare".equals(string)) {
            this._model.showPoincare = this.getBoolean("showPoincare");
        }
        if ("PoincareMax".equals(string)) {
            this._model.PoincareMax = this.getInt("PoincareMax");
        }
        if ("nPoincare".equals(string)) {
            this._model.nPoincare = this.getInt("nPoincare");
        }
        if ("PoincareX".equals(string)) {
            dArray = (double[])this.getValue("PoincareX").getObject();
            n2 = dArray.length;
            if (n2 > this._model.PoincareX.length) {
                n2 = this._model.PoincareX.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.PoincareX[n] = dArray[n];
            }
        }
        if ("PoincareY".equals(string)) {
            dArray = (double[])this.getValue("PoincareY").getObject();
            n2 = dArray.length;
            if (n2 > this._model.PoincareY.length) {
                n2 = this._model.PoincareY.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.PoincareY[n] = dArray[n];
            }
        }
        if ("sign".equals(string)) {
            this._model.sign = this.getDouble("sign");
        }
        if ("epsPoincare".equals(string)) {
            this._model.epsPoincare = this.getDouble("epsPoincare");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("u", this._model.u);
        this.setValue("v", this._model.v);
        this.setValue("dt", this._model.dt);
        this.setValue("E", this._model.E);
        this.setValue("L", this._model.L);
        this.setValue("phi", this._model.phi);
        this.setValue("r", this._model.r);
        this.setValue("rd", this._model.rd);
        this.setValue("phid", this._model.phid);
        this.setValue("k", this._model.k);
        this.setValue("L0", this._model.L0);
        this.setValue("tol", this._model.tol);
        this.setValue("graph", this._model.graph);
        this.setValue("xmax", this._model.xmax);
        this.setValue("Emax", this._model.Emax);
        this.setValue("a", this._model.a);
        this.setValue("showOrbit", this._model.showOrbit);
        this.setValue("showPoincare", this._model.showPoincare);
        this.setValue("PoincareMax", this._model.PoincareMax);
        this.setValue("nPoincare", this._model.nPoincare);
        this.setValue("PoincareX", this._model.PoincareX);
        this.setValue("PoincareY", this._model.PoincareY);
        this.setValue("sign", this._model.sign);
        this.setValue("epsPoincare", this._model.epsPoincare);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Elastic pendulum")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,0").setProperty("size", this._simulation.translateString("View.Main.size", "620,360")).getObject();
        this.Upper = (JPanel)this.addElement(new ControlPanel(), "Upper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "grid:1,2,0,0").getObject();
        this.Evolution = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Upper").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Evolution_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Evolution_minimumY()%").setProperty("maximumY", "xmax").setProperty("pressaction", "_model._method_for_Evolution_pressaction()").setProperty("square", "true").setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "Use the mouse to select the initial position")).getObject();
        this.Rod = (InteractiveArrow)this.addElement(new ControlArrow(), "Rod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("sizex", "%_model._method_for_Rod_sizex()%").setProperty("sizey", "%_model._method_for_Rod_sizey()%").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("stroke", "2").getObject();
        this.Spring = (InteractiveSpring)this.addElement(new ControlSpring(), "Spring").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "x").setProperty("sizey", "y").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("radius", "%_model._method_for_Spring_radius()%").getObject();
        this.Particle = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "x").setProperty("y", "y").setProperty("sizex", "a").setProperty("sizey", "a").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_Particle_dragaction()").setProperty("style", "RECTANGLE").setProperty("elementposition", "CENTERED").setProperty("angle", "phi").getObject();
        this.Center = (InteractiveParticle)this.addElement(new ControlParticle(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "0").setProperty("y", "0").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "cyan").getObject();
        this.Drawing = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Drawing").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Upper").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Drawing_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Drawing_minimumY()%").setProperty("maximumY", "xmax").setProperty("pressaction", "_model._method_for_Drawing_pressaction()").setProperty("axesType", "Cartesian3").setProperty("titleX", this._simulation.translateString("View.Drawing.titleX", "x")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.Drawing.titleY", "y")).setProperty("majorTicksY", "false").setProperty("square", "true").setProperty("gutters", "0,0,0,0").setProperty("tooltip", this._simulation.translateString("View.Drawing.tooltip", "Click to erase orbit")).getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("x", "x").setProperty("y", "y").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "showOrbit").setProperty("color", "blue").getObject();
        this.PoincarePoints = (ElementSet)this.addElement(new ControlParticleSet(), "PoincarePoints").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("elementnumber", "nPoincare").setProperty("x", "PoincareX").setProperty("y", "PoincareY").setProperty("visible", "%_model._method_for_PoincarePoints_visible()%").setProperty("enabled", "true").setProperty("secondaryColor", "red").setProperty("color", "red").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Values = (JPanel)this.addElement(new ControlPanel(), "Values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "grid:2,6,0,1").getObject();
        this.k = (JTextField)this.addElement(new ControlNumberField(), "k").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "k").setProperty("format", this._simulation.translateString("View.k.format", "k = 0.##")).setProperty("editable", "%_model._method_for_k_editable()%").setProperty("action", "_model._method_for_k_action()").setProperty("tooltip", this._simulation.translateString("View.k.tooltip", "Dimensionless spring constant kl/mg")).getObject();
        this.xx = (JTextField)this.addElement(new ControlNumberField(), "xx").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "x").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("editable", "%_model._method_for_xx_editable()%").setProperty("action", "_model._method_for_xx_action()").setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "x coordinate")).getObject();
        this.yy = (JTextField)this.addElement(new ControlNumberField(), "yy").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "y").setProperty("format", this._simulation.translateString("View.yy.format", "y = 0.##")).setProperty("editable", "%_model._method_for_yy_editable()%").setProperty("action", "_model._method_for_yy_action()").setProperty("tooltip", this._simulation.translateString("View.yy.tooltip", "y coordinate")).getObject();
        this.uu = (JTextField)this.addElement(new ControlNumberField(), "uu").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "u").setProperty("format", this._simulation.translateString("View.uu.format", "vx = 0.##")).setProperty("editable", "%_model._method_for_uu_editable()%").setProperty("action", "_model._method_for_uu_action()").setProperty("tooltip", this._simulation.translateString("View.uu.tooltip", "Horizontal velocity")).getObject();
        this.vv = (JTextField)this.addElement(new ControlNumberField(), "vv").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "v").setProperty("format", this._simulation.translateString("View.vv.format", "vy = 0.##")).setProperty("editable", "%_model._method_for_vv_editable()%").setProperty("action", "_model._method_for_vv_action()").setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "Vertical velocity")).getObject();
        this.ddt = (JTextField)this.addElement(new ControlNumberField(), "ddt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Integration step length")).getObject();
        this.ShowOrbit = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowOrbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "showOrbit").setProperty("text", this._simulation.translateString("View.ShowOrbit.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.ShowOrbit.mnemonic", "o")).setProperty("tooltip", this._simulation.translateString("View.ShowOrbit.tooltip", "Show orbit?")).getObject();
        this.ShowAngle = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowAngle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "graph").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.ShowAngle.text", "Graphics")).setProperty("mnemonic", this._simulation.translateString("View.ShowAngle.mnemonic", "g")).setProperty("tooltip", this._simulation.translateString("View.ShowAngle.tooltip", "Show evolution of polar variables?")).getObject();
        this.ShowPoincare = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowPoincare").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "showPoincare").setProperty("text", this._simulation.translateString("View.ShowPoincare.text", "Poincar\u00e9")).setProperty("mnemonic", this._simulation.translateString("View.ShowPoincare.mnemonic", "p")).setProperty("actionon", "_model._method_for_ShowPoincare_actionon()").setProperty("actionoff", "_model._method_for_ShowPoincare_actionoff()").setProperty("tooltip", this._simulation.translateString("View.ShowPoincare.tooltip", "Compute Poincare section dr/dt=0")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("variable", "xmax").setProperty("minimum", "1").setProperty("maximum", "10").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom")).getObject();
        this.GraphL = (JDialog)this.addElement(new ControlDialog(), "GraphL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.GraphL.title", "Graphics")).setProperty("layout", "border").setProperty("visible", "graph").setProperty("location", "640,0").setProperty("size", this._simulation.translateString("View.GraphL.size", "300,300")).getObject();
        this.Title = (JPanel)this.addElement(new ControlPanel(), "Title").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "GraphL").setProperty("layout", "grid:1,2,0,0").getObject();
        this.Labelr = (JLabel)this.addElement(new ControlLabel(), "Labelr").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Title").setProperty("text", this._simulation.translateString("View.Labelr.text", "r(t)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "0,128,0,255").getObject();
        this.Labelphi = (JLabel)this.addElement(new ControlLabel(), "Labelphi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Title").setProperty("text", this._simulation.translateString("View.Labelphi.text", "$\\phi$(t)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").getObject();
        this.Graphs = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Graphs").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "GraphL").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("pressaction", "_model._method_for_Graphs_pressaction()").setProperty("titleX", this._simulation.translateString("View.Graphs.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Graphs.titleY", "r, $\\phi$")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Graphs.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Graphs.yFormat", "phi = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Graphs.tooltip", "Click to erase")).getObject();
        this.Evolutionr = (InteractiveTrace)this.addElement(new ControlTrace(), "Evolutionr").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "t").setProperty("y", "r").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "0,128,0,255").getObject();
        this.Evolutionphi = (InteractiveTrace)this.addElement(new ControlTrace(), "Evolutionphi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "t").setProperty("y", "phi").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Elastic pendulum")).setProperty("visible", "true");
        this.getElement("Upper");
        this.getElement("Evolution").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "Use the mouse to select the initial position"));
        this.getElement("Rod").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("stroke", "2");
        this.getElement("Spring").setProperty("x", "0").setProperty("y", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true");
        this.getElement("Particle").setProperty("enabled", "true").setProperty("style", "RECTANGLE").setProperty("elementposition", "CENTERED");
        this.getElement("Center").setProperty("x", "0").setProperty("y", "0").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "cyan");
        this.getElement("Drawing").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("axesType", "Cartesian3").setProperty("majorTicksX", "false").setProperty("majorTicksY", "false").setProperty("square", "true").setProperty("gutters", "0,0,0,0").setProperty("tooltip", this._simulation.translateString("View.Drawing.tooltip", "Click to erase orbit"));
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("PoincarePoints").setProperty("enabled", "true").setProperty("secondaryColor", "red").setProperty("color", "red");
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Values");
        this.getElement("k").setProperty("format", this._simulation.translateString("View.k.format", "k = 0.##")).setProperty("tooltip", this._simulation.translateString("View.k.tooltip", "Dimensionless spring constant kl/mg"));
        this.getElement("xx").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "x coordinate"));
        this.getElement("yy").setProperty("format", this._simulation.translateString("View.yy.format", "y = 0.##")).setProperty("tooltip", this._simulation.translateString("View.yy.tooltip", "y coordinate"));
        this.getElement("uu").setProperty("format", this._simulation.translateString("View.uu.format", "vx = 0.##")).setProperty("tooltip", this._simulation.translateString("View.uu.tooltip", "Horizontal velocity"));
        this.getElement("vv").setProperty("format", this._simulation.translateString("View.vv.format", "vy = 0.##")).setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "Vertical velocity"));
        this.getElement("ddt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Integration step length"));
        this.getElement("ShowOrbit").setProperty("text", this._simulation.translateString("View.ShowOrbit.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.ShowOrbit.mnemonic", "o")).setProperty("tooltip", this._simulation.translateString("View.ShowOrbit.tooltip", "Show orbit?"));
        this.getElement("ShowAngle").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.ShowAngle.text", "Graphics")).setProperty("mnemonic", this._simulation.translateString("View.ShowAngle.mnemonic", "g")).setProperty("tooltip", this._simulation.translateString("View.ShowAngle.tooltip", "Show evolution of polar variables?"));
        this.getElement("ShowPoincare").setProperty("text", this._simulation.translateString("View.ShowPoincare.text", "Poincar\u00e9")).setProperty("mnemonic", this._simulation.translateString("View.ShowPoincare.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.ShowPoincare.tooltip", "Compute Poincare section dr/dt=0"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("Zoom").setProperty("minimum", "1").setProperty("maximum", "10").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom"));
        this.getElement("GraphL").setProperty("title", this._simulation.translateString("View.GraphL.title", "Graphics"));
        this.getElement("Title");
        this.getElement("Labelr").setProperty("text", this._simulation.translateString("View.Labelr.text", "r(t)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "0,128,0,255");
        this.getElement("Labelphi").setProperty("text", this._simulation.translateString("View.Labelphi.text", "$\\phi$(t)")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue");
        this.getElement("Graphs").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("titleY", this._simulation.translateString("View.Graphs.titleY", "r, $\\phi$")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Graphs.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Graphs.yFormat", "phi = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Graphs.tooltip", "Click to erase"));
        this.getElement("Evolutionr").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "0,128,0,255");
        this.getElement("Evolutionphi").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        super.reset();
    }
}

