/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.elastic;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.elastic.elasticSimulation;
import users.ehu.jma.oscillations.elastic.elasticView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class elastic
extends AbstractModel {
    public elasticSimulation _simulation = null;
    public elasticView _view = null;
    public elastic _model = this;
    public double t = 0.0;
    public double x = 2.0;
    public double y = 0.0;
    public double u = 0.0;
    public double v = 0.0;
    public double dt = 0.05;
    public double E = 0.0;
    public double L = 1.0;
    public double phi = 0.0;
    public double r = 0.0;
    public double rd = 0.0;
    public double phid = 0.0;
    public double k = 1.0;
    public double L0 = 20.0;
    public double tol = 1.0E-6;
    public boolean graph = false;
    public double xmax = 4.0;
    public double Emax = 3.0;
    public double a = 0.4;
    public boolean showOrbit = true;
    public boolean showPoincare = false;
    public int PoincareMax = 1000;
    public int nPoincare = 0;
    public double[] PoincareX;
    public double[] PoincareY;
    public double sign = 0.0;
    public double epsPoincare = 1.0E-4;
    private _ODE_evolution1 _ODEi_evolution1;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/elastic.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        elastic elastic2 = new elastic(stringArray);
    }

    public elastic() {
        this(null, null, null, null, null, false);
    }

    public elastic(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public elastic(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new elasticSimulation(this, string, frame, uRL, bl);
        this._view = (elasticView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.r = this.hypot(this.x, this.y);
        this.phi = Math.atan2(this.x, -this.y);
        this.rd = (this.x * this.u - this.y * this.v) / this.r;
        this.phid = (-this.y * this.u + this.x * this.v) / (this.r * this.r);
        this.nPoincare = 0;
        this.sign = this.rd > 0.0 ? 1.0 : -1.0;
        this._view.resetTraces();
    }

    public void _evolution2() {
        if (this.phi < -Math.PI) {
            this.phi += Math.PI * 2;
            this._view.getElement("Evolutionphi").setProperty("connected", "false");
        } else if (this.phi > Math.PI) {
            this.phi -= Math.PI * 2;
            this._view.getElement("Evolutionphi").setProperty("connected", "false");
        } else {
            this._view.getElement("Evolutionphi").setProperty("connected", "true");
        }
    }

    public void _evolution3() {
        double d = Math.cos(this.phi);
        double d2 = Math.sin(this.phi);
        this.x = this.r * d2;
        this.y = -this.r * d;
        this.u = this.rd * d2 + this.r * this.phid * d;
        this.v = -this.rd * d + this.r * this.phid * d2;
    }

    public void _constraints1() {
        if (this.showPoincare && this.nPoincare >= this.PoincareMax) {
            this._pause();
        }
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public double _method_for_Evolution_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Evolution_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Evolution_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Rod_sizex() {
        return this.x * this.L0 / this.r;
    }

    public double _method_for_Rod_sizey() {
        return this.y * this.L0 / this.r;
    }

    public double _method_for_Spring_radius() {
        return this.a / 4.0;
    }

    public void _method_for_Particle_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this.v = 0.0;
        this.u = 0.0;
        this._simulation.enableLoop();
    }

    public double _method_for_Drawing_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Drawing_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Drawing_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("Orbit").reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_PoincarePoints_visible() {
        return this.showPoincare && this.nPoincare > 0;
    }

    public boolean _method_for_k_editable() {
        return this._isPaused();
    }

    public void _method_for_k_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_yy_editable() {
        return this._isPaused();
    }

    public void _method_for_yy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_uu_editable() {
        return this._isPaused();
    }

    public void _method_for_uu_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_ShowPoincare_actionon() {
        this._simulation.disableLoop();
        this.sign = this.rd > 0.0 ? 1.0 : -1.0;
        this._simulation.enableLoop();
    }

    public void _method_for_ShowPoincare_actionoff() {
        this._simulation.disableLoop();
        this.nPoincare = 0;
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Graphs_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("Evolutionr").reset();
        this._view.getElement("Evolutionphi").reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.x = 2.0;
        this.y = 0.0;
        this.u = 0.0;
        this.v = 0.0;
        this.dt = 0.05;
        this.E = 0.0;
        this.L = 1.0;
        this.phi = 0.0;
        this.r = 0.0;
        this.rd = 0.0;
        this.phid = 0.0;
        this.k = 1.0;
        this.L0 = 20.0;
        this.tol = 1.0E-6;
        this.graph = false;
        this.xmax = 4.0;
        this.Emax = 3.0;
        this.a = 0.4;
        this.showOrbit = true;
        this.showPoincare = false;
        this.PoincareMax = 1000;
        this.nPoincare = 0;
        this.PoincareX = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareX[n] = 0.0;
        }
        this.PoincareY = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareY[n] = 0.0;
        }
        this.sign = 0.0;
        this.epsPoincare = 1.0E-4;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
        this._evolution3();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.PoincareX = null;
        this.PoincareY = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _r;
        private double _phi;
        private double _rd;
        private double _phid;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = elastic.this.r;
            this.__state[n++] = elastic.this.phi;
            this.__state[n++] = elastic.this.rd;
            this.__state[n++] = elastic.this.phid;
            this.__state[n++] = elastic.this.t;
            this.__solver = new ODEBisectionEventSolver(this, ODEMultistepSolver.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(elastic.this.dt);
        }

        void step() {
            if (elastic.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(elastic.this.tol);
            }
            if (elastic.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(elastic.this.dt);
            }
            int n = 0;
            this.__state[n++] = elastic.this.r;
            this.__state[n++] = elastic.this.phi;
            this.__state[n++] = elastic.this.rd;
            this.__state[n++] = elastic.this.phid;
            this.__state[n++] = elastic.this.t;
            this.__solver.step();
            n = 0;
            elastic.this.r = this.__state[n++];
            elastic.this.phi = this.__state[n++];
            elastic.this.rd = this.__state[n++];
            elastic.this.phid = this.__state[n++];
            elastic.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._r = dArray[n++];
            this._phi = dArray[n++];
            this._rd = dArray[n++];
            this._phid = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._r, this._phi, this._rd, this._phid, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._r, this._phi, this._rd, this._phid, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._r, this._phi, this._rd, this._phid, this._t);
            dArray2[n++] = this._ODE_evolution1_4(this._r, this._phi, this._rd, this._phid, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return d3;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return d4;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return d * d4 * d4 + Math.cos(d2) - elastic.this.k * (d - 1.0);
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return -(2.0 * d3 * d4 + Math.sin(d2)) / d;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Poincare section";
            }

            public double getTolerance() {
                return elastic.this.epsPoincare;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._r = dArray[n++];
                _ODE_evolution1.this._phi = dArray[n++];
                _ODE_evolution1.this._rd = dArray[n++];
                _ODE_evolution1.this._phid = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._r, _ODE_evolution1.this._phi, _ODE_evolution1.this._rd, _ODE_evolution1.this._phid, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4, double d5) {
                return !elastic.this.showPoincare || elastic.this.nPoincare >= elastic.this.PoincareMax ? 1.0 : elastic.this.sign * d3;
            }

            public boolean action() {
                int n = 0;
                elastic.this.r = _ODE_evolution1.this.__state[n++];
                elastic.this.phi = _ODE_evolution1.this.__state[n++];
                elastic.this.rd = _ODE_evolution1.this.__state[n++];
                elastic.this.phid = _ODE_evolution1.this.__state[n++];
                elastic.this.t = _ODE_evolution1.this.__state[n++];
                elastic.this.sign = -elastic.this.sign;
                elastic.this.PoincareX[elastic.this.nPoincare] = elastic.this.r * Math.sin(elastic.this.phi);
                elastic.this.PoincareY[elastic.this.nPoincare] = -elastic.this.r * Math.cos(elastic.this.phi);
                ++elastic.this.nPoincare;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = elastic.this.r;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = elastic.this.phi;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = elastic.this.rd;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = elastic.this.phid;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = elastic.this.t;
                return false;
            }
        }
    }
}

