/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.cylinders;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.cylinders.cylindersSimulation;
import users.ehu.jma.oscillations.cylinders.cylindersView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cylinders
extends AbstractModel {
    public cylindersSimulation _simulation = null;
    public cylindersView _view = null;
    public cylinders _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double v = 0.0;
    public double g = 9.81;
    public double w = 0.0;
    public double mu = 0.3;
    public double dt = 0.05;
    public double N1 = 0.0;
    public double N2 = 0.0;
    public double R1 = 0.0;
    public double R2 = 0.0;
    public double L = 3.0;
    public double db = 0.1;
    public double xc = 0.5;
    public double W = 10.0;
    public double rc = 0.4;
    public double xp = 0.0;
    public double yp = 0.0;
    public int N = 0;
    public int Nmax = 1000;
    public boolean vectors = false;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/cylinders.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        cylinders cylinders2 = new cylinders(stringArray);
    }

    public cylinders() {
        this(null, null, null, null, null, false);
    }

    public cylinders(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public cylinders(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new cylindersSimulation(this, string, frame, uRL, bl);
        this._view = (cylindersView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _constraints1() {
        this.w = Math.sqrt(this.mu * this.g / this.xc);
    }

    public void _constraints2() {
        if (this.xc < this.rc / 2.0) {
            this.xc = this.rc / 2.0;
        }
        if (this.L < 3.0 * this.xc) {
            this.xc = this.L / 3.0;
        }
        if (this.dt < 1.0E-4 || this.dt > 0.1) {
            this.dt = 0.1;
        }
    }

    public void _constraints3() {
        this.N1 = 2.0 * (1.0 + this.x / this.xc) / 2.0;
        this.N2 = 2.0 - this.N1;
        this.R1 = -this.mu * this.N1;
        this.R2 = this.mu * this.N2;
    }

    public void _constraints4() {
        this.xp = 7.0 * this.rc / 16.0 * Math.cos(this.W * this.t);
        this.yp = 7.0 * this.rc / 16.0 * Math.sin(this.W * this.t) - this.rc / 2.0;
    }

    public void _constraints5() {
        if (this.x < -this.xc || this.x > this.xc || this.x + this.L / 2.0 < this.xc || this.x - this.L / 2.0 > -this.xc) {
            this._pause();
            this._alert("Irudia", "Oops!", "The bar fell!");
            this.v = 0.0;
            this.x = 0.0;
        }
    }

    public void _constraints6() {
        if (this.N < 0) {
            this.N = 0;
        } else if (this.N > this.Nmax) {
            this.N = this.Nmax;
        }
        this.y = this.db / 2.0;
    }

    public void _method_for_Bmu_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_Bxc_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_Number_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Figure_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Cylinder1_y() {
        return -this.rc / 2.0;
    }

    public void _method_for_Cylinder1_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_Cylinder2_x() {
        return -this.xc;
    }

    public double _method_for_Cylinder2_y() {
        return -this.rc / 2.0;
    }

    public double _method_for_CylinderCenter1_x() {
        return this.xc + this.xp;
    }

    public double _method_for_CylinderCenter1_sizex() {
        return this.rc / 8.0;
    }

    public double _method_for_CylinderCenter1_sizey() {
        return this.rc / 8.0;
    }

    public double _method_for_CylinderCenter2_x() {
        return -this.xc - this.xp;
    }

    public double _method_for_CylinderCenter2_sizex() {
        return this.rc / 8.0;
    }

    public double _method_for_CylinderCenter2_sizey() {
        return this.rc / 8.0;
    }

    public void _method_for_Bar_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_N2_x() {
        return -this.xc;
    }

    public double _method_for_R2_x() {
        return -this.xc;
    }

    public double _method_for_Center_sizex() {
        return this.db / 1.5;
    }

    public double _method_for_Center_sizey() {
        return this.db / 1.5;
    }

    public double _method_for_Point1_y() {
        return -this.rc / 2.0;
    }

    public double _method_for_Point1_sizex() {
        return this.rc / 6.0;
    }

    public double _method_for_Point1_sizey() {
        return this.rc / 6.0;
    }

    public double _method_for_Point2_x() {
        return -this.xc;
    }

    public double _method_for_Point2_y() {
        return -this.rc / 2.0;
    }

    public double _method_for_Point2_sizex() {
        return this.rc / 6.0;
    }

    public double _method_for_Point2_sizey() {
        return this.rc / 6.0;
    }

    public boolean _method_for_Graphics_visible() {
        return this.N > 0;
    }

    public void _method_for_GraphPanel_pressaction() {
        this._simulation.disableLoop();
        this._resetView();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.v = 0.0;
        this.g = 9.81;
        this.w = 0.0;
        this.mu = 0.3;
        this.dt = 0.05;
        this.N1 = 0.0;
        this.N2 = 0.0;
        this.R1 = 0.0;
        this.R2 = 0.0;
        this.L = 3.0;
        this.db = 0.1;
        this.xc = 0.5;
        this.W = 10.0;
        this.rc = 0.4;
        this.xp = 0.0;
        this.yp = 0.0;
        this.N = 0;
        this.Nmax = 1000;
        this.vectors = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
        this._constraints4();
        this._constraints5();
        this._constraints6();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private EulerRichardson __solver = null;
        private double[] __state = null;
        private double _x;
        private double _v;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = cylinders.this.x;
            this.__state[n++] = cylinders.this.v;
            this.__state[n++] = cylinders.this.t;
            this.__solver = new EulerRichardson(this);
            this.__solver.initialize(cylinders.this.dt);
        }

        void step() {
            if (cylinders.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(cylinders.this.dt);
            }
            int n = 0;
            this.__state[n++] = cylinders.this.x;
            this.__state[n++] = cylinders.this.v;
            this.__state[n++] = cylinders.this.t;
            this.__solver.step();
            n = 0;
            cylinders.this.x = this.__state[n++];
            cylinders.this.v = this.__state[n++];
            cylinders.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._v = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._v, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._v, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3) {
            return -cylinders.this.w * cylinders.this.w * d;
        }
    }
}

