/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.bifurcation;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.bifurcation.bifurcationSimulation;
import users.ehu.jma.oscillations.bifurcation.bifurcationView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bifurcation
extends AbstractModel {
    public bifurcationSimulation _simulation = null;
    public bifurcationView _view = null;
    public bifurcation _model = this;
    public double t = 0.0;
    public double theta = 1.0;
    public double phi = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 0.6;
    public double thetap = 0.0;
    public double dt = 0.09999730000000001;
    public double tol = 1.0E-6;
    public double alpha = 1.0;
    public double beta = 0.0;
    public double thetaDegrees = 10.0;
    public boolean showg = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/bifurcation.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        bifurcation bifurcation2 = new bifurcation(stringArray);
    }

    public bifurcation() {
        this(null, null, null, null, null, false);
    }

    public bifurcation(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public bifurcation(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new bifurcationSimulation(this, string, frame, uRL, bl);
        this._view = (bifurcationView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.theta = Math.toRadians(this.thetaDegrees);
        this.thetap = 0.0;
        this.putxyz();
        this._view.resetTraces();
    }

    public void _evolution2() {
        this.phi += this.w * this.dt;
        if (this.phi > Math.PI) {
            this.phi -= Math.PI * 2;
        }
        this.putxyz();
    }

    public void putxyz() {
        this.x = Math.sin(this.theta) * Math.cos(this.phi);
        this.y = Math.sin(this.theta) * Math.sin(this.phi);
        this.z = -Math.cos(this.theta);
    }

    public double _method_for_Ring2_max() {
        return Math.PI * 2;
    }

    public double _method_for_Alpha_minimum() {
        return -Math.PI;
    }

    public double _method_for_Alpha_maximum() {
        return Math.PI;
    }

    public double _method_for_Beta_minimum() {
        return -Math.PI;
    }

    public double _method_for_Beta_maximum() {
        return Math.PI;
    }

    public void _method_for_Evolution_pressaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_theta1_y() {
        return Math.toDegrees(Math.acos(1.0 / this.w / this.w));
    }

    public boolean _method_for_theta1_visible() {
        return this.w > 1.0;
    }

    public double _method_for_theta2_y() {
        return -Math.toDegrees(Math.acos(1.0 / this.w / this.w));
    }

    public boolean _method_for_theta2_visible() {
        return this.w > 1.0;
    }

    public double _method_for_thetat_y() {
        return Math.toDegrees(this.theta);
    }

    public void _method_for_W_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Theta_enabled() {
        return this._isPaused();
    }

    public void _method_for_Theta_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.theta = 1.0;
        this.phi = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.6;
        this.thetap = 0.0;
        this.dt = 0.09999730000000001;
        this.tol = 1.0E-6;
        this.alpha = 1.0;
        this.beta = 0.0;
        this.thetaDegrees = 10.0;
        this.showg = true;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _theta;
        private double _thetap;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = bifurcation.this.theta;
            this.__state[n++] = bifurcation.this.thetap;
            this.__state[n++] = bifurcation.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(bifurcation.this.dt);
        }

        void step() {
            if (bifurcation.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(bifurcation.this.tol);
            }
            if (bifurcation.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(bifurcation.this.dt);
            }
            int n = 0;
            this.__state[n++] = bifurcation.this.theta;
            this.__state[n++] = bifurcation.this.thetap;
            this.__state[n++] = bifurcation.this.t;
            this.__solver.step();
            n = 0;
            bifurcation.this.theta = this.__state[n++];
            bifurcation.this.thetap = this.__state[n++];
            bifurcation.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._theta = dArray[n++];
            this._thetap = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._theta, this._thetap, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._theta, this._thetap, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3) {
            return Math.sin(d) * (bifurcation.this.w * bifurcation.this.w * Math.cos(d) - 1.0);
        }
    }
}

