/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.beats;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.beats.beatsSimulation;
import users.ehu.jma.oscillations.beats.beatsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class beats
extends AbstractModel {
    public beatsSimulation _simulation = null;
    public beatsView _view = null;
    public beats _model = this;
    public double t = 0.0;
    public double x1 = 0.0;
    public double y1 = 0.0;
    public double x2 = 0.0;
    public double y2 = 0.0;
    public double x3 = 0.0;
    public double y3 = 0.0;
    public double A2 = 1.0;
    public double w2 = 0.9;
    public double delta = 0.0;
    public double deltaDegrees = 90.0;
    public double amp = 0.0;
    public double dt = 0.25;
    public int npoints = 750;
    public double xmax = 2.0;
    public boolean showProj = true;
    public boolean showAllPhasors = true;
    public boolean showSum = true;
    public boolean showAllGraphs = false;
    public boolean showEnvolvent = false;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/beats.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        beats beats2 = new beats(stringArray);
    }

    public beats() {
        this(null, null, null, null, null, false);
    }

    public beats(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public beats(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new beatsSimulation(this, string, frame, uRL, bl);
        this._view = (beatsView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.setZero();
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        this.delta = Math.toRadians(this.deltaDegrees);
    }

    public void _constraints2() {
        this.xmax = 1.1 * (1.0 + this.A2);
    }

    public void _constraints3() {
        this.x1 = Math.cos(this.t);
        this.y1 = Math.sin(this.t);
        this.x2 = this.A2 * Math.cos(this.w2 * this.t + this.delta);
        this.y2 = this.A2 * Math.sin(this.w2 * this.t + this.delta);
        this.x3 = this.x1 + this.x2;
        this.y3 = this.y1 + this.y2;
        this.amp = this.hypot(this.x3, this.y3);
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void setZero() {
        this.t = 0.0;
        this._view.resetTraces();
    }

    public boolean _method_for_A2_editable() {
        return this._isPaused();
    }

    public void _method_for_A2_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_W2_editable() {
        return this._isPaused();
    }

    public void _method_for_W2_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Delta_editable() {
        return this._isPaused();
    }

    public void _method_for_Delta_action() {
        this._simulation.disableLoop();
        this.setZero();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_BothPhasors_actionoff() {
        this._simulation.disableLoop();
        this.showSum = false;
        this._simulation.enableLoop();
    }

    public double _method_for_Phasors_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Phasors_minimumY() {
        return -this.xmax;
    }

    public double _method_for_Graph_minimumY() {
        return -this.xmax;
    }

    public double _method_for_Inguratzailea2_y() {
        return -this.amp;
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.x1 = 0.0;
        this.y1 = 0.0;
        this.x2 = 0.0;
        this.y2 = 0.0;
        this.x3 = 0.0;
        this.y3 = 0.0;
        this.A2 = 1.0;
        this.w2 = 0.9;
        this.delta = 0.0;
        this.deltaDegrees = 90.0;
        this.amp = 0.0;
        this.dt = 0.25;
        this.npoints = 750;
        this.xmax = 2.0;
        this.showProj = true;
        this.showAllPhasors = true;
        this.showSum = true;
        this.showAllGraphs = false;
        this.showEnvolvent = false;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

