/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.Lissajous;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlText;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import users.ehu.jma.oscillations.Lissajous.Lissajous;
import users.ehu.jma.oscillations.Lissajous.LissajousSimulation;

class LissajousView
extends EjsControl
implements View {
    private LissajousSimulation _simulation = null;
    private Lissajous _model = null;
    public Component Main;
    public JPanel Left;
    public JTextField a1;
    public JTextField a2;
    public JTextField w1;
    public JTextField w2;
    public JTextField f;
    public JTextField dt;
    public JTextField points;
    public JCheckBox Phasors;
    public JButton startButton;
    public JButton continueButton;
    public JButton stepButton;
    public JButton resetButton;
    public DrawingPanel2D Graphs;
    public InteractiveTrace Orbit;
    public InteractiveArrow Phasor1;
    public InteractiveArrow Phasor2;
    public InteractivePoligon proj1;
    public InteractivePoligon proj2;
    public InteractiveParticle Horizontal;
    public InteractiveParticle Vertical;
    public InteractiveArrow Xaxis;
    public InteractiveArrow Yaxis;
    public InteractiveText Xname;
    public InteractiveText Yname;
    public JPanel Down;

    public LissajousView(LissajousSimulation lissajousSimulation, String string, Frame frame) {
        super(lissajousSimulation, string, frame);
        this._simulation = lissajousSimulation;
        this._model = (Lissajous)lissajousSimulation.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("xx", "apply(\"xx\")");
        this.addListener("xy", "apply(\"xy\")");
        this.addListener("yx", "apply(\"yx\")");
        this.addListener("yy", "apply(\"yy\")");
        this.addListener("a1", "apply(\"a1\")");
        this.addListener("a2", "apply(\"a2\")");
        this.addListener("w1", "apply(\"w1\")");
        this.addListener("w2", "apply(\"w2\")");
        this.addListener("f", "apply(\"f\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("x20", "apply(\"x20\")");
        this.addListener("y10", "apply(\"y10\")");
        this.addListener("p", "apply(\"p\")");
        this.addListener("phasors", "apply(\"phasors\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("xx".equals(string)) {
            this._model.xx = this.getDouble("xx");
        }
        if ("xy".equals(string)) {
            this._model.xy = this.getDouble("xy");
        }
        if ("yx".equals(string)) {
            this._model.yx = this.getDouble("yx");
        }
        if ("yy".equals(string)) {
            this._model.yy = this.getDouble("yy");
        }
        if ("a1".equals(string)) {
            this._model.a1 = this.getDouble("a1");
        }
        if ("a2".equals(string)) {
            this._model.a2 = this.getDouble("a2");
        }
        if ("w1".equals(string)) {
            this._model.w1 = this.getDouble("w1");
        }
        if ("w2".equals(string)) {
            this._model.w2 = this.getDouble("w2");
        }
        if ("f".equals(string)) {
            this._model.f = this.getDouble("f");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("x20".equals(string)) {
            this._model.x20 = this.getDouble("x20");
        }
        if ("y10".equals(string)) {
            this._model.y10 = this.getDouble("y10");
        }
        if ("p".equals(string)) {
            this._model.p = this.getInt("p");
        }
        if ("phasors".equals(string)) {
            this._model.phasors = this.getBoolean("phasors");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("xx", this._model.xx);
        this.setValue("xy", this._model.xy);
        this.setValue("yx", this._model.yx);
        this.setValue("yy", this._model.yy);
        this.setValue("a1", this._model.a1);
        this.setValue("a2", this._model.a2);
        this.setValue("w1", this._model.w1);
        this.setValue("w2", this._model.w2);
        this.setValue("f", this._model.f);
        this.setValue("dt", this._model.dt);
        this.setValue("x20", this._model.x20);
        this.setValue("y10", this._model.y10);
        this.setValue("p", this._model.p);
        this.setValue("phasors", this._model.phasors);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Lissajous figures")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "5,3").setProperty("size", this._simulation.translateString("View.Main.size", "498,409")).getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:12,1,0,2").setProperty("size", this._simulation.translateString("View.Left.size", "110,0")).setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.a1 = (JTextField)this.addElement(new ControlNumberField(), "a1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "a1").setProperty("format", this._simulation.translateString("View.a1.format", "A1 = 0.##")).setProperty("action", "_model._method_for_a1_action()").setProperty("tooltip", this._simulation.translateString("View.a1.tooltip", "Horizontal amplitude")).getObject();
        this.a2 = (JTextField)this.addElement(new ControlNumberField(), "a2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "a2").setProperty("format", this._simulation.translateString("View.a2.format", "A2 = 0.##")).setProperty("action", "_model._method_for_a2_action()").setProperty("tooltip", this._simulation.translateString("View.a2.tooltip", "Vertical amplitude")).getObject();
        this.w1 = (JTextField)this.addElement(new ControlNumberField(), "w1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "w1").setProperty("format", this._simulation.translateString("View.w1.format", "$\\omega$1 = 0.###")).setProperty("action", "_model._method_for_w1_action()").setProperty("tooltip", this._simulation.translateString("View.w1.tooltip", "Horizontal frequency")).getObject();
        this.w2 = (JTextField)this.addElement(new ControlNumberField(), "w2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "w2").setProperty("format", this._simulation.translateString("View.w2.format", "$\\omega$2 = 0.###")).setProperty("action", "_model._method_for_w2_action()").setProperty("tooltip", this._simulation.translateString("View.w2.tooltip", "Vertical frequency")).getObject();
        this.f = (JTextField)this.addElement(new ControlNumberField(), "f").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "f").setProperty("format", this._simulation.translateString("View.f.format", "$\\phi$ = 0")).setProperty("action", "_model._method_for_f_action()").setProperty("tooltip", this._simulation.translateString("View.f.tooltip", "Phase difference in degrees")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Interval between frames")).getObject();
        this.points = (JTextField)this.addElement(new ControlNumberField(), "points").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "p").setProperty("format", this._simulation.translateString("View.points.format", "0 point(s)")).setProperty("tooltip", this._simulation.translateString("View.points.tooltip", "Number of points in traces")).getObject();
        this.Phasors = (JCheckBox)this.addElement(new ControlCheckBox(), "Phasors").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "phasors").setProperty("text", this._simulation.translateString("View.Phasors.text", "Phasors")).setProperty("mnemonic", this._simulation.translateString("View.Phasors.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.Phasors.tooltip", "Show phasors?")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simulation")).getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.Graphs = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Graphs").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Graphs_minimumX()%").setProperty("maximumX", "1.75").setProperty("minimumY", "-1.75").setProperty("maximumY", "%_model._method_for_Graphs_maximumY()%").setProperty("pressaction", "_model._method_for_Graphs_pressaction()").setProperty("square", "true").setProperty("showCoordinates", "false").setProperty("tooltip", this._simulation.translateString("View.Graphs.tooltip", "Click to erase")).getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "xx").setProperty("y", "yy").setProperty("maxpoints", "p").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "red").getObject();
        this.Phasor1 = (InteractiveArrow)this.addElement(new ControlArrow(), "Phasor1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "0").setProperty("y", "y10").setProperty("sizex", "xx").setProperty("sizey", "xy").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("color", "blue").setProperty("secondaryColor", "blue").setProperty("stroke", "3").getObject();
        this.Phasor2 = (InteractiveArrow)this.addElement(new ControlArrow(), "Phasor2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "x20").setProperty("y", "0").setProperty("sizex", "yx").setProperty("sizey", "yy").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3").getObject();
        this.proj1 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "proj1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("points", "2").setProperty("min", "0").setProperty("max", "1").setProperty("variable", "s").setProperty("functionx", "xx").setProperty("functiony", "y10+xy+(yy-xy-y10)*s").setProperty("color", "blue").setProperty("visible", "phasors").setProperty("enabled", "false").getObject();
        this.proj2 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "proj2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("points", "2").setProperty("min", "0").setProperty("max", "1").setProperty("variable", "s").setProperty("functionx", "xx+(x20+yx-xx)*s").setProperty("functiony", "yy").setProperty("color", "0,128,0,255").setProperty("visible", "phasors").setProperty("enabled", "false").getObject();
        this.Horizontal = (InteractiveParticle)this.addElement(new ControlParticle(), "Horizontal").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "0").setProperty("y", "y10").setProperty("sizex", "%_model._method_for_Horizontal_sizex()%").setProperty("sizey", "%_model._method_for_Horizontal_sizey()%").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "null").setProperty("stroke", "1").getObject();
        this.Vertical = (InteractiveParticle)this.addElement(new ControlParticle(), "Vertical").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "x20").setProperty("y", "0").setProperty("sizex", "%_model._method_for_Vertical_sizex()%").setProperty("sizey", "%_model._method_for_Vertical_sizey()%").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null").setProperty("stroke", "1").getObject();
        this.Xaxis = (InteractiveArrow)this.addElement(new ControlArrow(), "Xaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "%_model._method_for_Xaxis_x()%").setProperty("y", "y10").setProperty("sizex", "%_model._method_for_Xaxis_sizex()%").setProperty("sizey", "0").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("color", "blue").setProperty("secondaryColor", "blue").getObject();
        this.Yaxis = (InteractiveArrow)this.addElement(new ControlArrow(), "Yaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "x20").setProperty("y", "%_model._method_for_Yaxis_y()%").setProperty("sizex", "0").setProperty("sizey", "%_model._method_for_Yaxis_sizey()%").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").getObject();
        this.Xname = (InteractiveText)this.addElement(new ControlText(), "Xname").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "%_model._method_for_Xname_x()%").setProperty("y", "%_model._method_for_Xname_y()%").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.Xname.text", "x")).setProperty("color", "blue").setProperty("font", "Dialog,ITALIC,12").getObject();
        this.Yname = (InteractiveText)this.addElement(new ControlText(), "Yname").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "%_model._method_for_Yname_x()%").setProperty("y", "%_model._method_for_Yname_y()%").setProperty("visible", "phasors").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.Yname.text", "y")).setProperty("angle", "%_model._method_for_Yname_angle()%").setProperty("color", "0,128,0,255").setProperty("font", "Dialog,ITALIC,12").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "grid:1,4,4,2").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Lissajous figures")).setProperty("visible", "true");
        this.getElement("Left").setProperty("size", this._simulation.translateString("View.Left.size", "110,0")).setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("a1").setProperty("format", this._simulation.translateString("View.a1.format", "A1 = 0.##")).setProperty("tooltip", this._simulation.translateString("View.a1.tooltip", "Horizontal amplitude"));
        this.getElement("a2").setProperty("format", this._simulation.translateString("View.a2.format", "A2 = 0.##")).setProperty("tooltip", this._simulation.translateString("View.a2.tooltip", "Vertical amplitude"));
        this.getElement("w1").setProperty("format", this._simulation.translateString("View.w1.format", "$\\omega$1 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.w1.tooltip", "Horizontal frequency"));
        this.getElement("w2").setProperty("format", this._simulation.translateString("View.w2.format", "$\\omega$2 = 0.###")).setProperty("tooltip", this._simulation.translateString("View.w2.tooltip", "Vertical frequency"));
        this.getElement("f").setProperty("format", this._simulation.translateString("View.f.format", "$\\phi$ = 0")).setProperty("tooltip", this._simulation.translateString("View.f.tooltip", "Phase difference in degrees"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Interval between frames"));
        this.getElement("points").setProperty("format", this._simulation.translateString("View.points.format", "0 point(s)")).setProperty("tooltip", this._simulation.translateString("View.points.tooltip", "Number of points in traces"));
        this.getElement("Phasors").setProperty("text", this._simulation.translateString("View.Phasors.text", "Phasors")).setProperty("tooltip", this._simulation.translateString("View.Phasors.tooltip", "Show phasors?"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Continue previous simulation"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("Graphs").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("maximumX", "1.75").setProperty("minimumY", "-1.75").setProperty("square", "true").setProperty("showCoordinates", "false").setProperty("tooltip", this._simulation.translateString("View.Graphs.tooltip", "Click to erase"));
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "red");
        this.getElement("Phasor1").setProperty("x", "0").setProperty("enabled", "false").setProperty("color", "blue").setProperty("secondaryColor", "blue").setProperty("stroke", "3");
        this.getElement("Phasor2").setProperty("y", "0").setProperty("enabled", "false").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3");
        this.getElement("proj1").setProperty("points", "2").setProperty("min", "0").setProperty("max", "1").setProperty("variable", "s").setProperty("functiony", "y10+xy+(yy-xy-y10)*s").setProperty("color", "blue").setProperty("enabled", "false");
        this.getElement("proj2").setProperty("points", "2").setProperty("min", "0").setProperty("max", "1").setProperty("variable", "s").setProperty("functionx", "xx+(x20+yx-xx)*s").setProperty("color", "0,128,0,255").setProperty("enabled", "false");
        this.getElement("Horizontal").setProperty("x", "0").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "null").setProperty("stroke", "1");
        this.getElement("Vertical").setProperty("y", "0").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null").setProperty("stroke", "1");
        this.getElement("Xaxis").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("color", "blue").setProperty("secondaryColor", "blue");
        this.getElement("Yaxis").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255");
        this.getElement("Xname").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.Xname.text", "x")).setProperty("color", "blue").setProperty("font", "Dialog,ITALIC,12");
        this.getElement("Yname").setProperty("enabled", "false").setProperty("text", this._simulation.translateString("View.Yname.text", "y")).setProperty("color", "0,128,0,255").setProperty("font", "Dialog,ITALIC,12");
        this.getElement("Down");
        super.reset();
    }
}

