/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.oscillations.Lissajous;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.oscillations.Lissajous.LissajousSimulation;
import users.ehu.jma.oscillations.Lissajous.LissajousView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lissajous
extends AbstractModel {
    public LissajousSimulation _simulation = null;
    public LissajousView _view = null;
    public Lissajous _model = this;
    public double t = 0.0;
    public double xx = 0.0;
    public double xy = 0.0;
    public double yx = 0.0;
    public double yy = 0.0;
    public double a1 = 1.0;
    public double a2 = 1.0;
    public double w1 = 1.357;
    public double w2 = 2.0;
    public double f = 45.0;
    public double dt = 0.1;
    public double x20 = -3.0;
    public double y10 = 3.0;
    public int p = 1000;
    public boolean phasors = true;

    public static String _getEjsModel() {
        return "users/ehu/jma/oscillations/Lissajous.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/oscillations/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Lissajous lissajous = new Lissajous(stringArray);
    }

    public Lissajous() {
        this(null, null, null, null, null, false);
    }

    public Lissajous(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Lissajous(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new LissajousSimulation(this, string, frame, uRL, bl);
        this._view = (LissajousView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this._resetView();
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        this.xx = this.a1 * Math.cos(this.w1 * this.t);
        this.xy = this.a1 * Math.sin(this.w1 * this.t);
        this.yx = -this.a2 * Math.sin(this.w2 * this.t + this.f * Math.PI / 180.0);
        this.yy = this.a2 * Math.cos(this.w2 * this.t + this.f * Math.PI / 180.0);
        this.x20 = -(this.a1 + this.a2 + 0.5);
        this.y10 = this.a1 + this.a2 + 0.5;
    }

    public void reset_all() {
        this.t = 0.0;
        this._view.resetTraces();
        this._play();
    }

    public void _method_for_a1_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_a2_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_w1_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_w2_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_f_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this.reset_all();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Graphs_minimumX() {
        return this.phasors ? -5.0 : -1.75;
    }

    public double _method_for_Graphs_maximumY() {
        return this.phasors ? 5.0 : 1.75;
    }

    public void _method_for_Graphs_pressaction() {
        this._simulation.disableLoop();
        this._resetView();
        this._simulation.enableLoop();
    }

    public double _method_for_Horizontal_sizex() {
        return 2.0 * this.a1;
    }

    public double _method_for_Horizontal_sizey() {
        return 2.0 * this.a1;
    }

    public double _method_for_Vertical_sizex() {
        return 2.0 * this.a2;
    }

    public double _method_for_Vertical_sizey() {
        return 2.0 * this.a2;
    }

    public double _method_for_Xaxis_x() {
        return -this.a1 - 0.1;
    }

    public double _method_for_Xaxis_sizex() {
        return 2.0 * (this.a1 + 0.2);
    }

    public double _method_for_Yaxis_y() {
        return -this.a2 - 0.1;
    }

    public double _method_for_Yaxis_sizey() {
        return 2.0 * (this.a2 + 0.2);
    }

    public double _method_for_Xname_x() {
        return this.a1 + 0.2;
    }

    public double _method_for_Xname_y() {
        return this.y10 + 0.2;
    }

    public double _method_for_Yname_x() {
        return this.x20 - 0.2;
    }

    public double _method_for_Yname_y() {
        return this.a2 + 0.2;
    }

    public double _method_for_Yname_angle() {
        return 1.5707963267948966;
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.xx = 0.0;
        this.xy = 0.0;
        this.yx = 0.0;
        this.yy = 0.0;
        this.a1 = 1.0;
        this.a2 = 1.0;
        this.w1 = 1.357;
        this.w2 = 2.0;
        this.f = 45.0;
        this.dt = 0.1;
        this.x20 = -3.0;
        this.y10 = 3.0;
        this.p = 1000;
        this.phasors = true;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

