/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Poincare;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Poincare.PoincareSimulation;
import users.ehu.jma.chaos.Poincare.PoincareView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Poincare
extends AbstractModel {
    public PoincareSimulation _simulation = null;
    public PoincareView _view = null;
    public Poincare _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double Pi2 = Math.PI * 2;
    public double dt = 0.3;
    public double a = 2.01;
    public double b = 3.0;
    public double c = 0.25;
    public double d = 0.2;
    public double x0 = 0.1;
    public double y0 = 0.1;
    public double z0 = 1.1;
    public double tol = 1.0E-4;
    public boolean showAxes = true;
    public double alpha = Math.toRadians(30.0);
    public double beta = Math.toRadians(30.0);
    public double omega = 0.01;
    public double maxd = 10.0;
    public double epsPoincare = 1.0E-4;
    public boolean showPoincare = true;
    public int nPoincare = 0;
    public int PoincareMax = 10000;
    public double[] PoincareX;
    public double[] PoincareY;
    public double[] PoincareZ;
    public double r = 0.05;
    public double sign = 0.0;
    public double[] OX;
    public double[] OZ;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Poincare.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Poincare poincare = new Poincare(stringArray);
    }

    public Poincare() {
        this(null, null, null, null, null, false);
    }

    public Poincare(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Poincare(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new PoincareSimulation(this, string, frame, uRL, bl);
        this._view = (PoincareView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.x = this.x0;
        this.y = this.y0;
        this.z = this.z0;
        this.nPoincare = 0;
        this.sign = this.y0 > 0.0 ? 1.0 : -1.0;
        this._view.resetTraces();
        this._resetSolvers();
    }

    public void _evolution2() {
        if (this.omega != 0.0) {
            this.alpha += this.omega * this.dt;
        }
    }

    public void _constraints1() {
        if (this.nPoincare >= this.PoincareMax) {
            this._pause();
        }
        if (this._isPlaying() && (Math.abs(this.x) > this.maxd || Math.abs(this.y) > this.maxd || Math.abs(this.z) > this.maxd)) {
            this._alert("Main", "Simulation is over", "Solution went too far!");
            this._pause();
        }
    }

    public void clearOrbit() {
        this._view.getElement("Orbit").reset();
    }

    public void clearAll() {
        this.clearOrbit();
        this.nPoincare = 0;
    }

    public boolean _method_for_Points_visible() {
        return this.showPoincare && this.nPoincare > 0;
    }

    public boolean _method_for_SectionPoints_visible() {
        return this.nPoincare > 0;
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_yy_editable() {
        return this._isPaused();
    }

    public void _method_for_yy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_zz_editable() {
        return this._isPaused();
    }

    public void _method_for_zz_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_aValue_editable() {
        return this._isPaused();
    }

    public void _method_for_aValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_bValue_editable() {
        return this._isPaused();
    }

    public void _method_for_bValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_cValue_editable() {
        return this._isPaused();
    }

    public void _method_for_cValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_dValue_editable() {
        return this._isPaused();
    }

    public void _method_for_dValue_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.clearAll();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.Pi2 = Math.PI * 2;
        this.dt = 0.3;
        this.a = 2.01;
        this.b = 3.0;
        this.c = 0.25;
        this.d = 0.2;
        this.x0 = 0.1;
        this.y0 = 0.1;
        this.z0 = 1.1;
        this.tol = 1.0E-4;
        this.showAxes = true;
        this.alpha = Math.toRadians(30.0);
        this.beta = Math.toRadians(30.0);
        this.omega = 0.01;
        this.maxd = 10.0;
        this.epsPoincare = 1.0E-4;
        this.showPoincare = true;
        this.nPoincare = 0;
        this.PoincareMax = 10000;
        this.PoincareX = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareX[n] = 0.0;
        }
        this.PoincareY = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareY[n] = 0.0;
        }
        this.PoincareZ = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareZ[n] = 0.0;
        }
        this.r = 0.05;
        this.sign = 0.0;
        this.OX = new double[]{1.0, 0.0, 0.0};
        this.OZ = new double[]{0.0, 0.0, 1.0};
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.PoincareX = null;
        this.PoincareY = null;
        this.PoincareZ = null;
        this.OX = null;
        this.OZ = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _y;
        private double _z;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Poincare.this.x;
            this.__state[n++] = Poincare.this.y;
            this.__state[n++] = Poincare.this.z;
            this.__state[n++] = Poincare.this.t;
            this.__solver = new ODEBisectionEventSolver(this, ODEMultistepSolver.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(Poincare.this.dt);
        }

        void step() {
            if (Poincare.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Poincare.this.tol);
            }
            if (Poincare.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Poincare.this.dt);
            }
            int n = 0;
            this.__state[n++] = Poincare.this.x;
            this.__state[n++] = Poincare.this.y;
            this.__state[n++] = Poincare.this.z;
            this.__state[n++] = Poincare.this.t;
            this.__solver.step();
            n = 0;
            Poincare.this.x = this.__state[n++];
            Poincare.this.y = this.__state[n++];
            Poincare.this.z = this.__state[n++];
            Poincare.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._y = dArray[n++];
            this._z = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._y, this._z, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._y, this._z, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._y, this._z, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4) {
            return d * (Poincare.this.a - Poincare.this.b + d3 + Poincare.this.d * (1.0 - d3 * d3)) - Poincare.this.c * d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4) {
            return d2 * (Poincare.this.a - Poincare.this.b + d3 + Poincare.this.d * (1.0 - d3 * d3)) + Poincare.this.c * d;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4) {
            return Poincare.this.a * d3 - (d * d + d2 * d2 + d3 * d3);
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Sections";
            }

            public double getTolerance() {
                return Poincare.this.epsPoincare;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._y = dArray[n++];
                _ODE_evolution1.this._z = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._y, _ODE_evolution1.this._z, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4) {
                return Poincare.this.sign * d2;
            }

            public boolean action() {
                int n = 0;
                Poincare.this.x = _ODE_evolution1.this.__state[n++];
                Poincare.this.y = _ODE_evolution1.this.__state[n++];
                Poincare.this.z = _ODE_evolution1.this.__state[n++];
                Poincare.this.t = _ODE_evolution1.this.__state[n++];
                Poincare.this.PoincareX[Poincare.this.nPoincare] = Poincare.this.x;
                Poincare.this.PoincareY[Poincare.this.nPoincare] = Poincare.this.y;
                Poincare.this.PoincareZ[Poincare.this.nPoincare] = Poincare.this.z;
                ++Poincare.this.nPoincare;
                Poincare.this.sign = -Poincare.this.sign;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Poincare.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Poincare.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Poincare.this.z;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Poincare.this.t;
                return true;
            }
        }
    }
}

