/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Henon_Poincare;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Dopri853;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Henon_Poincare.Henon_PoincareSimulation;
import users.ehu.jma.chaos.Henon_Poincare.Henon_PoincareView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Henon_Poincare
extends AbstractModel {
    public Henon_PoincareSimulation _simulation = null;
    public Henon_PoincareView _view = null;
    public Henon_Poincare _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double px = 0.0;
    public double py = 0.0;
    public double Pi2 = Math.PI * 2;
    public double dt = 0.3;
    public double Energy = 0.0833333;
    public double x0 = 0.0;
    public double y0 = 0.1;
    public double px0 = 1.1;
    public double py0 = 0.0;
    public double xx = 0.0;
    public double tol = 1.0E-7;
    public boolean showAxes = true;
    public double alpha = Math.toRadians(30.0);
    public double beta = Math.toRadians(30.0);
    public double omega = 0.01;
    public double maxd = 10.0;
    public double xmin = -0.4;
    public double xmax = 0.6;
    public double ymax = 0.5;
    public int bordern = 1000;
    public double[] borderx;
    public double[] borderyu;
    public double[] borderyd;
    public double epsPoincare = 1.0E-4;
    public boolean showPoincare = true;
    public int nPoincare = 0;
    public int PoincareMax = 10000;
    public double[] PoincareX;
    public double[] PoincareY;
    public double[] PoincarePy;
    public double r = 0.02;
    public double sign = 0.0;
    public double[] OY;
    public double[] OZ;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Henon_Poincare.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Henon_Poincare henon_Poincare = new Henon_Poincare(stringArray);
    }

    public Henon_Poincare() {
        this(null, null, null, null, null, false);
    }

    public Henon_Poincare(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Henon_Poincare(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new Henon_PoincareSimulation(this, string, frame, uRL, bl);
        this._view = (Henon_PoincareView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.allowed();
        this.initial();
    }

    public void _evolution2() {
        if (this.omega != 0.0) {
            this.alpha += this.omega * this.dt;
        }
    }

    public void _constraints1() {
        if (this.nPoincare >= this.PoincareMax) {
            this._pause();
        }
        if (this.xx(this.y0, this.py0) < 0.0) {
            this._alert("Section", "Error", "Forbidden initial conditions outside the energy surface");
            this.py0 = 0.0;
            this.y0 = 0.0;
        }
        if (this._isPlaying() && (Math.abs(this.x) > this.maxd || Math.abs(this.y) > this.maxd || Math.abs(this.px) > this.maxd || Math.abs(this.py) > this.maxd)) {
            this._alert("Main", "Simulation is over", "Solution went too far!");
            this._view.getElement("Go").setProperty("image", "images/play.gif");
            this._pause();
        }
    }

    public void clearOrbit() {
        this._view.getElement("Orbit").reset();
    }

    public void clearAll() {
        this.clearOrbit();
        this.nPoincare = 0;
    }

    public double sqr(double d) {
        return d * d;
    }

    public double xx(double d, double d2) {
        return 2.0 * this.Energy - (this.sqr(d2) + this.sqr(this.x0) + this.sqr(d) + 2.0 * (this.sqr(this.x0) - this.sqr(d) / 3.0) * d);
    }

    public void allowed() {
        double d = 0.001;
        this.xmin = -0.1;
        while (!(this.xx(this.xmin, 0.0) < 0.0)) {
            this.xmin -= 0.1;
        }
        this.xmax = 0.1;
        while (!(this.xx(this.xmax, 0.0) < 0.0)) {
            this.xmax += 0.1;
        }
        this.ymax = 0.1;
        while (!(this.xx(0.0, this.ymax) < 0.0)) {
            this.ymax += 0.1;
        }
        double d2 = this.xmin;
        while (this.xx(d2, 0.0) < 0.0) {
            d2 += d;
        }
        double d3 = this.xmax;
        while (this.xx(d3, 0.0) < 0.0) {
            d3 -= d;
        }
        for (int i = 0; i < this.bordern; ++i) {
            this.borderx[i] = d2 + (double)i * (d3 - d2) / (double)(this.bordern - 1);
            this.borderyu[i] = this.borderpy(this.borderx[i]);
            this.borderyd[i] = -this.borderyu[i];
        }
    }

    public double borderpy(double d) {
        double d2 = 0.0;
        while (this.xx(d, d2) > 0.0) {
            d2 += 0.01;
        }
        return d2;
    }

    public void initial() {
        this.t = 0.0;
        this.x = this.x0;
        this.y = this.y0;
        this.py = this.py0;
        this.px = Math.sqrt(this.xx(this.y0, this.py0));
        this.nPoincare = 0;
        this.sign = this.y0 > 0.0 ? 1.0 : -1.0;
        this._view.resetTraces();
        this._resetSolvers();
    }

    public double _method_for_Phase_space_minimumZ() {
        return -this.ymax;
    }

    public double _method_for_SectionPlane_z() {
        return -this.ymax;
    }

    public double _method_for_SectionPlane_sizex() {
        return this.xmax - this.xmin;
    }

    public double _method_for_SectionPlane_sizey() {
        return 2.0 * this.ymax;
    }

    public double _method_for_Xaxis_sizex() {
        return this.xmax + 0.1;
    }

    public double _method_for_Yaxis_sizey() {
        return this.xmax + 0.1;
    }

    public double _method_for_Zaxis_sizez() {
        return this.ymax + 0.1;
    }

    public double _method_for_Xlabel_x() {
        return this.xmax + 0.15;
    }

    public double _method_for_Ylabel_y() {
        return this.xmax + 0.15;
    }

    public double _method_for_Zlabel_z() {
        return this.ymax + 0.15;
    }

    public boolean _method_for_Points_visible() {
        return this.showPoincare && this.nPoincare > 0;
    }

    public double _method_for_Section_minimumY() {
        return -this.ymax;
    }

    public boolean _method_for_SectionPoints_visible() {
        return this.nPoincare > 0;
    }

    public boolean _method_for_yy_editable() {
        return this._isPaused();
    }

    public void _method_for_yy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_pyy_editable() {
        return this._isPaused();
    }

    public void _method_for_pyy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_energy_editable() {
        return this._isPaused();
    }

    public void _method_for_energy_action() {
        this._simulation.disableLoop();
        this.allowed();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_clearOrbit_action() {
        this._simulation.disableLoop();
        this.clearOrbit();
        this._simulation.enableLoop();
    }

    public void _method_for_clearAll_action() {
        this._simulation.disableLoop();
        this.clearAll();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.px = 0.0;
        this.py = 0.0;
        this.Pi2 = Math.PI * 2;
        this.dt = 0.3;
        this.Energy = 0.0833333;
        this.x0 = 0.0;
        this.y0 = 0.1;
        this.px0 = 1.1;
        this.py0 = 0.0;
        this.xx = 0.0;
        this.tol = 1.0E-7;
        this.showAxes = true;
        this.alpha = Math.toRadians(30.0);
        this.beta = Math.toRadians(30.0);
        this.omega = 0.01;
        this.maxd = 10.0;
        this.xmin = -0.4;
        this.xmax = 0.6;
        this.ymax = 0.5;
        this.bordern = 1000;
        this.borderx = new double[this.bordern];
        for (n = 0; n < this.bordern; ++n) {
            this.borderx[n] = 0.0;
        }
        this.borderyu = new double[this.bordern];
        for (n = 0; n < this.bordern; ++n) {
            this.borderyu[n] = 0.0;
        }
        this.borderyd = new double[this.bordern];
        for (n = 0; n < this.bordern; ++n) {
            this.borderyd[n] = 0.0;
        }
        this.epsPoincare = 1.0E-4;
        this.showPoincare = true;
        this.nPoincare = 0;
        this.PoincareMax = 10000;
        this.PoincareX = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareX[n] = 0.0;
        }
        this.PoincareY = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareY[n] = 0.0;
        }
        this.PoincarePy = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincarePy[n] = 0.0;
        }
        this.r = 0.02;
        this.sign = 0.0;
        this.OY = new double[]{0.0, 1.0, 0.0};
        this.OZ = new double[]{0.0, 0.0, 1.0};
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.borderx = null;
        this.borderyu = null;
        this.borderyd = null;
        this.PoincareX = null;
        this.PoincareY = null;
        this.PoincarePy = null;
        this.OY = null;
        this.OZ = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _y;
        private double _px;
        private double _py;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Henon_Poincare.this.x;
            this.__state[n++] = Henon_Poincare.this.y;
            this.__state[n++] = Henon_Poincare.this.px;
            this.__state[n++] = Henon_Poincare.this.py;
            this.__state[n++] = Henon_Poincare.this.t;
            this.__solver = new ODEBisectionEventSolver(this, Dopri853.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(Henon_Poincare.this.dt);
        }

        void step() {
            if (Henon_Poincare.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Henon_Poincare.this.tol);
            }
            if (Henon_Poincare.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Henon_Poincare.this.dt);
            }
            int n = 0;
            this.__state[n++] = Henon_Poincare.this.x;
            this.__state[n++] = Henon_Poincare.this.y;
            this.__state[n++] = Henon_Poincare.this.px;
            this.__state[n++] = Henon_Poincare.this.py;
            this.__state[n++] = Henon_Poincare.this.t;
            this.__solver.step();
            n = 0;
            Henon_Poincare.this.x = this.__state[n++];
            Henon_Poincare.this.y = this.__state[n++];
            Henon_Poincare.this.px = this.__state[n++];
            Henon_Poincare.this.py = this.__state[n++];
            Henon_Poincare.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._y = dArray[n++];
            this._px = dArray[n++];
            this._py = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._y, this._px, this._py, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._y, this._px, this._py, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._y, this._px, this._py, this._t);
            dArray2[n++] = this._ODE_evolution1_4(this._x, this._y, this._px, this._py, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return d3;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return d4;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return -d - 2.0 * d * d2;
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return -d2 - Henon_Poincare.this.sqr(d) + Henon_Poincare.this.sqr(d2);
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Sections";
            }

            public double getTolerance() {
                return Henon_Poincare.this.epsPoincare;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._y = dArray[n++];
                _ODE_evolution1.this._px = dArray[n++];
                _ODE_evolution1.this._py = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._y, _ODE_evolution1.this._px, _ODE_evolution1.this._py, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4, double d5) {
                return Henon_Poincare.this.sign * d;
            }

            public boolean action() {
                int n = 0;
                Henon_Poincare.this.x = _ODE_evolution1.this.__state[n++];
                Henon_Poincare.this.y = _ODE_evolution1.this.__state[n++];
                Henon_Poincare.this.px = _ODE_evolution1.this.__state[n++];
                Henon_Poincare.this.py = _ODE_evolution1.this.__state[n++];
                Henon_Poincare.this.t = _ODE_evolution1.this.__state[n++];
                Henon_Poincare.this.PoincareX[Henon_Poincare.this.nPoincare] = Henon_Poincare.this.x;
                Henon_Poincare.this.PoincareY[Henon_Poincare.this.nPoincare] = Henon_Poincare.this.y;
                Henon_Poincare.this.PoincarePy[Henon_Poincare.this.nPoincare] = Henon_Poincare.this.py;
                ++Henon_Poincare.this.nPoincare;
                Henon_Poincare.this.sign = -Henon_Poincare.this.sign;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Henon_Poincare.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Henon_Poincare.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Henon_Poincare.this.px;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Henon_Poincare.this.py;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Henon_Poincare.this.t;
                return true;
            }
        }
    }
}

