/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Duffing_phase;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Duffing_phase.Duffing_phaseSimulation;
import users.ehu.jma.chaos.Duffing_phase.Duffing_phaseView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duffing_phase
extends AbstractModel {
    public Duffing_phaseSimulation _simulation = null;
    public Duffing_phaseView _view = null;
    public Duffing_phase _model = this;
    public double t = 0.0;
    public int nmax = 101;
    public double[] q;
    public double[] qd;
    public double gamma = 0.0;
    public double q0 = 1.0;
    public double qd0 = 0.0;
    public double x0 = 0.0;
    public double y0 = 0.0;
    public double f = 0.0;
    public int n = 11;
    public double xmin = -2.0;
    public double xmax = 2.0;
    public double ymin = -1.2;
    public double ymax = 1.2;
    public double dt = 0.05;
    public double tol = 1.0E-6;
    public double d = 0.1;
    public int n0 = 2;
    public boolean traj = false;
    public int npoints = 121;
    public String type = "Square";
    public double R = 0.02;
    public double RR = 0.04;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Duffing_phase.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Duffing_phase duffing_phase = new Duffing_phase(stringArray);
    }

    public Duffing_phase() {
        this(null, null, null, null, null, false);
    }

    public Duffing_phase(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Duffing_phase(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new Duffing_phaseSimulation(this, string, frame, uRL, bl);
        this._view = (Duffing_phaseView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.set_type();
    }

    public void _evolution2() {
        this.q0 = this.q[this.n0];
        this.qd0 = this.qd[this.n0];
        this.x0 = Math.sin(this.q0);
        this.y0 = -Math.cos(this.q0);
    }

    public void _constraints1() {
        if (this.n <= 0) {
            this.n = 1;
        }
        if (this.n % 2 == 0) {
            ++this.n;
        }
        if (this.type.equals("Square") || this.type.equals("Disk")) {
            if (this.n > this.nmax) {
                this.n = this.nmax;
            }
            this.npoints = this.n * this.n;
            this.n0 = this.npoints / 2;
        } else if (this.type.equals("Hollow")) {
            if (4 * this.n - 3 > this.nmax * this.nmax) {
                this.n = (this.nmax * this.nmax + 3) / 4;
            }
            this.n0 = 4 * (this.n - 1);
            this.npoints = this.n0 + 1;
        } else {
            if (2 * this.n - 1 > this.nmax * this.nmax) {
                this.n = (this.nmax * this.nmax + 1) / 2;
            }
            this.n0 = 2 * (this.n - 1);
            this.npoints = this.n0 + 1;
        }
        this.x0 = Math.sin(this.q[this.n0]);
        this.y0 = -Math.cos(this.q[this.n0]);
    }

    public void set_type() {
        this.t = 0.0;
        this._view.getElement("Trajectory").reset();
        if (this.type.equals("Square")) {
            this.set_sqdi();
        } else if (this.type.equals("Hollow")) {
            this.set_void();
        } else if (this.type.equals("Circle")) {
            this.set_circ();
        }
    }

    public void set_sqdi() {
        this.q[this.n0] = this.q0;
        this.qd[this.n0] = this.qd0;
        if (this.n >= 3) {
            int n = this.n / 2;
            double d = this.d / (double)n;
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.q[i * this.n + j] = this.q0 + (double)(i - n) * d;
                    this.qd[i * this.n + j] = this.qd0 + (double)(j - n) * d;
                }
            }
        }
    }

    public void set_void() {
        this.q[this.n0] = this.q0;
        this.qd[this.n0] = this.qd0;
        if (this.n >= 3) {
            int n = this.n / 2;
            double d = this.d / (double)n;
            for (int i = 0; i < this.n - 1; ++i) {
                this.q[i] = this.q0 + (double)(i - n) * d;
                this.qd[i] = this.qd0 + (double)(this.n - 1 - n) * d;
                this.q[i + this.n - 1] = this.q0 + (double)(this.n - 1 - n) * d;
                this.qd[i + this.n - 1] = this.qd0 - (double)(i - n) * d;
                this.q[i + 2 * (this.n - 1)] = this.q0 - (double)(i - n) * d;
                this.qd[i + 2 * (this.n - 1)] = this.qd0 - (double)n * d;
                this.q[i + 3 * (this.n - 1)] = this.q0 - (double)n * d;
                this.qd[i + 3 * (this.n - 1)] = this.qd0 + (double)(i - n) * d;
            }
        }
    }

    public void set_circ() {
        this.q[this.n0] = this.q0;
        this.qd[this.n0] = this.qd0;
        if (this.n >= 3) {
            double d = this.d;
            double d2 = Math.PI / (double)(this.n - 1);
            for (int i = 0; i < 2 * this.n - 2; ++i) {
                this.q[i] = this.q0 + d * Math.cos((double)i * d2);
                this.qd[i] = this.qd0 + d * Math.sin((double)i * d2);
            }
        }
    }

    public double vel(int n, double d, double d2, double d3) {
        return n >= this.npoints ? 0.0 : d3;
    }

    public double acc(int n, double d, double d2, double d3) {
        if (n >= this.npoints) {
            return 0.0;
        }
        return -2.0 * this.gamma * d3 + d2 * (1.0 - d2 * d2) + this.f * Math.cos(d);
    }

    public void set_radius() {
        if (this.R < 0.0) {
            this.R = 0.0;
        }
        this.RR = 2.0 * this.R;
        if (this.RR < 0.02) {
            this.RR = 0.02;
        }
    }

    public void _method_for_PhaseSpace_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Center_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Kq_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Kqd_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_f0_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Traj_action() {
        this._simulation.disableLoop();
        this._view.getElement("Trajectory").reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Kn_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Kd_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Rval_action() {
        this._simulation.disableLoop();
        this.set_radius();
        this._simulation.enableLoop();
    }

    public void _method_for_Type_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.nmax = 101;
        this.q = new double[this.nmax * this.nmax];
        for (n = 0; n < this.nmax * this.nmax; ++n) {
            this.q[n] = 0.5;
        }
        this.qd = new double[this.nmax * this.nmax];
        for (n = 0; n < this.nmax * this.nmax; ++n) {
            this.qd[n] = 0.0;
        }
        this.gamma = 0.0;
        this.q0 = 1.0;
        this.qd0 = 0.0;
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.f = 0.0;
        this.n = 11;
        this.xmin = -2.0;
        this.xmax = 2.0;
        this.ymin = -1.2;
        this.ymax = 1.2;
        this.dt = 0.05;
        this.tol = 1.0E-6;
        this.d = 0.1;
        this.n0 = 2;
        this.traj = false;
        this.npoints = 121;
        this.type = "Square";
        this.R = 0.02;
        this.RR = 0.04;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.q = null;
        this.qd = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double[] _q;
        private double[] _qd;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + Duffing_phase.this.q.length + Duffing_phase.this.qd.length];
            this._q = new double[Duffing_phase.this.q.length];
            this._qd = new double[Duffing_phase.this.qd.length];
        }

        private boolean arraysChanged() {
            if (Duffing_phase.this.q.length != this._q.length) {
                return true;
            }
            return Duffing_phase.this.qd.length != this._qd.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : Duffing_phase.this.q) {
            }
            for (double this.__state[n++] : Duffing_phase.this.qd) {
            }
            this.__state[n++] = Duffing_phase.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(Duffing_phase.this.dt);
        }

        void step() {
            int n;
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (Duffing_phase.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Duffing_phase.this.tol);
            }
            if (Duffing_phase.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Duffing_phase.this.dt);
            }
            int n2 = 0;
            for (double this.__state[n2++] : Duffing_phase.this.q) {
            }
            for (double this.__state[n2++] : Duffing_phase.this.qd) {
            }
            this.__state[n2++] = Duffing_phase.this.t;
            this.__solver.step();
            n2 = 0;
            int n3 = Duffing_phase.this.q.length;
            for (n = 0; n < n3; ++n) {
                Duffing_phase.this.q[n] = this.__state[n2++];
            }
            n3 = Duffing_phase.this.qd.length;
            for (n = 0; n < n3; ++n) {
                Duffing_phase.this.qd[n] = this.__state[n2++];
            }
            Duffing_phase.this.t = this.__state[n2++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            int n3 = Duffing_phase.this.q.length;
            for (n = 0; n < n3; ++n) {
                this._q[n] = dArray[n2++];
            }
            n3 = Duffing_phase.this.qd.length;
            for (n = 0; n < n3; ++n) {
                this._qd[n] = dArray[n2++];
            }
            this._t = dArray[n2++];
            n2 = 0;
            n3 = Duffing_phase.this.q.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_1(n, this._q, this._qd, this._t);
            }
            n3 = Duffing_phase.this.qd.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_2(n, this._q, this._qd, this._t);
            }
            dArray2[n2++] = 1.0;
        }

        private double _ODE_evolution1_1(int n, double[] dArray, double[] dArray2, double d) {
            return Duffing_phase.this.vel(n, d, dArray[n], dArray2[n]);
        }

        private double _ODE_evolution1_2(int n, double[] dArray, double[] dArray2, double d) {
            return Duffing_phase.this.acc(n, d, dArray[n], dArray2[n]);
        }
    }
}

