/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Duffing_attractor;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Duffing_attractor.Duffing_attractorSimulation;
import users.ehu.jma.chaos.Duffing_attractor.Duffing_attractorView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duffing_attractor
extends AbstractModel {
    public Duffing_attractorSimulation _simulation = null;
    public Duffing_attractorView _view = null;
    public Duffing_attractor _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double v = 0.0;
    public double phase = 0.0;
    public double gamma = 0.1;
    public double f = 0.3;
    public double Pi2 = Math.PI * 2;
    public double dt = 0.1;
    public double x0 = 1.0;
    public double v0 = 0.0;
    public double tol = 1.0E-5;
    public double rho = 2.0;
    public double xx = 0.0;
    public double yy = 0.0;
    public boolean showOrbit = true;
    public boolean showAxes = true;
    public boolean showLabels = true;
    public double alpha = -0.01;
    public double beta = Math.toRadians(30.0);
    public double omega = 0.0;
    public String label1 = "";
    public String label2 = "";
    public String label3 = "";
    public double phase0 = 0.0;
    public double phi = 0.0;
    public double phaseDegrees = 45.0;
    public int N = 3;
    public double epsPoincare = 0.001;
    public boolean showPoincare = true;
    public int nPoincare = 0;
    public int PoincareMax = 10000;
    public double[] PoincareX;
    public double[] PoincareY;
    public double[] PoincareZ;
    public double r = 0.05;
    public double[] OX1;
    public double[] OX2;
    public double[] OX3;
    public double[] OZ;
    public double x1 = 0.0;
    public double y1 = 0.0;
    public double x2 = 0.0;
    public double y2 = 0.0;
    public double x3 = 0.0;
    public double y3 = 0.0;
    private _ODE_evolution1 _ODEi_evolution1;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Duffing_attractor.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Duffing_attractor duffing_attractor = new Duffing_attractor(stringArray);
    }

    public Duffing_attractor() {
        this(null, null, null, null, null, false);
    }

    public Duffing_attractor(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Duffing_attractor(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new Duffing_attractorSimulation(this, string, frame, uRL, bl);
        this._view = (Duffing_attractorView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.phase = 0.0;
        this.t = 0.0;
        this.x = this.x0;
        this.v = this.v0;
        this.xx = (this.rho + this.x) * Math.cos(this.phase);
        this.yy = (this.rho + this.x) * Math.sin(this.phase);
        this.phi = this.phase0 = Math.toRadians(this.phaseDegrees);
        this.OX1[0] = Math.cos(this.phi);
        this.OX1[1] = Math.sin(this.phi);
        this.OX2[0] = Math.cos(this.phi + this.Pi2 / (double)this.N);
        this.OX2[1] = Math.sin(this.phi + this.Pi2 / (double)this.N);
        this.OX3[0] = Math.cos(this.phi + 2.0 * this.Pi2 / (double)this.N);
        this.OX3[1] = Math.sin(this.phi + 2.0 * this.Pi2 / (double)this.N);
        this.OZ[2] = 1.0;
        this.x1 = this.rho * this.OX1[0];
        this.y1 = this.rho * this.OX1[1];
        this.x2 = this.rho * this.OX2[0];
        this.y2 = this.rho * this.OX2[1];
        this.x3 = this.rho * this.OX3[0];
        this.y3 = this.rho * this.OX3[1];
        this.label1 = "\u03c6=" + this._format(this.phaseDegrees, "0.##");
        this.label2 = "\u03c6=" + this._format(this.phaseDegrees + 120.0, "0.##");
        this.label3 = "\u03c6=" + this._format(this.phaseDegrees + 240.0, "0.##");
        this._view.resetTraces();
        this._resetSolvers();
    }

    public void _evolution2() {
        this.xx = (this.rho + this.x) * Math.cos(this.phase);
        this.yy = (this.rho + this.x) * Math.sin(this.phase);
    }

    public void _evolution3() {
        if (this.omega != 0.0) {
            this.alpha += this.omega * this.dt;
        }
        while (this.alpha >= this.Pi2) {
            this.alpha -= this.Pi2;
        }
        while (this.alpha <= -this.Pi2) {
            this.alpha += this.Pi2;
        }
    }

    public void _constraints1() {
        if (this.showPoincare && this.nPoincare >= this.PoincareMax) {
            this._pause();
        }
    }

    public void clearOrbit() {
        this._view.getElement("Orbit").reset();
    }

    public void clearAll() {
        this.clearOrbit();
        this.nPoincare = 0;
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Gamma_editable() {
        return this._isPaused();
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Force_editable() {
        return this._isPaused();
    }

    public void _method_for_Force_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Phase0_editable() {
        return this._isPaused();
    }

    public void _method_for_Phase0_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_ShowOrbit_actionoff() {
        this._simulation.disableLoop();
        this.clearOrbit();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this.clearAll();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.clearAll();
        this._simulation.enableLoop();
    }

    public double _method_for_Axisx1_sizex() {
        return this.OX1[0];
    }

    public double _method_for_Axisx1_sizey() {
        return this.OX1[1];
    }

    public boolean _method_for_Axisx1_visible() {
        return this.showPoincare && this.showAxes;
    }

    public boolean _method_for_Axisv1_visible() {
        return this.showPoincare && this.showAxes;
    }

    public double _method_for_Axisx2_sizex() {
        return this.OX2[0];
    }

    public double _method_for_Axisx2_sizey() {
        return this.OX2[1];
    }

    public boolean _method_for_Axisx2_visible() {
        return this.showPoincare && this.showAxes;
    }

    public boolean _method_for_Axisv2_visible() {
        return this.showPoincare && this.showAxes;
    }

    public boolean _method_for_Axisv3_visible() {
        return this.showPoincare && this.showAxes;
    }

    public double _method_for_Axisx3_sizex() {
        return this.OX3[0];
    }

    public double _method_for_Axisx3_sizey() {
        return this.OX3[1];
    }

    public boolean _method_for_Axisx3_visible() {
        return this.showPoincare && this.showAxes;
    }

    public boolean _method_for_PhaseLabel_visible() {
        return this.showAxes && this.showLabels;
    }

    public double _method_for_Label1_x() {
        return 2.0 * this.x1;
    }

    public double _method_for_Label1_y() {
        return 2.0 * this.y1;
    }

    public boolean _method_for_Label1_visible() {
        return this.showPoincare && this.showLabels;
    }

    public double _method_for_Label2_x() {
        return 2.0 * this.x2;
    }

    public double _method_for_Label2_y() {
        return 2.0 * this.y2;
    }

    public boolean _method_for_Label2_visible() {
        return this.showPoincare && this.showLabels;
    }

    public double _method_for_Label3_x() {
        return 2.0 * this.x3;
    }

    public double _method_for_Label3_y() {
        return 2.0 * this.y3;
    }

    public boolean _method_for_Label3_visible() {
        return this.showPoincare && this.showLabels;
    }

    public boolean _method_for_Points_visible() {
        return this.showPoincare && this.nPoincare > 0;
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.x = 0.0;
        this.v = 0.0;
        this.phase = 0.0;
        this.gamma = 0.1;
        this.f = 0.3;
        this.Pi2 = Math.PI * 2;
        this.dt = 0.1;
        this.x0 = 1.0;
        this.v0 = 0.0;
        this.tol = 1.0E-5;
        this.rho = 2.0;
        this.xx = 0.0;
        this.yy = 0.0;
        this.showOrbit = true;
        this.showAxes = true;
        this.showLabels = true;
        this.alpha = -0.01;
        this.beta = Math.toRadians(30.0);
        this.omega = 0.0;
        this.label1 = "";
        this.label2 = "";
        this.label3 = "";
        this.phase0 = 0.0;
        this.phi = 0.0;
        this.phaseDegrees = 45.0;
        this.N = 3;
        this.epsPoincare = 0.001;
        this.showPoincare = true;
        this.nPoincare = 0;
        this.PoincareMax = 10000;
        this.PoincareX = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareX[n] = 0.0;
        }
        this.PoincareY = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareY[n] = 0.0;
        }
        this.PoincareZ = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareZ[n] = 0.0;
        }
        this.r = 0.05;
        this.OX1 = new double[3];
        for (n = 0; n < 3; ++n) {
            this.OX1[n] = 0.0;
        }
        this.OX2 = new double[3];
        for (n = 0; n < 3; ++n) {
            this.OX2[n] = 0.0;
        }
        this.OX3 = new double[3];
        for (n = 0; n < 3; ++n) {
            this.OX3[n] = 0.0;
        }
        this.OZ = new double[3];
        for (n = 0; n < 3; ++n) {
            this.OZ[n] = 0.0;
        }
        this.x1 = 0.0;
        this.y1 = 0.0;
        this.x2 = 0.0;
        this.y2 = 0.0;
        this.x3 = 0.0;
        this.y3 = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
        this._evolution3();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.PoincareX = null;
        this.PoincareY = null;
        this.PoincareZ = null;
        this.OX1 = null;
        this.OX2 = null;
        this.OX3 = null;
        this.OZ = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _v;
        private double _phase;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Duffing_attractor.this.x;
            this.__state[n++] = Duffing_attractor.this.v;
            this.__state[n++] = Duffing_attractor.this.phase;
            this.__state[n++] = Duffing_attractor.this.t;
            this.__solver = new ODEBisectionEventSolver(this, ODEMultistepSolver.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(Duffing_attractor.this.dt);
        }

        void step() {
            if (Duffing_attractor.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Duffing_attractor.this.tol);
            }
            if (Duffing_attractor.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Duffing_attractor.this.dt);
            }
            int n = 0;
            this.__state[n++] = Duffing_attractor.this.x;
            this.__state[n++] = Duffing_attractor.this.v;
            this.__state[n++] = Duffing_attractor.this.phase;
            this.__state[n++] = Duffing_attractor.this.t;
            this.__solver.step();
            n = 0;
            Duffing_attractor.this.x = this.__state[n++];
            Duffing_attractor.this.v = this.__state[n++];
            Duffing_attractor.this.phase = this.__state[n++];
            Duffing_attractor.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._v = dArray[n++];
            this._phase = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._v, this._phase, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4) {
            return -2.0 * Duffing_attractor.this.gamma * d2 + d * (1.0 - d * d) + Duffing_attractor.this.f * Math.cos(d3);
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4) {
            return 1.0;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Sections";
            }

            public double getTolerance() {
                return Duffing_attractor.this.epsPoincare;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._v = dArray[n++];
                _ODE_evolution1.this._phase = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._v, _ODE_evolution1.this._phase, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4) {
                return Duffing_attractor.this.phase0 - d3;
            }

            public boolean action() {
                int n = 0;
                Duffing_attractor.this.x = _ODE_evolution1.this.__state[n++];
                Duffing_attractor.this.v = _ODE_evolution1.this.__state[n++];
                Duffing_attractor.this.phase = _ODE_evolution1.this.__state[n++];
                Duffing_attractor.this.t = _ODE_evolution1.this.__state[n++];
                Duffing_attractor.this.phase0 += Duffing_attractor.this.Pi2 / (double)Duffing_attractor.this.N;
                Duffing_attractor.this.PoincareX[Duffing_attractor.this.nPoincare] = (Duffing_attractor.this.rho + Duffing_attractor.this.x) * Math.cos(Duffing_attractor.this.phase);
                Duffing_attractor.this.PoincareY[Duffing_attractor.this.nPoincare] = (Duffing_attractor.this.rho + Duffing_attractor.this.x) * Math.sin(Duffing_attractor.this.phase);
                Duffing_attractor.this.PoincareZ[Duffing_attractor.this.nPoincare] = Duffing_attractor.this.v;
                ++Duffing_attractor.this.nPoincare;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing_attractor.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing_attractor.this.v;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing_attractor.this.phase;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing_attractor.this.t;
                return true;
            }
        }
    }
}

